/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.services.deploy.DeployResourceAccessor;
import com.sap.engine.services.deploy.container.ComponentNotDeployedException;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DTransaction;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeployEventSystem;
import com.sap.engine.services.deploy.server.RemoteCaller;
import com.sap.engine.services.deploy.server.TransactionStatistics;
import com.sap.engine.services.deploy.server.application.ApplicationTransaction;
import com.sap.engine.services.deploy.server.library.LibraryTransaction;
import com.sap.engine.services.deploy.server.library.ReferencesTransaction;
import java.util.Enumeration;
import java.util.Hashtable;

public class TransactionManager {
    private Hashtable transactions = new Hashtable();
    private DeployEventSystem eventSystem;
    private String clusterElementName = null;
    private int clusterID;
    private LockingContext lock = null;
    private String deployOwner = "";
    private RemoteCaller remote = null;
    private Object monitor = new Object();

    public void setDeployEventSystem(DeployEventSystem des) {
        this.eventSystem = des;
    }

    public void setClusterElementName(String clusterElementName) {
        this.clusterElementName = clusterElementName;
    }

    public void setLockingContext(LockingContext lctx) {
        this.lock = lctx;
    }

    public void setDeployOwner(String downer) {
        this.deployOwner = downer;
    }

    public void setClusterID(int cId) {
        this.clusterID = cId;
    }

    public void setRemoteCaller(RemoteCaller remote) {
        this.remote = remote;
    }

    public void registerTransactionWithLock(DTransaction transaction, char lockType, boolean wait) throws DeploymentException {
        this.logDebug("Locking transaction " + transaction.getTransactionType() + " for application " + transaction.getModuleID());
        this.lockApplication(transaction.getModuleID(), transaction.getTransactionType(), lockType, wait);
        transaction.setLockType(lockType);
        Object object = this.monitor;
        synchronized (object) {
            if (this.transactions.get(transaction.getModuleID()) != null) {
                throw new ServerDeploymentException("deploy_5070", new String[]{transaction.getModuleID()});
            }
            this.transactions.put(transaction.getModuleID(), transaction);
        }
        this.logDebug("Register (with lock " + lockType + ") transaction " + transaction.getTransactionType() + " for application " + transaction.getModuleID());
        this.logDebug("Transaction table: " + this.transactions);
        transaction.setBeginTime(System.currentTimeMillis());
        try {
            if (transaction.getLockType() == 'X') {
                this.eventSystem.fireDeployEvent(transaction.getModuleID(), transaction.getModuleType(), (byte)0, transaction.getTransactionType(), this.clusterElementName, "", null, null);
            } else {
                this.eventSystem.fireDeployEvent(transaction.getModuleID(), transaction.getModuleType(), (byte)2, transaction.getTransactionType(), this.clusterElementName, "", null, null);
            }
        }
        catch (DeploymentException dex) {
            dex.log();
        }
    }

    public void lockApplication(String appName, String transactionType, char lockType, boolean wait) throws DeploymentException {
        int i = 0;
        while (i < 5) {
            try {
                if (this.lock != null) {
                    this.lock.getAdministrativeLocking().lock(this.deployOwner, "DEPLOY_LOCK_AREA", appName, lockType, 120000);
                    return;
                }
                this.logInfo("Locking manager is not available - can not lock application " + appName);
            }
            catch (LockException lex) {
                if (!wait) {
                    throw new ServerDeploymentException("deploy_5070", new String[]{appName}, lex);
                }
                if (i == 4) {
                    throw new ServerDeploymentException("deploy_5070", new String[]{appName}, lex);
                }
            }
            catch (TechnicalLockException tlex) {
                throw new ServerDeploymentException("deploy_5071", new String[]{appName, tlex.getMessage()}, tlex);
            }
            ++i;
        }
    }

    public void unlockApplication(String appName, String transactionType, char lockType) throws DeploymentException {
        try {
            if (this.lock != null) {
                this.lock.getAdministrativeLocking().unlock(this.deployOwner, "DEPLOY_LOCK_AREA", appName, lockType, false);
            } else {
                this.logInfo("Locking manager is not available - can not lock application " + appName);
            }
        }
        catch (TechnicalLockException tlex) {
            throw new ServerDeploymentException("deploy_5071", new String[]{appName, tlex.getMessage()}, tlex);
        }
    }

    /*
     * Loose catch block
     */
    public void unregisterTransactionWithLock(String applicationName) {
        block35: {
            block36: {
                Object object;
                this.logDebug("Trying to unlock application " + applicationName);
                if (this.transactions.get(applicationName) == null) break block36;
                DTransaction transaction = (DTransaction)this.transactions.get(applicationName);
                this.logDebug("Unlocking transaction " + transaction.getTransactionType() + " for application:" + applicationName);
                this.printStatistics(transaction);
                long time = System.currentTimeMillis() - transaction.getBeginTime();
                if (transaction.getLockType() == 'X') {
                    this.logInfo("\nOperation " + transaction.getTransactionType() + " on application " + transaction.getModuleID() + " finished in whole cluster for " + time + " ms.");
                } else {
                    this.logInfo("\nOperation " + transaction.getTransactionType() + " on application " + transaction.getModuleID() + " finished on current cluster node for " + time + " ms.");
                }
                try {
                    block37: {
                        if (transaction instanceof ApplicationTransaction) {
                            ApplicationTransaction appTrans = (ApplicationTransaction)transaction;
                            if (transaction.getLockType() == 'X') {
                                this.remote.forceRemotely(appTrans);
                            }
                            if (appTrans.getHandler() != null) {
                                appTrans.getHandler().rollback();
                                Object var8_5 = null;
                                try {
                                    appTrans.getHandler().closeAllConfigurations();
                                }
                                catch (ConfigurationException cex2) {
                                    new ServerDeploymentException("deploy_5082", new String[]{"unregistering transaction with lock.\nReason: " + cex2.toString()}, cex2).log();
                                }
                                break block37;
                                {
                                    catch (ConfigurationException cex) {
                                        new ServerDeploymentException("deploy_5082", new String[]{"unregistering transaction with lock.\nReason: " + cex.toString()}, cex).log();
                                        Object var8_6 = null;
                                        try {
                                            appTrans.getHandler().closeAllConfigurations();
                                        }
                                        catch (ConfigurationException cex2) {
                                            new ServerDeploymentException("deploy_5082", new String[]{"unregistering transaction with lock.\nReason: " + cex2.toString()}, cex2).log();
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var8_7 = null;
                                    try {
                                        appTrans.getHandler().closeAllConfigurations();
                                    }
                                    catch (ConfigurationException cex2) {
                                        new ServerDeploymentException("deploy_5082", new String[]{"unregistering transaction with lock.\nReason: " + cex2.toString()}, cex2).log();
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    }
                    Object var11_13 = null;
                    object = this.monitor;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    Object object2 = this.monitor;
                    synchronized (object2) {
                        this.transactions.remove(applicationName);
                    }
                    this.logDebug("Unregister (with lock " + transaction.getLockType() + ") transaction " + transaction.getTransactionType() + " for application " + applicationName);
                    this.logDebug("Transaction table: " + this.transactions);
                    try {
                        if (this.lock != null) {
                            this.lock.getAdministrativeLocking().unlock(this.deployOwner, "DEPLOY_LOCK_AREA", applicationName, transaction.getLockType(), false);
                        } else {
                            this.logInfo("Locking manager is not available - can not unlock application " + applicationName);
                        }
                    }
                    catch (TechnicalLockException lex) {
                        this.logError("Unlock of application " + applicationName + " failed.");
                        this.logThrowable(lex);
                    }
                    String[][] messages = this.getWarningsAndErrors(transaction);
                    try {
                        if (transaction.getLockType() == 'X') {
                            this.eventSystem.fireDeployEvent(transaction.getModuleID(), transaction.getModuleType(), (byte)1, transaction.getTransactionType(), this.clusterElementName, "", messages[1], messages[0]);
                        } else {
                            this.eventSystem.fireDeployEvent(transaction.getModuleID(), transaction.getModuleType(), (byte)3, transaction.getTransactionType(), this.clusterElementName, "", messages[1], messages[0]);
                        }
                    }
                    catch (DeploymentException dex) {
                        dex.log();
                    }
                    throw throwable;
                }
                synchronized (object) {
                    this.transactions.remove(applicationName);
                }
                this.logDebug("Unregister (with lock " + transaction.getLockType() + ") transaction " + transaction.getTransactionType() + " for application " + applicationName);
                this.logDebug("Transaction table: " + this.transactions);
                try {
                    if (this.lock != null) {
                        this.lock.getAdministrativeLocking().unlock(this.deployOwner, "DEPLOY_LOCK_AREA", applicationName, transaction.getLockType(), false);
                    } else {
                        this.logInfo("Locking manager is not available - can not unlock application " + applicationName);
                    }
                }
                catch (TechnicalLockException lex) {
                    this.logError("Unlock of application " + applicationName + " failed.");
                    this.logThrowable(lex);
                }
                String[][] messages = this.getWarningsAndErrors(transaction);
                try {
                    if (transaction.getLockType() == 'X') {
                        this.eventSystem.fireDeployEvent(transaction.getModuleID(), transaction.getModuleType(), (byte)1, transaction.getTransactionType(), this.clusterElementName, "", messages[1], messages[0]);
                        break block35;
                    }
                    this.eventSystem.fireDeployEvent(transaction.getModuleID(), transaction.getModuleType(), (byte)3, transaction.getTransactionType(), this.clusterElementName, "", messages[1], messages[0]);
                }
                catch (DeploymentException dex) {
                    dex.log();
                }
                break block35;
            }
            this.logError("Unlock of application " + applicationName + " failed because the transaction was not found.");
        }
    }

    public void registerTransactionWithoutLock(DTransaction trans) {
        DTransaction formerTrans = (DTransaction)this.transactions.get(trans.getModuleID());
        if (formerTrans != null) {
            if (formerTrans.getChildTransaction() != null && formerTrans.getChildTransaction().getTransactionType().equals(trans.getTransactionType())) {
                this.transactions.remove(trans.getModuleID());
            } else {
                this.unregisterTransactionWithoutLock(trans.getModuleID());
            }
        }
        this.transactions.put(trans.getModuleID(), trans);
        trans.setBeginTime(System.currentTimeMillis());
        this.logDebug("Register (without lock) transaction " + trans.getTransactionType() + " for application " + trans.getModuleID());
        this.logDebug("Transaction table: " + this.transactions);
        try {
            this.eventSystem.fireDeployEvent(trans.getModuleID(), trans.getModuleType(), (byte)2, trans.getTransactionType(), this.clusterElementName, "", null, null);
        }
        catch (DeploymentException e) {
            e.log();
        }
    }

    /*
     * Loose catch block
     */
    public void unregisterTransactionWithoutLock(String appName) {
        block20: {
            DTransaction trans = (DTransaction)this.transactions.get(appName);
            if (trans == null) break block20;
            try {
                block21: {
                    ApplicationTransaction appTrans;
                    if (trans instanceof ApplicationTransaction && (appTrans = (ApplicationTransaction)trans).getHandler() != null) {
                        appTrans.getHandler().rollback();
                        Object var6_4 = null;
                        try {
                            appTrans.getHandler().closeAllConfigurations();
                        }
                        catch (ConfigurationException cex2) {
                            new ServerDeploymentException("deploy_5082", new String[]{"rollbacking handler for transaction " + appTrans.getTransactionType() + " over application " + appTrans.getModuleID()}, cex2).log();
                        }
                        break block21;
                        {
                            catch (ConfigurationException cex) {
                                new ServerDeploymentException("deploy_5082", new String[]{"rollbacking handler for transaction " + appTrans.getTransactionType() + " over application " + appTrans.getModuleID()}, cex).log();
                                Object var6_5 = null;
                                try {
                                    appTrans.getHandler().closeAllConfigurations();
                                }
                                catch (ConfigurationException cex2) {
                                    new ServerDeploymentException("deploy_5082", new String[]{"rollbacking handler for transaction " + appTrans.getTransactionType() + " over application " + appTrans.getModuleID()}, cex2).log();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            try {
                                appTrans.getHandler().closeAllConfigurations();
                            }
                            catch (ConfigurationException cex2) {
                                new ServerDeploymentException("deploy_5082", new String[]{"rollbacking handler for transaction " + appTrans.getTransactionType() + " over application " + appTrans.getModuleID()}, cex2).log();
                            }
                            throw throwable;
                        }
                    }
                }
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                long time = System.currentTimeMillis() - trans.getBeginTime();
                if (trans instanceof ApplicationTransaction || trans instanceof ReferencesTransaction) {
                    this.logInfo("Operation " + trans.getTransactionType() + " on application " + trans.getModuleID() + " finished for " + time + " ms.");
                } else if (trans instanceof LibraryTransaction) {
                    this.logInfo("Operation " + trans.getTransactionType() + " on library " + ((LibraryTransaction)trans).getLibName() + " finished for " + time + " ms.");
                }
                this.printStatistics(trans);
                String[][] messages = this.getWarningsAndErrors(trans);
                try {
                    this.eventSystem.fireDeployEvent(trans.getModuleID(), trans.getModuleType(), (byte)3, trans.getTransactionType(), this.clusterElementName, "", messages[1], messages[0]);
                }
                catch (DeploymentException e) {
                    e.log();
                }
                throw throwable;
            }
            long time = System.currentTimeMillis() - trans.getBeginTime();
            if (trans instanceof ApplicationTransaction || trans instanceof ReferencesTransaction) {
                this.logInfo("Operation " + trans.getTransactionType() + " on application " + trans.getModuleID() + " finished for " + time + " ms.");
            } else if (trans instanceof LibraryTransaction) {
                this.logInfo("Operation " + trans.getTransactionType() + " on library " + ((LibraryTransaction)trans).getLibName() + " finished for " + time + " ms.");
            }
            this.printStatistics(trans);
            String[][] messages = this.getWarningsAndErrors(trans);
            try {
                this.eventSystem.fireDeployEvent(trans.getModuleID(), trans.getModuleType(), (byte)3, trans.getTransactionType(), this.clusterElementName, "", messages[1], messages[0]);
            }
            catch (DeploymentException e) {
                e.log();
            }
            this.transactions.remove(appName);
            this.logDebug("Unregister (without lock) transaction " + trans.getTransactionType() + " for application " + appName);
            this.logDebug("Transaction table: " + this.transactions);
        }
    }

    public Hashtable beginLocalTransaction(DTransaction trans) throws DeploymentException, ComponentNotDeployedException {
        if (trans != null && trans.needForTransaction()) {
            trans.setUnregister(false);
            this.registerTransactionWithoutLock(trans);
            trans.makeAllPhasesLocal();
            TransactionStatistics stat = trans.getCurrentStatistics();
            if (stat != null) {
                Hashtable<String, String[]> res = new Hashtable<String, String[]>();
                if (stat.getErrors() != null) {
                    res.put("errors", stat.getErrors());
                }
                if (stat.getWarnings() != null) {
                    res.put("warnings", stat.getWarnings());
                }
            } else {
                return null;
            }
        }
        return null;
    }

    private void logDebug(String message) {
        if (DeployResourceAccessor.location != null) {
            DeployResourceAccessor.location.logT(100, message);
        }
    }

    private void logError(String message) {
        if (DeployResourceAccessor.category != null && DeployResourceAccessor.location != null) {
            DeployResourceAccessor.category.logT(500, DeployResourceAccessor.location, message);
        }
    }

    private void logWarning(String message) {
        if (DeployResourceAccessor.category != null && DeployResourceAccessor.location != null) {
            DeployResourceAccessor.category.logT(400, DeployResourceAccessor.location, message);
        }
    }

    private void logInfo(String message) {
        if (DeployResourceAccessor.category != null && DeployResourceAccessor.location != null) {
            DeployResourceAccessor.category.logT(300, DeployResourceAccessor.location, message);
        }
    }

    private void logThrowable(Throwable exc) {
        if (DeployResourceAccessor.category != null && DeployResourceAccessor.location != null) {
            DeployResourceAccessor.category.logThrowableT(500, DeployResourceAccessor.location, "", exc);
        }
    }

    private void printStatistics(DTransaction transaction) {
        TransactionStatistics[] stat = transaction.getStatistics();
        String[] warnings = null;
        String[] errors = null;
        if (stat != null) {
            int i = 0;
            while (i < stat.length) {
                if (stat[i] != null) {
                    int j;
                    warnings = this.generateResultMessage(stat[i].getWarnings(), "Warning", stat[i].getClusterID(), transaction.getTransactionType(), transaction.getModuleID());
                    errors = this.generateResultMessage(stat[i].getErrors(), "Error", stat[i].getClusterID(), transaction.getTransactionType(), transaction.getModuleID());
                    if (warnings != null) {
                        j = 0;
                        while (j < warnings.length) {
                            this.logWarning(warnings[j]);
                            ++j;
                        }
                    }
                    if (stat[i].getClusterID() == this.clusterID) {
                        if (transaction.isSuccessfullyFinished()) {
                            if (transaction instanceof LibraryTransaction) {
                                this.logInfo("\nOperation " + transaction.getTransactionType() + " over library " + ((LibraryTransaction)transaction).getLibName() + " finished successfully on server " + stat[i].getClusterID());
                            } else {
                                this.logInfo("\nOperation " + transaction.getTransactionType() + " over application " + transaction.getModuleID() + " finished successfully on server " + stat[i].getClusterID());
                            }
                        } else if (transaction instanceof LibraryTransaction) {
                            this.logError("\nOperation " + transaction.getTransactionType() + " over library " + ((LibraryTransaction)transaction).getLibName() + " finished with errors on server " + stat[i].getClusterID() + ". For more detailed information see traces of Deploy Service.");
                        } else {
                            this.logError("\nOperation " + transaction.getTransactionType() + " over application " + transaction.getModuleID() + " finished with errors on server " + stat[i].getClusterID() + ". For more detailed information see traces of Deploy Service.");
                        }
                    } else if (stat[i].isOkResult()) {
                        if (transaction instanceof LibraryTransaction) {
                            this.logInfo("\nOperation " + transaction.getTransactionType() + " over library " + ((LibraryTransaction)transaction).getLibName() + " finished successfully on server " + stat[i].getClusterID());
                        } else {
                            this.logInfo("\nOperation " + transaction.getTransactionType() + " over application " + transaction.getModuleID() + " finished successfully on server " + stat[i].getClusterID());
                        }
                    } else if (transaction instanceof LibraryTransaction) {
                        this.logError("\nOperation " + transaction.getTransactionType() + " over library " + ((LibraryTransaction)transaction).getLibName() + " finished with errors on server " + stat[i].getClusterID() + ". For more detailed information see traces of Deploy Service.");
                    } else {
                        this.logError("\nOperation " + transaction.getTransactionType() + " over application " + transaction.getModuleID() + " finished with errors on server " + stat[i].getClusterID() + ". For more detailed information see traces of Deploy Service.");
                    }
                    if (errors != null) {
                        j = 0;
                        while (j < errors.length) {
                            this.logError(errors[j]);
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    public String[] generateResultMessage(String[] source, String type, int clusterID, String transactionType, String moduleID) {
        String[] result = null;
        if (source != null) {
            result = new String[source.length];
            int i = 0;
            while (i < source.length) {
                result[i] = "\n" + type + " occurred on server " + clusterID + " during " + transactionType + " " + moduleID + " : " + source[i];
                ++i;
            }
        }
        return result;
    }

    private String[][] getWarningsAndErrors(DTransaction transaction) {
        String[][] result = new String[2][];
        TransactionStatistics[] stat = transaction.getStatistics();
        String[] warnings = new String[]{};
        String[] errors = new String[]{};
        if (stat != null) {
            int i = 0;
            while (i < stat.length) {
                if (stat[i] != null) {
                    warnings = DUtils.concatArrays(warnings, this.generateResultMessage(stat[i].getWarnings(), "Warning", stat[i].getClusterID(), transaction.getTransactionType(), transaction.getModuleID()));
                    errors = DUtils.concatArrays(errors, this.generateResultMessage(stat[i].getErrors(), "Error", stat[i].getClusterID(), transaction.getTransactionType(), transaction.getModuleID()));
                }
                ++i;
            }
        }
        if (warnings != null && warnings.length != 0) {
            result[0] = new String[warnings.length];
            result[0] = warnings;
        }
        if (errors != null && errors.length != 0) {
            result[1] = new String[errors.length];
            result[1] = errors;
        }
        return result;
    }

    public void elementLoss(ClusterElement element) {
        this.remote.removeServerID(element.getClusterId());
        Enumeration trans = this.transactions.elements();
        while (trans.hasMoreElements()) {
            DTransaction t = (DTransaction)trans.nextElement();
            if (!(t instanceof ApplicationTransaction)) continue;
            ((ApplicationTransaction)t).removeServerID(element.getClusterId());
        }
    }

    public DTransaction getTransaction(String appName) {
        return (DTransaction)this.transactions.get(appName);
    }
}

