/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

public class Resource {
    public static final byte CONTAINER = 0;
    public static final byte APPLICATION = 1;
    public static final byte LIBRARY = 2;
    public static final byte SERVICE = 3;
    public static final byte INTERFACE = 4;
    public static final byte COMPONENT = 5;
    public static final byte UNKNOWN_TYPE = -1;
    public static final byte UNKNOWN_REFERENCE = -2;
    public static final byte WEAK = -3;
    public static final byte HARD = -4;
    protected String name = null;
    protected byte reference = 0;
    protected byte type = (byte)-1;

    public Resource(String name, byte reference, byte type) {
        this.name = name;
        this.reference = reference;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public byte getReference() {
        return this.reference;
    }

    public byte getType() {
        return this.type;
    }

    public static String getReferenceName(byte value) {
        switch (value) {
            case -3: {
                return "weak";
            }
            case -4: {
                return "hard";
            }
        }
        return null;
    }

    public static String getTypeName(byte value) {
        switch (value) {
            case 0: {
                return "container";
            }
            case 2: {
                return "library";
            }
            case 3: {
                return "service";
            }
            case 4: {
                return "interface";
            }
            case 1: {
                return "application";
            }
            case 5: {
                return "application component";
            }
        }
        return null;
    }

    public static Resource createResource(byte type, String name) {
        return Resource.createResource(type, name, (byte)-2);
    }

    public static Resource createResource(byte type, String name, byte reference) {
        return new Resource(name, reference, type);
    }

    public Object clone() {
        Resource res = new Resource(this.name, this.reference, this.type);
        return res;
    }

    public boolean equals(Object obj) {
        if (!this.equalsWithoutReference(obj)) {
            return false;
        }
        Resource res = (Resource)obj;
        return this.reference == res.reference;
    }

    public boolean equalsWithoutReference(Object obj) {
        if (obj == null || !(obj instanceof Resource)) {
            return false;
        }
        Resource res = (Resource)obj;
        if (this.type != res.type) {
            return false;
        }
        return this.checkStrings(this.name, res.name);
    }

    protected boolean checkStrings(String str1, String str2) {
        return !(str1 != null ? !str1.equals(str2) : str2 != null);
    }

    public void setReference(byte ref) {
        this.reference = ref;
    }
}

