/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MultipleAnswer;
import com.sap.engine.frame.cluster.message.PartialResponseException;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DTransaction;
import com.sap.engine.services.deploy.server.LocalDeployment;
import com.sap.engine.services.deploy.server.TransactionStatistics;
import com.sap.engine.services.deploy.server.application.ApplicationTransaction;
import com.sap.engine.services.deploy.server.application.ParallelAdapter;
import com.sap.engine.services.deploy.server.library.LibraryTransaction;
import com.sap.engine.services.deploy.server.library.MakeReferencesTransaction;
import com.sap.engine.services.deploy.server.library.ReferencesTransaction;
import com.sap.engine.services.deploy.server.library.RemoveReferencesTransaction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class RemoteCaller {
    LocalDeployment localDeployment = null;
    ApplicationServiceContext sc = null;
    MessageContext messageCtx = null;
    private int[] serverIDs = null;
    private int currentID;
    private String warningPattern = "***WARNING***:";
    private String excPattern = "***DEP_EXC***:";

    public RemoteCaller(ApplicationServiceContext sc, LocalDeployment localDeployment) {
        int i;
        this.sc = sc;
        this.localDeployment = localDeployment;
        this.currentID = sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
        this.messageCtx = sc.getClusterContext().getMessageContext();
        ClusterElement[] elements = sc.getClusterContext().getClusterMonitor().getServiceNodes();
        ArrayList<ClusterElement> clElements = new ArrayList<ClusterElement>();
        if (elements != null) {
            i = 0;
            while (i < elements.length) {
                if (elements[i].getType() == 2) {
                    clElements.add(elements[i]);
                }
                ++i;
            }
        }
        this.serverIDs = new int[clElements.size()];
        i = 0;
        while (i < clElements.size()) {
            this.serverIDs[i] = ((ClusterElement)clElements.get(i)).getClusterId();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void addServerID(int serverID) {
        i = 0;
        if (this.sc == null) {
            return;
        }
        cEment = this.sc.getClusterContext().getClusterMonitor().getParticipant(serverID);
        if (this.sc == null || cEment == null) {
            return;
        }
        if (cEment.getType() == 2) ** GOTO lbl11
        return;
        while (this.serverIDs[i] != serverID) {
            ++i;
lbl11:
            // 2 sources

            if (i < this.serverIDs.length) continue;
        }
        if (i == this.serverIDs.length) {
            temp = new int[this.serverIDs.length + 1];
            System.arraycopy(this.serverIDs, 0, temp, 0, this.serverIDs.length);
            temp[this.serverIDs.length] = serverID;
            this.serverIDs = temp;
        }
    }

    public synchronized void removeServerID(int serverID) {
        int i = 0;
        while (i < this.serverIDs.length) {
            if (this.serverIDs[i] == serverID) {
                int[] temp = new int[this.serverIDs.length - 1];
                System.arraycopy(this.serverIDs, 0, temp, 0, i);
                if (i < this.serverIDs.length - 1) {
                    System.arraycopy(this.serverIDs, i + 1, temp, i, this.serverIDs.length - i - 1);
                }
                this.serverIDs = temp;
                return;
            }
            ++i;
        }
    }

    public synchronized int[] getServerIDs() {
        return this.sendToWho(this.serverIDs);
    }

    public TransactionStatistics[] listApplicationsRemotely(String container, int[] infoes) throws DeploymentException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("command", "listApp");
        table.put("container", container == null ? "null" : container);
        return this.sendAndWait(table, infoes, null);
    }

    public TransactionStatistics[] listApplicationsAndStatusesRemotely(String containerName, int[] infoes) throws DeploymentException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("command", "listApp");
        table.put("status", "true");
        table.put("container", containerName == null ? "null" : containerName);
        return this.sendAndWait(table, infoes, null);
    }

    public TransactionStatistics[] listElementsRemotely(String container, String application, int[] infoes) throws DeploymentException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("command", "listEl");
        table.put("container", container == null ? "null" : container);
        table.put("application_name", application == null ? "null" : application);
        return this.sendAndWait(table, infoes, application);
    }

    public TransactionStatistics[] listContainersRemotely(int[] infoes) throws DeploymentException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("command", "listContainers");
        return this.sendAndWait(table, infoes, null);
    }

    public TransactionStatistics getApplicationStatusRemotely(String appName, int id) throws DeploymentException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("command", "getStatus");
        table.put("application_name", appName);
        TransactionStatistics[] res = this.sendAndWait(table, new int[]{id}, appName);
        if (res != null && res.length == 1) {
            return res[0];
        }
        return null;
    }

    public void send(Hashtable table, int toClusterId) {
        byte[] holeMsg = null;
        if (this.sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 7) {
            return;
        }
        ClusterElement cEment = this.sc.getClusterContext().getClusterMonitor().getParticipant(toClusterId);
        if (this.sc == null || cEment == null || cEment.getState() == 7) {
            return;
        }
        try {
            holeMsg = this.getByteArray(table);
            try {
                this.messageCtx.send(toClusterId, 1, holeMsg, 0, holeMsg.length);
            }
            catch (Exception e) {
                this.logError("Error occurred while sending message to other cluster elements.");
                new ServerDeploymentException("deploy_5025", e).log();
            }
        }
        catch (Exception e) {
            this.logError("Error occurred while sending message to other cluster elements.");
            new ServerDeploymentException("deploy_5025", e).log();
        }
    }

    private byte[] getByteArray(Object obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(obj);
            oos.close();
        }
        catch (Exception ex) {
            oos.close();
            throw ex;
        }
        return baos.toByteArray();
    }

    public void send(Hashtable table, int[] infoes) {
        if (infoes == null || infoes.length == 0 || table == null) {
            return;
        }
        if (this.sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 7) {
            return;
        }
        if (infoes.length == this.getServerIDs().length) {
            this.sendToAll(table);
            return;
        }
        byte[] holeMsg = null;
        try {
            holeMsg = this.getByteArray(table);
            int i = 0;
            while (i < infoes.length) {
                this.logDebug("Send table: " + table + " to element ID " + infoes[i]);
                this.messageCtx.send(infoes[i], 1, holeMsg, 0, holeMsg.length);
                ++i;
            }
        }
        catch (Exception e) {
            this.logError("Error occurred while sending message to other cluster elements.");
            new ServerDeploymentException("deploy_5025", e).log();
        }
    }

    private void sendToAll(Hashtable table) {
        byte[] holeMsg = null;
        try {
            holeMsg = this.getByteArray(table);
            this.logDebug("Send table: " + table + " to all servers.");
            this.messageCtx.send(-1, (byte)2, 1, holeMsg, 0, holeMsg.length);
        }
        catch (Exception e) {
            this.logError("Error occurred while sending message to other cluster elements.");
            new ServerDeploymentException("deploy_5025", e).log();
        }
    }

    public TransactionStatistics[] sendAndWait(Hashtable table, int[] infoes, String appName) throws DeploymentException {
        if ((infoes = this.sendToWho(infoes)) == null || infoes.length == 0 || table == null) {
            return null;
        }
        if (infoes.length == this.getServerIDs().length) {
            return this.sendToAllAndWait(table, appName);
        }
        byte[] holeMsg = null;
        try {
            holeMsg = this.getByteArray(table);
        }
        catch (Exception ex) {
            throw new ServerDeploymentException("deploy_5025", ex);
        }
        MessageAnswer answer = null;
        TransactionStatistics[] statistics = new TransactionStatistics[infoes.length];
        try {
            int k = 0;
            while (k < infoes.length) {
                if (infoes[k] != this.currentID) {
                    statistics[k] = new TransactionStatistics(infoes[k]);
                    statistics[k].setModuleName(appName);
                    this.logDebug("Send (and wait for answer) table: " + table + " to element ID " + infoes[k]);
                    answer = this.messageCtx.sendAndWaitForAnswer(infoes[k], 1, holeMsg, 0, holeMsg.length, 600000L);
                    this.readAnswer(answer, infoes[k], statistics[k]);
                }
                ++k;
            }
        }
        catch (ClusterException clex) {
            throw new ServerDeploymentException("deploy_5025", clex);
        }
        return statistics;
    }

    public TransactionStatistics[] sendToAllAndWait(Hashtable table, String appName) throws DeploymentException {
        byte[] holeMsg = null;
        if (this.getServerIDs().length == 0) {
            return new TransactionStatistics[0];
        }
        try {
            holeMsg = this.getByteArray(table);
        }
        catch (Exception ex) {
            throw new ServerDeploymentException("deploy_5025", ex);
        }
        MultipleAnswer m_answer = null;
        try {
            this.logDebug("Send (and wait for answer) table: " + table + " to all servers.");
            m_answer = this.messageCtx.sendAndWaitForAnswer(-1, (byte)2, 1, holeMsg, 0, holeMsg.length, 600000L);
        }
        catch (PartialResponseException e) {
            m_answer = e.getPartialResponse();
        }
        catch (ClusterException cex) {
            throw new ServerDeploymentException("deploy_5025", cex);
        }
        if (m_answer == null) {
            throw new ServerDeploymentException("deploy_5025");
        }
        int[] infoes = m_answer.participants();
        TransactionStatistics[] statistics = new TransactionStatistics[infoes.length];
        MessageAnswer answer = null;
        int k = 0;
        while (k < infoes.length) {
            if (infoes[k] != this.currentID) {
                statistics[k] = new TransactionStatistics(infoes[k]);
                statistics[k].setModuleName(appName);
                try {
                    answer = m_answer.getAnswer(infoes[k]);
                    this.readAnswer(answer, infoes[k], statistics[k]);
                }
                catch (ClusterException cex) {
                    statistics[k].addError("Cannot read the answer from cluster ID " + infoes[k]);
                    this.logError("Cannot read the answer from cluster ID " + infoes[k]);
                    this.logDebug("Error occurred while reading the answer: " + cex.toString());
                }
            }
            ++k;
        }
        return statistics;
    }

    private void readAnswer(MessageAnswer answer, int info, TransactionStatistics statistics) throws DeploymentException {
        if (answer != null) {
            Object tempObject = null;
            try {
                tempObject = this.getObject(answer.getMessage(), answer.getOffset(), answer.getLength());
            }
            catch (Exception e) {
                tempObject = null;
                statistics.addErrors(new String[]{"Cannot read answer from server ID " + info + ":" + e.toString()});
                throw new ServerDeploymentException("deploy_5080", new String[]{String.valueOf(info)}, e);
            }
            if (tempObject != null) {
                Object res;
                String[] temp = null;
                if (tempObject instanceof String[]) {
                    temp = (String[])tempObject;
                    if (temp != null) {
                        res = "";
                        int i = 0;
                        while (i < temp.length) {
                            res = (String)res + temp[i] + ";";
                            ++i;
                        }
                        this.logDebug("Received answer (as String array) from server " + info + ": " + (String)res);
                    } else {
                        this.logDebug("Received answer from server " + info + ": null array");
                    }
                } else if (tempObject instanceof String) {
                    temp = new String[]{(String)tempObject};
                    this.logDebug("Received answer (as String) from server " + info + ": " + (String)tempObject);
                } else if (tempObject instanceof Hashtable) {
                    this.logDebug("Received answer (as Hashtable) from server " + info + ": " + (Hashtable)tempObject);
                    Hashtable tempHash = (Hashtable)tempObject;
                    statistics.addErrors((String[])tempHash.get("errors"));
                    tempHash.remove("errors");
                    statistics.addWarnings((String[])tempHash.get("warnings"));
                    tempHash.remove("warnings");
                    statistics.setHashAnswer(tempHash);
                }
                res = new Vector();
                if (temp != null) {
                    int j = 0;
                    while (j < temp.length) {
                        if (temp[j].startsWith(this.warningPattern)) {
                            statistics.addWarnings(new String[]{temp[j].substring(this.warningPattern.length())});
                        } else if (temp[j].startsWith(this.excPattern)) {
                            statistics.addErrors(new String[]{temp[j].substring(this.excPattern.length())});
                        } else {
                            ((Vector)res).add(temp[j]);
                        }
                        ++j;
                    }
                }
                String[] answers = new String[((Vector)res).size()];
                ((Vector)res).toArray(answers);
                statistics.addAnswers(answers);
            }
        }
    }

    private void logDebug(String message) {
        this.localDeployment.trace(100, message);
    }

    private void logError(String message) {
        this.localDeployment.logError(message);
    }

    private byte[] receivedRespond(Hashtable table, int clusterID) {
        String appName = (String)table.get("application_name");
        DTransaction transaction = null;
        transaction = this.localDeployment.getTransaction(appName);
        if (transaction != null) {
            if (transaction instanceof ParallelAdapter) {
                ((ParallelAdapter)transaction).receiveRespond(clusterID, (String[])table.get("warnings"), (String[])table.get("errors"));
            } else if (transaction.getChildTransaction() instanceof ParallelAdapter) {
                ((ParallelAdapter)transaction.getChildTransaction()).receiveRespond(clusterID, (String[])table.get("warnings"), (String[])table.get("errors"));
            }
        }
        return null;
    }

    private byte[] receivedListApp(Hashtable table) throws Exception {
        boolean withStatus;
        Hashtable<String, String> applicationsStatus;
        String[] names;
        block9: {
            names = null;
            applicationsStatus = null;
            String cont = null;
            withStatus = false;
            try {
                cont = (String)table.get("container");
                if (cont != null && (cont.equals("") || cont.equals("null"))) {
                    cont = null;
                }
                names = this.localDeployment.listApplications(cont);
                boolean bl = withStatus = table.get("status") != null;
                if (!withStatus || names == null) break block9;
                applicationsStatus = new Hashtable<String, String>();
                String status = null;
                int i = 0;
                while (i < names.length) {
                    try {
                        status = this.localDeployment.getApplicationStatus(names[i]);
                    }
                    catch (RemoteException rex) {
                        status = "NOT DEPLOYED";
                    }
                    applicationsStatus.put(names[i], status);
                    ++i;
                }
            }
            catch (Exception e) {
                return this.getByteArray(this.excPattern + " Exception occurred while listing applications on cluster element " + this.currentID + ":" + e.toString());
            }
        }
        try {
            if (!withStatus) {
                return this.getByteArray(names);
            }
            return this.getByteArray(applicationsStatus);
        }
        catch (Exception e) {
            return this.getByteArray(this.excPattern + " Exception occurred while listing applications on cluster element " + this.currentID + ":" + e.toString());
        }
    }

    private byte[] receivedListEl(Hashtable table) throws Exception {
        String[] names = null;
        String cont = null;
        String appName = (String)table.get("application_name");
        try {
            cont = (String)table.get("container");
            if (cont != null && (cont.equals("") || cont.equals("null"))) {
                cont = null;
            }
            if (appName != null && (appName.equals("") || appName.equals("null"))) {
                appName = null;
            }
            names = this.localDeployment.listElements(cont, appName);
        }
        catch (Exception e) {
            return this.getByteArray(this.excPattern + " Exception occurred while listing elements on cluster element " + this.currentID + ":" + e.toString());
        }
        try {
            return this.getByteArray(names);
        }
        catch (Exception e) {
            return this.getByteArray(this.excPattern + " Exception occurred while listing elements on cluster element " + this.currentID + ":" + e.toString());
        }
    }

    private byte[] receivedListContainers() throws Exception {
        String[] conts = this.localDeployment.listContainers();
        try {
            return this.getByteArray(conts);
        }
        catch (Exception e) {
            return this.getByteArray(this.excPattern + " Exception occurred while listing containers on cluster element " + this.currentID + ":" + e.toString());
        }
    }

    private byte[] receivedGetStatus(Hashtable table) throws Exception {
        String appName = (String)table.get("application_name");
        try {
            String status = this.localDeployment.getApplicationStatus(appName);
            return this.getByteArray(status);
        }
        catch (Exception rex) {
            return this.getByteArray(this.excPattern + " Exception occurred while getting application status of application " + appName + " on cluster element " + this.currentID + ":" + rex.toString());
        }
    }

    private byte[] receivedGetContainerInfo(Hashtable table) throws Exception {
        ContainerInfo info = this.localDeployment.getContainerInfo((String)table.get("container"));
        if (info == null) {
            return null;
        }
        return this.getByteArray(info);
    }

    private byte[] receivedBeginLocalTransaction(Hashtable table, int clusterID) throws Exception {
        String appName = (String)table.get("application_name");
        if (appName != null) {
            try {
                Hashtable response = this.localDeployment.beginLocalTransaction(table, clusterID);
                if (response != null) {
                    return this.getByteArray(response);
                }
                return null;
            }
            catch (DeploymentException dex) {
                dex.log();
                try {
                    return this.getByteArray(this.excPattern + "DeploymentException occurred on serverID " + this.currentID + " : " + dex.toString());
                }
                catch (Exception ex) {
                    ServerDeploymentException dex1 = new ServerDeploymentException("deploy_5031", new String[]{this.excPattern + "DeploymentException occurred on serverID " + this.currentID + " : " + dex.toString()});
                    dex1.log();
                    return null;
                }
            }
            catch (Exception ex) {
                String command = "";
                if (table.get("command") != null) {
                    command = (String)table.get("command");
                }
                ServerDeploymentException dex = new ServerDeploymentException("deploy_5029", new String[]{command, appName}, ex);
                dex.log();
                return this.getByteArray(this.excPattern + "DeploymentException occurred on serverID " + this.currentID + " : " + dex.getMessage());
            }
        }
        return null;
    }

    public byte[] received(Object theObject, int clusterID) {
        try {
            Hashtable table = (Hashtable)theObject;
            this.logDebug("Received table from " + clusterID + ": " + table);
            String command = (String)table.get("command");
            if (command == null) {
                return null;
            }
            if (command.equals("respond")) {
                return this.receivedRespond(table, clusterID);
            }
            if (command.equals("listApp")) {
                return this.receivedListApp(table);
            }
            if (command.equals("listEl")) {
                return this.receivedListEl(table);
            }
            if (command.equals("listContainers")) {
                return this.receivedListContainers();
            }
            if (command.equals("getStatus")) {
                return this.receivedGetStatus(table);
            }
            if (command.equals("getContainerInfo")) {
                return this.receivedGetContainerInfo(table);
            }
            return this.receivedBeginLocalTransaction(table, clusterID);
        }
        catch (Throwable th) {
            new ServerDeploymentException("deploy_5030", new String[]{"Cannot receive object " + theObject + " from clusterID" + clusterID}, th).log();
            return null;
        }
    }

    public TransactionStatistics[] notifyRemotely(DTransaction transaction, boolean wait) throws DeploymentException {
        if (this.getServerIDs().length > 0) {
            Hashtable<String, Object> table = new Hashtable<String, Object>();
            table.put("command", transaction.getTransactionType());
            table.put("application_name", transaction.getModuleID());
            if (!(transaction instanceof LibraryTransaction)) {
                if (transaction instanceof ReferencesTransaction) {
                    if (transaction instanceof MakeReferencesTransaction) {
                        table.put("ref_objects", ((MakeReferencesTransaction)transaction).getReferenceObjects());
                    } else {
                        table.put("ref_objects", ((RemoveReferencesTransaction)transaction).getLibNames());
                    }
                } else if (transaction instanceof ApplicationTransaction) {
                    ApplicationTransaction appTransaction = (ApplicationTransaction)transaction;
                    ContainerInterface[] containers = appTransaction.getAffectedContainers();
                    String[] containerNames = null;
                    if (containers != null) {
                        containerNames = new String[containers.length];
                        int i = 0;
                        while (i < containers.length) {
                            containerNames[i] = containers[i].getContainerInfo().getName();
                            if (appTransaction.getContainerProperties(i) != null) {
                                table.put("properties:" + containerNames[i], appTransaction.getContainerProperties(i));
                            }
                            ++i;
                        }
                        table.put("containers", containerNames);
                        if (appTransaction.getSerializableForSend() != null) {
                            table.put("object", appTransaction.getSerializableForSend());
                        }
                    }
                }
            }
            if (wait) {
                return this.sendAndWait(table, this.sendToWho(transaction.getOtherServerIDs()), transaction.getModuleID());
            }
            this.send(table, this.sendToWho(transaction.getOtherServerIDs()));
            return null;
        }
        return null;
    }

    public void forceRemotely(ApplicationTransaction trans) {
        int[] serverIDs;
        int[] transParticipants = trans.getOtherServerIDs();
        if (transParticipants == null) {
            transParticipants = new int[]{};
        }
        if ((serverIDs = this.getServerIDs()).length > transParticipants.length) {
            int[] newIDs = new int[serverIDs.length - transParticipants.length];
            int counter = 0;
            int j = 0;
            int i = 0;
            while (i < serverIDs.length) {
                j = 0;
                while (j < transParticipants.length) {
                    if (serverIDs[i] == transParticipants[j]) break;
                    ++j;
                }
                if (j == transParticipants.length) {
                    newIDs[counter++] = serverIDs[i];
                    if (counter == newIDs.length) break;
                }
                ++i;
            }
            if (newIDs.length > 0) {
                Hashtable<String, String> table = new Hashtable<String, String>();
                table.put("command", trans.getTransactionType());
                table.put("phase", "force");
                table.put("application_name", trans.getModuleID());
                this.send(table, this.sendToWho(newIDs));
            }
        }
    }

    public void sendRespond(String appName, int toClusterID, String[] warnings, String[] errors) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("command", "respond");
        table.put("application_name", appName);
        if (warnings != null) {
            table.put("warnings", warnings);
        }
        if (errors != null) {
            table.put("errors", errors);
        }
        this.logDebug("Sends response : " + table);
        this.send(table, toClusterID);
    }

    protected int[] sendToWho(int[] infoes) {
        int[] res = new int[infoes.length];
        int index = 0;
        if (this.sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 7) {
            return new int[0];
        }
        ClusterElement cEment = null;
        int i = 0;
        while (i < infoes.length) {
            int j = 0;
            while (j < this.serverIDs.length) {
                if (infoes[i] == this.serverIDs[j]) {
                    cEment = this.sc.getClusterContext().getClusterMonitor().getParticipant(infoes[i]);
                    if (this.sc != null && cEment != null && cEment.getState() == 3) {
                        res[index++] = infoes[i];
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
        int[] realRes = new int[index];
        System.arraycopy(res, 0, realRes, 0, index);
        return realRes;
    }

    public ContainerInfo getContainerInfoRemotely(String contName, int id) {
        if (this.sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 7) {
            return null;
        }
        ClusterElement cEment = this.sc.getClusterContext().getClusterMonitor().getParticipant(id);
        if (this.sc == null || cEment == null || cEment.getState() == 7) {
            return null;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("command", "getContainerInfo");
        table.put("container", contName);
        ContainerInfo res = null;
        byte[] holeMsg = null;
        try {
            holeMsg = this.getByteArray(table);
            MessageAnswer answer = null;
            try {
                this.logDebug("Sending command " + (String)table.get("command") + " to cluster element with ID " + id);
                answer = this.messageCtx.sendAndWaitForAnswer(id, 1, holeMsg, 0, holeMsg.length, 600000L);
                Object obj = null;
                if (answer.getMessage() != null && answer.getMessage().length > 0 && (obj = this.getObject(answer.getMessage(), answer.getOffset(), answer.getLength())) instanceof ContainerInfo) {
                    res = (ContainerInfo)obj;
                }
            }
            catch (Exception e) {
                this.logError("Error occurred while sending message to other cluster elements.");
                new ServerDeploymentException("deploy_5025", e).log();
            }
        }
        catch (Exception e) {
            this.logError("Error occurred while sending message to other cluster elements.");
            new ServerDeploymentException("deploy_5025", e).log();
        }
        return res;
    }

    private Object getObject(byte[] obj, int offset, int length) throws Exception {
        if (obj == null || length == 0) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(obj, offset, length);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object object = null;
        try {
            object = ois.readObject();
            ois.close();
        }
        catch (Exception ex) {
            ois.close();
            throw ex;
        }
        return object;
    }
}

