/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.monitor.InterfaceMonitor;
import com.sap.engine.frame.container.monitor.LibraryMonitor;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.ComponentResource;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.LocalDeployment;
import com.sap.engine.services.deploy.server.Resource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ReferenceResolver {
    private LocalDeployment deploy = null;
    private Hashtable appsMissingResources = new Hashtable();
    private Hashtable appsUsedResources = new Hashtable();
    private ComponentResource[] localAloneComponents = null;

    public ReferenceResolver(LocalDeployment deploy) {
        this.deploy = deploy;
    }

    public void resourceAvailable(Resource resource) {
        Hashtable deployedComponents_types;
        DeploymentInfo info;
        if (resource.getType() == 1 && (info = this.deploy.getApplicationInfo(resource.getName())) != null && (deployedComponents_types = info.getDeployedComponents_Types()) != null) {
            Enumeration deployedComponents = deployedComponents_types.keys();
            String component = null;
            String[] types = null;
            while (deployedComponents.hasMoreElements()) {
                component = (String)deployedComponents.nextElement();
                types = info.getResTypesOfComponent(component);
                if (types == null) continue;
                int i = 0;
                while (i < types.length) {
                    this.resourceAvailable(new ComponentResource(component, types[i], -2));
                    ++i;
                }
            }
        }
        this.processApplicationsImplicitStoppedForResource(resource);
        this.processStartedApplicationsWithWeakReference(resource);
    }

    private void processApplicationsImplicitStoppedForResource(Resource resource) {
        Enumeration apps = this.appsMissingResources.keys();
        Resource[] tempResources = null;
        String app = null;
        Resource found = null;
        while (apps.hasMoreElements()) {
            ComponentResource comp;
            app = (String)apps.nextElement();
            tempResources = (Resource[])this.appsMissingResources.get(app);
            found = this.foundResource(tempResources, resource, true);
            if (found == null) continue;
            this.removeMissingResource(app, found, true);
            DeploymentInfo info = this.deploy.getApplicationInfo(app);
            if (info == null) continue;
            if (info.getStatus() == 6) {
                switch (found.getReference()) {
                    case -3: {
                        this.deploy.logWarning("The resource " + Resource.getTypeName(found.getType()) + " " + found.getName() + " to which application " + app + " has a weak reference is now available.");
                        break;
                    }
                    case -4: {
                        try {
                            this.deploy.logWarning("Starting application " + app + " which is in implicit_stopped mode, because the resource " + found.getName() + " with type " + Resource.getTypeName(found.getType()) + ", for which it waits is now available");
                            this.deploy.startApplicationLocalAndWait(app);
                            break;
                        }
                        catch (DeploymentException dex) {
                            dex.log();
                            break;
                        }
                        catch (OutOfMemoryError oofmer) {
                            throw oofmer;
                        }
                        catch (Throwable th) {
                            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"starting application " + app + ", which is caused by the activation of resource " + resource.getName() + " with type " + Resource.getTypeName(resource.getType())}, th);
                            sdex.log();
                        }
                    }
                }
                continue;
            }
            if (info.getStatus() != 1 || found.getReference() != -3) continue;
            if (found.getType() == 5 && (comp = (ComponentResource)found).getLoaderName() != null && info.getLoaderName() != null) {
                this.deploy.getApplicationServiceContext().getCoreContext().getLoadContext().registerReference(info.getLoaderName(), comp.getLoaderName());
                this.deploy.logWarning("Registered reference from " + info.getLoaderName() + " to " + comp.getLoaderName() + " because the component " + comp.getName() + " is available");
            }
            this.deploy.logWarning("The resource " + Resource.getTypeName(found.getType()) + " " + found.getName() + " to which application " + app + " has a weak reference is now available.");
        }
    }

    private void processStartedApplicationsWithWeakReference(Resource resource) {
        Enumeration apps = this.appsUsedResources.keys();
        Resource[] tempResources = null;
        String app = null;
        Resource found = null;
        while (apps.hasMoreElements()) {
            DeploymentInfo info;
            app = (String)apps.nextElement();
            tempResources = (Resource[])this.appsUsedResources.get(app);
            found = this.foundResource(tempResources, resource, true);
            if (found == null || (info = this.deploy.getApplicationInfo(app)) == null || info.getStatus() != 1 || found.getReference() != -3) continue;
            if (found.getType() != 3) {
                ServerDeploymentException sdex;
                this.deploy.logWarning("The resource " + Resource.getTypeName(found.getType()) + " " + found.getName() + " to which application " + app + " has a " + Resource.getReferenceName(found.getReference()) + " reference is now available and will restart the application.");
                try {
                    this.deploy.stopApplicationLocalAndWait(app, false);
                }
                catch (DeploymentException dex) {
                    dex.log();
                }
                catch (OutOfMemoryError oofmer) {
                    throw oofmer;
                }
                catch (Throwable th) {
                    sdex = new ServerDeploymentException("deploy_5082", new String[]{"restarting application " + app + ", which is caused by the activation of resource " + resource.getName() + " with type " + Resource.getTypeName(resource.getType())}, th);
                    sdex.log();
                }
                try {
                    this.deploy.startApplicationLocalAndWait(app);
                    continue;
                }
                catch (DeploymentException dex) {
                    dex.log();
                    continue;
                }
                catch (OutOfMemoryError oofmer) {
                    throw oofmer;
                }
                catch (Throwable th) {
                    sdex = new ServerDeploymentException("deploy_5082", new String[]{"restarting application " + app + ", which is caused by the activation of resource " + resource.getName() + " with type " + Resource.getTypeName(resource.getType())}, th);
                    sdex.log();
                    continue;
                }
            }
            if (found.getType() != 3) continue;
            this.deploy.logWarning("The resource " + Resource.getTypeName(found.getType()) + " " + found.getName() + " to which application " + app + " has a " + Resource.getReferenceName(found.getReference()) + " reference is now available and will NOT restart the application.");
        }
    }

    private Resource foundResource(Resource[] resources, Resource resource, boolean equalsWithoutReference) {
        if (resources == null) {
            return null;
        }
        int i = 0;
        while (i < resources.length) {
            if (equalsWithoutReference ? resources[i].equalsWithoutReference(resource) : resources[i].equals(resource)) {
                return resources[i];
            }
            ++i;
        }
        return null;
    }

    public void resourceUnavailable(Resource resource) {
        Enumeration apps = this.appsUsedResources.keys();
        Resource[] tempResources = null;
        String app = null;
        Resource found = null;
        while (apps.hasMoreElements()) {
            app = (String)apps.nextElement();
            tempResources = (Resource[])this.appsUsedResources.get(app);
            found = this.foundResource(tempResources, resource, true);
            if (found == null) continue;
            this.addMissingResource(app, found);
            DeploymentInfo info = this.deploy.getApplicationInfo(app);
            if (info == null || info.getStatus() != 1) continue;
            switch (found.getReference()) {
                case -3: {
                    ComponentResource comp;
                    if (found.getType() == 5 && (comp = (ComponentResource)found).getLoaderName() != null && info.getLoaderName() != null) {
                        this.deploy.getApplicationServiceContext().getCoreContext().getLoadContext().unregisterReference(info.getLoaderName(), comp.getLoaderName());
                        this.deploy.logWarning("Unregistered reference from " + info.getLoaderName() + " to " + comp.getLoaderName() + " because the component " + comp.getName() + " is not available");
                    }
                    this.deploy.logWarning("The resource " + Resource.getTypeName(found.getType()) + " " + found.getName() + " to which application " + app + " has a weak reference is not available any more.");
                    break;
                }
                case -4: {
                    try {
                        this.deploy.logWarning("Stopping application " + app + " which is in started mode, because the resource " + found.getName() + " with type " + Resource.getTypeName(found.getType()) + " is not available.");
                        this.deploy.stopApplicationLocalAndWait(app, true);
                        break;
                    }
                    catch (DeploymentException dex) {
                        dex.log();
                    }
                }
            }
        }
    }

    public void checkCycleReferences(String appName, ReferenceObject[] refs) throws DeploymentException {
        DeploymentInfo info = this.deploy.getApplicationInfo(appName);
        if (info == null || refs == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < refs.length) {
            if ("application".equals(refs[i].getReferenceTargetType()) && !list.contains(refs[i].toString())) {
                list.add(refs[i].toString());
            }
            ++i;
        }
        refs = info.getReferences();
        if (refs != null) {
            int i2 = 0;
            while (i2 < refs.length) {
                if ("application".equals(refs[i2].getReferenceTargetType()) && !list.contains(refs[i2].toString())) {
                    list.add(refs[i2].toString());
                }
                ++i2;
            }
        }
        String[] refNames = new String[list.size()];
        list.toArray(refNames);
        int i3 = 0;
        while (i3 < refNames.length) {
            if (this.isSuccessor(refNames[i3], appName)) {
                throw new ServerDeploymentException("deploy_5088", new String[]{appName, refNames[i3]});
            }
            ++i3;
        }
    }

    private boolean isSuccessor(String parent, String succ) {
        if (parent.equals(succ)) {
            return true;
        }
        DeploymentInfo info = this.deploy.getApplicationInfo(parent);
        if (info == null) {
            return false;
        }
        ReferenceObject[] refs = info.getReferences();
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                if ("application".equals(refs[i].getReferenceTargetType())) {
                    if (refs[i].toString().equals(succ)) {
                        return true;
                    }
                    if (this.isSuccessor(refs[i].toString(), succ)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public String[] beforeStartingApplication(DeploymentInfo info) throws DeploymentException {
        String[] resources;
        if (info == null) {
            return null;
        }
        ReferenceObject[] refs = info.getReferences();
        ArrayList warnings = new ArrayList();
        boolean found = false;
        ComponentResource resource = null;
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                this.processMakeReference(info.getApplicationName(), refs[i], warnings);
                ++i;
            }
        }
        if ((resources = info.getResources()) != null) {
            String resName = null;
            String resType = null;
            String reference = null;
            try {
                int i = 0;
                while (i < resources.length) {
                    resName = DUtils.decodeResourceName(resources[i]);
                    resType = DUtils.decodeResourceType(resources[i]);
                    reference = DUtils.decodeResourceReferenceType(resources[i]);
                    byte type = "weak".equals(reference) ? (byte)-3 : -4;
                    resource = new ComponentResource(resName, resType, type);
                    if (!this.doesApplicationContainComponent(info, resName, resType)) {
                        found = this.processUsageOfComponent(info.getApplicationName(), resName, resType, reference, warnings, resource);
                        if (found) {
                            this.addUsedResource(info.getApplicationName(), resource);
                        } else {
                            this.addMissingResource(info.getApplicationName(), resource);
                        }
                    }
                    ++i;
                }
            }
            catch (DeploymentException dex) {
                this.addMissingResource(info.getApplicationName(), resource);
                throw dex;
            }
            catch (Exception ex) {
                if (resource != null) {
                    this.addMissingResource(info.getApplicationName(), resource);
                }
                throw new ServerDeploymentException("deploy_5082", new String[]{"starting application " + info.getApplicationName()}, ex);
            }
            catch (Error err) {
                if (resource != null) {
                    this.addMissingResource(info.getApplicationName(), resource);
                }
                throw err;
            }
        }
        String[] res = new String[warnings.size()];
        warnings.toArray(res);
        return res;
    }

    public void processMakeReference(String app, ReferenceObject ref, ArrayList warnings) throws DeploymentException {
        boolean found = false;
        Resource resource = null;
        try {
            byte type;
            byte by = type = "weak".equals(ref.getReferenceType()) ? (byte)-3 : -4;
            if (ref.getReferenceTargetType().equals("interface")) {
                resource = new Resource(ref.getName(), type, 4);
                found = this.processReferenceToInterface(app, ref, warnings);
            } else if (ref.getReferenceTargetType().equals("library")) {
                resource = new Resource(ref.getName(), type, 2);
                found = this.processReferenceToLibrary(app, ref, warnings);
            } else if (ref.getReferenceTargetType().equals("service")) {
                resource = new Resource(ref.getName(), type, 3);
                found = this.processReferenceToService(app, ref, warnings);
            } else if (ref.getReferenceTargetType().equals("application")) {
                resource = new Resource(ref.getName(), type, 1);
                found = this.processReferenceToApplication(app, ref, warnings);
            }
            if (resource != null) {
                if (found) {
                    this.addUsedResource(app, resource);
                } else {
                    this.addMissingResource(app, resource);
                }
            }
        }
        catch (DeploymentException dex) {
            if (resource != null) {
                this.addMissingResource(app, resource);
            }
            throw dex;
        }
        catch (Exception ex) {
            if (resource != null) {
                this.addMissingResource(app, resource);
            }
            throw new ServerDeploymentException("deploy_5082", new String[]{"starting application " + app}, ex);
        }
        catch (Error err) {
            if (resource != null) {
                this.addMissingResource(app, resource);
            }
            throw err;
        }
    }

    protected boolean processReferenceToInterface(String appName, ReferenceObject refs, ArrayList warnings) throws DeploymentException {
        String serverCompName = refs.toString();
        InterfaceMonitor iMonitor = null;
        if (serverCompName.startsWith("interface:") && serverCompName.length() > "interface:".length()) {
            serverCompName = serverCompName.substring("interface:".length());
            iMonitor = this.deploy.getApplicationServiceContext().getContainerContext().getSystemMonitor().getInterface(serverCompName);
            if (iMonitor == null || iMonitor.getStatus() != 4) {
                if (refs.getReferenceType().equals("hard")) {
                    throw new ServerDeploymentException("deploy_5035", new String[]{appName, serverCompName, refs.getReferenceTargetType()});
                }
                warnings.add("Interface " + serverCompName + " is not deployed or loaded, but resolving of application " + appName + " continues because it has weak reference to this interface.");
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean processReferenceToService(String appName, ReferenceObject refs, ArrayList warnings) throws DeploymentException {
        block10: {
            String serverCompName = refs.toString();
            ServiceMonitor sMonitor = null;
            if (serverCompName.startsWith("service:") && serverCompName.length() > "service:".length()) {
                serverCompName = serverCompName.substring("service:".length());
                sMonitor = this.deploy.getApplicationServiceContext().getContainerContext().getSystemMonitor().getService(serverCompName);
                if (sMonitor == null) {
                    if (refs.getReferenceType().equals("hard")) {
                        throw new ServerDeploymentException("deploy_5035", new String[]{appName, serverCompName, refs.getReferenceTargetType()});
                    }
                    warnings.add("Service " + serverCompName + " is not deployed or loaded, but resolving of application " + appName + " continues because it has a weak reference to this service.");
                } else {
                    if (sMonitor.getStatus() == 4) {
                        try {
                            this.deploy.logInfo("Application " + appName + " has " + refs.getReferenceType() + " reference to service " + serverCompName + " and is going to start it.");
                            sMonitor.start();
                            return true;
                        }
                        catch (ServiceException sex) {
                            this.deploy.logThrowable(sex);
                            if (refs.getReferenceType().equals("weak")) {
                                warnings.add("Service " + serverCompName + " cannot be started because " + sex.getMessage() + ", but resolving of application " + appName + " continues because it has weak reference to this service.");
                                break block10;
                            }
                            throw new ServerDeploymentException("deploy_5035", new String[]{appName, serverCompName, refs.getReferenceTargetType()}, sex);
                        }
                    }
                    if (sMonitor.getStatus() == 5) {
                        return true;
                    }
                    if (refs.getReferenceType().equals("hard")) {
                        throw new ServerDeploymentException("deploy_5035", new String[]{appName, serverCompName, refs.getReferenceTargetType()});
                    }
                    warnings.add("Service " + serverCompName + " is not deployed or loaded, but resolving of application " + appName + " continues because it has weak reference to this service.");
                }
            }
        }
        return false;
    }

    protected boolean processReferenceToLibrary(String appName, ReferenceObject refs, ArrayList warnings) throws DeploymentException {
        String serverCompName = refs.toString();
        LibraryMonitor lMonitor = null;
        if (serverCompName.startsWith("library:") && serverCompName.length() > "library:".length()) {
            serverCompName = serverCompName.substring("library:".length());
            lMonitor = this.deploy.getApplicationServiceContext().getContainerContext().getSystemMonitor().getLibrary(serverCompName);
            if (lMonitor == null || lMonitor.getStatus() != 4) {
                if (refs.getReferenceType().equals("hard")) {
                    throw new ServerDeploymentException("deploy_5035", new String[]{appName, serverCompName, refs.getReferenceTargetType()});
                }
                warnings.add("Library " + serverCompName + " is not deployed or loaded, but resolving of application " + appName + " continues because it has weak reference to this library.");
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean processUsageOfComponent(String appName, String compName, String compType, String refType, ArrayList warnings, ComponentResource resource) throws DeploymentException {
        int type;
        ComponentResource foundInLocals = this.foundInLocalAloneResources(resource);
        if (foundInLocals != null) {
            resource.setLoaderName(foundInLocals.getLoaderName());
            return true;
        }
        String foundInApp = this.getApplicationForComponent(compName, compType);
        int n = type = "weak".equals(refType) ? -3 : -4;
        if (foundInApp == null) {
            switch (type) {
                case -3: {
                    warnings.add("Application " + appName + " has a weak reference to resource " + compName + " with type " + compType + " but the resource is not available and the application may not work correctly!");
                    break;
                }
                case -4: {
                    throw new ServerDeploymentException("deploy_5035", new String[]{appName, compName, compType});
                }
            }
        } else {
            DeploymentInfo foundInAppInfo = this.deploy.getApplicationInfo(foundInApp);
            byte status = foundInAppInfo.getStatus();
            if (status == 6 || status == 0) {
                try {
                    this.deploy.startApplicationLocalAndWait(foundInAppInfo.getApplicationName());
                    resource.setLoaderName(foundInAppInfo.getLoaderName());
                    resource.setAppName(foundInAppInfo.getApplicationName());
                    return true;
                }
                catch (OutOfMemoryError oofmer) {
                    throw oofmer;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable dex) {
                    if (type == -4) {
                        throw new ServerDeploymentException("deploy_5035", new String[]{appName, compName, compType}, dex);
                    }
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5035", new String[]{appName, compName, compType}, dex);
                    sdex.log();
                    warnings.add("Application " + foundInApp + " containing component " + compName + ", is not started but resolving of application " + appName + " continues because it has weak reference to this application.");
                }
            } else if (status == 1) {
                resource.setLoaderName(foundInAppInfo.getLoaderName());
                resource.setAppName(foundInAppInfo.getApplicationName());
                return true;
            }
        }
        return false;
    }

    protected boolean processReferenceToApplication(String appName, ReferenceObject refs, ArrayList warnings) throws DeploymentException {
        DeploymentInfo refApp = this.deploy.getApplicationInfo(refs.toString());
        if (refApp == null) {
            String[] externalConts = this.deploy.getExternalContainerNames();
            if (externalConts == null || externalConts.length == 0) {
                if (refs.getReferenceType().equals("hard")) {
                    throw new ServerDeploymentException("deploy_5035", new String[]{appName, refs.getReferenceTarget(), refs.getReferenceTargetType()});
                }
                warnings.add("Application " + refs.toString() + " is not deployed, but resolving of application " + appName + " continues because it has weak reference to this application.");
            } else {
                try {
                    warnings.add("Application " + appName + " has " + refs.getReferenceType() + " reference to application " + refs.toString() + " and is starting it!");
                    this.deploy.startApplicationLocalAndWait(refs.toString());
                    return true;
                }
                catch (OutOfMemoryError oofmer) {
                    throw oofmer;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable dex) {
                    if (refs.getReferenceType().equals("hard")) {
                        throw new ServerDeploymentException("deploy_5035", new String[]{appName, refs.getReferenceTarget(), refs.getReferenceTargetType()}, dex);
                    }
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5035", new String[]{appName, refs.getReferenceTarget(), refs.getReferenceTargetType()}, dex);
                    sdex.log();
                    warnings.add("Application " + refs.getReferenceTarget() + " is not started, but resolving of application " + appName + " continues because it has weak reference to this application.");
                }
            }
        } else if (refApp.getStatus() == 0 || refApp.getStatus() == 6) {
            try {
                warnings.add("Application " + appName + " has " + refs.getReferenceType() + " reference to application " + refApp.getApplicationName() + " and is starting it!");
                this.deploy.startApplicationLocalAndWait(refApp.getApplicationName());
                return true;
            }
            catch (OutOfMemoryError oofmer) {
                throw oofmer;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable dex) {
                if (refs.getReferenceType().equals("hard")) {
                    throw new ServerDeploymentException("deploy_5035", new String[]{appName, refs.getReferenceTarget(), refs.getReferenceTargetType()}, dex);
                }
                ServerDeploymentException sdex = new ServerDeploymentException("deploy_5035", new String[]{appName, refs.getReferenceTarget(), refs.getReferenceTargetType()}, dex);
                sdex.log();
                warnings.add("Application " + refs.getReferenceTarget() + " is not started, but resolving of application " + appName + " continues because it has weak reference to this application.");
            }
        } else if (refApp.getStatus() == 1) {
            return true;
        }
        return false;
    }

    public String[] beforeStoppingApplication(DeploymentInfo info) throws DeploymentException {
        ArrayList<String> warnings = new ArrayList<String>();
        ReferenceObject[] refs = info.getReferenesFrom();
        DeploymentInfo from = null;
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                if (refs[i].getReferenceTargetType().equals("application")) {
                    from = this.deploy.getApplicationInfo(refs[i].toString());
                    if (from == null) {
                        String[] externalConts = this.deploy.getExternalContainerNames();
                        if (externalConts == null || externalConts.length == 0) {
                            info.removeReferencesFrom(new String[]{refs[i].toString()});
                        } else {
                            try {
                                if (refs[i].getReferenceType().equals("hard")) {
                                    this.deploy.stopApplicationLocalAndWait(refs[i].toString(), true);
                                    warnings.add("Stopping application " + refs[i].toString() + " because it has a hard reference to application " + info.getApplicationName() + ", but it is being stopped.");
                                    this.addMissingResource(refs[i].toString(), Resource.createResource((byte)1, info.getApplicationName(), (byte)-4));
                                }
                                this.addMissingResource(refs[i].toString(), Resource.createResource((byte)1, info.getApplicationName(), (byte)-3));
                                warnings.add("Application " + refs[i].toString() + " has a weak reference to application " + info.getApplicationName() + " which is being stopped and it may not work correctly.");
                            }
                            catch (DeploymentException dex) {
                                throw new ServerDeploymentException("deploy_5087", new String[]{info.getApplicationName(), refs[i].toString(), refs[i].getReferenceTargetType()}, dex);
                            }
                        }
                    } else {
                        byte reference = refs[i].getReferenceType().equals("weak") ? (byte)-3 : -4;
                        this.processAppRefToStoppingResource(from.getApplicationName(), Resource.createResource((byte)1, info.getApplicationName(), reference), warnings);
                    }
                }
                ++i;
            }
        }
        String[] res = new String[warnings.size()];
        warnings.toArray(res);
        return res;
    }

    private void processAppRefToStoppingResource(String fromApp, Resource resource, ArrayList warnings) throws DeploymentException {
        if (fromApp == null || resource == null) {
            return;
        }
        boolean used = false;
        Resource[] resources = (Resource[])this.appsUsedResources.get(fromApp);
        if (resources != null) {
            boolean equalsWithoutReference = false;
            boolean componentInApplication = false;
            int i = 0;
            while (i < resources.length) {
                equalsWithoutReference = resource.equalsWithoutReference(resources[i]);
                if (!equalsWithoutReference && resource.getType() == 1 && resources[i].getType() == 5 && resource.getName().equals(((ComponentResource)resources[i]).getAppName())) {
                    componentInApplication = true;
                }
                if (equalsWithoutReference || componentInApplication) {
                    resource.setReference(resources[i].getReference());
                    this.addMissingResource(fromApp, resources[i]);
                    used = true;
                }
                ++i;
            }
        }
        if (used) {
            DeploymentInfo from = this.deploy.getApplicationInfo(fromApp);
            if (from == null) {
                return;
            }
            if (from.getStatus() == 1) {
                try {
                    if (resource.getReference() == -4) {
                        this.deploy.stopApplicationLocalAndWait(from.getApplicationName(), true);
                    } else {
                        warnings.add("Application " + fromApp + " has a weak reference to application " + resource.getName() + " which is being stopped and it may not work correctly.");
                    }
                }
                catch (DeploymentException dex) {
                    throw new ServerDeploymentException("deploy_5087", new String[]{resource.getName(), fromApp, "application"}, dex);
                }
                catch (OutOfMemoryError oofmer) {
                    throw oofmer;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable dex) {
                    if (resource.getReference() == -4) {
                        throw new ServerDeploymentException("deploy_5087", new String[]{resource.getName(), fromApp, "application"}, dex);
                    }
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5087", new String[]{resource.getName(), fromApp, "application"}, dex);
                    sdex.log();
                    warnings.add("Application " + fromApp + " was not started, but resolving of application " + resource.getName() + " continues because it has a weak reference to this application.");
                }
            }
        }
    }

    public void processRemoveReference(String fromApp, Resource resource, ArrayList warnings) throws DeploymentException {
        if (fromApp == null || resource == null) {
            return;
        }
        boolean used = false;
        Resource[] resources = (Resource[])this.appsUsedResources.get(fromApp);
        if (resources != null) {
            int i = 0;
            while (i < resources.length) {
                if (resource.equalsWithoutReference(resources[i])) {
                    resource.setReference(resources[i].getReference());
                    this.removeUsedResource(fromApp, resource);
                    used = true;
                    break;
                }
                ++i;
            }
        }
        this.removeMissingResource(fromApp, resource, false);
    }

    public String getApplicationForComponent(String resName, String resType) {
        String[] apps = this.deploy.listApplications();
        if (apps != null) {
            int i = 0;
            while (i < apps.length) {
                if (this.doesApplicationContainComponent(this.deploy.getApplicationInfo(apps[i]), resName, resType)) {
                    return apps[i];
                }
                ++i;
            }
        }
        return null;
    }

    public boolean doesApplicationContainComponent(DeploymentInfo info, String resName, String resType) {
        String[] types = null;
        return info != null && (types = info.getResTypesOfComponent(resName)) != null && this.found(resType, types);
    }

    private boolean found(String res, String[] components) {
        int i = 0;
        while (i < components.length) {
            if (res.equals(components[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void addMissingResource(String appName, Resource resource) {
        Resource[] res = this.addResource((Resource[])this.appsMissingResources.get(appName), resource);
        if (res != null && res.length > 0) {
            this.appsMissingResources.put(appName, res);
        }
        this.removeUsedResource(appName, resource);
    }

    public synchronized Resource getReasonForImplicitStopped(String appName) {
        if (appName == null || this.appsMissingResources.get(appName) == null) {
            return null;
        }
        Resource[] resources = (Resource[])this.appsMissingResources.get(appName);
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getReference() == -4) {
                return resources[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized void removeMissingResource(String appName, Resource resource, boolean addToUsed) {
        Resource[] res = this.removeResource((Resource[])this.appsMissingResources.get(appName), resource);
        if (res != null && res.length > 0) {
            this.appsMissingResources.put(appName, res);
        } else {
            this.appsMissingResources.remove(appName);
        }
        if (addToUsed) {
            this.addUsedResource(appName, resource);
        }
    }

    public synchronized void addUsedResource(String appName, Resource resource) {
        Resource[] res = this.addResource((Resource[])this.appsUsedResources.get(appName), resource);
        if (res != null && res.length > 0) {
            this.appsUsedResources.put(appName, res);
        }
        this.removeMissingResource(appName, resource, false);
    }

    public synchronized void removeUsedResource(String appName, Resource resource) {
        Resource[] res = this.removeResource((Resource[])this.appsUsedResources.get(appName), resource);
        if (res != null && res.length > 0) {
            this.appsUsedResources.put(appName, res);
        } else {
            this.appsUsedResources.remove(appName);
        }
    }

    private Resource[] addResource(Resource[] resources, Resource resource) {
        if (resource == null) {
            return resources;
        }
        if (resources == null || resources.length == 0) {
            return new Resource[]{resource};
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i].equalsWithoutReference(resource)) {
                return resources;
            }
            ++i;
        }
        Resource[] res = new Resource[resources.length + 1];
        System.arraycopy(resources, 0, res, 0, resources.length);
        res[resources.length] = resource;
        return res;
    }

    private Resource[] removeResource(Resource[] resources, Resource resource) {
        if (resource == null) {
            return resources;
        }
        if (resources == null || resources.length == 0) {
            return resources;
        }
        ArrayList<Resource> list = new ArrayList<Resource>();
        int i = 0;
        while (i < resources.length) {
            if (!resources[i].equalsWithoutReference(resource)) {
                list.add(resources[i]);
            }
            ++i;
        }
        Resource[] res = new Resource[list.size()];
        list.toArray(res);
        return res;
    }

    public void removeMissingResources(String appName) {
        this.appsMissingResources.remove(appName);
    }

    public void removeUsedResources(String appName) {
        this.appsUsedResources.remove(appName);
    }

    public String[] getUsedComponentLoaders(String app) {
        Resource[] resources = (Resource[])this.appsUsedResources.get(app);
        if (resources == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getType() == 5 && resources[i] instanceof ComponentResource && ((ComponentResource)resources[i]).getLoaderName() != null) {
                list.add(((ComponentResource)resources[i]).getLoaderName());
            }
            ++i;
        }
        String[] res = new String[list.size()];
        list.toArray(res);
        return res;
    }

    public void addAloneComponent(String componentName, String resourceType, String loaderName) throws DeploymentException {
        if (componentName == null || resourceType == null) {
            return;
        }
        ComponentResource cres = new ComponentResource(componentName, resourceType, -2);
        cres.setLoaderName(loaderName);
        Resource[] temp = this.addResource(this.localAloneComponents, cres);
        if (temp != null) {
            this.localAloneComponents = new ComponentResource[temp.length];
            int i = 0;
            while (i < temp.length) {
                this.localAloneComponents[i] = (ComponentResource)temp[i];
                ++i;
            }
        }
        this.resourceAvailable(cres);
    }

    public void removeAloneComponent(String componentName, String resourceType) throws DeploymentException {
        if (componentName == null || resourceType == null) {
            return;
        }
        ComponentResource cres = new ComponentResource(componentName, resourceType, -2);
        this.localAloneComponents = (ComponentResource[])this.removeResource(this.localAloneComponents, cres);
        this.resourceUnavailable(cres);
    }

    private ComponentResource foundInLocalAloneResources(ComponentResource res) {
        if (res == null || res.getName() == null || res.getComponentType() == null) {
            return null;
        }
        Resource found = this.foundResource(this.localAloneComponents, res, true);
        if (found != null) {
            return (ComponentResource)found;
        }
        return null;
    }
}

