/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.services.deploy.DeployEvent;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DTransaction;
import com.sap.engine.services.deploy.server.DeployEventSystem;
import com.sap.engine.services.deploy.server.TransactionManager;
import com.sap.engine.services.deploy.server.application.ApplicationTransaction;
import com.sap.engine.services.deploy.server.application.ParallelAdapter;
import java.util.ArrayList;

public class FinishListener
implements Runnable {
    private DTransaction[] transactions = new DTransaction[0];
    private boolean wait = true;
    private boolean sendEvent = false;
    private DeployEventSystem eventSystem = null;
    private String operation;
    private ArrayList errors = new ArrayList();
    private ArrayList warnings = new ArrayList();
    private String whoCausedGroupOperation = null;
    private TransactionManager tManager = null;
    private ApplicationServiceContext asc = null;

    public FinishListener(DTransaction[] trans, boolean wait, boolean sendEvent, DeployEventSystem eventSystem, String operation) throws DeploymentException {
        this.transactions = trans;
        this.operation = operation;
        this.wait = wait;
        this.sendEvent = sendEvent;
        this.eventSystem = eventSystem;
    }

    public void setTransactionManager(TransactionManager tManager) {
        this.tManager = tManager;
    }

    public void setApplicationServiceContext(ApplicationServiceContext asc) {
        this.asc = asc;
    }

    public void makeOperation() {
        if (this.wait) {
            this.run();
        } else {
            this.asc.getCoreContext().getThreadSystem().startThread((Runnable)this, true, true);
        }
    }

    public void run() {
        if (this.transactions == null || this.transactions.length == 0) {
            this.notifyForCompletition();
            return;
        }
        int i = 0;
        while (i < this.transactions.length) {
            block14: {
                try {
                    if (this.transactions[i] != null) {
                        if (this.transactions[i].unregister()) {
                            this.tManager.registerTransactionWithLock(this.transactions[i], this.transactions[i].getLockType(), false);
                        } else {
                            this.tManager.registerTransactionWithoutLock(this.transactions[i]);
                        }
                        if (this.transactions[i] instanceof ParallelAdapter) {
                            ((ParallelAdapter)this.transactions[i]).makeAllPhasesLocalAndWait();
                        } else {
                            this.transactions[i].makeAllPhasesLocal();
                        }
                        if (this.transactions[i].getCurrentStatistics() != null) {
                            this.addWarnings(this.transactions[i].getCurrentStatistics().getWarnings());
                        }
                    }
                }
                catch (OutOfMemoryError oofme) {
                    throw oofme;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (DeploymentException dex) {
                    if (this.transactions[i] != null && this.transactions[i] instanceof ApplicationTransaction && !((ApplicationTransaction)this.transactions[i]).getTransactionCommunicator().isMarkedForShutdown()) {
                        this.addError("Error during " + this.transactions[i].getTransactionType() + " application " + this.transactions[i].getModuleID() + " : " + dex.toString());
                        dex.log();
                    }
                }
                catch (Throwable th) {
                    if (this.transactions[i] == null || !(this.transactions[i] instanceof ApplicationTransaction) || ((ApplicationTransaction)this.transactions[i]).getTransactionCommunicator().isMarkedForShutdown()) break block14;
                    this.addError("Error during " + this.transactions[i].getTransactionType() + " application " + this.transactions[i].getModuleID() + " : " + th.toString());
                    new ServerDeploymentException("deploy_5029", new String[]{this.transactions[i].getTransactionType(), this.transactions[i].getModuleID()}, th).log();
                }
            }
            ++i;
        }
        this.notifyForCompletition();
    }

    private void notifyForCompletition() {
        byte actionType;
        if (this.sendEvent && (actionType = this.eventSystem.defineActionType(this.operation)) != -1) {
            DeployEvent event = new DeployEvent(null, 3, actionType, this.eventSystem.getServerName());
            event.setWhoCausedGroupOperation(this.whoCausedGroupOperation);
            event.setErrors(this.listToStringArray(this.errors));
            event.setWarnings(this.listToStringArray(this.warnings));
            try {
                this.eventSystem.fireDeployEvent(event, (byte)0);
            }
            catch (DeploymentException dex) {
                dex.log();
            }
        }
    }

    public void addError(String error) {
        if (error != null) {
            this.errors.add(error);
        }
    }

    public void addWarnings(String[] warnings) {
        if (warnings != null) {
            int i = 0;
            while (i < warnings.length) {
                this.warnings.add(warnings[i]);
                ++i;
            }
        }
    }

    public String[] listToStringArray(ArrayList list) {
        if (list.size() == 0) {
            return null;
        }
        String[] res = new String[list.size()];
        list.toArray(res);
        return res;
    }

    public void setWhoCausedGroupOperation(String who) {
        this.whoCausedGroupOperation = who;
    }
}

