/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.server.DUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DeploymentInfo
extends AdditionalAppInfo {
    public static final byte STOPPED = 0;
    public static final byte STARTED = 1;
    public static final byte UPGRADING = 2;
    public static final byte STARTING = 3;
    public static final byte STOPPING = 4;
    public static final byte UNKNOWN = 5;
    public static final byte IMPLICIT_STOPPED = 6;
    private String applicationName;
    private String[] containerFilesForClassLoader;
    private String[] internalLibraries;
    private boolean isStandAloneArchive;
    private byte status;
    private String[] remoteSupport = null;
    private Properties props = null;
    private String[] containerNames = null;
    private String[] languageLibs = null;
    private ReferenceObject[] references = null;
    private ReferenceObject[] referencesFrom = null;
    private Hashtable containers_deployedComponents = new Hashtable();
    private Hashtable deployedComponents_resTypes = null;
    private String additionalClasspath = null;
    private String applicationLoaderName = null;
    private String sapManifestCfg = null;
    private String appConfigurationPath = null;
    private long appArchiveSize = -1L;
    private long deploymentDuration = -1L;
    private int numberOfRedeploys = 0;
    private String timeOfLastRedeployment = "0";
    private String[] resources = null;
    private ArrayList appsContainingNecessaryResources = null;
    private Vector optionalContainers = null;
    private Hashtable containers_deployedFileNames = new Hashtable();

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String[] getContainerFilesForClassLoader() {
        return this.containerFilesForClassLoader;
    }

    public String[] getInternalLibraries() {
        return this.internalLibraries;
    }

    public void setStandAloneArchive(boolean isStandAloneArchive) {
        this.isStandAloneArchive = isStandAloneArchive;
    }

    public boolean isStandAloneArchive() {
        return this.isStandAloneArchive;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setRemoteSupport(String[] remoteSupport) {
        this.remoteSupport = remoteSupport;
    }

    public String[] getRemoteSupport() {
        return this.remoteSupport;
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setInternalLibraries(String[] temp) {
        this.internalLibraries = this.getRelativePaths(temp);
    }

    public void addContainerFilesForClassLoader(String[] temp) {
        if (temp == null || temp.length == 0) {
            return;
        }
        String[] paths = this.getRelativePaths(temp);
        if (this.containerFilesForClassLoader == null) {
            this.containerFilesForClassLoader = paths;
        } else {
            File current = null;
            File tempFile = null;
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < paths.length) {
                if (!list.contains(paths[i])) {
                    current = new File(paths[i]);
                    int j = 0;
                    j = 0;
                    while (j < list.size()) {
                        tempFile = new File((String)list.get(j));
                        if (tempFile.getAbsolutePath().equals(current.getAbsolutePath())) break;
                        ++j;
                    }
                    if (j == list.size()) {
                        list.add(paths[i]);
                    }
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.containerFilesForClassLoader.length) {
                if (!list.contains(this.containerFilesForClassLoader[i2])) {
                    int j = 0;
                    current = new File(this.containerFilesForClassLoader[i2]);
                    j = 0;
                    while (j < list.size()) {
                        tempFile = new File((String)list.get(j));
                        if (tempFile.getAbsolutePath().equals(current.getAbsolutePath())) break;
                        ++j;
                    }
                    if (j == list.size()) {
                        list.add(this.containerFilesForClassLoader[i2]);
                    }
                }
                ++i2;
            }
            this.containerFilesForClassLoader = new String[list.size()];
            list.toArray(this.containerFilesForClassLoader);
        }
    }

    public void addLanguageLibs(String[] jars) {
        if (jars != null) {
            String[] paths = this.getRelativePaths(jars);
            if (this.languageLibs == null) {
                this.languageLibs = paths;
            } else {
                String[] f = new String[this.languageLibs.length + jars.length];
                System.arraycopy(this.languageLibs, 0, f, 0, this.languageLibs.length);
                System.arraycopy(paths, 0, f, this.languageLibs.length, paths.length);
                this.languageLibs = f;
            }
        }
    }

    public void setContainerFilesForClassLoader(String[] temp) {
        this.containerFilesForClassLoader = temp;
    }

    public void setInternalLibraries(File[] componentArchives) {
        if (componentArchives != null) {
            String[] temp = new String[componentArchives.length];
            int i = 0;
            while (i < componentArchives.length) {
                temp[i] = componentArchives[i].getAbsolutePath();
                ++i;
            }
            this.internalLibraries = this.getRelativePaths(temp);
        }
    }

    public void addFilesForClassLoader(File[] temp) {
        if (temp != null) {
            String[] tempFiles = new String[temp.length];
            int i = 0;
            while (i < temp.length) {
                tempFiles[i] = temp[i].getAbsolutePath();
                ++i;
            }
            this.addContainerFilesForClassLoader(tempFiles);
        }
    }

    private String[] getRelativePaths(String[] temp) {
        String[] res = null;
        if (temp != null) {
            res = new String[temp.length];
            int i = 0;
            while (i < temp.length) {
                res[i] = this.getRelativePath(temp[i]);
                ++i;
            }
        }
        return res;
    }

    private String getRelativePath(String fName) {
        File file = new File(fName);
        if (!file.isAbsolute()) {
            return fName.replace('\\', '/');
        }
        String currentDir = SystemProperties.getProperty((String)"user.dir");
        fName = fName.replace('\\', File.separatorChar);
        if ((fName = fName.replace('/', File.separatorChar)).indexOf(currentDir) > -1) {
            fName = fName.substring(currentDir.length() + 1);
        }
        fName = fName.replace('\\', '/');
        return fName;
    }

    public void preparePaths() {
        int i;
        if (this.containerFilesForClassLoader != null) {
            i = 0;
            while (i < this.containerFilesForClassLoader.length) {
                this.containerFilesForClassLoader[i] = this.getRelativePath(this.containerFilesForClassLoader[i]);
                ++i;
            }
        }
        if (this.internalLibraries != null) {
            i = 0;
            while (i < this.internalLibraries.length) {
                this.internalLibraries[i] = this.getRelativePath(this.internalLibraries[i]);
                ++i;
            }
        }
    }

    public String toString() {
        int i;
        String res = "DeploymentInfo of application with name " + this.applicationName + "\n" + "\n" + "\t is stand alone module: " + this.isStandAloneArchive + "\n" + "\t module properties: " + this.props + "\n" + "\t files for ApplicationClassloader: ";
        if (this.containerFilesForClassLoader != null) {
            i = 0;
            while (i < this.containerFilesForClassLoader.length) {
                res = res + this.containerFilesForClassLoader[i] + "; ";
                ++i;
            }
        }
        if (this.internalLibraries != null) {
            res = res + "\n\t Internal Libraries: ";
            i = 0;
            while (i < this.internalLibraries.length) {
                res = res + this.internalLibraries[i] + "; ";
                ++i;
            }
        }
        if (this.containerNames != null) {
            res = res + "\n\t The names of concerned containers : ";
            i = 0;
            while (i < this.containerNames.length) {
                res = res + this.containerNames[i] + "; ";
                ++i;
            }
        }
        if (this.languageLibs != null) {
            res = res + "\n\t Language libraries for this application: ";
            i = 0;
            while (i < this.languageLibs.length) {
                res = res + this.languageLibs[i] + "; ";
                ++i;
            }
        }
        if (this.remoteSupport != null) {
            res = res + "\n\t remoteSupport: ";
            i = 0;
            while (i < this.remoteSupport.length) {
                res = res + this.remoteSupport[i] + "; ";
                ++i;
            }
        }
        res = res + "\n\t status: ";
        if (this.status == 0) {
            res = res + "STOPPED";
        } else if (this.status == 1) {
            res = res + "STARTED";
        } else if (this.status == 3) {
            res = res + "STARTING";
        } else if (this.status == 4) {
            res = res + "STOPPING";
        } else if (this.status == 2) {
            res = res + "UPGRADING";
        } else if (this.status == 5) {
            res = res + "UNKNOWN";
        } else if (this.status == 6) {
            res = res + "IMPLICIT_STOPPED";
        }
        res = res + "\n";
        return res;
    }

    public void setLanguageLibs(String[] libs) {
        this.languageLibs = this.getRelativePaths(libs);
    }

    public String[] getLanguageLibs() {
        return this.languageLibs;
    }

    public void setContainerNames(String[] contNames) {
        this.containerNames = contNames;
    }

    public String[] getContainerNames() {
        return this.containerNames;
    }

    public void addContainerName(String contName) {
        if (this.containerNames == null) {
            this.containerNames = new String[]{contName};
        } else {
            int i = 0;
            while (i < this.containerNames.length) {
                if (this.containerNames[i].equals(contName)) {
                    return;
                }
                ++i;
            }
            String[] temp = new String[this.containerNames.length + 1];
            System.arraycopy(this.containerNames, 0, temp, 0, this.containerNames.length);
            temp[this.containerNames.length] = contName;
            this.containerNames = temp;
        }
    }

    public Object clone() {
        String[] temp;
        DeploymentInfo info = new DeploymentInfo();
        info.setApplicationName(this.applicationName);
        info.setStandAloneArchive(this.isStandAloneArchive);
        if (this.props != null) {
            info.setProperties((Properties)((Hashtable)this.props).clone());
        }
        info.setStatus(this.status);
        info.setLoaderName(this.getLoaderName());
        info.setDeployedComponents((Hashtable)this.getDeployedComponents().clone());
        if (this.containerFilesForClassLoader != null) {
            temp = new String[this.containerFilesForClassLoader.length];
            System.arraycopy(this.containerFilesForClassLoader, 0, temp, 0, this.containerFilesForClassLoader.length);
            info.setContainerFilesForClassLoader(temp);
        }
        if (this.internalLibraries != null) {
            temp = new String[this.internalLibraries.length];
            System.arraycopy(this.internalLibraries, 0, temp, 0, this.internalLibraries.length);
            info.setInternalLibraries(temp);
        }
        if (this.languageLibs != null) {
            temp = new String[this.languageLibs.length];
            System.arraycopy(this.languageLibs, 0, temp, 0, this.languageLibs.length);
            info.setLanguageLibs(temp);
        }
        if (this.containerNames != null) {
            temp = new String[this.containerNames.length];
            System.arraycopy(this.containerNames, 0, temp, 0, this.containerNames.length);
            info.setContainerNames(temp);
        }
        if (this.remoteSupport != null) {
            temp = new String[this.remoteSupport.length];
            System.arraycopy(this.remoteSupport, 0, temp, 0, this.remoteSupport.length);
            info.setRemoteSupport(temp);
        }
        if (this.references != null) {
            ReferenceObject[] clonningRefs = new ReferenceObject[this.references.length];
            int i = 0;
            while (i < this.references.length) {
                clonningRefs[i] = (ReferenceObject)this.references[i].clone();
                ++i;
            }
            info.setReferences(clonningRefs);
        }
        info.setAdditionalClasspath(this.getAdditionalClasspath());
        info.setFailOverValue(this.getFailOverValue());
        info.setSAPManifestConfiguration(this.getSAPManifestConfiguration());
        info.setApplicationConfigurationPath(this.getApplicationConfigurationPath());
        return info;
    }

    public ReferenceObject[] getReferences() {
        return this.references;
    }

    void setReferences(ReferenceObject[] references) {
        this.references = references;
    }

    ReferenceObject[] addReference(ReferenceObject ref, ReferenceObject[] toRefs) {
        return DUtils.concatReferences(toRefs, new ReferenceObject[]{ref});
    }

    void addReference(ReferenceObject ref) {
        this.references = this.addReference(ref, this.references);
    }

    void removeReferences(String[] refs) {
        this.references = this.removeReferences(refs, this.references);
    }

    ReferenceObject[] removeReferences(String[] references1, ReferenceObject[] fromRefs) {
        if (fromRefs == null || references1 == null || references1.length == 0) {
            return fromRefs;
        }
        int i = 0;
        while (i < references1.length) {
            fromRefs = this.removeReference(references1[i], fromRefs);
            ++i;
        }
        return fromRefs;
    }

    ReferenceObject[] removeReference(String ref, ReferenceObject[] fromRefs) {
        if (ref == null || fromRefs == null || fromRefs.length == 0) {
            return fromRefs;
        }
        ArrayList<ReferenceObject> list = new ArrayList<ReferenceObject>();
        int i = 0;
        while (i < fromRefs.length) {
            if (!fromRefs[i].toString().equals(ref)) {
                list.add(fromRefs[i]);
            }
            ++i;
        }
        if (list.size() < fromRefs.length) {
            fromRefs = new ReferenceObject[list.size()];
            list.toArray(fromRefs);
        }
        return fromRefs;
    }

    public void addDeployedComponents(String containerName, String[] deployedComponents) {
        if (containerName == null) {
            return;
        }
        String[] res = DUtils.concatArrays((String[])this.containers_deployedComponents.get(containerName), deployedComponents);
        if (res == null) {
            return;
        }
        this.containers_deployedComponents.put(containerName, res);
    }

    public void removeDeployedComponents(String containerName) {
        this.containers_deployedComponents.remove(containerName);
    }

    public void removeDeployedComponents(String containerName, String[] deployedComponents) {
        if (containerName == null || deployedComponents == null || deployedComponents.length == 0) {
            return;
        }
        String[] old = (String[])this.containers_deployedComponents.get(containerName);
        if (old == null || old.length == 0) {
            return;
        }
        Vector<String> res = new Vector<String>();
        boolean found = false;
        int i = 0;
        while (i < old.length) {
            found = false;
            int j = 0;
            while (j < deployedComponents.length) {
                if (old[i].equals(deployedComponents[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                res.add(old[i]);
            }
            ++i;
        }
        if (res.size() == 0) {
            this.containers_deployedComponents.remove(containerName);
        } else {
            String[] temp = new String[res.size()];
            res.toArray(temp);
            this.containers_deployedComponents.put(containerName, res);
        }
    }

    public Hashtable getDeployedComponents() {
        return this.containers_deployedComponents;
    }

    public String[] getDeployedComponents(String containerName) {
        if (containerName == null) {
            String[] components = null;
            Enumeration cmps = this.containers_deployedComponents.elements();
            while (cmps.hasMoreElements()) {
                components = DUtils.concatArrays(components, (String[])cmps.nextElement());
            }
            return components;
        }
        return (String[])this.containers_deployedComponents.get(containerName);
    }

    public void setDeployedComponents(Hashtable hash) {
        if (hash == null) {
            return;
        }
        this.containers_deployedComponents = hash;
    }

    public Hashtable getDeployedFileNames() {
        return this.containers_deployedFileNames;
    }

    public void setDeployedFileNames(Hashtable hash) {
        if (hash == null) {
            return;
        }
        this.containers_deployedFileNames = hash;
    }

    public String[] getDeployedFileNames(String contName) {
        if (this.containers_deployedFileNames == null) {
            return null;
        }
        return (String[])this.containers_deployedFileNames.get(contName);
    }

    public void addDeployedFileNames(String contName, String[] fileNames) {
        if (contName == null || fileNames == null) {
            return;
        }
        if (this.containers_deployedFileNames == null) {
            this.containers_deployedFileNames = new Hashtable();
        }
        this.containers_deployedFileNames.put(contName, fileNames);
    }

    public void setLoaderName(String loaderName) {
        this.applicationLoaderName = loaderName;
    }

    public String getLoaderName() {
        return this.applicationLoaderName;
    }

    public void setAdditionalClasspath(String additionalClPath) {
        this.additionalClasspath = additionalClPath;
    }

    public String getAdditionalClasspath() {
        return this.additionalClasspath;
    }

    public String[] getApplicationLoaderFiles() {
        String[] classLoaderJars = DUtils.concatArrays(this.getInternalLibraries(), this.getContainerFilesForClassLoader());
        if (this.getAdditionalClasspath() != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.getAdditionalClasspath(), ";");
            String[] additionalCl = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                additionalCl[i++] = tokenizer.nextToken();
            }
            classLoaderJars = DUtils.concatArrays(classLoaderJars, additionalCl);
        }
        if (classLoaderJars != null) {
            File file = null;
            File temp = null;
            Vector<String> res = new Vector<String>();
            boolean found = false;
            int i = 0;
            while (i < classLoaderJars.length) {
                found = false;
                file = new File(classLoaderJars[i]);
                int j = 0;
                while (j < res.size()) {
                    temp = new File((String)res.elementAt(j));
                    if (file.getAbsolutePath().equals(temp.getAbsolutePath())) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    res.add(classLoaderJars[i]);
                }
                ++i;
            }
            classLoaderJars = new String[res.size()];
            res.toArray(classLoaderJars);
        }
        return classLoaderJars;
    }

    public ReferenceObject[] getReferenesFrom() {
        return this.referencesFrom;
    }

    public void setReferencesFrom(ReferenceObject[] refs) {
        this.referencesFrom = refs;
    }

    synchronized void addReferenceFrom(ReferenceObject ref) {
        this.referencesFrom = this.addReference(ref, this.referencesFrom);
    }

    synchronized void removeReferencesFrom(String[] references) {
        this.referencesFrom = this.removeReferences(references, this.referencesFrom);
    }

    public void setSAPManifestConfiguration(String manifestCfg) {
        this.sapManifestCfg = manifestCfg;
    }

    public String getSAPManifestConfiguration() {
        return this.sapManifestCfg;
    }

    public void setApplicationConfigurationPath(String appConfigPath) {
        this.appConfigurationPath = appConfigPath;
    }

    public String getApplicationConfigurationPath() {
        return this.appConfigurationPath;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public long getAppArchiveSize() {
        return this.appArchiveSize;
    }

    public void setAppArchiveSize(long appArchiveSize) {
        this.appArchiveSize = appArchiveSize;
    }

    public long getDeploymentDuration() {
        return this.deploymentDuration;
    }

    public void setDeploymentDuration(long deploymentDuration) {
        this.deploymentDuration = deploymentDuration;
    }

    public int getNumberOfRedeploys() {
        return this.numberOfRedeploys;
    }

    public void setNumberOfRedeploys(int numberOfRedeploys) {
        this.numberOfRedeploys = numberOfRedeploys;
    }

    public String getTimeOfLastRedeployment() {
        return this.timeOfLastRedeployment;
    }

    public void setTimeOfLastRedeployment(String timeOfLastRedeployment) {
        this.timeOfLastRedeployment = timeOfLastRedeployment;
    }

    public void addDeployedComponent_ResTypes(String component, String[] resTypes) {
        if (component == null || resTypes == null || resTypes.length == 0) {
            return;
        }
        if (this.deployedComponents_resTypes == null) {
            this.deployedComponents_resTypes = new Hashtable();
        }
        String[] temp = (String[])this.deployedComponents_resTypes.get(component);
        if ((temp = DUtils.concatArrays(temp, resTypes)) != null) {
            this.deployedComponents_resTypes.put(component, temp);
        }
    }

    public String[] getResTypesOfComponent(String component) {
        if (this.deployedComponents_resTypes == null || component == null) {
            return null;
        }
        return (String[])this.deployedComponents_resTypes.get(component);
    }

    public Hashtable getDeployedComponents_Types() {
        return this.deployedComponents_resTypes;
    }

    public void setDeployedComponents_Types(Hashtable temp) {
        this.deployedComponents_resTypes = temp;
    }

    public void setResources(String[] res) {
        this.resources = res;
    }

    public void addResource(String res) {
        if (res != null) {
            this.resources = DUtils.concatArrays(this.resources, new String[]{res});
        }
    }

    public void removeResource(String res) {
        if (res != null && this.resources != null) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < this.resources.length) {
                if (!this.resources[i].equals(res)) {
                    list.add(this.resources[i]);
                }
                ++i;
            }
            this.resources = new String[list.size()];
            list.toArray(this.resources);
        }
    }

    public String[] getResources() {
        return this.resources;
    }

    public void addAppContainingNecessaryResources(String appName) {
        if (appName == null) {
            return;
        }
        if (this.appsContainingNecessaryResources == null) {
            this.appsContainingNecessaryResources = new ArrayList();
            this.appsContainingNecessaryResources.add(appName);
        } else if (!this.appsContainingNecessaryResources.contains(appName)) {
            this.appsContainingNecessaryResources.add(appName);
        }
    }

    public String[] getAppsContainingNecessaryResources() {
        if (this.appsContainingNecessaryResources == null) {
            return null;
        }
        String[] res = new String[this.appsContainingNecessaryResources.size()];
        this.appsContainingNecessaryResources.toArray(res);
        return res;
    }

    public void addOptionalContainer(String contName) {
        if (contName == null) {
            return;
        }
        if (this.optionalContainers == null) {
            this.optionalContainers = new Vector();
        }
        this.optionalContainers.add(contName);
    }

    public boolean isOptionalContainer(String contName) {
        if (contName == null) {
            return false;
        }
        return this.optionalContainers != null && this.optionalContainers.contains(contName);
    }

    public String[] getOptionalContainers() {
        if (this.optionalContainers == null || this.optionalContainers.size() == 0) {
            return null;
        }
        String[] res = new String[this.optionalContainers.size()];
        this.optionalContainers.toArray(res);
        return res;
    }

    public void setOptionalContainers(String[] optContainers) {
        if (optContainers == null || optContainers.length == 0) {
            return;
        }
        int i = 0;
        while (i < optContainers.length) {
            this.addOptionalContainer(optContainers[i]);
            ++i;
        }
    }
}

