/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.event.ServiceEventListener;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.container.monitor.LibraryMonitor;
import com.sap.engine.frame.container.monitor.Reference;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.frame.core.load.res.DirResource;
import com.sap.engine.frame.core.load.res.JarResource;
import com.sap.engine.frame.core.load.res.MultipleResource;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.gui.UserNode;
import com.sap.engine.interfaces.cross.CrossInterface;
import com.sap.engine.interfaces.cross.ProtocolProvider;
import com.sap.engine.interfaces.log.Logger;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.userstore.context.GroupContext;
import com.sap.engine.interfaces.security.userstore.context.GroupInfo;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.security.domain.ProtectionDomainFactory;
import com.sap.engine.services.deploy.ApplicationInformation;
import com.sap.engine.services.deploy.DeployCallback;
import com.sap.engine.services.deploy.DeployEvent;
import com.sap.engine.services.deploy.DeployResourceAccessor;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.command.ChangeInterfaces;
import com.sap.engine.services.deploy.command.ChangeLibraries;
import com.sap.engine.services.deploy.command.ChangeReference;
import com.sap.engine.services.deploy.command.ChangeServices;
import com.sap.engine.services.deploy.command.ContainerInfoCommand;
import com.sap.engine.services.deploy.command.DeployCommand;
import com.sap.engine.services.deploy.command.DeployLanguageLibCommand;
import com.sap.engine.services.deploy.command.GetClientJarsCommand;
import com.sap.engine.services.deploy.command.GetStartUpModeCommand;
import com.sap.engine.services.deploy.command.GetStatusCommand;
import com.sap.engine.services.deploy.command.ListApplicationsCommand;
import com.sap.engine.services.deploy.command.ListElementsCommand;
import com.sap.engine.services.deploy.command.ListRefsCommand;
import com.sap.engine.services.deploy.command.RemoveApplicationCommand;
import com.sap.engine.services.deploy.command.StartApplicationCommand;
import com.sap.engine.services.deploy.command.StopApplicationCommand;
import com.sap.engine.services.deploy.command.UnlockApplicationCommand;
import com.sap.engine.services.deploy.command.UpdateCommand;
import com.sap.engine.services.deploy.command.UpdateFilesCommand;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ComponentNotDeployedException;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.ContainerManagement;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExceptionInfo;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.container.ProgressListener;
import com.sap.engine.services.deploy.container.ReferenceObjectIntf;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.ear.EARClassLoader;
import com.sap.engine.services.deploy.ear.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.ApplicationLoader;
import com.sap.engine.services.deploy.server.ClusterChangeListener;
import com.sap.engine.services.deploy.server.ClusterServicesAdapter;
import com.sap.engine.services.deploy.server.ContainerWrapper;
import com.sap.engine.services.deploy.server.DTransaction;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeployCommunicatorImpl;
import com.sap.engine.services.deploy.server.DeployEventSystem;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.FinishListener;
import com.sap.engine.services.deploy.server.LocalDeployment;
import com.sap.engine.services.deploy.server.ReferenceResolver;
import com.sap.engine.services.deploy.server.RemoteCaller;
import com.sap.engine.services.deploy.server.Resource;
import com.sap.engine.services.deploy.server.TransactionCommunicator;
import com.sap.engine.services.deploy.server.TransactionManager;
import com.sap.engine.services.deploy.server.TransactionStatistics;
import com.sap.engine.services.deploy.server.application.AddAppInfoChangeTransaction;
import com.sap.engine.services.deploy.server.application.DeploymentTransaction;
import com.sap.engine.services.deploy.server.application.LanguageLibTransaction;
import com.sap.engine.services.deploy.server.application.ParallelAdapter;
import com.sap.engine.services.deploy.server.application.RemoveTransaction;
import com.sap.engine.services.deploy.server.application.RuntimeTransaction;
import com.sap.engine.services.deploy.server.application.SingleFileUpdateTransaction;
import com.sap.engine.services.deploy.server.application.StartTransaction;
import com.sap.engine.services.deploy.server.application.StopTransaction;
import com.sap.engine.services.deploy.server.application.UpdateTransaction;
import com.sap.engine.services.deploy.server.library.DeployLibTransaction;
import com.sap.engine.services.deploy.server.library.MakeReferencesTransaction;
import com.sap.engine.services.deploy.server.library.RemoveLibTransaction;
import com.sap.engine.services.deploy.server.library.RemoveReferencesTransaction;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.CodeSource;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipInputStream;
import javax.rmi.PortableRemoteObject;

public class DeployServiceImpl
extends PortableRemoteObject
implements DeployService,
LocalDeployment,
TransactionCommunicator,
ClusterChangeListener,
ContainerManagement {
    RemoteCaller remote = null;
    private Properties serviceProperties = null;
    public static ClassLoader frameLoader;
    LockingContext lock = null;
    ApplicationServiceContext sc = null;
    ClusterServicesAdapter clusterAdapter;
    int clusterID;
    String clusterElementName = null;
    Logger log = null;
    long logId = -1L;
    String rootDir = null;
    String tempDeployDir = null;
    Hashtable containersHash = new Hashtable();
    boolean inShutdown = false;
    public static final String DEPLOY_AREA = "DEPLOY_LOCK_AREA";
    private static final String deployed_in_unavailable_container = "deployed in unavailable container ";
    private String deployOwner = "";
    private String appsWorkDir = "";
    Command[] cmds = null;
    Hashtable applications = new Hashtable();
    Hashtable applicationReferences = new Hashtable();
    private DeployEventSystem eventSystem = null;
    private ReferenceResolver resolver = null;
    private Vector rootApplications = new Vector();
    private Hashtable exceptionInfos = new Hashtable();
    private TransactionManager tManager = null;
    private boolean throwWarnings = false;
    private boolean clearAfterFailure = true;
    private String[] initially_not_started_apps = null;
    private Vector externalContainers = new Vector();
    static /* synthetic */ Class class$com$sap$engine$services$deploy$DeployService;

    public DeployServiceImpl(ApplicationServiceContext sc, Properties frameProps) throws RemoteException {
        this.sc = sc;
        this.serviceProperties = frameProps;
        this.registerCommands();
        this.resolver = new ReferenceResolver(this);
        this.clusterAdapter = new ClusterServicesAdapter(this, this.resolver);
        Class<?> tmpClass = sc.getClass();
        ClassLoader tmpClassLoader = tmpClass.getClassLoader();
        try {
            tmpClass = tmpClassLoader.loadClass("com.sap.engine.frame.ApplicationServiceContext");
            frameLoader = tmpClass.getClassLoader();
        }
        catch (ClassNotFoundException cnfException) {
            throw new RemoteException("Cannot load com.sap.engine.frame.ApplicationServiceContext", cnfException);
        }
        this.lock = sc.getCoreContext().getLockingContext();
        try {
            this.deployOwner = this.lock.getAdministrativeLocking().createUniqueOwner();
        }
        catch (TechnicalLockException tlex) {
            this.logThrowable(tlex);
            this.deployOwner = "DEPLOY_OWNER";
        }
        ClusterElement info = sc.getClusterContext().getClusterMonitor().getCurrentParticipant();
        if (info != null) {
            this.clusterElementName = info.getName();
            this.clusterID = info.getClusterId();
        }
        this.eventSystem = new DeployEventSystem(this.clusterElementName, this);
    }

    public String getDeployLockOwner() {
        return this.deployOwner;
    }

    private void setAppsWorkDir(String workDir) {
        workDir = workDir.replace('\\', File.separatorChar);
        File file = new File(workDir = workDir.replace('/', File.separatorChar));
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            this.appsWorkDir = file.getCanonicalPath();
        }
        catch (IOException ioex) {
            this.appsWorkDir = workDir;
            this.logWarning("Error occurred while setting applications' work directory: " + ioex.getMessage() + ". This directory remains " + workDir);
        }
        if (!this.appsWorkDir.endsWith(File.separator)) {
            this.appsWorkDir = this.appsWorkDir + File.separator;
        }
    }

    public String getAppsWorkDir() {
        return this.appsWorkDir;
    }

    public void setStrictJ2EEChecks(boolean strictJ2EEChecks) {
        this.throwWarnings = strictJ2EEChecks;
    }

    public void setClearAfterFailure(boolean clearAfterFailure) {
        this.clearAfterFailure = clearAfterFailure;
    }

    protected void initLocal(String workDir) {
        if (this.sc == null) {
            return;
        }
        this.setAppsWorkDir(workDir);
        if (this.remote == null) {
            this.remote = new RemoteCaller(this.sc, this);
        }
        this.tManager = new TransactionManager();
        this.tManager.setClusterElementName(this.clusterElementName);
        this.tManager.setClusterID(this.clusterID);
        this.tManager.setDeployEventSystem(this.eventSystem);
        this.tManager.setDeployOwner(this.deployOwner);
        this.tManager.setLockingContext(this.lock);
        this.tManager.setRemoteCaller(this.remote);
        try {
            this.sc.getServiceState().registerServiceEventListener((ServiceEventListener)this.clusterAdapter);
        }
        catch (ListenerAlreadyRegisteredException e) {
            new ServerDeploymentException("deploy_5082", new String[]{"local init of Deploy service.\nReason: " + e.toString()}, e).log();
        }
        int mask = 20951;
        this.sc.getServiceState().registerContainerEventListener(mask, null, (ContainerEventListener)this.clusterAdapter);
    }

    public void setRootDirectory(String root) {
        this.rootDir = root.endsWith(File.separator) ? root : root + File.separator;
        File dir = new File(root);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(dir = new File(this.rootDir + File.separator + "deploying" + File.separator)).exists()) {
            dir.mkdirs();
        }
        this.tempDeployDir = this.rootDir + File.separator + "deploying" + File.separator;
    }

    /*
     * Loose catch block
     */
    protected void initializeApplications() throws DeploymentException {
        Configuration deployConfig;
        Configuration config;
        ConfigurationHandler handler;
        block51: {
            ConfigurationHandlerFactory factory;
            block52: {
                File appWorkDir = new File(this.getAppsWorkDir());
                if (!appWorkDir.exists()) {
                    appWorkDir.mkdirs();
                }
                handler = null;
                config = null;
                deployConfig = null;
                factory = this.getApplicationServiceContext().getCoreContext().getConfigurationHandlerFactory();
                if (factory != null) {
                    try {
                        handler = factory.getConfigurationHandler();
                    }
                    catch (ConfigurationException ce) {
                        throw new ServerDeploymentException("deploy_5056", new String[]{"initializing applications"}, ce);
                    }
                }
                if (handler == null) {
                    throw new ServerDeploymentException("deploy_5057", new String[]{"initializing applications"});
                }
                String[] allRoots = null;
                try {
                    allRoots = handler.getAllRootNames();
                }
                catch (ConfigurationException cex) {
                    throw new ServerDeploymentException("deploy_5059", cex);
                }
                boolean foundApps = false;
                boolean foundDeploy = false;
                if (allRoots != null) {
                    int i = 0;
                    while (i < allRoots.length) {
                        if ("apps".equals(allRoots[i])) {
                            foundApps = true;
                        } else if ("deploy".equals(allRoots[i])) {
                            foundDeploy = true;
                        }
                        ++i;
                    }
                }
                if (foundApps && foundDeploy) break block51;
                if (!foundApps) {
                    try {
                        config = handler.createRootConfiguration("apps");
                    }
                    catch (ConfigurationLockedException cle) {
                        new ServerDeploymentException("deploy_5082", new String[]{"initializing applications.\nReason: " + cle.toString()}, cle).log();
                    }
                    catch (ConfigurationException ce1) {
                        throw new ServerDeploymentException("deploy_5058", new String[]{"apps"}, ce1);
                    }
                }
                if (!foundDeploy) {
                    try {
                        deployConfig = handler.createRootConfiguration("deploy");
                    }
                    catch (ConfigurationLockedException cle) {
                        new ServerDeploymentException("deploy_5082", new String[]{"initializing applications.\nReason: " + cle.toString()}, cle).log();
                    }
                    catch (ConfigurationException ce1) {
                        throw new ServerDeploymentException("deploy_5058", new String[]{"deploy"}, ce1);
                    }
                }
                handler.commit();
                Object var12_24 = null;
                try {
                    handler.closeAllConfigurations();
                }
                catch (ConfigurationException cex) {
                    new ServerDeploymentException("deploy_5082", new String[]{"initializing applications.\nReason: " + cex.toString()}, cex).log();
                }
                break block52;
                {
                    catch (ConfigurationException cex) {
                        throw new ServerDeploymentException("deploy_5060", new String[]{"initialize applications"}, cex);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_25 = null;
                    try {
                        handler.closeAllConfigurations();
                    }
                    catch (ConfigurationException cex) {
                        new ServerDeploymentException("deploy_5082", new String[]{"initializing applications.\nReason: " + cex.toString()}, cex).log();
                    }
                    throw throwable;
                }
            }
            try {
                handler = factory.getConfigurationHandler();
            }
            catch (ConfigurationException ce) {
                throw new ServerDeploymentException("deploy_5056", new String[]{"initializing applications"}, ce);
            }
        }
        try {
            DeploymentInfo[] infoes;
            try {
                config = handler.openConfiguration("apps", 0);
            }
            catch (ConfigurationLockedException cle) {
                new ServerDeploymentException("deploy_5082", new String[]{"initializing applications.\nReason: " + cle.toString()}, cle).log();
            }
            catch (ConfigurationException ce) {
                throw new ServerDeploymentException("deploy_5062", new String[]{"apps", "read"}, ce);
            }
            try {
                deployConfig = handler.openConfiguration("deploy", 0);
            }
            catch (ConfigurationLockedException cle) {
                new ServerDeploymentException("deploy_5082", new String[]{"initializing applications.\nReason: " + cle.toString()}, cle).log();
            }
            catch (ConfigurationException ce) {
                throw new ServerDeploymentException("deploy_5062", new String[]{"deploy", "read"}, ce);
            }
            if (config != null && (infoes = this.getDInfoesFromDB(config, deployConfig)) != null) {
                int i = 0;
                while (i < infoes.length) {
                    if (infoes[i] != null) {
                        this.logInfo("Downloading information for application: " + infoes[i].getApplicationName());
                        if (infoes[i].getStatus() == 5) {
                            infoes[i].setStatus((byte)0);
                            this.trace(100, "Application " + infoes[i].getApplicationName() + " is in STOPPED mode.");
                        }
                        if (infoes[i].getStatus() == 6) {
                            this.trace(100, "Application " + infoes[i].getApplicationName() + " is in IMPLICIT_STOPPED mode.");
                        }
                        if (infoes[i].getStatus() == 3) {
                            infoes[i].setStatus((byte)0);
                            this.trace(100, "Application " + infoes[i].getApplicationName() + " is in STOPPED mode.");
                        }
                        if (infoes[i].getStatus() == 4) {
                            infoes[i].setStatus((byte)1);
                            this.trace(100, "Application " + infoes[i].getApplicationName() + " is in STARTED mode.");
                        }
                        if (infoes[i].getStatus() == 2) {
                            infoes[i].setStatus((byte)0);
                            this.trace(100, "Application " + infoes[i].getApplicationName() + " is in STOPPED mode.");
                        }
                        if (infoes[i].getStatus() == 1) {
                            try {
                                this.defineApplicationLoader(infoes[i].getApplicationName(), infoes[i]);
                            }
                            catch (DeploymentException de) {
                                de.log();
                            }
                        }
                    }
                    ++i;
                }
            }
            Object var15_30 = null;
        }
        catch (Throwable throwable) {
            Object var15_31 = null;
            try {
                handler.commit();
                handler.closeAllConfigurations();
            }
            catch (ConfigurationException ce) {
                new ServerDeploymentException("deploy_5082", new String[]{"initializing applications.\nReason: " + ce.toString()}, ce).log();
            }
            throw throwable;
        }
        try {
            handler.commit();
            handler.closeAllConfigurations();
        }
        catch (ConfigurationException ce) {
            new ServerDeploymentException("deploy_5082", new String[]{"initializing applications.\nReason: " + ce.toString()}, ce).log();
        }
    }

    public void unregister() {
        if (this.clusterAdapter != null) {
            this.clusterAdapter.unregister();
        }
        this.sc.getServiceState().unregisterContainerEventListener();
        this.sc.getServiceState().unregisterClusterEventListener();
        this.sc.getServiceState().unregisterServiceEventListener();
        this.eventSystem.unregister();
        this.logId = -1L;
    }

    public String[] deploy(String earFile, String[] remoteSupport, Properties props) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        if (props == null) {
            props = new Properties();
        }
        try {
            this.shutdownCheck();
            Vector warnings = new Vector();
            remoteSupport = this.checkSupport(remoteSupport, warnings);
            DeploymentTransaction deployTransaction = new DeploymentTransaction(earFile, remoteSupport, props, this, this.clearAfterFailure);
            deployTransaction.setUnregister(true);
            this.makeGlobalTransaction(deployTransaction);
            String[] temp = new String[warnings.size()];
            warnings.toArray(temp);
            deployTransaction.addWarnings(temp);
            try {
                this.processWarningsAndErrors(deployTransaction);
            }
            catch (WarningException wex) {
                wex.setResult(deployTransaction.getResult());
                throw wex;
            }
            return deployTransaction.getResult();
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while deploying ear file " + earFile + ". \nReason: " + dex.getMessage());
            }
            throw new RemoteException("Error occurred while deploying ear file " + earFile + ". \nReason: " + dex.getStackTraceString());
        }
    }

    public String[] deploy(String archiveFile, String containerName, String[] remoteSupport, Properties props) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.nullVerifier(props, "deploy application with Properties");
        try {
            this.shutdownCheck();
            Vector warnings = new Vector();
            remoteSupport = this.checkSupport(remoteSupport, warnings);
            DeploymentTransaction deployTransaction = new DeploymentTransaction(archiveFile, containerName, remoteSupport, props, this, this.clearAfterFailure);
            deployTransaction.setUnregister(true);
            this.makeGlobalTransaction(deployTransaction);
            String[] temp = new String[warnings.size()];
            warnings.toArray(temp);
            deployTransaction.addWarnings(temp);
            try {
                this.processWarningsAndErrors(deployTransaction);
            }
            catch (WarningException wex) {
                wex.setResult(deployTransaction.getResult());
                throw wex;
            }
            return deployTransaction.getResult();
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while deploying stand-alone module file " + archiveFile + ". \nReason: " + dex.getMessage());
            }
            throw new RemoteException("Error occurred while deploying stand-alone module file " + archiveFile + ". \nReason: " + dex.getStackTraceString());
        }
    }

    public String[] update(String earFile, Properties props) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        String appName = null;
        this.trace(200, "Starting update of ear " + earFile);
        try {
            this.shutdownCheck();
            UpdateTransaction updateTransaction = new UpdateTransaction(earFile, props, this);
            appName = updateTransaction.getModuleID();
            if (this.getApplicationInfo(appName) == null) {
                return this.deployApplicationDuringUpdate(earFile, new String[]{"p4"}, props, false, null);
            }
            updateTransaction.setUnregister(true);
            this.makeGlobalTransaction(updateTransaction);
            try {
                this.processWarningsAndErrors(updateTransaction);
            }
            catch (WarningException wex) {
                wex.setResult(updateTransaction.getResult());
                throw wex;
            }
            return updateTransaction.getResult();
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while updating ear file " + earFile + ". \nReason: " + dex.getMessage());
            }
            throw new RemoteException("Error occurred while updating ear file " + earFile + ". \nReason: " + dex.getStackTraceString());
        }
    }

    private String[] deployApplicationDuringUpdate(String file, String[] remoteSupport, Properties props, boolean isStandAlone, String container) throws RemoteException, WarningException {
        String[] warningsArr;
        String appName;
        String[] res;
        block7: {
            res = null;
            appName = null;
            warningsArr = null;
            try {
                res = isStandAlone ? this.deploy(file, container, remoteSupport, props) : this.deploy(file, remoteSupport, props);
                if (res != null && res.length > 0 && res[0].startsWith("Application : ")) {
                    appName = res[0].substring("Application : ".length());
                }
            }
            catch (WarningException wex) {
                res = wex.getResult();
                warningsArr = wex.getWarnings();
                if (res == null || res.length <= 0 || !res[0].startsWith("Application : ")) break block7;
                appName = res[0].substring("Application : ".length());
            }
        }
        if (appName != null) {
            try {
                this.startApplicationAndWait(appName);
            }
            catch (WarningException wex) {
                warningsArr = DUtils.concatArrays(warningsArr, wex.getWarnings());
            }
        }
        if (warningsArr != null) {
            WarningException wex = new WarningException();
            wex.setWarning(warningsArr);
            wex.setResult(res);
            throw wex;
        }
        return res;
    }

    public String[] update(String archiveFile, String containerName, String[] remoteSupport, Properties props) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.nullVerifier(props, "update application with Properties");
        try {
            this.shutdownCheck();
            Vector warnings = new Vector();
            remoteSupport = this.checkSupport(remoteSupport, warnings);
            UpdateTransaction updateTransaction = new UpdateTransaction(archiveFile, containerName, remoteSupport, props, this);
            if (this.applications.get(updateTransaction.getModuleID()) == null) {
                return this.deployApplicationDuringUpdate(archiveFile, remoteSupport, props, true, containerName);
            }
            updateTransaction.setUnregister(true);
            this.makeGlobalTransaction(updateTransaction);
            String[] temp = new String[warnings.size()];
            warnings.toArray(temp);
            updateTransaction.addWarnings(temp);
            try {
                this.processWarningsAndErrors(updateTransaction);
            }
            catch (WarningException wex) {
                wex.setResult(updateTransaction.getResult());
                throw wex;
            }
            return updateTransaction.getResult();
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while updating stand-alone module file " + archiveFile + ". \nReason: " + dex.getMessage());
            }
            throw new RemoteException("Error occurred while updating stand-alone module file " + archiveFile + ". \nReason: " + dex.getStackTraceString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void singleFileUpdate(FileUpdateInfo[] files, String appName, Properties props) throws RemoteException {
        SingleFileUpdateTransaction sfuTrans;
        block22: {
            if (!this.clusterAdapter.isAdministratorInRole()) {
                throw new RemoteException("Only Administrators have the right to perform this operation.");
            }
            this.compNameVerifier(appName, "single-file-update", "application");
            int[] needRestartServers = new int[]{};
            try {
                int[] servers = this.getClusterIDs(null);
                ArrayList<Integer> temp = new ArrayList<Integer>();
                String appStatus = null;
                if (servers != null) {
                    ClusterElement cEment = null;
                    int i = 0;
                    while (i < servers.length) {
                        try {
                            cEment = this.getApplicationServiceContext().getClusterContext().getClusterMonitor().getParticipant(servers[i]);
                            if (this.getApplicationServiceContext() != null && cEment != null && (appStatus = this.getApplicationStatus(appName, cEment.getName())) != null && appStatus.equals("STARTED")) {
                                temp.add(new Integer(servers[i]));
                            }
                        }
                        catch (RemoteException re) {
                            ServerDeploymentException de = new ServerDeploymentException("deploy_5030", new String[]{"while getting status of " + appName + "."}, re);
                            de.log();
                        }
                        ++i;
                    }
                }
                if (temp.size() > 0) {
                    needRestartServers = new int[temp.size()];
                    int i = 0;
                    while (i < temp.size()) {
                        needRestartServers[i] = (Integer)temp.get(i);
                        ++i;
                    }
                }
            }
            catch (DeploymentException dex) {
                dex.log();
                throw new RemoteException("Error occurred while cluster ids : " + dex.getMessage());
            }
            sfuTrans = null;
            try {
                try {
                    this.shutdownCheck();
                    sfuTrans = new SingleFileUpdateTransaction(this, appName, files, props);
                    sfuTrans.setUnregister(false);
                    this.makeGlobalTransaction(sfuTrans);
                }
                catch (DeploymentException dex) {
                    dex.log();
                    Throwable th = dex.getCause();
                    if (th != null) {
                        throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
                    }
                    if (!(dex instanceof ServerDeploymentException)) throw new RemoteException("Error occurred during single file update of application " + appName + ". \nReason: " + dex.getMessage(), dex);
                    throw new RemoteException("Error occurred during single file update of application " + appName + ". \nReason: " + dex.getMessage());
                }
                Object var13_15 = null;
                if (sfuTrans == null) return;
                if (!sfuTrans.needStartApplicationAfterFinished()) break block22;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (sfuTrans == null) throw throwable;
                if (!sfuTrans.needStartApplicationAfterFinished()) {
                    this.unregisterTransactionWithLock(sfuTrans.getModuleID());
                    throw throwable;
                }
                try {
                    StartTransaction startTransaction = new StartTransaction(appName, this, needRestartServers);
                    if (!startTransaction.needForTransaction()) throw throwable;
                    startTransaction.setUnregister(true);
                    this.trace(200, "Waiting for application " + appName + " to stop.");
                    this.registerTransactionWithoutLock(startTransaction);
                    startTransaction.makeAllPhases();
                    throw throwable;
                }
                catch (DeploymentException dex) {
                    dex.log();
                    Throwable th = dex.getCause();
                    if (th != null) {
                        throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
                    }
                    if (!(dex instanceof ServerDeploymentException)) throw new RemoteException("Error occurred while starting application " + appName + " after single file update" + ". \nReason: " + dex.getStackTraceString());
                    throw new RemoteException("Error occurred while starting application " + appName + " after single file update" + ". \nReason: " + dex.getMessage());
                }
            }
            try {}
            catch (DeploymentException dex) {
                dex.log();
                Throwable th = dex.getCause();
                if (th != null) {
                    throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
                }
                if (!(dex instanceof ServerDeploymentException)) throw new RemoteException("Error occurred while starting application " + appName + " after single file update" + ". \nReason: " + dex.getStackTraceString());
                throw new RemoteException("Error occurred while starting application " + appName + " after single file update" + ". \nReason: " + dex.getMessage());
            }
            StartTransaction startTransaction = new StartTransaction(appName, this, needRestartServers);
            if (!startTransaction.needForTransaction()) return;
            startTransaction.setUnregister(true);
            this.trace(200, "Waiting for application " + appName + " to stop.");
            this.registerTransactionWithoutLock(startTransaction);
            startTransaction.makeAllPhases();
            return;
        }
        this.unregisterTransactionWithLock(sfuTrans.getModuleID());
    }

    public void remove(String applicationName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(applicationName, "remove", "application");
        try {
            this.shutdownCheck();
            RemoveTransaction removeTransaction = new RemoveTransaction(applicationName, this);
            removeTransaction.setUnregister(true);
            this.makeGlobalTransaction(removeTransaction);
            this.processWarningsAndErrors(removeTransaction);
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while removing application " + applicationName + ". \nReason: " + dex.getMessage());
            }
            throw new RemoteException("Error occurred while removing application " + applicationName + ". \nReason: " + dex.getStackTraceString());
        }
    }

    public String[] listContainers(String[] serverNames) throws RemoteException {
        try {
            TransactionStatistics[] stat;
            this.shutdownCheck();
            int[] infoes = this.getClusterIDs(serverNames);
            int localIndex = this.isLocalIncluded(infoes);
            String[] res = null;
            if (localIndex != -1) {
                res = this.listContainers();
                int[] temp = new int[infoes.length - 1];
                System.arraycopy(infoes, 0, temp, 0, localIndex);
                System.arraycopy(infoes, localIndex + 1, temp, localIndex, temp.length - localIndex);
                infoes = temp;
            }
            if ((stat = this.remote.listContainersRemotely(infoes)) != null) {
                int i = 0;
                while (i < stat.length) {
                    if (stat[i] != null) {
                        res = DUtils.concatArrays(res, stat[i].getAnswers());
                    }
                    ++i;
                }
            }
            return res;
        }
        catch (DeploymentException dex) {
            dex.log();
            throw new RemoteException("Error occurred while listing containers : " + dex.getMessage());
        }
    }

    public String[] listContainers() {
        String[] containers = new String[this.containersHash.size()];
        int i = 0;
        Enumeration en = this.containersHash.elements();
        while (en.hasMoreElements()) {
            containers[i] = ((ContainerInterface)en.nextElement()).getContainerInfo().getName();
            ++i;
        }
        return containers;
    }

    public String[] listApplications(String containerName, String[] serverNames) throws RemoteException {
        try {
            TransactionStatistics[] stat;
            String[] res = null;
            int[] infoes = this.getClusterIDs(serverNames);
            int localIndex = this.isLocalIncluded(infoes);
            if (localIndex != -1) {
                if (containerName == null) {
                    res = this.listApplications();
                } else {
                    res = this.listApplications(containerName);
                    int[] temp = new int[infoes.length - 1];
                    System.arraycopy(infoes, 0, temp, 0, localIndex);
                    System.arraycopy(infoes, localIndex + 1, temp, localIndex, temp.length - localIndex);
                    infoes = temp;
                }
            }
            if ((stat = this.remote.listApplicationsRemotely(containerName, infoes)) != null) {
                int i = 0;
                while (i < stat.length) {
                    if (stat[i] != null) {
                        res = DUtils.concatArrays(res, stat[i].getAnswers());
                    }
                    ++i;
                }
            }
            if (res == null) {
                res = new String[]{};
            }
            return res;
        }
        catch (DeploymentException dex) {
            dex.log();
            throw new RemoteException("Error occurred while listing applications : " + dex.getMessage());
        }
    }

    public String[] listElements(String containerName, String applicationName, String[] serverNames) throws RemoteException {
        try {
            TransactionStatistics[] stat;
            this.shutdownCheck();
            String[] res = null;
            applicationName = this.getApplicationID(applicationName);
            int[] infoes = this.getClusterIDs(serverNames);
            int localIndex = this.isLocalIncluded(infoes);
            if (localIndex != -1) {
                res = this.listElements(containerName, applicationName);
                int[] temp = new int[infoes.length - 1];
                System.arraycopy(infoes, 0, temp, 0, localIndex);
                System.arraycopy(infoes, localIndex + 1, temp, localIndex, temp.length - localIndex);
                infoes = temp;
            }
            if ((stat = this.remote.listElementsRemotely(containerName, applicationName, infoes)) != null) {
                int i = 0;
                while (i < stat.length) {
                    if (stat[i] != null) {
                        res = DUtils.concatArrays(res, stat[i].getAnswers());
                    }
                    ++i;
                }
            }
            if (res == null) {
                res = new String[]{};
            }
            return DUtils.processListElement(res, deployed_in_unavailable_container);
        }
        catch (DeploymentException dex) {
            dex.log();
            throw new RemoteException("Error occurred while listing elements : " + dex.getMessage());
        }
    }

    public SerializableFile getClientJar(String applicationName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(applicationName, "get-client-jar of", "application");
        try {
            this.shutdownCheck();
            SerializableFile[] res = null;
            File[] files = null;
            files = this.listClientJars(null, applicationName);
            if (files != null && files.length > 0) {
                res = new SerializableFile[files.length];
                int i = 0;
                while (i < files.length) {
                    res[i] = new SerializableFile(files[i]);
                    ++i;
                }
            }
            return DUtils.mergeClientJars(res, applicationName, this.rootDir);
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while getting client jar of application " + applicationName + ". \nReason: " + dex.getMessage());
            }
            throw new RemoteException("Error occurred while getting client jar of application " + applicationName + ". \nReason: " + dex.getStackTraceString());
        }
    }

    private File[] listClientJars(String containerName, String applicationName) throws DeploymentException {
        Vector allComponents = new Vector();
        Object[] serverAppl = null;
        if (containerName == null) {
            Enumeration containers = this.containersHash.elements();
            while (containers.hasMoreElements()) {
                try {
                    serverAppl = ((ContainerInterface)containers.nextElement()).getClientJar(applicationName);
                    DUtils.addArrayToVector((File[])serverAppl, allComponents);
                }
                catch (Exception e) {
                    throw new ServerDeploymentException("deploy_5063", new String[]{applicationName}, e);
                }
            }
        } else {
            ContainerInterface cont = (ContainerInterface)this.containersHash.get(containerName);
            if (cont != null) {
                serverAppl = cont.getClientJar(applicationName);
            }
            return serverAppl;
        }
        if (allComponents != null && allComponents.size() > 0) {
            serverAppl = new File[allComponents.size()];
            allComponents.copyInto(serverAppl);
        }
        return serverAppl;
    }

    public DeployCommunicator registerContainer(String containerName, ContainerInterface container) {
        if (ContainerWrapper.doWork) {
            this.containersHash.put(containerName, new ContainerWrapper(container, this));
        } else {
            this.containersHash.put(containerName, container);
        }
        DeployCommunicatorImpl dCom = new DeployCommunicatorImpl(this, this.sc, containerName);
        container.addProgressListener((ProgressListener)this.eventSystem);
        return dCom;
    }

    public void unregisterContainer(String containerName) {
        ContainerInterface cont = (ContainerInterface)this.containersHash.get(containerName);
        if (cont != null) {
            cont.removeProgressListener((ProgressListener)this.eventSystem);
            this.containersHash.remove(containerName);
        }
    }

    public void stopApplication(String applicationName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(applicationName, "stop", "application");
        this.stopApplication(applicationName, (String[])null);
    }

    public void stopApplication(String applicationName, String[] serverNames) throws RemoteException {
        this.startOrStopApplication(applicationName, null, serverNames, false);
    }

    public void startApplication(String applicationName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(applicationName, "start", "application");
        this.startApplication(applicationName, (String[])null);
    }

    public void startApplication(String applicationName, String[] serverNames) throws RemoteException {
        this.startOrStopApplication(applicationName, null, serverNames, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startOrStopApplication(String applicationName, Properties properties, String[] serverNames, boolean start) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(applicationName, "start", "application");
        try {
            this.shutdownCheck();
            int[] ids = this.getClusterIDs(serverNames);
            int[] remoteServers = this.remote.getServerIDs();
            ParallelAdapter parallel = null;
            if (ids.length < remoteServers.length + 1) {
                P4ObjectBroker broker = P4ObjectBroker.init();
                DeployService remoteDeploy = null;
                ClusterElement cEment = null;
                int i = 0;
                while (i < ids.length) {
                    if (ids[i] == this.clusterID) {
                        parallel = start ? new StartTransaction(applicationName, this, new int[]{this.clusterID}) : new StopTransaction(applicationName, this, new int[]{this.clusterID}, false);
                        if (parallel.needForTransaction()) {
                            parallel.setUnregister(true);
                            parallel.setProperties(properties);
                            this.tManager.registerTransactionWithLock(parallel, 'S', false);
                            parallel.makeAllPhases();
                        }
                    } else {
                        if (start) {
                            this.trace(200, "Send start application request for application " + applicationName + " to cluster id " + ids[i]);
                        } else {
                            this.trace(200, "Send stop application request for application " + applicationName + " to cluster id " + ids[i]);
                        }
                        remoteDeploy = (DeployService)broker.narrow((Object)broker.stringToObject("clusteraloc:::" + ids[i] + "::/deploy"), class$com$sap$engine$services$deploy$DeployService == null ? DeployServiceImpl.class$("com.sap.engine.services.deploy.DeployService") : class$com$sap$engine$services$deploy$DeployService);
                        if (remoteDeploy == null) throw new RemoteException("P4Object broker return null while trying to access the Deploy Service on cluster id " + ids[i]);
                        cEment = this.sc.getClusterContext().getClusterMonitor().getParticipant(ids[i]);
                        if (cEment != null) {
                            if (start) {
                                remoteDeploy.startApplication(applicationName, new String[]{cEment.getName()});
                            } else {
                                remoteDeploy.stopApplication(applicationName, new String[]{cEment.getName()});
                            }
                        } else {
                            if (!start) throw new RemoteException("Error while stopping application " + applicationName + " on cluster id " + ids[i] + ", because it doesn't participate in the cluster.");
                            throw new RemoteException("Error while starting application " + applicationName + " on cluster id " + ids[i] + ", because it doesn't participate in the cluster.");
                        }
                    }
                    ++i;
                }
                return;
            } else {
                parallel = start ? new StartTransaction(applicationName, this, ids) : new StopTransaction(applicationName, this, ids, false);
                if (!parallel.needForTransaction()) return;
                parallel.setUnregister(true);
                parallel.setProperties(properties);
                this.registerTransactionWithLock(parallel);
                parallel.makeAllPhases();
            }
            return;
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                if (!start) throw new RemoteException("Error occurred while stopping application " + applicationName + ". \nReason: " + dex.getMessage());
                throw new RemoteException("Error occurred while starting application " + applicationName + ". \nReason: " + dex.getMessage());
            }
            if (!start) throw new RemoteException("Error occurred while stopping application " + applicationName + ". \nReason: " + dex.getMessage(), dex);
            throw new RemoteException("Error occurred while starting application " + applicationName + ". \nReason: " + dex.getMessage(), dex);
        }
    }

    public String getApplicationStatus(String applicationName) throws RemoteException {
        this.compNameVerifier(applicationName, "get-application-status of", "application");
        try {
            byte status = this.getStatus(applicationName);
            if (status == 0) {
                return "STOPPED";
            }
            if (status == 1) {
                return "STARTED";
            }
            if (status == 3) {
                return "STARTING";
            }
            if (status == 4) {
                return "STOPPING";
            }
            if (status == 2) {
                return "UPGRADING";
            }
            if (status == 6) {
                return "IMPLICIT_STOPPED";
            }
            return "UNKNOWN";
        }
        catch (DeploymentException dex) {
            dex.log();
            throw new RemoteException("Error in getting status of application " + applicationName + " : " + dex.getMessage());
        }
    }

    public String getApplicationStatus(String applicationName, String serverName) throws RemoteException {
        this.compNameVerifier(applicationName, "get-application-status of", "application");
        if (this.clusterElementName.equals(serverName)) {
            return this.getApplicationStatus(applicationName);
        }
        try {
            int[] ids = this.getClusterIDs(new String[]{serverName});
            TransactionStatistics stat = this.remote.getApplicationStatusRemotely(applicationName, ids[0]);
            if (stat != null) {
                String[] res = stat.getAnswers();
                if (res == null || res.length == 0) {
                    this.logError("Missing result from server " + serverName + " about status of application " + applicationName);
                    throw new RemoteException("Missing result from server " + serverName + " about status of application " + applicationName);
                }
                this.logInfo("Received from server " + serverName + " status " + res[0] + " of application " + applicationName);
                return res[0];
            }
            this.logError("No result received from server " + serverName + " about status of application " + applicationName);
            throw new RemoteException("No result received from server " + serverName + " about status of application " + applicationName);
        }
        catch (DeploymentException dex) {
            dex.log();
            throw new RemoteException("Error occurred while getting status of application " + applicationName + ":" + dex.getMessage());
        }
    }

    public ExportInfo[] getCurrentStatus(String applicationName) throws RemoteException {
        this.compNameVerifier(applicationName, "get-current-status of", "application");
        try {
            this.shutdownCheck();
            if (this.containersHash == null) {
                return null;
            }
            ExportInfo[] infos = null;
            ContainerInterface cont = null;
            Enumeration en = this.containersHash.elements();
            while (en.hasMoreElements()) {
                cont = (ContainerInterface)en.nextElement();
                infos = DUtils.concatInfos(infos, cont.getCurrentStatus(applicationName));
            }
            return infos;
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while getting current status of application " + applicationName + ". \nReason: " + dex.getMessage());
            }
            throw new RemoteException("Error occurred while getting current status of application " + applicationName + ". \nReason: " + dex.getStackTraceString());
        }
    }

    public void deployLibrary(String jar, String libName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.deployServerComponent(jar, libName, (byte)0);
    }

    public void deployLibrary(String jar) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.deployServerComponent(jar, null, (byte)0);
    }

    public void removeLibrary(String libName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(libName, "remove", "library");
        this.removeServerComponent(libName, (byte)0);
    }

    public void deployInterface(String jar, String intfName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.deployServerComponent(jar, intfName, (byte)1);
    }

    public void deployInterface(String jar) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.deployServerComponent(jar, null, (byte)1);
    }

    public void removeInterface(String intfName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.removeServerComponent(intfName, (byte)1);
    }

    public void deployService(String jar, String serviceName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.deployServerComponent(jar, serviceName, (byte)2);
    }

    public void deployService(String jar) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.deployServerComponent(jar, null, (byte)2);
    }

    public void removeService(String serviceName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(serviceName, "remove", "service");
        this.removeServerComponent(serviceName, (byte)2);
    }

    private void deployServerComponent(String jar, String name, byte type) throws RemoteException {
        try {
            this.shutdownCheck();
            DeployLibTransaction transaction = null;
            transaction = new DeployLibTransaction(jar, name, type, this);
            transaction.setUnregister(true);
            this.registerTransactionWithoutLock(transaction);
            try {
                transaction.makeAllPhases();
                Object var6_6 = null;
                if (transaction.unregister()) {
                    this.unregisterTransactionWithoutLock(transaction.getModuleID());
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (transaction.unregister()) {
                    this.unregisterTransactionWithoutLock(transaction.getModuleID());
                }
                throw throwable;
            }
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while deploying server component " + name + ". \nReason: " + dex.getMessage());
            }
            throw new RemoteException("Error occurred while deploying server component " + name + ". \nReason: " + dex.getStackTraceString());
        }
    }

    private void removeServerComponent(String name, byte type) throws RemoteException {
        try {
            Vector warnings = new Vector();
            this.shutdownCheck();
            String[] remoteSupport = null;
            remoteSupport = this.checkSupport(remoteSupport, warnings);
            RemoveLibTransaction transaction = null;
            transaction = new RemoveLibTransaction(name, type, this);
            transaction.setUnregister(true);
            this.registerTransactionWithoutLock(transaction);
            try {
                transaction.makeAllPhases();
                Object var7_8 = null;
                if (transaction.unregister()) {
                    this.unregisterTransactionWithoutLock(transaction.getModuleID());
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (transaction.unregister()) {
                    this.unregisterTransactionWithoutLock(transaction.getModuleID());
                }
                throw throwable;
            }
            this.processWarningsAndErrors(transaction);
        }
        catch (DeploymentException de) {
            de.log();
            Throwable th = de.getCause();
            if (th != null) {
                throw new RemoteException(de.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (de instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while removing server component " + name + ". \nReason: " + de.getMessage());
            }
            throw new RemoteException("Error occurred while removing server component " + name + ". \nReason: " + de.getStackTraceString());
        }
    }

    public void makeReferences(String fromApplication, String[] refs) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(fromApplication, "make reference(s) from", "application");
        if (refs == null || refs.length == 0) {
            return;
        }
        ReferenceObject[] references = new ReferenceObject[refs.length];
        int i = 0;
        while (i < references.length) {
            references[i] = new ReferenceObject(refs[i], "weak");
            ++i;
        }
        this.makeReferences(fromApplication, references);
    }

    public void makeReferences(String fromApplication, Properties toLibraries) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(fromApplication, "make reference(s) from", "application");
        if (toLibraries == null || ((Hashtable)toLibraries).size() == 0) {
            return;
        }
        ReferenceObject[] references = new ReferenceObject[((Hashtable)toLibraries).size()];
        int i = 0;
        Enumeration refs = ((Hashtable)toLibraries).keys();
        String ref = null;
        while (refs.hasMoreElements()) {
            ref = (String)refs.nextElement();
            references[i] = new ReferenceObject(ref, toLibraries.getProperty(ref));
        }
        this.makeReferences(fromApplication, references);
    }

    public void removeReferences(String fromApplication, String[] toLibraries) throws RemoteException {
        block33: {
            if (!this.clusterAdapter.isAdministratorInRole()) {
                throw new RemoteException("Only Administrators have the right to perform this operation.");
            }
            this.compNameVerifier(fromApplication, "remove reference(s) from", "application");
            try {
                this.shutdownCheck();
                if (fromApplication.startsWith("service:")) {
                    throw new RemoteException("It is not allowed to change references of services after the service is deployed.");
                }
                if (fromApplication.startsWith("library:")) {
                    throw new RemoteException("It is not allowed to change references of libraries after the library is deployed.");
                }
                if (fromApplication.startsWith("interface:")) {
                    throw new RemoteException("It is not allowed to change references of interfaces after the interface is deployed.");
                }
                if (toLibraries == null || toLibraries.length == 0) {
                    return;
                }
                DeploymentInfo info = (DeploymentInfo)((Object)this.applications.get(fromApplication = this.getApplicationID(fromApplication)));
                if (info == null) {
                    ReferenceObject[] refs = (ReferenceObject[])this.applicationReferences.get(fromApplication);
                    String[] warnings = null;
                    TransactionStatistics[] trans = null;
                    if (refs != null) {
                        warnings = this.evaluateReferences(fromApplication, refs, toLibraries);
                        ConfigurationHandlerFactory factory = this.getApplicationServiceContext().getCoreContext().getConfigurationHandlerFactory();
                        ConfigurationHandler handler = null;
                        if (factory != null) {
                            try {
                                handler = factory.getConfigurationHandler();
                            }
                            catch (ConfigurationException ce) {
                                throw new ServerDeploymentException("deploy_5056", new String[]{"saving application references"}, ce);
                            }
                        }
                        if (handler == null) {
                            throw new ServerDeploymentException("deploy_5057", new String[]{"saving application references"});
                        }
                        try {
                            Configuration appRefsConfig = DUtils.getSubConfiguration(handler, "deploy", fromApplication.substring(0, fromApplication.indexOf("/")), fromApplication.substring(fromApplication.indexOf("/") + 1));
                            DUtils.setSerializedObject(appRefsConfig, "HASH_STR_STR:Reference_type", DUtils.decodeReferenceObjectArray(refs), "of references.");
                        }
                        catch (ConfigurationException ce) {
                            new ServerDeploymentException("deploy_5082", new String[]{"removing references from application " + fromApplication + ".\nReason: " + ce.toString()}, ce).log();
                            throw new ServerDeploymentException("deploy_5094", new String[]{"removing references from not deployed application"}, ce);
                        }
                        try {
                            handler.commit();
                            handler.closeAllConfigurations();
                        }
                        catch (ConfigurationException ce) {
                            new ServerDeploymentException("deploy_5082", new String[]{"removing references from application " + fromApplication + ".\nReason: " + ce.toString()}, ce).log();
                        }
                    } else {
                        warnings = new String[toLibraries.length];
                        int i = 0;
                        while (i < toLibraries.length) {
                            warnings[i] = "Reference from " + fromApplication + " to " + toLibraries[i] + " doesn't exist.";
                            ++i;
                        }
                    }
                    Hashtable<String, Object> table = new Hashtable<String, Object>();
                    table.put("command", "removeRefs");
                    table.put("application_name", fromApplication);
                    table.put("ref_objects", toLibraries);
                    trans = this.remote.sendAndWait(table, this.remote.getServerIDs(), fromApplication);
                    WarningException wex = null;
                    if (warnings != null && warnings.length > 0) {
                        wex = new WarningException();
                        wex.setWarning(this.generateResultMessage(warnings, "Warning", this.clusterID, "removeRefs", fromApplication));
                    }
                    if (trans != null) {
                        String[] transWarnings = null;
                        int i = 0;
                        while (i < trans.length) {
                            transWarnings = this.generateResultMessage(trans[i].getWarnings(), "Warning", trans[i].getClusterID(), "removeRefs", fromApplication);
                            if (transWarnings != null) {
                                int j = 0;
                                while (j < transWarnings.length) {
                                    if (wex == null) {
                                        wex = new WarningException();
                                    }
                                    wex.addWarning(transWarnings[j]);
                                    ++j;
                                }
                            }
                            ++i;
                        }
                    }
                    if (wex != null) {
                        throw wex;
                    }
                    break block33;
                }
                RemoveReferencesTransaction transaction = new RemoveReferencesTransaction(fromApplication, toLibraries, this);
                transaction.setUnregister(true);
                this.registerTransactionWithLock(transaction);
                try {
                    transaction.makeAllPhases();
                    Object var13_21 = null;
                    if (transaction.unregister()) {
                        this.unregisterTransactionWithLock(transaction.getModuleID());
                    }
                }
                catch (Throwable throwable) {
                    Object var13_22 = null;
                    if (transaction.unregister()) {
                        this.unregisterTransactionWithLock(transaction.getModuleID());
                    }
                    throw throwable;
                }
                this.processWarningsAndErrors(transaction);
            }
            catch (DeploymentException dex) {
                dex.log();
                Throwable th = dex.getCause();
                if (th != null) {
                    throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
                }
                if (dex instanceof ServerDeploymentException) {
                    throw new RemoteException("Error occurred while removing references from application " + fromApplication + ". \nReason: " + dex.getMessage());
                }
                throw new RemoteException("Error occurred while removing references from application " + fromApplication + ". \nReason: " + dex.getStackTraceString());
            }
            catch (WarningException wex) {
                if (!this.throwWarnings) break block33;
                throw wex;
            }
        }
    }

    public void deployLanguageLib(String appName, String[] jars) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        try {
            this.shutdownCheck();
            LanguageLibTransaction langTransaction = new LanguageLibTransaction(appName, this, jars);
            langTransaction.setUnregister(true);
            this.makeGlobalTransaction(langTransaction);
        }
        catch (DeploymentException dex) {
            dex.log();
            throw new RemoteException("Error occurred while deploying language library for application" + appName + ":" + dex.getMessage());
        }
    }

    public String[] getSupports() throws RemoteException {
        String[] names = null;
        ProtocolProvider[] monitors = ((CrossInterface)this.sc.getContainerContext().getObjectRegistry().getProvidedInterface("cross")).getProviders();
        if (monitors != null) {
            names = new String[monitors.length];
            int i = 0;
            while (i < monitors.length) {
                names[i] = monitors[i].getName();
                ++i;
            }
        }
        if (names == null || names.length == 0 || names[0] == null) {
            names = new String[]{"p4"};
        }
        return names;
    }

    public String getRootDirectory() {
        return this.rootDir;
    }

    public ApplicationServiceContext getApplicationServiceContext() {
        return this.sc;
    }

    public String[] listApplications() {
        String[] temp = new String[this.applications.size()];
        Enumeration infoes = this.applications.elements();
        int i = 0;
        while (infoes.hasMoreElements()) {
            temp[i++] = ((DeploymentInfo)((Object)infoes.nextElement())).getApplicationName();
        }
        return temp;
    }

    public String[] listElements(String appName) {
        return this.listElements(null, appName);
    }

    public void registerTransactionWithLock(DTransaction transaction) throws DeploymentException {
        this.tManager.registerTransactionWithLock(transaction, 'X', true);
    }

    public void lockApplication(String appName, String transactionType) throws DeploymentException {
        this.tManager.lockApplication(appName, transactionType, 'X', false);
    }

    private String[] generateResultMessage(String[] source, String type, int clusterID, String transactionType, String moduleID) {
        String[] result = null;
        if (source != null) {
            result = new String[source.length];
            int i = 0;
            while (i < source.length) {
                result[i] = "\n" + type + " occurred on server " + clusterID + " during " + transactionType + " " + moduleID + " : " + source[i];
                ++i;
            }
        }
        return result;
    }

    private String[][] getWarningsAndErrors(DTransaction transaction) {
        String[][] result = new String[2][];
        TransactionStatistics[] stat = transaction.getStatistics();
        String[] warnings = new String[]{};
        String[] errors = new String[]{};
        if (stat != null) {
            int i = 0;
            while (i < stat.length) {
                if (stat[i] != null) {
                    warnings = DUtils.concatArrays(warnings, this.generateResultMessage(stat[i].getWarnings(), "Warning", stat[i].getClusterID(), transaction.getTransactionType(), transaction.getModuleID()));
                    errors = DUtils.concatArrays(errors, this.generateResultMessage(stat[i].getErrors(), "Error", stat[i].getClusterID(), transaction.getTransactionType(), transaction.getModuleID()));
                }
                ++i;
            }
        }
        if (warnings != null && warnings.length != 0) {
            result[0] = new String[warnings.length];
            result[0] = warnings;
        }
        if (errors != null && errors.length != 0) {
            result[1] = new String[errors.length];
            result[1] = errors;
        }
        return result;
    }

    public void unregisterTransactionWithLock(String applicationName) {
        this.tManager.unregisterTransactionWithLock(applicationName);
    }

    public void registerTransactionWithoutLock(DTransaction trans) {
        this.tManager.registerTransactionWithoutLock(trans);
    }

    public void unregisterTransactionWithoutLock(String appName) {
        this.tManager.unregisterTransactionWithoutLock(appName);
    }

    public RemoteCaller getRemoteCaller() {
        if (this.remote == null) {
            this.remote = new RemoteCaller(this.sc, this);
        }
        return this.remote;
    }

    public Enumeration getContainers() {
        return this.containersHash.elements();
    }

    public ContainerInterface getContainer(String contName) {
        if (contName != null) {
            return (ContainerInterface)this.containersHash.get(contName);
        }
        return null;
    }

    public void registerEARloader(ClassLoader loader, DeploymentInfo info) throws DeploymentException {
        String appName = info.getApplicationName();
        if (loader instanceof ReferencedLoader) {
            String[] refs = this.sc.getCoreContext().getLoadContext().getReferences(appName);
            LoadContext loadContext = this.sc.getCoreContext().getLoadContext();
            try {
                ReferencedLoader temp;
                String[] r;
                int i;
                ReferenceObject[] previousRefs;
                int i2;
                this.sc.getCoreContext().getLoadContext().register((ReferencedLoader)loader);
                String[] standartRefs = this.getStandartAppReferences();
                if (standartRefs != null) {
                    i2 = 0;
                    while (i2 < standartRefs.length) {
                        loadContext.registerReference("Deployment:Runtime:" + appName, standartRefs[i2]);
                        ++i2;
                    }
                }
                if (refs != null || refs.length != 0) {
                    i2 = 0;
                    while (i2 < refs.length) {
                        loadContext.registerReference("Deployment:Runtime:" + appName, refs[i2]);
                        ++i2;
                    }
                }
                if ((previousRefs = (ReferenceObject[])this.applicationReferences.get(appName)) != null) {
                    int i3 = 0;
                    while (i3 < previousRefs.length) {
                        loadContext.registerReference("Deployment:Runtime:" + appName, previousRefs[i3].toString());
                        loadContext.registerReference(appName, previousRefs[i3].toString());
                        ++i3;
                    }
                }
                if (info != null) {
                    ReferenceObject[] appRefs = info.getReferences();
                    DeploymentInfo temp2 = null;
                    if (appRefs != null) {
                        i = 0;
                        while (i < appRefs.length) {
                            if ("application".equals(appRefs[i].getReferenceTargetType())) {
                                temp2 = this.getApplicationInfo(appRefs[i].toString());
                                if (temp2 != null) {
                                    loadContext.registerReference("Deployment:Runtime:" + appName, temp2.getLoaderName() != null ? temp2.getLoaderName() : temp2.getApplicationName());
                                } else {
                                    loadContext.registerReference("Deployment:Runtime:" + appName, appRefs[i].toString());
                                }
                            } else {
                                loadContext.registerReference("Deployment:Runtime:" + appName, appRefs[i].toString());
                            }
                            ++i;
                        }
                    }
                }
                if ((r = (temp = (ReferencedLoader)loadContext.getClassLoader("Deployment:Runtime:" + appName)).getReferencesTo()) != null) {
                    i = 0;
                    while (i < r.length) {
                        this.trace(100, "Registered reference from Deployment:Runtime:" + appName + " to " + r[i]);
                        ++i;
                    }
                } else {
                    this.trace(100, "No references registered from Deployment:Runtime:" + appName);
                }
            }
            catch (Exception e) {
                this.logError("Cannot register loader for application " + appName);
                this.trace(500, "Registering application loader failed because of unexpected exception: " + e.toString());
                throw new ServerDeploymentException("deploy_5064", new String[]{appName}, e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterEARloader(ClassLoader loader, String appName) throws DeploymentException {
        if (loader == null) return;
        if (!(loader instanceof ReferencedLoader)) return;
        LoadContext loadContext = this.sc.getCoreContext().getLoadContext();
        try {
            try {
                String[] refs = loadContext.getReferences("Deployment:Runtime:" + appName);
                if (refs != null) {
                    int i = 0;
                    while (i < refs.length) {
                        loadContext.unregisterReference("Deployment:Runtime:" + appName, refs[i]);
                        ++i;
                    }
                }
                loadContext.unregister((ReferencedLoader)loader);
                ((ReferencedLoader)loader).prepareForRemove();
            }
            catch (Exception ex) {
                throw new ServerDeploymentException("deploy_5065", new String[]{appName}, ex);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!(loader instanceof EARClassLoader)) throw throwable;
            ((EARClassLoader)loader).clear();
            throw throwable;
        }
        if (!(loader instanceof EARClassLoader)) return;
        ((EARClassLoader)loader).clear();
    }

    public void bindLoader(DTransaction transaction, String appName, DeploymentInfo deployment) throws DeploymentException {
        if (deployment == null) {
            throw new ServerDeploymentException("deploy_5000", new String[]{appName, "bind application loader"});
        }
        deployment.preparePaths();
        this.defineApplicationLoader(appName, deployment);
    }

    public void removeApplicationLoader(String appName) throws DeploymentException {
        try {
            LoadContext loadContext = this.sc.getCoreContext().getLoadContext();
            ClassLoader loader1 = loadContext.getClassLoader(appName);
            if (loader1 != null && loader1 instanceof ReferencedLoader) {
                ReferencedLoader refLoader = (ReferencedLoader)loader1;
                loadContext.unregister(refLoader);
                refLoader.prepareForRemove();
            }
            this.removeApplicationStandartReferences(appName);
        }
        catch (Exception e) {
            throw new ServerDeploymentException("deploy_5066", new String[]{appName}, e);
        }
    }

    public int[] getOtherServerIDs() {
        return this.remote.getServerIDs();
    }

    public int getClusterID() {
        return this.clusterID;
    }

    public String getClusterIDName() {
        return this.clusterElementName;
    }

    public int getClusterID(int[] clusterIDs) {
        int k;
        int[] clID = this.remote.getServerIDs();
        int id = -1;
        int j = 0;
        while (j < clusterIDs.length) {
            k = 0;
            while (k < clID.length) {
                if (clID[k] == clusterIDs[j]) {
                    id = clusterIDs[j];
                    break;
                }
                ++k;
            }
            if (id != -1) break;
            ++j;
        }
        if (id == -1) {
            k = 0;
            while (k < clID.length) {
                if (clID[k] != this.clusterID) {
                    return clID[k];
                }
                ++k;
            }
        }
        return id;
    }

    public int isLocalIncluded(int[] clusterIDs) {
        int i = 0;
        while (i < clusterIDs.length) {
            if (clusterIDs[i] == this.clusterID) break;
            ++i;
        }
        return i == clusterIDs.length ? -1 : i;
    }

    public String[] getAllServerNames() {
        int[] others = this.remote.getServerIDs();
        ArrayList<String> temp = new ArrayList<String>();
        ClusterElement cEment = null;
        int i = 0;
        while (i < others.length) {
            cEment = this.sc.getClusterContext().getClusterMonitor().getParticipant(others[i]);
            if (this.sc != null && cEment != null) {
                temp.add(cEment.getName());
            }
            ++i;
        }
        temp.add(this.clusterElementName);
        String[] res = new String[temp.size()];
        temp.toArray(res);
        return res;
    }

    public int[] getClusterIDs(String[] serverNames) throws DeploymentException {
        if (serverNames != null) {
            int[] elements = this.remote.getServerIDs();
            int[] res = new int[serverNames.length];
            int index = 0;
            ClusterElement cEment = null;
            int i = 0;
            while (i < serverNames.length) {
                if (serverNames[i] != null) {
                    if (serverNames[i].equals(this.clusterElementName)) {
                        res[index++] = this.clusterID;
                    } else {
                        int j = 0;
                        cEment = null;
                        while (j < elements.length) {
                            cEment = this.sc.getClusterContext().getClusterMonitor().getParticipant(elements[j]);
                            if (this.sc != null && cEment != null && serverNames[i].equals(cEment.getName())) {
                                res[index++] = elements[j];
                                break;
                            }
                            ++j;
                        }
                        if (j == elements.length) {
                            throw new ServerDeploymentException("deploy_5067", new String[]{serverNames[i]});
                        }
                    }
                } else {
                    throw new ServerDeploymentException("deploy_5067", new String[]{"null"});
                }
                ++i;
            }
            int[] temp = new int[index];
            System.arraycopy(res, 0, temp, 0, index);
            return temp;
        }
        int[] ids = this.remote.getServerIDs();
        int[] temp = new int[ids.length + 1];
        System.arraycopy(ids, 0, temp, 0, ids.length);
        temp[ids.length] = this.clusterID;
        return temp;
    }

    public void logDebug(String message) {
        if (DeployResourceAccessor.category != null && DeployResourceAccessor.location != null) {
            DeployResourceAccessor.category.logT(100, DeployResourceAccessor.location, message);
        }
    }

    public void logWarning(String message) {
        if (DeployResourceAccessor.category != null && DeployResourceAccessor.location != null) {
            DeployResourceAccessor.category.logT(400, DeployResourceAccessor.location, message);
        }
    }

    public void logError(String message) {
        if (DeployResourceAccessor.category != null && DeployResourceAccessor.location != null) {
            DeployResourceAccessor.category.logT(500, DeployResourceAccessor.location, message);
        }
    }

    public void logInfo(String message) {
        if (DeployResourceAccessor.category != null && DeployResourceAccessor.location != null) {
            DeployResourceAccessor.category.logT(300, DeployResourceAccessor.location, message);
        }
    }

    public void logPath(String message) {
        if (DeployResourceAccessor.category != null && DeployResourceAccessor.location != null) {
            DeployResourceAccessor.category.logT(200, DeployResourceAccessor.location, message);
        }
    }

    public void trace(int severity, String message) {
        if (DeployResourceAccessor.location != null) {
            DeployResourceAccessor.location.logT(severity, message);
        }
    }

    public void logThrowable(Throwable exc) {
        if (DeployResourceAccessor.category != null && DeployResourceAccessor.location != null) {
            DeployResourceAccessor.category.logThrowableT(500, DeployResourceAccessor.location, "", exc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clusterElementReady() {
        long _start = System.currentTimeMillis();
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                this.shutdownCheck();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.startApplicationsInitially();
            }
            catch (DeploymentException dex) {
                dex.log();
                Object var6_4 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                this.sc.getContainerContext().getDeployContext().applicationsStarted();
                long _est = System.currentTimeMillis() - _start;
                this.logInfo("The synchronization of applications with DB completed for " + _est + " ms.");
                return;
            }
            Object var6_3 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            this.sc.getContainerContext().getDeployContext().applicationsStarted();
            long _est = System.currentTimeMillis() - _start;
            this.logInfo("The synchronization of applications with DB completed for " + _est + " ms.");
            throw throwable;
        }
        this.sc.getContainerContext().getDeployContext().applicationsStarted();
        long _est = System.currentTimeMillis() - _start;
        this.logInfo("The synchronization of applications with DB completed for " + _est + " ms.");
    }

    private boolean checkContainers(DeploymentInfo info) {
        if (info != null) {
            String[] containerNames = info.getContainerNames();
            if (containerNames != null) {
                int i = 0;
                while (i < containerNames.length) {
                    if (this.getContainer(containerNames[i]) == null && !info.isOptionalContainer(containerNames[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean checkContainersLazyStart(DeploymentInfo info) {
        if (info != null) {
            String[] containerNames = info.getContainerNames();
            if (containerNames != null) {
                int i = 0;
                while (i < containerNames.length) {
                    ContainerInfo ci = this.getContainerInfo(containerNames[i]);
                    if (ci == null || !ci.isSupportingLazyStart()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void setRecursivelyStatus(DeploymentInfo info, byte status) {
        if (info != null) {
            String[] appsContainingNecessaryResources;
            info.setStatus(status);
            ReferenceObject[] refs = info.getReferences();
            DeploymentInfo temp = null;
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    if (refs[i].getReferenceTargetType().equals("application") && (temp = (DeploymentInfo)((Object)this.applications.get(refs[i].toString()))) != null && temp.getStatus() != status) {
                        this.setRecursivelyStatus(temp, status);
                    }
                    ++i;
                }
            }
            if ((appsContainingNecessaryResources = info.getAppsContainingNecessaryResources()) != null) {
                int i = 0;
                while (i < appsContainingNecessaryResources.length) {
                    temp = (DeploymentInfo)((Object)this.applications.get(appsContainingNecessaryResources[i]));
                    if (temp != null && temp.getStatus() != status) {
                        this.setRecursivelyStatus(temp, status);
                    }
                    ++i;
                }
            }
        }
    }

    private void startApplicationsInitially() {
        int i;
        DeploymentInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> apps = new ArrayList<String>();
        int i2 = 0;
        while (i2 < this.rootApplications.size()) {
            info = this.getApplicationInfo((String)this.rootApplications.elementAt(i2));
            if (info != null) {
                if (info.getStatus() == 1) {
                    this.trace(100, "application " + info.getApplicationName() + " startup status is : " + info.getStartUp());
                    if (this.checkContainers(info) && (info.getStartUp() == 3 || info.getStartUp() == 2 && !this.checkContainersLazyStart(info))) {
                        this.trace(100, "Starting root application " + info.getApplicationName());
                        this.setRecursivelyStatus(info, (byte)0);
                        apps.add(info.getApplicationName());
                    } else {
                        info.setStatus((byte)0);
                        this.checkChildren(info, apps);
                    }
                } else if (info.getStatus() == 0) {
                    this.checkChildren(info, apps);
                }
            }
            ++i2;
        }
        DeployEvent event = new DeployEvent(null, 2, this.eventSystem.defineActionType("initialStartApplications"), this.clusterElementName);
        event.setWhoCausedGroupOperation("deploy");
        try {
            this.eventSystem.fireDeployEvent(event, (byte)0);
        }
        catch (OutOfMemoryError oofmer) {
            throw oofmer;
        }
        catch (Throwable th) {
            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5029", new String[]{"initial starting", ""}, th);
            sdex.log();
        }
        try {
            i = 0;
            while (i < apps.size()) {
                String appName = (String)apps.get(i);
                if (!this.skipApplicaitonOnInitialStart(appName)) {
                    try {
                        this.startApplicationLocalAndWait(appName);
                    }
                    catch (DeploymentException dex) {
                        dex.log();
                        errors.add("Error occurred while initially starting application " + appName + ":" + dex.getMessage());
                    }
                    catch (Exception ex) {
                        ServerDeploymentException sdex = new ServerDeploymentException("deploy_5029", new String[]{"initial starting", appName}, ex);
                        sdex.log();
                        errors.add("Error occurred while initially starting application " + appName + ":" + ex.getMessage());
                    }
                    catch (OutOfMemoryError oofmer) {
                        errors.add("Error occurred while initially starting application " + appName + ":" + oofmer.getMessage());
                        throw oofmer;
                    }
                    catch (ThreadDeath td) {
                        errors.add("Error occurred while initially starting application " + appName + ":" + td.getMessage());
                        throw td;
                    }
                    catch (Throwable th) {
                        ServerDeploymentException sdex = new ServerDeploymentException("deploy_5029", new String[]{"initial starting", appName}, th);
                        sdex.log();
                        errors.add("Error occurred while initially starting application " + appName + ":" + th.getMessage());
                    }
                }
                ++i;
            }
            Object var15_18 = null;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            try {
                event.setAction((byte)3);
                this.eventSystem.fireDeployEvent(event, (byte)0);
            }
            catch (OutOfMemoryError oofmer) {
                throw oofmer;
            }
            catch (Throwable th) {
                ServerDeploymentException sdex = new ServerDeploymentException("deploy_5029", new String[]{"initial starting", ""}, th);
                sdex.log();
            }
            throw throwable;
        }
        try {
            event.setAction((byte)3);
            this.eventSystem.fireDeployEvent(event, (byte)0);
        }
        catch (OutOfMemoryError oofmer) {
            throw oofmer;
        }
        catch (Throwable th) {
            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5029", new String[]{"initial starting", ""}, th);
            sdex.log();
        }
        i = 0;
        while (i < errors.size()) {
            this.logError((String)errors.get(i));
            ++i;
        }
    }

    private boolean skipApplicaitonOnInitialStart(String appName) {
        if (this.initially_not_started_apps != null) {
            int i = 0;
            while (i < this.initially_not_started_apps.length) {
                if (appName.equals(this.initially_not_started_apps[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void checkChildren(DeploymentInfo info, ArrayList apps) {
        if (info.getStatus() == 0) {
            String[] appsContainingNecessaryResources;
            ReferenceObject[] refs = info.getReferences();
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    if (refs[i].getReferenceTargetType().equals("application")) {
                        this.checkChildren1(apps, refs[i].toString());
                    }
                    ++i;
                }
            }
            if ((appsContainingNecessaryResources = info.getAppsContainingNecessaryResources()) != null) {
                int i = 0;
                while (i < appsContainingNecessaryResources.length) {
                    this.checkChildren1(apps, appsContainingNecessaryResources[i]);
                    ++i;
                }
            }
        }
    }

    private void checkChildren1(ArrayList apps, String appChild) {
        DeploymentInfo temp = (DeploymentInfo)((Object)this.applications.get(appChild));
        if (temp != null) {
            if (temp.getStatus() == 1) {
                apps.add(temp.getApplicationName());
                this.setRecursivelyStatus(temp, (byte)0);
            } else if (temp.getStatus() == 0) {
                this.checkChildren(temp, apps);
            }
        }
    }

    public void elementJoin(ClusterElement element) {
        this.remote.addServerID(element.getClusterId());
        this.eventSystem.serverAdded(element.getName());
    }

    public void elementLoss(ClusterElement element) {
        this.tManager.elementLoss(element);
    }

    public void afterElementStop(ClusterElement element) {
        this.remote.removeServerID(element.getClusterId());
    }

    public void markForShutdown() {
        this.inShutdown = true;
    }

    public boolean isMarkedForShutdown() {
        return this.inShutdown;
    }

    public Command[] getCommands() {
        return this.cmds;
    }

    public Hashtable beginLocalTransaction(Hashtable commandTable, int fromClusterId) throws DeploymentException, ComponentNotDeployedException {
        String phase;
        String appName = (String)commandTable.get("application_name");
        String transactionType = (String)commandTable.get("command");
        String[] containers = (String[])commandTable.get("containers");
        Hashtable<String, Properties> containerProps = new Hashtable<String, Properties>();
        Properties props = null;
        if (containers != null) {
            int i = 0;
            while (i < containers.length) {
                props = (Properties)commandTable.get("properties:" + containers[i]);
                if (props != null) {
                    containerProps.put(containers[i], props);
                }
                ++i;
            }
        }
        DTransaction trans = null;
        if (transactionType.equals("deploy")) {
            trans = new DeploymentTransaction(appName, this, containerProps, containers);
        } else if (transactionType.equals("update")) {
            trans = new UpdateTransaction(appName, this, containerProps, containers);
        } else if (transactionType.equals("stopApp")) {
            try {
                phase = (String)commandTable.get("phase");
                if (phase != null && phase.equals("force")) {
                    trans = new StopTransaction(appName, this, false);
                }
                trans = new StopTransaction(appName, this, fromClusterId, containers, false);
            }
            catch (DeploymentException dex) {
                dex.log();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                dex.printStackTrace(new PrintStream(baos));
                this.remote.sendRespond(appName, fromClusterId, null, new String[]{baos.toString()});
                return null;
            }
        } else if (transactionType.equals("startApp")) {
            phase = (String)commandTable.get("phase");
            try {
                if (phase != null && phase.equals("force")) {
                    trans = new StartTransaction(appName, this);
                }
                trans = new StartTransaction(appName, this, fromClusterId, containers);
            }
            catch (DeploymentException dex) {
                dex.log();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                dex.printStackTrace(new PrintStream(baos));
                this.remote.sendRespond(appName, fromClusterId, null, new String[]{baos.toString()});
                return null;
            }
        } else if (transactionType.equals("removeApp")) {
            trans = new RemoveTransaction(appName, this, true);
        } else if (!(transactionType.equals("deployLangLib") || transactionType.equals("deployLib") || transactionType.equals("removeLib"))) {
            DeploymentInfo info;
            if (transactionType.equals("makeRefs")) {
                info = (DeploymentInfo)((Object)this.applications.get(appName));
                if (info == null) {
                    this.applicationReferences.put(appName, (ReferenceObject[])commandTable.get("ref_objects"));
                } else {
                    trans = new MakeReferencesTransaction(appName, (ReferenceObject[])commandTable.get("ref_objects"), this);
                }
            } else if (transactionType.equals("removeRefs")) {
                info = (DeploymentInfo)((Object)this.applications.get(appName));
                if (info == null) {
                    String[] warnings = null;
                    String[] forRemove = (String[])commandTable.get("ref_objects");
                    ReferenceObject[] existing = (ReferenceObject[])this.applicationReferences.get(appName);
                    if (existing != null) {
                        warnings = this.evaluateReferences(appName, existing, forRemove);
                    } else {
                        warnings = new String[forRemove.length];
                        int i = 0;
                        while (i < forRemove.length) {
                            warnings[i] = "Reference from " + appName + " to " + forRemove[i] + " doesn't exist.";
                            ++i;
                        }
                    }
                    if (warnings != null && warnings.length > 0) {
                        Hashtable<String, String[]> res = new Hashtable<String, String[]>();
                        res.put("warnings", warnings);
                        return res;
                    }
                } else {
                    trans = new RemoveReferencesTransaction(appName, (String[])commandTable.get("ref_objects"), this);
                }
            } else if (transactionType.equals("runtimeChanges")) {
                if (containers == null || containers.length == 0) {
                    throw new ServerDeploymentException("deploy_5001", new String[]{"runtimeChanges", String.valueOf(fromClusterId), appName, this.clusterElementName});
                }
                trans = new RuntimeTransaction(appName, this, containers[0]);
            } else if (transactionType.equals("singleFileUpdate")) {
                if (containers == null) {
                    throw new ServerDeploymentException("deploy_5001", new String[]{appName, String.valueOf(fromClusterId), this.clusterElementName, "single file update"});
                }
                trans = new SingleFileUpdateTransaction(this, appName, containers);
            } else if (transactionType.equals("appInfoChange")) {
                trans = new AddAppInfoChangeTransaction(appName, this, (AdditionalAppInfo)commandTable.get("object"), containers);
            }
        }
        if (trans != null && trans.needForTransaction()) {
            trans.setUnregister(false);
            this.registerTransactionWithoutLock(trans);
            trans.makeAllPhasesLocal();
            TransactionStatistics stat = trans.getCurrentStatistics();
            if (stat != null) {
                Hashtable<String, String[]> res = new Hashtable<String, String[]>();
                if (stat.getErrors() != null) {
                    res.put("errors", stat.getErrors());
                }
                if (stat.getWarnings() != null) {
                    res.put("warnings", stat.getWarnings());
                }
                return res;
            }
            return null;
        }
        return null;
    }

    public DTransaction getTransaction(String appName) {
        return this.tManager.getTransaction(appName);
    }

    public String[] listApplications(String containerName) {
        String[] allApps = null;
        if (containerName == null) {
            return this.listApplications();
        }
        Vector<String> res = new Vector<String>();
        Enumeration infoes = this.applications.elements();
        DeploymentInfo info = null;
        while (infoes.hasMoreElements()) {
            info = (DeploymentInfo)((Object)infoes.nextElement());
            if (info.getDeployedComponents(containerName) == null) continue;
            res.add(info.getApplicationName());
        }
        allApps = new String[res.size()];
        res.toArray(allApps);
        return allApps;
    }

    public String[] listElements(String containerName, String applicationName) {
        String[] allComponents = null;
        DeploymentInfo info = null;
        if (applicationName == null) {
            Enumeration enumeration = this.applications.elements();
            while (enumeration.hasMoreElements()) {
                info = (DeploymentInfo)((Object)enumeration.nextElement());
                allComponents = DUtils.concatArrays(allComponents, this.getDeployedComponents(containerName, info));
            }
        } else {
            info = (DeploymentInfo)((Object)this.applications.get(applicationName));
            allComponents = this.getDeployedComponents(containerName, info);
        }
        return allComponents;
    }

    public String getApplicationID(String appName) {
        return DUtils.getApplicationID(appName);
    }

    private void shutdownCheck() throws DeploymentException {
        if (this.inShutdown) {
            throw new ServerDeploymentException("deploy_5068");
        }
    }

    private void defineApplicationLoader(String appName, DeploymentInfo deployment) throws DeploymentException {
        try {
            String[] refs;
            int i;
            LoadContext loadContext = this.sc.getCoreContext().getLoadContext();
            ClassLoader loader1 = loadContext.getClassLoader(appName);
            if (loader1 != null && loader1 instanceof ReferencedLoader) {
                loadContext.unregister((ReferencedLoader)loader1);
                ((ReferencedLoader)loader1).prepareForRemove();
            }
            URL url = new URL("file", "", this.getAppsWorkDir() + appName + "/-");
            CodeSource codeSource = new CodeSource(url, null);
            ProtectionDomain domain1 = new ProtectionDomain(codeSource, Policy.getPolicy().getPermissions(codeSource));
            String[] classLoaderJars = deployment.getApplicationLoaderFiles();
            com.sap.engine.frame.core.load.res.Resource[] resources = null;
            if (classLoaderJars != null) {
                File file = null;
                ArrayList<Object> list = new ArrayList<Object>();
                JarResource jarResource = null;
                i = 0;
                while (i < classLoaderJars.length) {
                    file = new File(classLoaderJars[i]);
                    if (file.exists()) {
                        codeSource = new CodeSource(file.toURL(), null);
                        ProtectionDomain domain = ProtectionDomainFactory.getFactory().registerApplicationProtectionDomain(null, codeSource);
                        if (file.isDirectory()) {
                            list.add(new DirResource(classLoaderJars[i], false, domain));
                        } else {
                            jarResource = new JarResource(classLoaderJars[i], false, domain);
                            jarResource.useTimeoutClose();
                            list.add(jarResource);
                        }
                    }
                    ++i;
                }
                resources = new com.sap.engine.frame.core.load.res.Resource[list.size()];
                list.toArray(resources);
            } else {
                resources = new com.sap.engine.frame.core.load.res.Resource[]{};
            }
            String loaderName = null;
            if (resources.length > 0) {
                ApplicationLoader loader = new ApplicationLoader((com.sap.engine.frame.core.load.res.Resource)new MultipleResource(resources), frameLoader, appName, domain1);
                loadContext.register((ReferencedLoader)loader);
                loaderName = deployment.getLoaderName() == null ? appName : deployment.getLoaderName();
            } else {
                loaderName = deployment.getLoaderName();
            }
            if (loaderName == null) {
                return;
            }
            this.makeApplicationStandartReferences(loaderName);
            ReferenceObject[] appRefs = deployment.getReferences();
            DeploymentInfo temp = null;
            if (appRefs != null) {
                i = 0;
                while (i < appRefs.length) {
                    if ("application".equals(appRefs[i].getReferenceTargetType())) {
                        temp = this.getApplicationInfo(appRefs[i].toString());
                        if (temp != null) {
                            loadContext.registerReference(loaderName, temp.getLoaderName() != null ? temp.getLoaderName() : temp.getApplicationName());
                        } else {
                            loadContext.registerReference(loaderName, appRefs[i].toString());
                        }
                    } else {
                        loadContext.registerReference(loaderName, appRefs[i].toString());
                    }
                    ++i;
                }
            }
            if ((refs = this.resolver.getUsedComponentLoaders(appName)) != null) {
                int i2 = 0;
                while (i2 < refs.length) {
                    if (refs[i2] != null) {
                        loadContext.registerReference(loaderName, refs[i2]);
                    }
                    ++i2;
                }
            }
            if ((refs = loadContext.getReferences(loaderName)) == null || refs.length == 0) {
                this.trace(100, "No references registered for loader " + loaderName);
            } else {
                int i3 = 0;
                while (i3 < refs.length) {
                    this.trace(100, "Registered reference from loader " + loaderName + " to " + refs[i3]);
                    ++i3;
                }
            }
        }
        catch (Exception e) {
            throw new ServerDeploymentException("deploy_5004", new String[]{appName}, e);
        }
    }

    private String[] getStandartAppReferences() {
        if (this.serviceProperties != null && this.serviceProperties.getProperty("StandardApplicationReferences") != null) {
            String refs = this.serviceProperties.getProperty("StandardApplicationReferences");
            StringTokenizer tokenizer = new StringTokenizer(refs, ";");
            Vector<String> resVector = new Vector<String>();
            String ref = "";
            while (tokenizer.hasMoreTokens()) {
                ref = tokenizer.nextToken();
                if (ref == null || ref.trim().equals("")) continue;
                resVector.add(ref);
            }
            Object[] res = new String[]{};
            if (resVector != null && resVector.size() != 0) {
                res = new String[resVector.size()];
                resVector.copyInto(res);
            }
            return res;
        }
        return new String[]{"service:servlet_jsp", "service:dbpool", "service:ts", "service:ejb", "service:p4", "service:iiop", "service:deploy", "service:connector", "service:jmsconnector", "service:timeout", "service:webservices", "library:jsse", "library:servlet", "library:mail", "library:ejb20", "library:activation", "library:j2eeca", "library:jms", "library:opensql", "interface:csiv2", "interface:security", "interface:ejbserialization", "interface:cross", "interface:webservices", "interface:log", "interface:ejbcomponent"};
    }

    public void makeApplicationStandartReferences(String appName) throws DeploymentException {
        String[] refsTo = this.getStandartAppReferences();
        try {
            int i = 0;
            while (i < refsTo.length) {
                this.sc.getCoreContext().getLoadContext().registerReference(appName, refsTo[i]);
                ++i;
            }
        }
        catch (Exception e) {
            throw new ServerDeploymentException("deploy_5073", new String[]{appName}, e);
        }
    }

    public void removeApplicationStandartReferences(String appName) throws DeploymentException {
        String loaderName = null;
        DeploymentInfo info = (DeploymentInfo)((Object)this.applications.get(appName));
        loaderName = info == null ? appName : (info.getLoaderName() != null ? info.getLoaderName() : appName);
        if (loaderName == null) {
            return;
        }
        String[] refsTo = this.getStandartAppReferences();
        try {
            String[] refs;
            if (this.sc.getCoreContext().getLoadContext().getClassLoader(loaderName) == null) {
                int i = 0;
                while (i < refsTo.length) {
                    this.sc.getCoreContext().getLoadContext().unregisterReference(loaderName, refsTo[i]);
                    ++i;
                }
            }
            if (info != null) {
                ReferenceObject[] appRefs = info.getReferences();
                DeploymentInfo temp = null;
                if (appRefs != null) {
                    int i = 0;
                    while (i < appRefs.length) {
                        if ("application".equals(appRefs[i].getReferenceTargetType())) {
                            temp = this.getApplicationInfo(appRefs[i].toString());
                            if (temp != null) {
                                this.sc.getCoreContext().getLoadContext().unregisterReference(loaderName, temp.getLoaderName() != null ? temp.getLoaderName() : temp.getApplicationName());
                                this.trace(100, "Unregistered reference from loader " + loaderName + " to " + (temp.getLoaderName() != null ? temp.getLoaderName() : temp.getApplicationName()));
                            } else {
                                this.sc.getCoreContext().getLoadContext().unregisterReference(loaderName, appRefs[i].toString());
                                this.trace(100, "Unregistered reference from loader " + loaderName + " to " + appRefs[i].toString());
                            }
                        } else {
                            this.sc.getCoreContext().getLoadContext().unregisterReference(loaderName, appRefs[i].toString());
                            this.trace(100, "Unregistered reference from loader " + loaderName + " to " + appRefs[i].toString());
                        }
                        ++i;
                    }
                }
            }
            if ((refs = this.resolver.getUsedComponentLoaders(appName)) != null) {
                int i = 0;
                while (i < refs.length) {
                    this.sc.getCoreContext().getLoadContext().unregisterReference(loaderName, refs[i]);
                    this.trace(100, "Unregistered reference from loader " + loaderName + " to " + refs[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new ServerDeploymentException("deploy_5074", new String[]{appName}, e);
        }
    }

    private void makeGlobalTransaction(DTransaction transaction) throws DeploymentException, ComponentNotDeployedException {
        this.registerTransactionWithLock(transaction);
        try {
            transaction.makeAllPhases();
            Object var3_2 = null;
            if (transaction.unregister()) {
                this.unregisterTransactionWithLock(transaction.getModuleID());
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (transaction.unregister()) {
                this.unregisterTransactionWithLock(transaction.getModuleID());
            }
            throw throwable;
        }
    }

    private String[] checkSupport(String[] remoteSupport, Vector warnings) throws RemoteException {
        String[] support = this.getSupports();
        if (remoteSupport == null || remoteSupport.length == 0) {
            warnings.add("No remote support protocols were set. Will use default one : p4.");
            return new String[]{"p4"};
        }
        boolean isOne = false;
        boolean isFound = false;
        boolean addMessage = false;
        String names = "";
        String some = "";
        int i = 0;
        while (i < remoteSupport.length) {
            isFound = false;
            some = some + remoteSupport[i] + ", ";
            int j = 0;
            while (j < support.length) {
                if (i == 0) {
                    names = names + support[j] + ", ";
                }
                if (remoteSupport[i] != null && remoteSupport[i].equals(support[j])) {
                    isFound = true;
                    if (isOne) break;
                    isOne = true;
                    break;
                }
                ++j;
            }
            if (!isFound) {
                addMessage = true;
                warnings.add("The following remote support is not defined : " + remoteSupport[i]);
            }
            ++i;
        }
        if (addMessage) {
            warnings.add("The only available remote support protocols are : " + names + "please remove the ones that are wrong.");
        }
        if (!isOne) {
            warnings.add("ID5008 The given remote supports " + some + "are not available." + " The following are currently accessible : " + names + ".The application will be deployed with default one - p4 support.");
        }
        return remoteSupport;
    }

    public Hashtable getServerLibraries() {
        LibraryMonitor[] lms = this.sc.getContainerContext().getSystemMonitor().getLibraries();
        Hashtable<String, String[]> result = new Hashtable<String, String[]>();
        String libName = null;
        String[] libJars = null;
        int i = 0;
        while (i < lms.length) {
            libName = lms[i].getComponentName();
            libJars = lms[i].getJars();
            result.put(libName, libJars);
            ++i;
        }
        return result;
    }

    public String[] getServerReferences() {
        int i;
        Vector<String> result = new Vector<String>();
        LibraryMonitor[] lms = this.sc.getContainerContext().getSystemMonitor().getLibraries();
        Reference[] refs = null;
        int j = 0;
        String libName = null;
        String newRef = null;
        int i2 = 0;
        while (i2 < lms.length) {
            libName = lms[i2].getComponentName();
            refs = lms[i2].getReferences();
            j = 0;
            while (j < refs.length) {
                newRef = libName + ";" + DUtils.parseReferencesInternal(refs[j].getName());
                if (!result.contains(newRef)) {
                    result.add(newRef);
                }
                ++j;
            }
            ++i2;
        }
        Enumeration enumeration = this.applications.keys();
        String appName = null;
        ReferenceObject[] appRefs = null;
        while (enumeration.hasMoreElements()) {
            appName = (String)enumeration.nextElement();
            appRefs = ((DeploymentInfo)((Object)this.applications.get(appName))).getReferences();
            if (appRefs == null) continue;
            i = 0;
            while (i < appRefs.length) {
                newRef = appName + ";" + DUtils.parseReferencesInternal(appRefs[i].toString());
                if (!result.contains(newRef)) {
                    result.add(newRef);
                }
                ++i;
            }
        }
        enumeration = this.applicationReferences.keys();
        appName = null;
        appRefs = null;
        while (enumeration.hasMoreElements()) {
            appName = (String)enumeration.nextElement();
            appRefs = (ReferenceObject[])this.applicationReferences.get(appName);
            if (appRefs == null) continue;
            i = 0;
            while (i < appRefs.length) {
                newRef = appName + ";" + DUtils.parseReferencesInternal(appRefs[i].toString());
                if (!result.contains(newRef)) {
                    result.add(newRef);
                }
                ++i;
            }
        }
        Object[] r = new String[result.size()];
        result.copyInto(r);
        return r;
    }

    public DeploymentInfo[] getAllDeploymentInfoes() {
        DeploymentInfo[] temp = new DeploymentInfo[this.applications.size()];
        Enumeration infoes = this.applications.elements();
        int i = 0;
        while (infoes.hasMoreElements()) {
            temp[i++] = (DeploymentInfo)((Object)infoes.nextElement());
        }
        return temp;
    }

    public DeploymentInfo getDeploymentInfo(String appName) {
        Object obj = this.applications.get(appName);
        if (obj != null) {
            return (DeploymentInfo)((Object)obj);
        }
        return null;
    }

    protected void registerCommands() {
        this.cmds = new Command[19];
        this.cmds[0] = new DeployCommand(this);
        this.cmds[1] = new GetClientJarsCommand(this);
        this.cmds[2] = new ListApplicationsCommand(this);
        this.cmds[3] = new ListElementsCommand(this);
        this.cmds[4] = new RemoveApplicationCommand(this);
        this.cmds[5] = new StopApplicationCommand(this);
        this.cmds[6] = new StartApplicationCommand(this);
        this.cmds[7] = new UpdateCommand(this);
        this.cmds[8] = new GetStatusCommand(this);
        this.cmds[9] = new ChangeLibraries(this);
        this.cmds[10] = new ChangeReference(this);
        this.cmds[11] = new DeployLanguageLibCommand(this);
        this.cmds[12] = new UnlockApplicationCommand(this.sc.getCoreContext().getLockingContext(), this.deployOwner, DEPLOY_AREA);
        this.cmds[13] = new ListRefsCommand(this);
        this.cmds[14] = new ContainerInfoCommand(this);
        this.cmds[15] = new UpdateFilesCommand(this);
        this.cmds[16] = new ChangeServices(this);
        this.cmds[17] = new ChangeInterfaces(this);
        this.cmds[18] = new GetStartUpModeCommand(this);
    }

    public DeploymentInfo getApplicationInfo(String appName) {
        if (appName != null) {
            return (DeploymentInfo)((Object)this.applications.get(appName));
        }
        return null;
    }

    public DeploymentInfo getApplicationInfo(String appName, boolean isAlwayReads, boolean isDownloadApps, Configuration appConfig, Configuration deployAppConfig) {
        if (appName != null) {
            if (this.applications.get(appName) != null && !isAlwayReads) {
                return (DeploymentInfo)((Object)this.applications.get(appName));
            }
            if (appConfig != null) {
                try {
                    if (!appName.equals(appConfig.getConfigEntry("STR:ApplicationName"))) {
                        return null;
                    }
                }
                catch (ConfigurationException ex) {
                    ServerDeploymentException dex = new ServerDeploymentException("deploy_5075", new String[]{appConfig.getPath()}, ex);
                    dex.log();
                    return null;
                }
                DeploymentInfo info = new DeploymentInfo();
                info.setApplicationName(appName);
                try {
                    Byte tempStatus = (Byte)deployAppConfig.getConfigEntry("BYTE:AppStatus");
                    info.setStatus(tempStatus);
                }
                catch (ConfigurationException cex) {
                    this.logError("Not specified status in DB of application " + appName);
                    this.trace(500, "Error occurred while retrieving status of application: " + appName + ": " + cex.toString());
                    return null;
                }
                try {
                    if (deployAppConfig.existsConfigEntry("STR:StartUp")) {
                        Integer tempStartUp = (Integer)deployAppConfig.getConfigEntry("STR:StartUp");
                        info.setStartUp(tempStartUp);
                        this.trace(100, "Application " + appName + " startup mode is " + tempStartUp);
                    }
                }
                catch (ConfigurationException cex) {
                    this.logWarning("Getting start up info about application " + appName + " failed.");
                    this.trace(400, "Error occurred while retrieving start up info about application " + appName + ": " + cex.toString());
                }
                try {
                    Configuration serverDeployAppConfig = null;
                    if (deployAppConfig.existsSubConfiguration("" + this.getClusterID())) {
                        serverDeployAppConfig = deployAppConfig.getSubConfiguration("" + this.getClusterID());
                    } else if (deployAppConfig.existsSubConfiguration(this.getClusterIDName())) {
                        serverDeployAppConfig = deployAppConfig.getSubConfiguration(this.getClusterIDName());
                    }
                    if (serverDeployAppConfig != null && serverDeployAppConfig.existsFile("STR:ExceptionInfo")) {
                        ExceptionInfo exceptionInfo = ExceptionInfo.encode((String)((String)DUtils.getDeserializedObject(serverDeployAppConfig, "STR:ExceptionInfo")));
                        this.exceptionInfos.put(appName, exceptionInfo);
                    }
                }
                catch (ConfigurationException cex) {
                    this.logWarning("Getting exception info about application " + appName + " failed.");
                    this.trace(400, "Error occurred while getting exception info for application " + appName + ": " + cex.toString());
                }
                catch (ServerDeploymentException sde) {
                    sde.log();
                }
                try {
                    if (deployAppConfig.existsConfigEntry("BYTES:appArchiveSize")) {
                        Long tempSize = (Long)deployAppConfig.getConfigEntry("BYTES:appArchiveSize");
                        info.setAppArchiveSize(tempSize);
                    }
                }
                catch (ConfigurationException cex) {
                    this.logWarning("Getting archive size of application " + appName + " failed.");
                    this.trace(400, "Error occurred while retrieving archive size of application " + appName + ":" + cex.toString());
                }
                try {
                    if (deployAppConfig.existsConfigEntry("MILLISECONDS:deploymentDuration")) {
                        Long tempDuration = (Long)deployAppConfig.getConfigEntry("MILLISECONDS:deploymentDuration");
                        info.setDeploymentDuration(tempDuration);
                    }
                }
                catch (ConfigurationException cex) {
                    this.logWarning("Getting deployment duration of application " + appName + " failed.");
                    this.trace(400, "Error occurred while getting deployment duration of application " + appName + ":" + cex.toString());
                }
                try {
                    if (deployAppConfig.existsConfigEntry("INT:numberOfRedeploys")) {
                        Integer tempNumber = (Integer)deployAppConfig.getConfigEntry("INT:numberOfRedeploys");
                        info.setNumberOfRedeploys(tempNumber);
                    } else {
                        info.setNumberOfRedeploys(1);
                    }
                }
                catch (ConfigurationException cex) {
                    this.logWarning("Getting number of redeploys of application " + appName + " failed.");
                    this.trace(400, "Error occurred while getting number of redeploys of application " + appName + ":" + cex.toString());
                }
                try {
                    if (deployAppConfig.existsConfigEntry("TIME:timeOfLastRedeployment")) {
                        String tempTime = null;
                        Object obj = deployAppConfig.getConfigEntry("TIME:timeOfLastRedeployment");
                        if (obj instanceof String) {
                            tempTime = (String)obj;
                        } else if (obj instanceof Long) {
                            Date temp = new Date((Long)obj);
                            tempTime = temp.toString();
                        }
                        info.setTimeOfLastRedeployment(tempTime);
                    }
                }
                catch (ConfigurationException cex) {
                    this.trace(300, "Not specified time of last redeployment of application " + appName);
                }
                try {
                    info.setContainerNames((String[])appConfig.getConfigEntry("STR[]:ContainerNames"));
                }
                catch (ConfigurationException cex) {
                    this.logError("Getting containers on which application " + appName + " is deployed failed.");
                    this.trace(500, "Error occurred while getting containers for application " + appName + ": " + cex.toString());
                }
                try {
                    info.setOptionalContainers((String[])appConfig.getConfigEntry("STR[]:optionalContainers"));
                }
                catch (ConfigurationException cex) {
                    this.trace(300, "Not specified optional containers for application " + appName);
                }
                try {
                    Hashtable deployedComponents = null;
                    try {
                        deployedComponents = (Hashtable)DUtils.getDeserializedObject(appConfig, "HASH_STR_STR[]:Cont_CompNames");
                    }
                    catch (ServerDeploymentException sde) {
                        sde.log();
                        return null;
                    }
                    info.setDeployedComponents(deployedComponents);
                }
                catch (ConfigurationException cex) {
                    this.logError("Getting deployed components of application " + appName + " failed.");
                    this.trace(500, "Error occurred while getting deployed components of application " + appName + ": " + cex.toString());
                }
                try {
                    Hashtable deployedFileNames = null;
                    try {
                        if (appConfig.existsFile("HASH_STR_STR[]:Cont_FileNames")) {
                            deployedFileNames = (Hashtable)DUtils.getDeserializedObject(appConfig, "HASH_STR_STR[]:Cont_FileNames");
                        }
                    }
                    catch (ServerDeploymentException sde) {
                        sde.log();
                    }
                    info.setDeployedFileNames(deployedFileNames);
                }
                catch (ConfigurationException cex) {
                    this.logError("Getting deployed files of application " + appName + " failed.");
                    this.trace(500, "Error occurred while getting deployed files of application " + appName + ": " + cex.toString());
                }
                try {
                    Hashtable deployedResources_Types = (Hashtable)DUtils.getDeserializedObject(appConfig, "HASH_STR_STR[]:Res_Types");
                    info.setDeployedComponents_Types(deployedResources_Types);
                }
                catch (ServerDeploymentException sde) {
                    sde.log();
                }
                catch (ConfigurationException cex) {
                    this.trace(300, "Not specified types of deployed resources for application " + appName);
                }
                try {
                    String[] encodedResources = null;
                    try {
                        encodedResources = (String[])DUtils.getDeserializedObject(appConfig, "STR[]:EncodeResources");
                    }
                    catch (ServerDeploymentException sde) {
                        sde.log();
                        return null;
                    }
                    info.setResources(encodedResources);
                    if (encodedResources != null && !isDownloadApps) {
                        int i = 0;
                        while (i < encodedResources.length) {
                            this.addReferenceInternallyFrom(info, encodedResources[i]);
                            ++i;
                        }
                    }
                }
                catch (ConfigurationException cex) {
                    this.trace(300, "Not specified encoded resources of application " + appName);
                }
                try {
                    String[] containerCLfiles = null;
                    try {
                        containerCLfiles = (String[])DUtils.getDeserializedObject(appConfig, "STR[]:AppLoaderFilePaths");
                    }
                    catch (ServerDeploymentException sde) {
                        sde.log();
                        return null;
                    }
                    if (containerCLfiles != null) {
                        info.setContainerFilesForClassLoader(DUtils.getRealPaths(this.getAppsWorkDir(), containerCLfiles));
                    }
                }
                catch (ConfigurationException ex) {
                    this.trace(300, "Not specified container class loader files for application " + appName);
                }
                try {
                    Hashtable libsCRC = null;
                    try {
                        libsCRC = (Hashtable)DUtils.getDeserializedObject(appConfig, "HASH_STR_BYTE[]:LibFileName_CRC");
                    }
                    catch (ServerDeploymentException sde) {
                        sde.log();
                        return null;
                    }
                    if (libsCRC != null) {
                        String[] internalLibs = new String[libsCRC.size()];
                        Enumeration libs = libsCRC.keys();
                        int i = 0;
                        while (libs.hasMoreElements()) {
                            internalLibs[i++] = (String)libs.nextElement();
                        }
                        info.setInternalLibraries(DUtils.getRealPaths(this.getAppsWorkDir() + appName.replace('/', File.separatorChar), internalLibs));
                    }
                }
                catch (ConfigurationException ex) {
                    this.trace(300, "Not specified internal libraries for application " + appName);
                }
                try {
                    info.setProperties((Properties)appConfig.getConfigEntry("PROPS_STR_STR:ApplicationProperties"));
                }
                catch (ConfigurationException ex) {
                    this.trace(300, "Not specified properties for application " + appName);
                }
                try {
                    info.setRemoteSupport((String[])appConfig.getConfigEntry("STR[]:RemoteSupport"));
                }
                catch (ConfigurationException ex) {
                    this.trace(300, "Not specified remote support for application " + appName);
                }
                try {
                    info.setStandAloneArchive((Boolean)appConfig.getConfigEntry("BOOL:IsStandAloneArchive"));
                }
                catch (ConfigurationException ex) {
                    this.logError("Checking whether application " + appName + " is a stand alone archive failed.");
                    this.trace(500, "Error occurred while checking if application " + appName + " is a stand alone archive: " + ex.toString());
                }
                ClassLoader threadLoader = null;
                try {
                    block99: {
                        try {
                            threadLoader = Thread.currentThread().getContextClassLoader();
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                            Object refs = null;
                            try {
                                if (appConfig.existsFile("HASH_STR_STR:Reference_type") || appConfig.existsConfigEntry("HASH_STR_STR:Reference_type")) {
                                    refs = DUtils.getDeserializedObject(appConfig, "HASH_STR_STR:Reference_type");
                                }
                            }
                            catch (ServerDeploymentException sde) {
                                sde.log();
                                DeploymentInfo i = null;
                                Object var14_51 = null;
                                Thread.currentThread().setContextClassLoader(threadLoader);
                                return i;
                            }
                            if (refs == null) break block99;
                            ReferenceObject[] refObj = null;
                            if (refs instanceof String[]) {
                                refObj = DUtils.encodeReferenceObjectArray((String[])refs);
                            } else if (refs instanceof ReferenceObject[]) {
                                refObj = (ReferenceObject[])refs;
                            } else if (refs instanceof Hashtable && refs != null) {
                                ArrayList<ReferenceObject> refsArr = new ArrayList<ReferenceObject>();
                                Enumeration enumeration = ((Hashtable)refs).keys();
                                String refName = null;
                                while (enumeration.hasMoreElements()) {
                                    refName = (String)enumeration.nextElement();
                                    if (refName == null) continue;
                                    refsArr.add(new ReferenceObject(refName, (String)((Hashtable)refs).get(refName)));
                                }
                                refObj = new ReferenceObject[refsArr.size()];
                                refsArr.toArray(refObj);
                            }
                            info.setReferences(refObj);
                            if (refObj == null || isDownloadApps) break block99;
                            int i = 0;
                            while (i < refObj.length) {
                                this.addReferenceInternallyFrom(info, refObj[i]);
                                ++i;
                            }
                        }
                        catch (ConfigurationException ex) {
                            this.logError("Getting references of application " + appName + " failed.");
                            this.trace(500, "Error occurred while getting references of application " + appName + ": " + ex.toString());
                            Object var14_53 = null;
                            Thread.currentThread().setContextClassLoader(threadLoader);
                        }
                    }
                    Object var14_52 = null;
                    Thread.currentThread().setContextClassLoader(threadLoader);
                }
                catch (Throwable throwable) {
                    Object var14_54 = null;
                    Thread.currentThread().setContextClassLoader(threadLoader);
                    throw throwable;
                }
                try {
                    info.setAdditionalClasspath((String)appConfig.getConfigEntry("STR:AdditionalClasspath"));
                }
                catch (ConfigurationException cex) {
                    this.trace(300, "Not specified additional class path for application " + appName);
                }
                try {
                    info.setFailOverValue((String)appConfig.getConfigEntry("STR:Failover"));
                }
                catch (ConfigurationException cex) {
                    this.trace(300, "Not specified fail over for application " + appName);
                }
                catch (BaseIllegalArgumentException de) {
                    de.log();
                }
                try {
                    Configuration appCfg = appConfig.getSubConfiguration("appcfg");
                    info.setApplicationConfigurationPath(appCfg.getPath());
                    Configuration manifestCfg = appCfg.getSubConfiguration("SAP_MANIFEST");
                    info.setSAPManifestConfiguration(manifestCfg.getPath());
                }
                catch (ConfigurationException cex) {
                    this.trace(300, "Not specified specific configuration for application " + appName);
                }
                if (!isDownloadApps) {
                    this.addApplicationInfo(info.getApplicationName(), info, false);
                } else if (appName != null && info != null) {
                    this.applications.put(appName, info);
                }
                try {
                    info.setLoaderName((String)appConfig.getConfigEntry("STR:Loader"));
                }
                catch (ConfigurationException cex) {
                    this.trace(300, "Not specified loader name for application " + appName);
                }
                return info;
            }
        }
        return null;
    }

    private DeploymentInfo[] getDInfoesFromDB(Configuration appsConfig, Configuration deployConfig) {
        Vector<DeploymentInfo> dInfoes;
        DeploymentInfo[] res;
        block22: {
            if (appsConfig == null) {
                return null;
            }
            res = null;
            dInfoes = new Vector<DeploymentInfo>();
            Configuration providerConfig = null;
            Configuration deployAppConfig = null;
            Configuration deployProviderConfig = null;
            try {
                String[] providerNames = appsConfig.getAllSubConfigurationNames();
                DeploymentInfo info = null;
                if (providerNames == null) break block22;
                int i = 0;
                while (i < providerNames.length) {
                    block23: {
                        if (providerNames[i] != null) {
                            try {
                                int j;
                                providerConfig = appsConfig.getSubConfiguration(providerNames[i]);
                                deployProviderConfig = deployConfig.getSubConfiguration(providerNames[i]);
                                String[] appNames = providerConfig.getAllSubConfigurationNames();
                                String[] deployNames = deployProviderConfig.getAllSubConfigurationNames();
                                if (appNames != null) {
                                    j = 0;
                                    while (j < appNames.length) {
                                        try {
                                            deployAppConfig = deployProviderConfig.getSubConfiguration(appNames[j]);
                                            info = this.getApplicationInfo(providerNames[i] + "/" + appNames[j], false, true, providerConfig.getSubConfiguration(appNames[j]), deployAppConfig);
                                            if (info != null) {
                                                dInfoes.add(info);
                                            }
                                        }
                                        catch (ConfigurationException ce) {
                                            ServerDeploymentException dex = new ServerDeploymentException("deploy_5062", new String[]{"", ""}, ce);
                                            dex.log();
                                        }
                                        ++j;
                                    }
                                    Enumeration apps = this.applications.keys();
                                    DeploymentInfo currDI = null;
                                    String currApp = null;
                                    String[] currResources = null;
                                    ReferenceObject[] currRefs = null;
                                    while (apps.hasMoreElements()) {
                                        int k;
                                        currApp = (String)apps.nextElement();
                                        currDI = this.getApplicationInfo(currApp);
                                        currResources = currDI.getResources();
                                        if (currResources != null) {
                                            k = 0;
                                            while (k < currResources.length) {
                                                this.addReferenceInternallyFrom(currDI, currResources[k]);
                                                ++k;
                                            }
                                        }
                                        if ((currRefs = currDI.getReferences()) == null) continue;
                                        k = 0;
                                        while (k < currRefs.length) {
                                            this.addReferenceInternallyFrom(currDI, currRefs[k]);
                                            ++k;
                                        }
                                    }
                                    apps = this.applications.keys();
                                    while (apps.hasMoreElements()) {
                                        currApp = (String)apps.nextElement();
                                        this.addApplicationInfo(currApp, this.getApplicationInfo(currApp), false);
                                    }
                                }
                                if (deployNames == null) break block23;
                                j = 0;
                                while (j < deployNames.length) {
                                    if (!DUtils.isAlreadyAdded(appNames, deployNames[j])) {
                                        try {
                                            Configuration appConfig = deployProviderConfig.getSubConfiguration(deployNames[j]);
                                            if (appConfig.existsFile("HASH_STR_STR:Reference_type") || appConfig.existsConfigEntry("HASH_STR_STR:Reference_type")) {
                                                ReferenceObject[] refObj = DUtils.encodeReferenceObjectArray((String[])DUtils.getDeserializedObject(appConfig, "HASH_STR_STR:Reference_type"));
                                                this.applicationReferences.put(providerNames[i] + "/" + deployNames[j], refObj);
                                            }
                                        }
                                        catch (ServerDeploymentException sde) {
                                            sde.log();
                                            return null;
                                        }
                                    }
                                    ++j;
                                }
                            }
                            catch (ConfigurationException ce) {
                                ServerDeploymentException dex = new ServerDeploymentException("deploy_5062", new String[]{"", ""}, ce);
                                dex.log();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (ConfigurationException ce) {
                ServerDeploymentException dex = new ServerDeploymentException("deploy_5062", new String[]{"", ""}, ce);
                dex.log();
            }
        }
        res = new DeploymentInfo[dInfoes.size()];
        dInfoes.toArray(res);
        return res;
    }

    public String getContainerWorkDir(String containerName, String applicationName) {
        String path = this.getAppsWorkDir() + applicationName.replace('/', File.separatorChar) + File.separator + containerName;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path;
    }

    public ReferenceObject[] getAdditionalReferences(String applicationName) {
        return (ReferenceObject[])this.applicationReferences.get(applicationName);
    }

    public void setLocalApplicationStatus(String appName, byte status) {
        DeploymentInfo info = (DeploymentInfo)((Object)this.applications.get(appName));
        if (info != null) {
            this.trace(100, "Set status " + status + " of application " + appName);
            info.setStatus(status);
            String[] conts = info.getContainerNames();
            if (conts != null) {
                ContainerInterface cont = null;
                int i = 0;
                while (i < conts.length) {
                    cont = this.getContainer(conts[i]);
                    if (cont != null) {
                        cont.applicationStatusChanged(appName, status);
                    }
                    ++i;
                }
            }
        }
    }

    public byte getStatus(String appName) throws DeploymentException {
        DeploymentInfo info = (DeploymentInfo)((Object)this.applications.get(appName = this.getApplicationID(appName)));
        if (info != null) {
            return info.getStatus();
        }
        throw new ServerDeploymentException("deploy_5005", new String[]{appName, this.clusterElementName, "get its status"});
    }

    public void removeApplicationInfo(String appName) {
        if (appName == null) {
            return;
        }
        DeploymentInfo info = (DeploymentInfo)((Object)this.applications.get(appName));
        if (info != null) {
            this.removeRootApplication(info);
        }
        this.applications.remove(appName);
    }

    public Properties getApplicationReferences(String appName) throws RemoteException {
        Properties res;
        block6: {
            int i;
            ReferenceObject[] temp;
            DeploymentInfo info;
            block5: {
                appName = this.getApplicationID(appName);
                info = (DeploymentInfo)((Object)this.applications.get(appName));
                res = new Properties();
                temp = null;
                if (info != null) break block5;
                temp = (ReferenceObject[])this.applicationReferences.get(appName);
                if (temp == null) break block6;
                int i2 = 0;
                while (i2 < temp.length) {
                    ((Hashtable)res).put(temp[i2].toString(), temp[i2].getReferenceType());
                    ++i2;
                }
                break block6;
            }
            String[] refs = this.getStandartAppReferences();
            if (refs != null) {
                i = 0;
                while (i < refs.length) {
                    ((Hashtable)res).put(refs[i], "weak");
                    ++i;
                }
            }
            if ((temp = info.getReferences()) != null) {
                i = 0;
                while (i < temp.length) {
                    ((Hashtable)res).put(temp[i].toString(), temp[i].getReferenceType());
                    ++i;
                }
            }
        }
        return res;
    }

    public void registerReferences(String appName, ReferenceObject[] refs) {
        if (appName != null && refs != null) {
            this.applicationReferences.put(appName, refs);
        }
    }

    public void unregisterReferences(String appName) {
        if (appName != null) {
            this.applicationReferences.remove(appName);
        }
    }

    public void addApplicationInfo(String appName, DeploymentInfo info, boolean temp) {
        if (appName == null || info == null) {
            return;
        }
        this.applications.put(appName, info);
        if (!temp) {
            Enumeration apps = this.applications.elements();
            DeploymentInfo other = null;
            ReferenceObject[] refs = null;
            String[] resources = null;
            block0: while (apps.hasMoreElements()) {
                int i;
                other = (DeploymentInfo)((Object)apps.nextElement());
                if (appName.equals(other.getApplicationName())) continue;
                refs = other.getReferences();
                if (refs != null) {
                    i = 0;
                    while (i < refs.length) {
                        if ("application".equals(refs[i].getReferenceTargetType()) && appName.equals(refs[i].toString())) {
                            this.addReferenceInternallyFrom(other, refs[i]);
                            break;
                        }
                        ++i;
                    }
                }
                if ((resources = other.getResources()) == null) continue;
                i = 0;
                while (i < resources.length) {
                    if (this.resolver.doesApplicationContainComponent(info, DUtils.decodeResourceName(resources[i]), DUtils.decodeResourceType(resources[i]))) {
                        this.addReferenceInternallyFrom(other, resources[i]);
                        continue block0;
                    }
                    ++i;
                }
            }
            this.addRootApplication(info);
        }
    }

    private synchronized void addRootApplication(DeploymentInfo info) {
        String[] appsContainingNecessaryResources;
        ReferenceObject[] refs = info.getReferences();
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                if (refs[i].getReferenceTargetType().equals("application") && this.rootApplications.contains(refs[i].toString())) {
                    this.rootApplications.remove(refs[i].toString());
                }
                ++i;
            }
        }
        if ((appsContainingNecessaryResources = info.getAppsContainingNecessaryResources()) != null) {
            int i = 0;
            while (i < appsContainingNecessaryResources.length) {
                if (this.rootApplications.contains(appsContainingNecessaryResources[i])) {
                    this.rootApplications.remove(appsContainingNecessaryResources[i]);
                }
                ++i;
            }
        }
        if (!(info.getReferenesFrom() != null && info.getReferenesFrom().length != 0 || this.rootApplications.contains(info.getApplicationName()))) {
            this.rootApplications.add(info.getApplicationName());
        }
    }

    public synchronized void removeRootApplication(DeploymentInfo info) {
        ReferenceObject[] refs = info.getReferences();
        DeploymentInfo temp = null;
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                if (refs[i].getReferenceTargetType().equals("application") && this.rootApplications.contains(refs[i].getReferenceTarget())) {
                    temp = this.getApplicationInfo(refs[i].getReferenceTarget());
                    temp.removeReferencesFrom(new String[]{info.getApplicationName()});
                    if (!(temp == null || temp.getReferenesFrom() != null && temp.getReferenesFrom().length != 0 || this.rootApplications.contains(refs[i].getReferenceTarget()))) {
                        this.rootApplications.add(refs[i].getReferenceTarget());
                    }
                }
                ++i;
            }
        }
        if (info.getReferenesFrom() == null || info.getReferenesFrom().length == 0) {
            this.rootApplications.remove(info.getApplicationName());
        }
    }

    public DeployService getDeployService() {
        return this;
    }

    public ContainerInfo getContainerInfo(String containerName, String serverName) throws RemoteException {
        if (containerName == null) {
            throw new RemoteException("Container name is not specified.");
        }
        if (serverName == null) {
            serverName = this.clusterElementName;
        }
        return this.getContainerInfo(containerName, new String[]{serverName});
    }

    public ContainerInfo getContainerInfo(String containerName, String[] serverNames) throws RemoteException {
        if (containerName == null) {
            throw new RemoteException("Container name is not specified.");
        }
        try {
            int[] ids = this.getClusterIDs(serverNames);
            int localIndex = this.isLocalIncluded(ids);
            ContainerInfo info = null;
            if (localIndex != -1 && (info = this.getContainerInfo(containerName)) != null) {
                return info;
            }
            int i = 0;
            while (i < ids.length) {
                if (i != localIndex && (info = this.remote.getContainerInfoRemotely(containerName, ids[i])) != null) {
                    return info;
                }
                ++i;
            }
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while getting information about container " + containerName + ". \nReason: " + dex.getMessage());
            }
            throw new RemoteException("Error occurred while getting information about container " + containerName + ". \nReason: " + dex.getStackTraceString());
        }
        throw new RemoteException("Container " + containerName + " is not started on the specified server(s)");
    }

    public ContainerInfo getContainerInfo(String containerName) {
        ContainerInterface cont = this.getContainer(containerName);
        if (cont != null) {
            return cont.getContainerInfo();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerDeployCallback(DeployCallback callback, String[] serverNames) throws RemoteException {
        try {
            int[] ids = this.getClusterIDs(serverNames);
            int localIndex = this.isLocalIncluded(ids);
            if (localIndex != -1) {
                this.eventSystem.addDeployCallback(callback);
            }
            DeployService remoteDeploy = null;
            P4ObjectBroker broker = P4ObjectBroker.init();
            ClusterElement cEment = null;
            int i = 0;
            while (i < ids.length) {
                if (i != localIndex) {
                    remoteDeploy = (DeployService)broker.narrow((Object)broker.stringToObject("clusteraloc:::" + ids[i] + "::/deploy"), class$com$sap$engine$services$deploy$DeployService == null ? DeployServiceImpl.class$("com.sap.engine.services.deploy.DeployService") : class$com$sap$engine$services$deploy$DeployService);
                    if (remoteDeploy == null) throw new RemoteException("P4Object broker return null while trying to access the Deploy Service on cluster id " + ids[i]);
                    cEment = this.sc.getClusterContext().getClusterMonitor().getParticipant(ids[i]);
                    if (this.sc == null || cEment == null) throw new RemoteException("Error while registering deploy callback on cluster id " + ids[i] + ", because it doesn't participate in the cluster.");
                    remoteDeploy.registerDeployCallback(callback, new String[]{cEment.getName()});
                }
                ++i;
            }
            return;
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (!(dex instanceof ServerDeploymentException)) throw new RemoteException("Error occurred while registering deploy callback. \nReason: " + dex.getStackTraceString());
            throw new RemoteException("Error occurred while registering deploy callback. \nReason: " + dex.getMessage());
        }
    }

    public void unregisterDeployCallback(DeployCallback callback, String[] serverNames) throws RemoteException {
        try {
            int[] ids = this.getClusterIDs(serverNames);
            int localIndex = this.isLocalIncluded(ids);
            if (localIndex != -1) {
                this.eventSystem.removeDeployCallback(callback);
            }
            DeployService remoteDeploy = null;
            P4ObjectBroker broker = P4ObjectBroker.init();
            ClusterElement cEment = null;
            int i = 0;
            while (i < ids.length) {
                if (i != localIndex) {
                    remoteDeploy = (DeployService)broker.narrow((Object)broker.stringToObject("clusteraloc:::" + ids[i] + "::/deploy"), class$com$sap$engine$services$deploy$DeployService == null ? DeployServiceImpl.class$("com.sap.engine.services.deploy.DeployService") : class$com$sap$engine$services$deploy$DeployService);
                    cEment = this.sc.getClusterContext().getClusterMonitor().getParticipant(ids[i]);
                    if (this.sc != null && cEment != null) {
                        remoteDeploy.unregisterDeployCallback(callback, new String[]{cEment.getName()});
                    }
                }
                ++i;
            }
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while unregistering deploy callback. \nReason: " + dex.getMessage());
            }
            throw new RemoteException("Error occurred while unregistering deploy callback. \nReason: " + dex.getStackTraceString());
        }
    }

    public DeployEventSystem getEventSystem() {
        return this.eventSystem;
    }

    public void startTransactionsLocal(DTransaction[] trans, boolean wait, boolean sendEvent, String whoCausedGroupOperation, String operation) throws DeploymentException {
        if (trans == null || trans.length == 0) {
            return;
        }
        FinishListener listener = null;
        listener = new FinishListener(trans, wait, sendEvent, this.eventSystem, operation);
        listener.setWhoCausedGroupOperation(whoCausedGroupOperation);
        listener.setTransactionManager(this.tManager);
        listener.setApplicationServiceContext(this.sc);
        listener.makeOperation();
    }

    public UserNode getTree() throws RemoteException {
        try {
            GroupContext userstore = ((SecurityContext)this.sc.getContainerContext().getObjectRegistry().getServiceInterface("security")).getUserStoreContext().getActiveUserStore().getGroupContext();
            GroupInfo root = userstore.getGroupInfo("root");
            if (root == null) {
                return null;
            }
            UserNode rootNode = new UserNode(root.getName(), 0, false);
            this.addChild(userstore, root, rootNode);
            return rootNode;
        }
        catch (Throwable t) {
            new ServerDeploymentException("deploy_5082", new String[]{"getting tree of users and groups."}, t).log();
            throw new RemoteException("Cannot return the structure of user and group node from the server in a UserNode structure.", t);
        }
    }

    private void addChild(GroupContext userstore, GroupInfo parent, UserNode node) {
        Iterator childIterator = null;
        UserNode childNode = null;
        String name = null;
        ArrayList<UserNode> list = new ArrayList<UserNode>();
        childIterator = userstore.getChildGroups(parent.getName());
        while (childIterator.hasNext()) {
            name = (String)childIterator.next();
            childNode = new UserNode(name, 0, false);
            childNode.setParents(new UserNode[]{node});
            list.add(childNode);
            this.addChild(userstore, userstore.getGroupInfo(name), childNode);
        }
        childIterator = userstore.getUsersOfGroup(parent.getName());
        while (childIterator.hasNext()) {
            name = (String)childIterator.next();
            childNode = new UserNode(name, 0, true);
            childNode.setParents(new UserNode[]{node});
            list.add(childNode);
        }
        UserNode[] children = new UserNode[list.size()];
        int i = 0;
        while (i < children.length) {
            children[i] = (UserNode)list.get(i);
            ++i;
        }
        node.setChildren(children);
    }

    public ReferenceResolver getReferenceResolver() {
        return this.resolver;
    }

    public void setExceptionInfo(String appName, ExceptionInfo exceptionInfo) {
        if (exceptionInfo != null) {
            this.exceptionInfos.put(appName, exceptionInfo);
        } else {
            this.exceptionInfos.remove(appName);
        }
    }

    public ExceptionInfo getExceptionInfo(String appName) {
        return (ExceptionInfo)this.exceptionInfos.get(appName);
    }

    public void startApplicationsLocal(String[] appNames, boolean wait, String whoCausedGroupOperation) throws DeploymentException {
        Vector<StartTransaction> trans = new Vector<StartTransaction>();
        if (appNames != null) {
            StartTransaction start = null;
            DeploymentInfo info = null;
            int i = 0;
            while (i < appNames.length) {
                info = this.getApplicationInfo(appNames[i]);
                if (info != null && info.getStatus() != 1) {
                    start = new StartTransaction(appNames[i], this);
                    start.setUnregister(true);
                    start.setLockType('S');
                    trans.add(start);
                }
                ++i;
            }
        }
        DTransaction[] sTrans = new StartTransaction[trans.size()];
        trans.toArray(sTrans);
        this.startTransactionsLocal(sTrans, wait, true, whoCausedGroupOperation, "startApp");
    }

    public String[] getApplicationsForContainer(String contName) throws DeploymentException {
        if (this.getContainer(contName) == null) {
            throw new ServerDeploymentException("deploy_5006", new String[]{contName, "get applications that have components, deployed on it"});
        }
        String[] res = new String[this.applications.size()];
        int c = 0;
        DeploymentInfo info = null;
        Enumeration enumeration = this.applications.elements();
        while (enumeration.hasMoreElements()) {
            info = (DeploymentInfo)((Object)enumeration.nextElement());
            if (info.getDeployedComponents(contName) == null) continue;
            res[c++] = info.getApplicationName();
        }
        String[] result = new String[c];
        System.arraycopy(res, 0, result, 0, c);
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startApplicationLocalAndWait(String appName) throws DeploymentException {
        this.shutdownCheck();
        externalConts = this.getExternalContainerNames();
        warnings = null;
        if (this.getApplicationInfo(appName) != null) {
            trans = new StartTransaction(appName, this);
            if (trans.needForTransaction() == false) return;
            trans.setUnregister(true);
            this.tManager.registerTransactionWithLock(trans, 'S', true);
            trans.makeAllPhasesLocalAndWait();
            return;
        }
        if (externalConts.length <= 0) return;
        try {
            try {
                this.tManager.lockApplication(appName, "startApp", 'S', true);
                cont = null;
                i = 0;
                while (i < externalConts.length) {
                    block36: {
                        block35: {
                            block33: {
                                block34: {
                                    cont = this.getContainer(externalConts[i]);
                                    if (cont == null) break block36;
                                    try {
                                        cont.prepareStart(appName, null);
                                        break block33;
                                    }
                                    catch (WarningException wex) {
                                        warnings = this.tManager.generateResultMessage(wex.getWarnings(), "Warning", this.clusterID, "startApp", appName);
                                        if (warnings == null) break block34;
                                        j = 0;
                                        if (true) ** GOTO lbl52
                                    }
                                    catch (OutOfMemoryError oofmer) {
                                        throw oofmer;
                                    }
                                    catch (ThreadDeath td) {
                                        throw td;
                                    }
                                    catch (Throwable thr) {
                                        try {
                                            cont.rollbackStart(appName);
                                            break block35;
                                        }
                                        catch (WarningException wex) {
                                            warnings = this.tManager.generateResultMessage(wex.getWarnings(), "Warning", this.clusterID, "startApp", appName);
                                            if (warnings == null) break block35;
                                            j = 0;
                                            if (true) ** GOTO lbl94
                                        }
                                        catch (OutOfMemoryError oofme) {
                                            throw oofme;
                                        }
                                        catch (ThreadDeath td) {
                                            throw td;
                                        }
                                        catch (Throwable th) {
                                            sdex = new ServerDeploymentException("deploy_5082", new String[]{"rollbacking start of application " + appName}, th);
                                            sdex.log();
                                            break block35;
                                        }
                                    }
                                    do {
                                        this.logWarning(warnings[j]);
                                        ++j;
lbl52:
                                        // 2 sources

                                    } while (j < warnings.length);
                                }
                                try {
                                    cont.commitStart(appName);
                                    break block33;
                                }
                                catch (WarningException wex1) {
                                    warnings = this.tManager.generateResultMessage(wex1.getWarnings(), "Warning", this.clusterID, "startApp", appName);
                                    if (warnings == null) break block33;
                                    j = 0;
                                    if (true) ** GOTO lbl73
                                }
                                catch (OutOfMemoryError oofme) {
                                    throw oofme;
                                }
                                catch (ThreadDeath td) {
                                    throw td;
                                }
                                catch (Throwable th) {
                                    sdex = new ServerDeploymentException("deploy_5082", new String[]{"committing start of application " + appName}, th);
                                    sdex.log();
                                    break block33;
                                }
                                do {
                                    this.logWarning(warnings[j]);
                                    ++j;
lbl73:
                                    // 2 sources

                                } while (j < warnings.length);
                            }
                            try {
                                cont.commitStart(appName);
                            }
                            catch (WarningException we) {
                                warnings = this.tManager.generateResultMessage(we.getWarnings(), "Warning", this.clusterID, "startApp", appName);
                                if (warnings == null) ** GOTO lbl103
                                j = 0;
                                if (true) ** GOTO lbl102
                            }
                            catch (OutOfMemoryError oofme) {
                                throw oofme;
                            }
                            catch (ThreadDeath td) {
                                throw td;
                            }
                            catch (Throwable th) {
                                sdex = new ServerDeploymentException("deploy_5082", new String[]{"committing start of application " + appName}, th);
                                sdex.log();
                            }
                            break block36;
                            do {
                                this.logWarning(warnings[j]);
                                ++j;
lbl94:
                                // 2 sources

                            } while (j < warnings.length);
                        }
                        if (thr instanceof DeploymentException) {
                            throw (DeploymentException)thr;
                        }
                        throw new ServerDeploymentException("deploy_5082", new String[]{"preparing start of application " + appName}, thr);
                        do {
                            this.logWarning(warnings[j]);
                            ++j;
lbl102:
                            // 2 sources

                        } while (j < warnings.length);
                    }
                    ++i;
                }
            }
            catch (DeploymentException dex) {
                throw dex;
            }
            catch (Error error) {
                error.printStackTrace();
                throw error;
            }
            catch (Exception ex) {
                throw new ServerDeploymentException("deploy_5082", new String[]{"starting local application " + appName}, ex);
            }
            var16_34 = null;
            this.tManager.unlockApplication(appName, "startApp", 'S');
            return;
        }
        catch (Throwable var15_36) {
            var16_35 = null;
            this.tManager.unlockApplication(appName, "startApp", 'S');
            throw var15_36;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopApplicationLocalAndWait(String appName, boolean implicit) throws DeploymentException {
        externalConts = this.getExternalContainerNames();
        warnings = null;
        if (this.getApplicationInfo(appName) != null) {
            trans = new StopTransaction(appName, this, implicit);
            if (trans.needForTransaction() == false) return;
            trans.setUnregister(true);
            this.tManager.registerTransactionWithLock(trans, 'S', true);
            trans.makeAllPhasesLocalAndWait();
            return;
        }
        if (externalConts.length <= 0) return;
        try {
            try {
                this.tManager.lockApplication(appName, "stopApp", 'S', true);
                cont = null;
                i = 0;
                while (i < externalConts.length) {
                    block36: {
                        block35: {
                            block33: {
                                block34: {
                                    cont = this.getContainer(externalConts[i]);
                                    if (cont == null) break block36;
                                    try {
                                        cont.prepareStop(appName, null);
                                        break block33;
                                    }
                                    catch (WarningException wex) {
                                        warnings = this.tManager.generateResultMessage(wex.getWarnings(), "Warning", this.clusterID, "stopApp", appName);
                                        if (warnings == null) break block34;
                                        j = 0;
                                        if (true) ** GOTO lbl51
                                    }
                                    catch (OutOfMemoryError oofmer) {
                                        throw oofmer;
                                    }
                                    catch (ThreadDeath td) {
                                        throw td;
                                    }
                                    catch (Throwable thr) {
                                        try {
                                            cont.rollbackStop(appName);
                                            break block35;
                                        }
                                        catch (WarningException wex) {
                                            warnings = this.tManager.generateResultMessage(wex.getWarnings(), "Warning", this.clusterID, "stopApp", appName);
                                            if (warnings == null) break block35;
                                            j = 0;
                                            if (true) ** GOTO lbl93
                                        }
                                        catch (OutOfMemoryError oofme) {
                                            throw oofme;
                                        }
                                        catch (ThreadDeath td) {
                                            throw td;
                                        }
                                        catch (Throwable th) {
                                            sdex = new ServerDeploymentException("deploy_5082", new String[]{"rollbacking stop of application " + appName}, th);
                                            sdex.log();
                                            break block35;
                                        }
                                    }
                                    do {
                                        this.logWarning(warnings[j]);
                                        ++j;
lbl51:
                                        // 2 sources

                                    } while (j < warnings.length);
                                }
                                try {
                                    cont.commitStop(appName);
                                    break block33;
                                }
                                catch (WarningException wex1) {
                                    warnings = this.tManager.generateResultMessage(wex1.getWarnings(), "Warning", this.clusterID, "stopApp", appName);
                                    if (warnings == null) break block33;
                                    j = 0;
                                    if (true) ** GOTO lbl72
                                }
                                catch (OutOfMemoryError oofme) {
                                    throw oofme;
                                }
                                catch (ThreadDeath td) {
                                    throw td;
                                }
                                catch (Throwable th) {
                                    sdex = new ServerDeploymentException("deploy_5082", new String[]{"committing stop of application " + appName}, th);
                                    sdex.log();
                                    break block33;
                                }
                                do {
                                    this.logWarning(warnings[j]);
                                    ++j;
lbl72:
                                    // 2 sources

                                } while (j < warnings.length);
                            }
                            try {
                                cont.commitStop(appName);
                            }
                            catch (WarningException we) {
                                warnings = this.tManager.generateResultMessage(we.getWarnings(), "Warning", this.clusterID, "stopApp", appName);
                                if (warnings == null) ** GOTO lbl102
                                j = 0;
                                if (true) ** GOTO lbl101
                            }
                            catch (OutOfMemoryError oofme) {
                                throw oofme;
                            }
                            catch (ThreadDeath td) {
                                throw td;
                            }
                            catch (Throwable th) {
                                sdex = new ServerDeploymentException("deploy_5082", new String[]{"committing stop of application " + appName}, th);
                                sdex.log();
                            }
                            break block36;
                            do {
                                this.logWarning(warnings[j]);
                                ++j;
lbl93:
                                // 2 sources

                            } while (j < warnings.length);
                        }
                        if (thr instanceof DeploymentException) {
                            throw (DeploymentException)thr;
                        }
                        throw new ServerDeploymentException("deploy_5082", new String[]{"preparing stop of application " + appName}, thr);
                        do {
                            this.logWarning(warnings[j]);
                            ++j;
lbl101:
                            // 2 sources

                        } while (j < warnings.length);
                    }
                    ++i;
                }
            }
            catch (DeploymentException dex) {
                throw dex;
            }
            catch (Error error) {
                error.printStackTrace();
                throw error;
            }
            catch (Exception ex) {
                throw new ServerDeploymentException("deploy_5082", new String[]{"stopping local application " + appName}, ex);
            }
            var17_35 = null;
            this.tManager.unlockApplication(appName, "stopApp", 'S');
            return;
        }
        catch (Throwable var16_37) {
            var17_36 = null;
            this.tManager.unlockApplication(appName, "stopApp", 'S');
            throw var16_37;
        }
    }

    public void startApplicationAndWait(String appName) throws RemoteException {
        this.startApplicationAndWait(appName, null);
    }

    public void startApplicationAndWait(String appName, String[] serverNames) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(appName, "start", "application");
        try {
            this.trace(200, "Starting application " + appName + " and wait.");
            this.startApplicationAndWait(appName, serverNames, true);
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while starting application " + appName + " and wait" + ". \nReason: " + dex.getMessage());
            }
            throw new RemoteException("Error occurred while starting application " + appName + " and wait" + ". \nReason: " + dex.getStackTraceString());
        }
    }

    public void stopApplicationAndWait(String appName) throws RemoteException {
        this.stopApplicationAndWait(appName, null);
    }

    public void stopApplicationAndWait(String appName, String[] serverNames) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(appName, "stop", "application");
        try {
            this.stopApplicationAndWait(appName, serverNames, true);
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while stopping application " + appName + " and wait" + ". \nReason: " + dex.getMessage());
            }
            throw new RemoteException("Error occurred while stopping application " + appName + " and wait" + ". \nReason: " + dex.getStackTraceString());
        }
    }

    public void startApplicationAndWait(String appName, String[] serverNames, boolean lock) throws DeploymentException, WarningException {
        this.shutdownCheck();
        StartTransaction trans = new StartTransaction(appName, this, this.getClusterIDs(serverNames));
        if (trans.needForTransaction()) {
            trans.setUnregister(lock);
            if (lock) {
                this.registerTransactionWithLock(trans);
            } else {
                this.registerTransactionWithoutLock(trans);
            }
            trans.makeAllPhasesAndWait();
            this.processWarningsAndErrors(trans);
        }
    }

    public void stopApplicationAndWait(String appName, String[] serverNames, boolean lock) throws DeploymentException, WarningException {
        this.shutdownCheck();
        StopTransaction trans = new StopTransaction(appName, this, this.getClusterIDs(serverNames), false);
        if (trans.needForTransaction()) {
            trans.setUnregister(lock);
            if (lock) {
                this.registerTransactionWithLock(trans);
            } else {
                this.registerTransactionWithoutLock(trans);
            }
            trans.makeAllPhasesAndWait();
            this.processWarningsAndErrors(trans);
        }
    }

    public void startApplicationLocal(String appName) throws DeploymentException {
        this.shutdownCheck();
        StartTransaction trans = new StartTransaction(appName, this);
        if (trans.needForTransaction()) {
            trans.setUnregister(true);
            this.tManager.registerTransactionWithLock(trans, 'S', false);
            trans.makeAllPhasesLocal();
        }
    }

    public void stopApplicationLocal(String appName) throws DeploymentException {
        this.shutdownCheck();
        StopTransaction trans = new StopTransaction(appName, this, false);
        if (trans.needForTransaction()) {
            trans.setUnregister(true);
            this.tManager.registerTransactionWithLock(trans, 'S', false);
            trans.makeAllPhasesLocal();
        }
    }

    public String getDeployProperty(String key) {
        if (this.serviceProperties != null && key != null) {
            return this.serviceProperties.getProperty(key);
        }
        return null;
    }

    public AdditionalAppInfo getAdditionalAppInfo(String appName) throws RemoteException {
        AdditionalAppInfo info = (AdditionalAppInfo)this.applications.get(appName);
        if (info == null) {
            throw new RemoteException("Application " + appName + " is not deployed on server " + this.clusterElementName);
        }
        AdditionalAppInfo addAppInfo = new AdditionalAppInfo();
        addAppInfo.setFailOverValue(info.getFailOverValue());
        return addAppInfo;
    }

    public void setAdditionalAppInfo(String appName, AdditionalAppInfo info) throws RemoteException {
        try {
            this.shutdownCheck();
            AddAppInfoChangeTransaction changeTransaction = new AddAppInfoChangeTransaction(appName, this, info);
            changeTransaction.setUnregister(true);
            this.makeGlobalTransaction(changeTransaction);
        }
        catch (DeploymentException dex) {
            dex.log();
            Throwable th = dex.getCause();
            if (th != null) {
                throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
            }
            if (dex instanceof ServerDeploymentException) {
                throw new RemoteException("Error occurred while setting additional application info of application " + appName + ". \nReason: " + dex.getMessage());
            }
            throw new RemoteException("Error occurred while setting additional application info of application " + appName + ". \nReason: " + dex.getMessage(), dex);
        }
    }

    public void makeReferences(String fromApplication, ReferenceObject[] references) throws RemoteException {
        block22: {
            if (!this.clusterAdapter.isAdministratorInRole()) {
                throw new RemoteException("Only Administrators have the right to perform this operation.");
            }
            this.compNameVerifier(fromApplication, "make reference(s) from", "application");
            if (references == null || references.length == 0) {
                return;
            }
            try {
                this.shutdownCheck();
                if (fromApplication.startsWith("service:")) {
                    throw new RemoteException("It is not allowed to change references of services after the service is deployed.");
                }
                if (fromApplication.startsWith("library:")) {
                    throw new RemoteException("It is not allowed to change references of libraries after the library is deployed.");
                }
                if (fromApplication.startsWith("interface:")) {
                    throw new RemoteException("It is not allowed to change references of interfaces after the interface is deployed.");
                }
                DeploymentInfo info = (DeploymentInfo)((Object)this.applications.get(fromApplication = this.getApplicationID(fromApplication)));
                if (info == null) {
                    ReferenceObject[] previousRefs = (ReferenceObject[])this.applicationReferences.get(fromApplication);
                    previousRefs = DUtils.concatReferences(previousRefs, references);
                    this.applicationReferences.put(fromApplication, previousRefs);
                    ConfigurationHandlerFactory factory = this.getApplicationServiceContext().getCoreContext().getConfigurationHandlerFactory();
                    ConfigurationHandler handler = null;
                    if (factory != null) {
                        try {
                            handler = factory.getConfigurationHandler();
                        }
                        catch (ConfigurationException ce) {
                            throw new ServerDeploymentException("deploy_5056", new String[]{"saving application references"}, ce);
                        }
                    }
                    if (handler == null) {
                        throw new ServerDeploymentException("deploy_5057", new String[]{"saving application references"});
                    }
                    try {
                        Configuration appRefsConfig = DUtils.getSubConfiguration(handler, "deploy", fromApplication.substring(0, fromApplication.indexOf("/")), fromApplication.substring(fromApplication.indexOf("/") + 1));
                        DUtils.setSerializedObject(appRefsConfig, "HASH_STR_STR:Reference_type", DUtils.decodeReferenceObjectArray(previousRefs), "of references.");
                    }
                    catch (ConfigurationException ce) {
                        this.logThrowable(ce);
                        throw new ServerDeploymentException("deploy_5094", new String[]{"making references from not deployed application"}, ce);
                    }
                    try {
                        handler.commit();
                        handler.closeAllConfigurations();
                    }
                    catch (ConfigurationException ce) {
                        new ServerDeploymentException("deploy_5082", new String[]{"making references for application " + fromApplication + ".\nReason: " + ce.toString()}, ce).log();
                    }
                    Hashtable<String, Object> table = new Hashtable<String, Object>();
                    table.put("command", "makeRefs");
                    table.put("application_name", fromApplication);
                    table.put("ref_objects", previousRefs);
                    this.remote.sendAndWait(table, this.remote.getServerIDs(), fromApplication);
                    break block22;
                }
                MakeReferencesTransaction transaction = new MakeReferencesTransaction(fromApplication, references, this);
                transaction.setUnregister(true);
                this.registerTransactionWithLock(transaction);
                try {
                    transaction.makeAllPhases();
                    Object var9_14 = null;
                    if (transaction.unregister()) {
                        this.unregisterTransactionWithLock(transaction.getModuleID());
                    }
                }
                catch (Throwable throwable) {
                    Object var9_15 = null;
                    if (transaction.unregister()) {
                        this.unregisterTransactionWithLock(transaction.getModuleID());
                    }
                    throw throwable;
                }
            }
            catch (DeploymentException dex) {
                dex.log();
                Throwable th = dex.getCause();
                if (th != null) {
                    throw new RemoteException(dex.getMessage() + ". \nReason: " + th.getMessage(), th);
                }
                if (dex instanceof ServerDeploymentException) {
                    throw new RemoteException("Error occurred while making references from application " + fromApplication + ". \nReason: " + dex.getMessage());
                }
                throw new RemoteException("Error occurred while making references from application " + fromApplication + ". \nReason: " + dex.getStackTraceString());
            }
        }
    }

    public void removeReferences(String fromApplication, ReferenceObject[] references) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(fromApplication, "remove reference(s) from", "application");
        String[] toLibraries = new String[references.length];
        int i = 0;
        while (i < references.length) {
            toLibraries[i] = references[i].toString();
            ++i;
        }
        this.removeReferences(fromApplication, toLibraries);
    }

    public void makeReferences(String providerName, String fromApplication, ReferenceObject[] references) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(fromApplication, "make reference(s) from", "application");
        this.makeReferences(this.getInternalAppID(providerName, fromApplication), references);
    }

    public void removeReferences(String providerName, String fromApplication, ReferenceObject[] references) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(fromApplication, "remove reference(s) from", "application");
        this.removeReferences(this.getInternalAppID(providerName, fromApplication), references);
    }

    public String getApplicationStatus(String providerName, String applicationName, String serverName) throws RemoteException {
        this.compNameVerifier(applicationName, "get-application-status of", "application");
        return this.getApplicationStatus(this.getInternalAppID(providerName, applicationName), serverName);
    }

    public SerializableFile getClientJar(String providerName, String applicationName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(applicationName, "get-client-jar of", "application");
        return this.getClientJar(this.getInternalAppID(providerName, applicationName));
    }

    public ExportInfo[] getCurrentStatus(String providerName, String applicationName) throws RemoteException {
        this.compNameVerifier(applicationName, "get-current-status of", "application");
        return this.getCurrentStatus(this.getInternalAppID(providerName, applicationName));
    }

    public String[] listElements(String containerName, String providerName, String applicationName, String[] serverNames) throws RemoteException {
        return this.listElements(containerName, this.getInternalAppID(providerName, applicationName), serverNames);
    }

    public void remove(String providerName, String applicationName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(applicationName, "remove", "application");
        this.remove(this.getInternalAppID(providerName, applicationName));
    }

    public void removeLibrary(String providerName, String libName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(libName, "remove", "library");
        this.removeLibrary(this.getInternalLibID(providerName, libName));
    }

    public void singleFileUpdate(FileUpdateInfo[] files, String providerName, String appName, Properties props) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(appName, "single-file-update", "application");
        this.singleFileUpdate(files, this.getInternalAppID(providerName, appName), props);
    }

    public void stopApplication(String providerName, String applicationName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(applicationName, "stop", "application");
        this.stopApplication(this.getInternalAppID(providerName, applicationName));
    }

    public void stopApplication(String providerName, String applicationName, String[] serverNames) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(applicationName, "stop", "application");
        this.stopApplication(this.getInternalAppID(providerName, applicationName), serverNames);
    }

    public void startApplication(String providerName, String applicationName) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(applicationName, "start", "application");
        this.startApplication(this.getInternalAppID(providerName, applicationName));
    }

    public void startApplication(String providerName, String applicationName, String[] serverNames) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(applicationName, "start", "application");
        this.startApplication(this.getInternalAppID(providerName, applicationName), serverNames);
    }

    private String getInternalAppID(String providerName, String applicationName) {
        if (providerName == null) {
            providerName = "sap.com";
        }
        applicationName = DUtils.replaceForbiddenSymbols(applicationName);
        return providerName + "/" + applicationName;
    }

    private String getInternalLibID(String providerName, String libName) {
        providerName = providerName == null || providerName.equals("engine.sap.com") || providerName.equals("sap.com") ? "" : providerName + "~";
        return providerName + libName.replace('/', '~');
    }

    private String[] getDeployedComponents(String containerName, DeploymentInfo info) {
        ContainerInfo contInfo = null;
        if (info == null) {
            return null;
        }
        if (containerName == null) {
            String[] components = null;
            String[] containerNames = info.getContainerNames();
            if (containerNames != null) {
                int i = 0;
                while (i < containerNames.length) {
                    contInfo = this.getContainerInfo(containerNames[i]);
                    components = contInfo != null ? DUtils.concatArrays(components, DUtils.addToElements(info.getDeployedComponents(containerNames[i]), "- " + (contInfo.isJ2EEContainer() ? contInfo.getJ2EEModuleName() : contInfo.getModuleName()))) : DUtils.concatArrays(components, DUtils.addToElements(info.getDeployedComponents(containerNames[i]), "- deployed in unavailable container " + containerNames[i] + " on " + this.clusterElementName));
                    ++i;
                }
            }
            return components;
        }
        contInfo = this.getContainerInfo(containerName);
        if (contInfo != null) {
            return DUtils.addToElements(info.getDeployedComponents(containerName), "- " + (contInfo.isJ2EEContainer() ? contInfo.getJ2EEModuleName() : contInfo.getModuleName()));
        }
        return DUtils.addToElements(info.getDeployedComponents(containerName), "- deployed in unavailable container " + containerName + " on " + this.clusterElementName);
    }

    public void addReferenceInternally(String fromApplicationName, ReferenceObject ref) {
        DeploymentInfo info = this.getApplicationInfo(fromApplicationName);
        if (ref == null) {
            return;
        }
        if (info != null) {
            info.addReference(ref);
            this.addReferenceInternallyFrom(info, ref);
        }
    }

    public void addReferenceInternally(DeploymentInfo info, ReferenceObject ref) {
        if (ref == null) {
            return;
        }
        if (info != null) {
            info.addReference(ref);
            this.addReferenceInternallyFrom(info, ref);
        }
    }

    private void addReferenceInternallyFrom(DeploymentInfo from, ReferenceObject ref) {
        DeploymentInfo to;
        if (from == null || ref == null) {
            return;
        }
        if ("application".equals(ref.getReferenceTargetType()) && (to = this.getApplicationInfo(ref.toString())) != null) {
            ReferenceObject fromRef = new ReferenceObject(from.getApplicationName(), ref.getReferenceType());
            fromRef.setReferenceTargetType("application");
            to.addReferenceFrom(fromRef);
        }
    }

    private String addReferenceInternallyFrom(DeploymentInfo from, String encodedResource) {
        DeploymentInfo to;
        String resType;
        if (from == null || encodedResource == null) {
            return null;
        }
        String resName = DUtils.decodeResourceName(encodedResource);
        if (this.resolver.doesApplicationContainComponent(from, resName, resType = DUtils.decodeResourceType(encodedResource))) {
            return null;
        }
        String toApp = this.resolver.getApplicationForComponent(resName, resType);
        if (toApp == null) {
            return null;
        }
        String resRefType = DUtils.decodeResourceReferenceType(encodedResource);
        String refType = "weak";
        if (resRefType != null && (resRefType.equals("weak") || resRefType.equals("hard"))) {
            refType = resRefType;
        }
        if ((to = this.getApplicationInfo(toApp)) != null) {
            ReferenceObject fromRef = new ReferenceObject(from.getApplicationName(), refType);
            fromRef.setReferenceTargetType("application");
            to.addReferenceFrom(fromRef);
            from.addAppContainingNecessaryResources(toApp);
        }
        return toApp;
    }

    public void addReferenceInternallyFrom(String appID, ReferenceObject ref) {
        DeploymentInfo to;
        if (appID == null || ref == null) {
            return;
        }
        if ("application".equals(ref.getReferenceTargetType()) && (to = this.getApplicationInfo(ref.toString())) != null) {
            ReferenceObject fromRef = new ReferenceObject(appID, ref.getReferenceType());
            fromRef.setReferenceTargetType("application");
            to.addReferenceFrom(fromRef);
        }
    }

    public DeploymentInfo getApplicationInfoWithLoader(String appName) {
        DeploymentInfo to = this.getApplicationInfo(appName);
        if (to != null) {
            return to;
        }
        Enumeration apps = this.applications.elements();
        while (apps.hasMoreElements()) {
            to = (DeploymentInfo)((Object)apps.nextElement());
            if (to.getLoaderName() == null || !to.getLoaderName().equals(appName)) continue;
            return to;
        }
        return null;
    }

    public void removeReferencesInternally(String fromApplicationName, String[] refs) {
        DeploymentInfo info = this.getApplicationInfo(fromApplicationName);
        if (refs == null) {
            return;
        }
        if (info != null) {
            info.removeReferences(refs);
            DeploymentInfo temp = null;
            int i = 0;
            while (i < refs.length) {
                if (!(refs[i].startsWith("library:") || refs[i].startsWith("service:") || refs[i].startsWith("interface:") || (temp = this.getApplicationInfo(refs[i].toString())) == null)) {
                    temp.removeReferencesFrom(new String[]{info.getApplicationName()});
                    this.addRootApplication(temp);
                }
                ++i;
            }
        }
    }

    public String[] fillDeploymentInfo(DeploymentInfo deployment, String fromContainer, ApplicationDeployInfo tempInfo) throws DeploymentException {
        String[] components = null;
        ArrayList<String> warnings = new ArrayList<String>();
        if (tempInfo != null) {
            components = tempInfo.getDeployedComponentNames();
        }
        String appName = deployment.getApplicationName();
        if (tempInfo != null && components != null && components.length > 0) {
            deployment.addDeployedComponents(fromContainer, components);
            deployment.setLoaderName(tempInfo.getLoaderName());
            Properties resRefs = tempInfo.getResourceReferences();
            if (resRefs != null) {
                Enumeration<?> resources = resRefs.propertyNames();
                String resource = null;
                while (resources.hasMoreElements()) {
                    resource = (String)resources.nextElement();
                }
            }
            if (tempInfo.getWarnings() != null) {
                String[] w = new String[tempInfo.getWarnings().size()];
                tempInfo.getWarnings().toArray(w);
                int i = 0;
                while (i < w.length) {
                    warnings.add(w[i]);
                    ++i;
                }
            }
            if (tempInfo.getReferences() != null) {
                ReferenceObjectIntf[] containerRefs = tempInfo.getReferences();
                ReferenceObject temp = null;
                int i = 0;
                while (i < containerRefs.length) {
                    temp = new ReferenceObject();
                    temp.setReferenceProviderName(containerRefs[i].getReferenceProviderName());
                    temp.setReferenceTarget(containerRefs[i].getReferenceTarget());
                    temp.setReferenceTargetType(containerRefs[i].getReferenceTargetType());
                    temp.setReferenceType(containerRefs[i].getReferenceType());
                    this.addReferenceInternally(appName, temp);
                    ++i;
                }
            }
            deployment.addContainerFilesForClassLoader(tempInfo.getFilesForClassloader());
        }
        String[] warns = new String[warnings.size()];
        warnings.toArray(warns);
        return warns;
    }

    public ApplicationInformation getApplicationInformation(String applicationName) throws RemoteException {
        this.compNameVerifier(applicationName, "get-application-information of", "application");
        DeploymentInfo info = this.getApplicationInfo(applicationName);
        if (info == null) {
            throw new RemoteException("Application " + applicationName + " is not deployed.");
        }
        ApplicationInformation appInfo = new ApplicationInformation();
        appInfo.setLoaderName(info.getLoaderName() == null ? applicationName : info.getLoaderName());
        appInfo.setStandAloneModule(info.isStandAloneArchive());
        appInfo.setSapManifestCfgPath(info.getSAPManifestConfiguration());
        appInfo.setApplicationConfigurationPath(info.getApplicationConfigurationPath());
        appInfo.setContainerNames(info.getContainerNames());
        appInfo.setDeployedFileNames(info.getDeployedFileNames());
        appInfo.setAliases(DUtils.getAliases(info));
        return appInfo;
    }

    public void stopApplication(String appName, Properties props) throws RemoteException {
        if (!this.clusterAdapter.isAdministratorInRole()) {
            throw new RemoteException("Only Administrators have the right to perform this operation.");
        }
        this.compNameVerifier(appName, "stop", "application");
    }

    public void startApplication(String applicationName, Properties props) throws RemoteException {
        this.startOrStopApplication(applicationName, props, null, true);
    }

    public void registerAsExternalContainer(String contName) {
        if (contName == null) {
            return;
        }
        if (!this.externalContainers.contains(contName)) {
            this.externalContainers.add(contName);
        }
    }

    public void unregisterAsExternalContainer(String contName) {
        if (contName == null) {
            return;
        }
        if (this.externalContainers.contains(contName)) {
            this.externalContainers.remove(contName);
        }
    }

    public String[] getExternalContainerNames() {
        String[] res = new String[this.externalContainers.size()];
        this.externalContainers.toArray(res);
        return res;
    }

    public String[] getAppsReferencedComponent(String component) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration apps = this.applications.elements();
        DeploymentInfo info = null;
        ReferenceObject[] refs = null;
        block0: while (apps.hasMoreElements()) {
            info = (DeploymentInfo)((Object)apps.nextElement());
            refs = info.getReferences();
            if (refs == null) continue;
            int i = 0;
            while (i < refs.length) {
                if (refs[i].toString().equals(component)) {
                    list.add(info.getApplicationName());
                    continue block0;
                }
                ++i;
            }
        }
        String[] res = new String[list.size()];
        list.toArray(res);
        return res;
    }

    public long getAppArchiveSize(String applicationName) throws RemoteException {
        DeploymentInfo deploymentInfo = this.getApplicationInfo(applicationName);
        if (deploymentInfo != null) {
            return deploymentInfo.getAppArchiveSize();
        }
        throw new RemoteException("The application " + applicationName + " is not deployed.");
    }

    public long getDeploymentDuration(String applicationName) throws RemoteException {
        DeploymentInfo deploymentInfo = this.getApplicationInfo(applicationName);
        if (deploymentInfo != null) {
            return deploymentInfo.getDeploymentDuration();
        }
        throw new RemoteException("The application " + applicationName + " is not deployed.");
    }

    public int getNumberOfRedeploys(String applicationName) throws RemoteException {
        DeploymentInfo deploymentInfo = this.getApplicationInfo(applicationName);
        if (deploymentInfo != null) {
            return deploymentInfo.getNumberOfRedeploys();
        }
        throw new RemoteException("The application " + applicationName + " is not deployed.");
    }

    public String getTimeOfLastRedeployment(String applicationName) throws RemoteException {
        DeploymentInfo deploymentInfo = this.getApplicationInfo(applicationName);
        if (deploymentInfo != null) {
            return deploymentInfo.getTimeOfLastRedeployment() != null ? deploymentInfo.getTimeOfLastRedeployment() : "0";
        }
        throw new RemoteException("The application " + applicationName + " is not deployed.");
    }

    public void startAppModification(String app) throws LockException {
        if (app != null) {
            try {
                this.lock.getAdministrativeLocking().lock(this.deployOwner, DEPLOY_AREA, app, 'E', 120000);
            }
            catch (TechnicalLockException tlex) {
                new ServerDeploymentException("deploy_5082", new String[]{"making modification of application " + app + ".\nReason: " + tlex.toString()}, tlex).log();
            }
            catch (IllegalArgumentException iaex) {
                ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"making modification of application " + app}, iaex);
                sdex.log();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appModificationDone(String app) {
        if (app == null) return;
        try {
            this.lock.getAdministrativeLocking().unlock(this.deployOwner, DEPLOY_AREA, app, 'E', false);
            if (this.sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getState() != 3) return;
        }
        catch (TechnicalLockException tlex) {
            new ServerDeploymentException("deploy_5082", new String[]{"finishing modification of application " + app + ".\nReason: " + tlex.toString()}, tlex).log();
            return;
        }
        catch (IllegalArgumentException iaex) {
            ServerDeploymentException sdex = new ServerDeploymentException("deploy_5082", new String[]{"finishing modification of application " + app}, iaex);
            sdex.log();
        }
    }

    private void compNameVerifier(String compName, String operation, String componentType) throws RemoteException {
        if (compName == null) {
            String temp = componentType != null && (componentType.startsWith("a") || componentType.startsWith("i")) ? " an " : " a ";
            throw new RemoteException("You are trying to " + operation + temp + componentType + " with name " + compName + ", which is not legal.");
        }
    }

    private void nullVerifier(Object obj, String action) throws RemoteException {
        if (obj == null) {
            throw new RemoteException("You are trying to " + action + " null, which is not legal.");
        }
    }

    private void processWarningsAndErrors(DTransaction transaction) throws WarningException {
        if (!this.throwWarnings) {
            return;
        }
        String[][] result = this.getWarningsAndErrors(transaction);
        if (result != null && result.length == 2 && result[0] != null && result[0].length != 0 || result[1] != null && result[1].length != 0) {
            WarningException wex = new WarningException();
            wex.setWarning(DUtils.concatArrays(result[0], result[1]));
            throw wex;
        }
    }

    public TransactionStatistics[] listApplicationAndStatusesInCluster(String containerName, String[] serverNames) throws RemoteException {
        TransactionStatistics stat = null;
        int index = DUtils.findElement(this.clusterElementName, serverNames);
        if (index != -1) {
            stat = new TransactionStatistics(this.getClusterID());
            Hashtable<String, String> res = new Hashtable<String, String>();
            String[] apps = this.listApplications(containerName);
            if (apps != null) {
                String status = null;
                int i = 0;
                while (i < apps.length) {
                    try {
                        status = this.getApplicationStatus(apps[i]);
                    }
                    catch (RemoteException rex) {
                        status = "NOT DEPLOYED";
                    }
                    res.put(apps[i], status);
                    ++i;
                }
            }
            stat.setHashAnswer(res);
        }
        ArrayList<String> temp = new ArrayList<String>();
        int i = 0;
        while (i < serverNames.length) {
            if (index != i) {
                temp.add(serverNames[i]);
            }
            ++i;
        }
        serverNames = new String[temp.size()];
        temp.toArray(serverNames);
        TransactionStatistics[] resStatistics = null;
        try {
            int[] restClusterIDs = this.getClusterIDs(serverNames);
            if (restClusterIDs != null && restClusterIDs.length != 0) {
                TransactionStatistics[] statistics = this.remote.listApplicationsAndStatusesRemotely(containerName, restClusterIDs);
                if (statistics != null) {
                    if (stat != null) {
                        resStatistics = new TransactionStatistics[statistics.length + 1];
                        System.arraycopy(statistics, 0, resStatistics, 0, statistics.length);
                        resStatistics[statistics.length] = stat;
                    } else {
                        resStatistics = statistics;
                    }
                } else if (stat != null) {
                    resStatistics = new TransactionStatistics[]{stat};
                }
            } else if (stat != null) {
                resStatistics = new TransactionStatistics[]{stat};
            }
        }
        catch (DeploymentException dex) {
            throw new RemoteException("Error occurred while listing all applications and their statuses in cluster.", dex);
        }
        return resStatistics;
    }

    public Hashtable listApplicationAndStatuses(int clusterID) {
        String[] apps;
        Hashtable<String, String> res = new Hashtable<String, String>();
        if (clusterID == this.getClusterID() && (apps = this.listApplications()) != null) {
            String status = null;
            int i = 0;
            while (i < apps.length) {
                try {
                    status = this.getApplicationStatus(apps[i]);
                }
                catch (RemoteException rex) {
                    status = "NOT DEPLOYED";
                }
                res.put(apps[i], status);
                ++i;
            }
        }
        return res;
    }

    public Resource getReasonForImplicitStopped(String appName) throws RemoteException {
        this.compNameVerifier(appName, "get-application-status of", "application");
        appName = this.getApplicationID(appName);
        return this.resolver.getReasonForImplicitStopped(appName);
    }

    private String[] evaluateReferences(String fromApp, ReferenceObject[] existing, String[] forRemove) {
        String[] res = null;
        ArrayList<ReferenceObject> list = new ArrayList<ReferenceObject>();
        boolean[] isFound = new boolean[forRemove.length];
        int i = 0;
        while (i < isFound.length) {
            isFound[i] = false;
            ++i;
        }
        boolean found = false;
        int i2 = 0;
        while (i2 < existing.length) {
            found = false;
            int j = 0;
            while (j < forRemove.length) {
                if (existing[i2].toString().equals(forRemove[j])) {
                    isFound[j] = true;
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                list.add(existing[i2]);
            }
            ++i2;
        }
        ArrayList<String> warnings = new ArrayList<String>();
        int i3 = 0;
        while (i3 < isFound.length) {
            if (!isFound[i3]) {
                warnings.add("Reference from " + fromApp + " to " + forRemove[i3] + " doesn't exist.");
            }
            ++i3;
        }
        existing = new ReferenceObject[list.size()];
        list.toArray(existing);
        if (existing.length == 0) {
            this.applicationReferences.remove(fromApp);
        } else {
            this.applicationReferences.put(fromApp, existing);
        }
        res = new String[warnings.size()];
        warnings.toArray(res);
        return res;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getModuleEntries(String applicationName, String container, String module) throws RemoteException {
        block16: {
            if (!this.clusterAdapter.isAdministratorInRole()) {
                throw new RemoteException("Only Administrators have the right to perform this operation.");
            }
            this.compNameVerifier(applicationName, "get-modul-entries of", "application");
            if (container == null) throw new RemoteException("Please specify correct container name.");
            if (container.trim().equals("")) {
                throw new RemoteException("Please specify correct container name.");
            }
            if (module == null) throw new RemoteException("Please specify correct module name.");
            if (module.trim().equals("")) {
                throw new RemoteException("Please specify correct module name.");
            }
            applicationName = this.getApplicationID(applicationName);
            handler = null;
            try {
                factory = this.getApplicationServiceContext().getCoreContext().getConfigurationHandlerFactory();
                if (factory != null) {
                    try {
                        handler = factory.getConfigurationHandler();
                    }
                    catch (ConfigurationException ce) {
                        throw new RemoteException("Cannot get configuration handler in action geting module entries.", ce);
                    }
                }
                if (handler == null) break block16;
                appConfig = null;
                configPath = "apps/" + applicationName;
                try {
                    appConfig = handler.openConfiguration(configPath, 0);
                }
                catch (ConfigurationException ce) {
                    throw new RemoteException("Cannot open configuration " + configPath + " for READ access.", ce);
                }
                if (appConfig == null) break block16;
                try {
                    ce = this.getModuleEntries(appConfig, module);
                    var10_12 = null;
                }
                catch (ConfigurationException ce) {
                    throw new RemoteException("Cannot search the configuration " + appConfig.getPath() + " for module with name " + module + ".", ce);
                }
            }
            catch (Throwable var9_18) {
                var10_14 = null;
                try {
                    if (handler == null) throw var9_18;
                    handler.commit();
                    handler.closeAllConfigurations();
                    throw var9_18;
                }
                catch (ConfigurationException ce) {
                    new ServerDeploymentException("deploy_5082", new String[]{"getting module entries.\nReason: " + ce.toString()}, ce).log();
                }
                throw var9_18;
            }
            ** try [egrp 4[TRYBLOCK] [4 : 314->336)] { 
lbl49:
            // 1 sources

            if (handler == null) return ce;
            handler.commit();
            handler.closeAllConfigurations();
            return ce;
lbl53:
            // 1 sources

            catch (ConfigurationException ce) {
                new ServerDeploymentException("deploy_5082", new String[]{"getting module entries.\nReason: " + ce.toString()}, ce).log();
            }
            return ce;
        }
        var10_13 = null;
        try {}
        catch (ConfigurationException ce) {
            new ServerDeploymentException("deploy_5082", new String[]{"getting module entries.\nReason: " + ce.toString()}, ce).log();
            return null;
        }
        if (handler == null) return null;
        handler.commit();
        handler.closeAllConfigurations();
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getModuleEntries(Configuration config, String module) throws ConfigurationException {
        block15: {
            block14: {
                fileNames = config.getAllFileEntryNames();
                index = DUtils.findElement(module, fileNames);
                if (index == -1) break block15;
                list = new ArrayList<String>();
                zis = null;
                try {
                    zis = new ZipInputStream(config.getFile(fileNames[index]));
                    if (zis != null) {
                        entry = null;
                        while ((entry = zis.getNextEntry()) != null && entry.getName() != null) {
                            if (entry.getName().endsWith("/") || entry.getName().endsWith("\\")) continue;
                            list.add(entry.getName());
                        }
                    }
                    var9_12 = null;
                    if (zis == null) break block14;
                    ** GOTO lbl40
                }
                catch (IOException ioe) {
                    zis = null;
                    var9_13 = null;
                    if (zis != null) {
                        try {
                            zis.close();
                        }
                        catch (IOException ioe) {
                            zis = null;
                        }
                    }
                    break block14;
                }
                {
                    catch (Throwable var8_18) {
                        var9_14 = null;
                        if (zis == null) throw var8_18;
                        ** try [egrp 2[TRYBLOCK] [2 : 162->170)] { 
lbl35:
                        // 1 sources

                        zis.close();
                        throw var8_18;
lbl37:
                        // 1 sources

                        catch (IOException ioe) {
                            zis = null;
                        }
                        throw var8_18;
                    }
lbl40:
                    // 1 sources

                    ** try [egrp 2[TRYBLOCK] [2 : 162->170)] { 
lbl41:
                    // 1 sources

                    zis.close();
lbl43:
                    // 1 sources

                    catch (IOException ioe) {}
                    zis = null;
                }
            }
            entries = new String[list.size()];
            list.toArray(entries);
            return entries;
        }
        allSubConfigs = config.getAllSubConfigurationNames();
        result = null;
        i = 0;
        while (true) {
            if (i >= allSubConfigs.length) {
                return null;
            }
            result = this.getModuleEntries(config.getSubConfiguration(allSubConfigs[i]), module);
            if (result != null) {
                return result;
            }
            ++i;
        }
    }

    public void setInitiallyNotStartedApps(String[] initiallyNotStartedApps) {
        this.initially_not_started_apps = initiallyNotStartedApps;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

