/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.container.ApplicationContainerContext;
import com.sap.engine.frame.container.registry.ObjectRegistry;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.lib.security.domain.ProtectionDomainFactory;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.ContainerWrapper;
import com.sap.engine.services.deploy.server.DeployRuntimeControlImpl;
import com.sap.engine.services.deploy.server.DeployServiceImpl;
import com.sap.engine.services.deploy.server.ObjectSerializer;
import com.sap.engine.services.deploy.server.RemoteCaller;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.StringTokenizer;

public class DeployServiceFrame
implements MessageListener,
ApplicationServiceFrame {
    private DeployServiceImpl deploy = null;
    private RemoteCaller remote = null;
    private ApplicationServiceContext sdc = null;
    private String serviceDir = ".";
    private ObjectSerializer osr = new ObjectSerializer();
    private int commandId = -1;
    private String appWorkDir = null;
    public static final String APPS_FOLDER = "Applications_Folder";
    public static final String STANDARD_APP_REFS = "StandardApplicationReferences";
    public static final String INITIAL_APPS = "InitialDeployedApplications";
    public static final String START_APP_TIMEOUT = "timeout_startApps_of_container";
    public static final String STRICT_J2EE_CHECKS = "Strict_J2EE_Checks";
    public static final String CLEAR_AFTER_FAILURE = "Clear_After_Failure";
    public static final String ADDITIONAL_DEBUG_INFO = "Additional_Debug_Info";
    public static final String INITIALLY_NOT_STARTED_APPS = "Initially_Not_Started_Apps";

    public void start(ApplicationServiceContext sdc) throws ServiceException {
        this.sdc = sdc;
        ObjectRegistry clCtx = sdc.getContainerContext().getObjectRegistry();
        try {
            this.deploy = new DeployServiceImpl(sdc, sdc.getServiceState().getProperties());
        }
        catch (RemoteException re) {
            throw new ServiceException("Could not initialize Remote part of the Deploy Service.", (Throwable)re);
        }
        this.serviceDir = sdc.getServiceState().getWorkingDirectoryName();
        this.deploy.setRootDirectory(this.serviceDir);
        this.appWorkDir = "." + File.separator + "apps";
        if (sdc.getServiceState().getProperties().getProperty(APPS_FOLDER) != null) {
            this.appWorkDir = sdc.getServiceState().getProperties().getProperty(APPS_FOLDER);
        }
        try {
            ProtectionDomainFactory.setAppsDir((String)this.appWorkDir);
        }
        catch (IOException e) {
            throw new ServiceException("Could not set " + this.appWorkDir + " into protection domain factory.", (Throwable)e);
        }
        this.deploy.initLocal(this.appWorkDir);
        this.deploy.setClearAfterFailure(this.getClearAfterFailure(sdc));
        ContainerWrapper.doWork = this.getDebug(sdc);
        boolean strictJ2EEChecks = this.getStrictJ2EEChecks(sdc);
        this.deploy.setStrictJ2EEChecks(strictJ2EEChecks);
        this.deploy.setInitiallyNotStartedApps(this.getInitiallyNotStartedApps(sdc.getServiceState().getProperties()));
        this.remote = this.deploy.getRemoteCaller();
        sdc.getContainerContext().getObjectRegistry().registerInterface((Object)this.deploy);
        try {
            sdc.getContainerContext().getObjectRegistry().registerInterfaceProvider("container", (Object)this.deploy);
        }
        catch (Exception e) {
            throw new ServiceException("Could not register provider for interface container.", (Throwable)e);
        }
        try {
            this.deploy.initializeApplications();
        }
        catch (DeploymentException rex) {
            rex.log();
        }
        try {
            sdc.getClusterContext().getMessageContext().registerListener((MessageListener)this);
        }
        catch (Exception e) {
            throw new ServiceException("Can not register message listener.", (Throwable)e);
        }
        try {
            ApplicationContainerContext appCtx = sdc.getContainerContext();
            sdc.getServiceState().registerManagementInterface((ManagementInterface)new DeployRuntimeControlImpl(this.deploy, clCtx));
        }
        catch (Exception e) {
            throw new ServiceException("Can not register management interface.", (Throwable)e);
        }
    }

    private String[] getInitiallyNotStartedApps(Properties props) {
        String value = props.getProperty(INITIALLY_NOT_STARTED_APPS);
        String[] result = null;
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ";");
            result = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                result[i++] = tokenizer.nextToken();
            }
        }
        return result;
    }

    private boolean getDeployProperty(ApplicationServiceContext asc, String propertyName, boolean defaultValue) {
        boolean res = defaultValue;
        String value = asc.getServiceState().getProperty(propertyName);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                res = true;
            } else if (value.equalsIgnoreCase("false")) {
                res = false;
            }
        }
        return res;
    }

    private boolean getStrictJ2EEChecks(ApplicationServiceContext asc) {
        return this.getDeployProperty(asc, STRICT_J2EE_CHECKS, false);
    }

    private boolean getClearAfterFailure(ApplicationServiceContext asc) {
        return this.getDeployProperty(asc, CLEAR_AFTER_FAILURE, true);
    }

    private boolean getDebug(ApplicationServiceContext asc) {
        return this.getDeployProperty(asc, ADDITIONAL_DEBUG_INFO, false);
    }

    public void receive(int serverId, int messageId, byte[] message, int offset, int length) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Object theObject = null;
            try {
                theObject = DeployServiceFrame.getObject(message, offset, length);
            }
            catch (Exception ex) {
                new ServerDeploymentException("deploy_5030", new String[]{"Cannot get Object from message: " + message + " with offset " + offset + " and length " + length}, ex).log();
            }
            this.remote.received(theObject, serverId);
            Object var10_9 = null;
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            Thread.currentThread().setContextClassLoader(loader);
            throw throwable;
        }
    }

    public static Object getObject(byte[] obj, int offset, int length) throws Exception {
        if (obj == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(obj, offset, length);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object object = null;
        try {
            object = ois.readObject();
            ois.close();
        }
        catch (Exception ex) {
            ois.close();
            throw ex;
        }
        return object;
    }

    public MessageAnswer receiveWait(int serverId, int messageId, byte[] message, int offset, int length) {
        MessageAnswer answ = new MessageAnswer();
        answ.setMessage(new byte[0]);
        answ.setOffset(0);
        answ.setLength(0);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Object theObject = null;
            byte[] bytes = null;
            try {
                theObject = ObjectSerializer.getObject(message, offset, length);
            }
            catch (Exception ex) {
                new ServerDeploymentException("deploy_5030", new String[]{"Cannot get Object from message: " + message + " with offset " + offset + " and length " + length}, ex).log();
            }
            answ = new MessageAnswer();
            bytes = this.remote.received(theObject, serverId);
            if (bytes != null) {
                answ.setMessage(bytes);
                answ.setOffset(0);
                answ.setLength(bytes.length);
            }
            Object var12_11 = null;
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            Thread.currentThread().setContextClassLoader(loader);
            throw throwable;
        }
        return answ;
    }

    public void stop() {
        this.sdc.getClusterContext().getMessageContext().unregisterListener();
        this.sdc.getContainerContext().getObjectRegistry().unregisterInterface();
        this.sdc.getServiceState().unregisterManagementInterface();
        this.sdc.getContainerContext().getObjectRegistry().unregisterInterfaceProvider("container");
        this.deploy.unregister();
    }

    public boolean changeProperties(Properties properties) throws IllegalArgumentException {
        String value;
        String appFol = properties.getProperty(APPS_FOLDER);
        if (appFol != null && appFol.equals(this.appWorkDir)) {
            try {
                ProtectionDomainFactory.setAppsDir((String)appFol);
                this.appWorkDir = appFol;
                return false;
            }
            catch (IOException e) {
                new ServerDeploymentException("deploy_5030", new String[]{"Cannot set applications folder " + appFol + " into com.sap.engine.lib.security.domain.ProtectionDomainFactory."}, e).log();
            }
        }
        if ((value = this.sdc.getServiceState().getProperty(STRICT_J2EE_CHECKS)) != null && this.deploy != null) {
            this.deploy.setStrictJ2EEChecks(this.getStrictJ2EEChecks(this.sdc));
            return true;
        }
        return false;
    }

    public String getName() {
        return "deploy";
    }
}

