/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

import com.sap.engine.frame.container.registry.ObjectRegistry;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.adminadapter.interfaces.ConvenienceEngineAdministrator;
import com.sap.engine.services.adminadapter.interfaces.RemoteAdminInterface;
import com.sap.engine.services.deploy.ApplicationInformation;
import com.sap.engine.services.deploy.DeployCallback;
import com.sap.engine.services.deploy.DeployRuntimeControlInterface;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.server.DeployServiceImpl;
import com.sap.engine.services.file.FileTransfer;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.rmi.PortableRemoteObject;

public class DeployRuntimeControlImpl
extends PortableRemoteObject
implements DeployRuntimeControlInterface,
Serializable {
    static final long serialVersionUID = -3188329315399290981L;
    public static String[] selected = null;
    String[] serverNames = null;
    String[] clusterNames = null;
    String[] serviceNames = null;
    String[] clusterTypes = null;
    DeployServiceImpl deployService = null;
    ObjectRegistry ctx = null;

    public DeployRuntimeControlImpl(DeployServiceImpl ds, ObjectRegistry ctx) throws RemoteException {
        this.deployService = ds;
        this.ctx = ctx;
    }

    public String[] getClusterNames() throws RemoteException {
        String[] result = new String[]{};
        try {
            result = this.getClElementsByType(new byte[]{2, 1});
        }
        catch (Exception e) {
            throw new RemoteException("Error: " + e.toString());
        }
        return result;
    }

    public String[] getServerNames() throws RemoteException {
        String[] result = new String[]{};
        try {
            result = this.getClElementsByType(new byte[]{2});
        }
        catch (Exception e) {
            throw new RemoteException("Error: " + e.toString());
        }
        return result;
    }

    public String getServerName() {
        return this.deployService.clusterElementName;
    }

    public String[] getContainers(String serverName) throws RemoteException {
        if (serverName == null) {
            return this.deployService.listContainers(null);
        }
        return this.deployService.listContainers(new String[]{serverName});
    }

    public String[] getContainersSupportingSingleFileUpdate(String serverName) throws RemoteException {
        String[] allContainers = this.getContainers(serverName);
        if (allContainers != null) {
            ArrayList<String> containersSupportingSingleFileUpdate = new ArrayList<String>();
            int i = 0;
            while (i < allContainers.length) {
                if (this.deployService.getContainerInfo(allContainers[i], serverName).isSupportingSingleFileUpdate()) {
                    containersSupportingSingleFileUpdate.add(allContainers[i]);
                }
                ++i;
            }
            allContainers = new String[containersSupportingSingleFileUpdate.size()];
            containersSupportingSingleFileUpdate.toArray(allContainers);
        }
        return allContainers;
    }

    public String[] listApplications(String containerName, String serverName) throws RemoteException {
        String[] stringArray;
        if (serverName == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = serverName;
        }
        return this.deployService.listApplications(containerName, stringArray);
    }

    public String[] listElements(String containerName, String applicationName, String serverNames) throws RemoteException {
        String[] stringArray;
        if (serverNames == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = serverNames;
        }
        return this.deployService.listElements(containerName, applicationName, stringArray);
    }

    public String[] getSelected() throws RemoteException {
        return selected;
    }

    public String[] getSupport() throws RemoteException {
        return this.deployService.getSupports();
    }

    public String[] deploy(String earName, String[] serverNames, String[] remoteSupport, byte j2ee_version, boolean isOneInstPerPK, boolean isUpdate) throws RemoteException {
        Properties props = new Properties();
        ((Hashtable)props).put("specification", "J2EE_1_3");
        ((Hashtable)props).put("root_lookup", "false");
        if (isOneInstPerPK) {
            ((Hashtable)props).put("container_type", "A");
        } else {
            ((Hashtable)props).put("container_type", "B");
        }
        if (isUpdate) {
            return this.deployService.update(earName, props);
        }
        return this.deployService.deploy(earName, remoteSupport, props);
    }

    public void remove(String applicationName, String[] containerNames, String[] serverNames) throws RemoteException {
        this.deployService.remove(applicationName);
    }

    public SerializableFile getClientJar(String containerName, String application, String[] serverNames) throws RemoteException {
        return this.deployService.getClientJar(application);
    }

    public FileTransfer getFileTransferer() throws RemoteException {
        FileTransfer transfer = null;
        transfer = (FileTransfer)this.ctx.getServiceInterface("file");
        return transfer;
    }

    public void stopApplication(String applicationName) throws RemoteException {
        this.deployService.stopApplication(applicationName);
    }

    public void startApplication(String applicationName) throws RemoteException {
        this.deployService.startApplication(applicationName);
    }

    public void stopApplication(String applicationName, String[] serverNames) throws RemoteException {
        this.deployService.stopApplication(applicationName, serverNames);
    }

    public void startApplication(String applicationName, String[] serverNames) throws RemoteException {
        this.deployService.startApplication(applicationName, serverNames);
    }

    public String getApplicationStatus(String applicationName) throws RemoteException {
        return this.deployService.getApplicationStatus(applicationName);
    }

    public String getApplicationStatus(String applicationName, String serverName) throws RemoteException {
        return this.deployService.getApplicationStatus(applicationName, serverName);
    }

    public void deployLibrary(String libName, String[] jars) throws RemoteException {
    }

    public void updateLibrary(String libName, String[] jars) throws RemoteException {
    }

    public void removeLibrary(String libName) throws RemoteException {
        this.deployService.removeLibrary(libName);
    }

    public void makeReferences(String fromApplication, String[] toLibraries) throws RemoteException {
        this.deployService.makeReferences(fromApplication, toLibraries);
    }

    public void removeReferences(String fromApplication, String[] toLibraries) throws RemoteException {
        this.deployService.removeReferences(fromApplication, toLibraries);
    }

    public Hashtable getServerLibraries() throws RemoteException {
        return this.deployService.getServerLibraries();
    }

    public String[] getServerReferences() throws RemoteException {
        return this.deployService.getServerReferences();
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    public void registerDeployCallback(DeployCallback callback, String[] serverNames) throws RemoteException {
        this.deployService.registerDeployCallback(callback, serverNames);
    }

    public void unregisterDeployCallback(DeployCallback callback, String[] serverNames) throws RemoteException {
        this.deployService.unregisterDeployCallback(callback, serverNames);
    }

    public AdditionalAppInfo getAdditionalAppInfo(String app) throws RemoteException {
        return this.deployService.getAdditionalAppInfo(app);
    }

    public void setAdditionalAppInfo(String app, AdditionalAppInfo addAppInfo) throws RemoteException {
        this.deployService.setAdditionalAppInfo(app, addAppInfo);
    }

    private String[] getClElementsByType(byte[] type) throws Exception {
        RemoteAdminInterface admin = (RemoteAdminInterface)this.ctx.getServiceInterface("adminadapter");
        ConvenienceEngineAdministrator convenienceAdministrator = admin.getConvenienceEngineAdministrator();
        int[] clNodesIDs = convenienceAdministrator.getClusterNodeIds();
        String[] result = new String[]{};
        String[] temp = null;
        int i = 0;
        while (i < clNodesIDs.length) {
            int i1 = 0;
            while (i1 < type.length) {
                if (convenienceAdministrator.getClusterNodeType(clNodesIDs[i]) == type[i1]) {
                    temp = new String[result.length + 1];
                    System.arraycopy(result, 0, temp, 0, result.length);
                    temp[result.length] = convenienceAdministrator.getClusterNodeName(clNodesIDs[i]);
                    result = temp;
                }
                ++i1;
            }
            ++i;
        }
        return result;
    }

    public String[] listApplications() throws RemoteException {
        return this.listApplications(null);
    }

    public String[] listApplications(String containerName) throws RemoteException {
        return this.listApplications(containerName, null);
    }

    public String[] listElements(String containerName, String applicationName) throws RemoteException {
        return this.listElements(containerName, applicationName, null);
    }

    public boolean isApplicationStarted(String applicationName) throws RemoteException {
        return "STARTED".equals(this.getApplicationStatus(applicationName));
    }

    public String[] getServerReferences(String applicationName) throws RemoteException {
        String[] allServerRefs = this.getServerReferences();
        Vector<String> appRefs = new Vector<String>();
        if (allServerRefs != null) {
            int i = 0;
            while (i < allServerRefs.length) {
                if (allServerRefs[i].startsWith(applicationName)) {
                    appRefs.add(allServerRefs[i].substring(applicationName.length() + 1));
                }
                ++i;
            }
        }
        Object[] temp = new String[appRefs.size()];
        appRefs.copyInto(temp);
        return temp;
    }

    public void singleFileUpdate(FileUpdateInfo[] files, String appName, Properties props) throws RemoteException {
        this.deployService.singleFileUpdate(files, appName, props);
    }

    public void singleFileUpdate(FileUpdateInfo[] files, String providerName, String appName, Properties props) throws RemoteException {
        this.deployService.singleFileUpdate(files, providerName, appName, props);
    }

    public long getAppArchiveSize(String providerName, String applicationName) throws RemoteException {
        return this.deployService.getAppArchiveSize(providerName + "/" + applicationName);
    }

    public long getDeploymentDuration(String providerName, String applicationName) throws RemoteException {
        return this.deployService.getDeploymentDuration(providerName + "/" + applicationName);
    }

    public int getNumberOfRedeploys(String providerName, String applicationName) throws RemoteException {
        return this.deployService.getNumberOfRedeploys(providerName + "/" + applicationName);
    }

    public String getTimeOfLastRedeployment(String providerName, String applicationName) throws RemoteException {
        return this.deployService.getTimeOfLastRedeployment(providerName + "/" + applicationName);
    }

    public ApplicationInformation getApplicationInformation(String applicationName) throws RemoteException {
        return this.deployService.getApplicationInformation(applicationName);
    }

    public String[] getModuleEntries(String applicationName, String container, String module) throws RemoteException {
        return this.deployService.getModuleEntries(applicationName, container, module);
    }

    public String[][] listApplicationsAs2Parts() throws RemoteException {
        String[] apps = this.listApplications();
        String[][] res = null;
        if (apps != null) {
            res = new String[apps.length][];
            int i = 0;
            while (i < apps.length) {
                res[i] = this.getProviderAndComponent(apps[i]);
                ++i;
            }
        }
        return res;
    }

    private String[] getProviderAndComponent(String appName) {
        if (appName == null) {
            return null;
        }
        String[] res = new String[2];
        if (appName.indexOf("/") != -1) {
            res[0] = appName.substring(0, appName.indexOf("/"));
            if (appName.indexOf("/") != appName.length() - 1) {
                res[1] = appName.substring(appName.indexOf("/") + 1);
            }
        } else {
            res[0] = "sap.com";
            res[1] = appName;
        }
        return res;
    }

    public String[][] getApplicationsInfo() throws RemoteException {
        String[] applications = this.listApplications();
        int numberOfApps = applications.length;
        String[][] appsInfo = new String[numberOfApps][6];
        int i = 0;
        while (i < numberOfApps) {
            String appName;
            appsInfo[i][0] = appName = applications[i];
            appsInfo[i][1] = this.deployService.getAppArchiveSize(appName) + "";
            appsInfo[i][2] = this.deployService.getDeploymentDuration(appName) + "";
            appsInfo[i][3] = this.deployService.getNumberOfRedeploys(appName) + "";
            appsInfo[i][4] = this.deployService.getTimeOfLastRedeployment(appName);
            appsInfo[i][5] = this.deployService.getApplicationStatus(appName);
            ++i;
        }
        return appsInfo;
    }
}

