/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

import com.sap.engine.services.deploy.DeployCallback;
import com.sap.engine.services.deploy.DeployEvent;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ProgressEvent;
import com.sap.engine.services.deploy.container.ProgressListener;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DeployServiceImpl;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.rmi_p4.P4ConnectionException;

public class DeployEventSystem
implements ProgressListener {
    private DeployCallback[] callbacks = new DeployCallback[0];
    private String serverName = null;
    private DeployServiceImpl deploy = null;

    public DeployEventSystem(String serverName, DeployServiceImpl deploy) {
        this.serverName = serverName;
        this.deploy = deploy;
    }

    public synchronized void addDeployCallback(DeployCallback callback) {
        if (callback == null) {
            return;
        }
        if (this.found(callback) != -1) {
            return;
        }
        DeployCallback[] temp = new DeployCallback[this.callbacks.length + 1];
        System.arraycopy(this.callbacks, 0, temp, 0, this.callbacks.length);
        temp[this.callbacks.length] = callback;
        this.callbacks = temp;
    }

    private int found(DeployCallback l) {
        int j = this.callbacks.length - 1;
        while (j >= 0) {
            if (l.equals(this.callbacks[j])) {
                return j;
            }
            --j;
        }
        return -1;
    }

    public synchronized void removeDeployCallback(DeployCallback callback) {
        int index = this.found(callback);
        if (index == -1) {
            return;
        }
        DeployCallback[] temp = new DeployCallback[this.callbacks.length - 1];
        System.arraycopy(this.callbacks, 0, temp, 0, index);
        if (index != this.callbacks.length - 1) {
            System.arraycopy(this.callbacks, index + 1, temp, index, this.callbacks.length - index - 1);
        }
        this.callbacks = temp;
    }

    public void fireDeployEvent(String compName, byte componentType, byte phase, String action, String serverID, String msg, String[] errors, String[] warnings) throws DeploymentException {
        byte actionType = this.defineActionType(action);
        DeployEvent event = new DeployEvent(compName, phase, actionType, serverID);
        event.setMessage(msg);
        event.setErrors(errors);
        event.setWarnings(warnings);
        this.fireDeployEvent(event, componentType);
    }

    public byte defineActionType(String action) {
        int actionType = -1;
        if (action == null) {
            return (byte)actionType;
        }
        if (action.equals("deploy")) {
            actionType = 0;
        } else if (action.equals("deployLib")) {
            actionType = 1;
        } else if (action.equals("removeLib")) {
            actionType = 2;
        } else if (action.equals("deployLangLib")) {
            actionType = 3;
        } else if (action.equals("makeRefs")) {
            actionType = 4;
        } else if (action.equals("removeRefs")) {
            actionType = 5;
        } else if (action.equals("update")) {
            actionType = 6;
        } else if (action.equals("removeApp")) {
            actionType = 7;
        } else if (action.equals("stopApp")) {
            actionType = 8;
        } else if (action.equals("startApp")) {
            actionType = 9;
        } else if (action.equals("runtimeChanges")) {
            actionType = 10;
        } else if (action.equals("singleFileUpdate")) {
            actionType = 11;
        } else if (action.equals("appInfoChange")) {
            actionType = 12;
        } else if (action.equals("initialStartApplications")) {
            actionType = 13;
        }
        return (byte)actionType;
    }

    public void fireDeployEvent(DeployEvent event, byte componentType) throws DeploymentException {
        if (event == null) {
            return;
        }
        switch (componentType) {
            case 0: {
                byte status = -1;
                if (event.getComponentName() == null) break;
                DeploymentInfo info = this.deploy.getApplicationInfo(event.getComponentName());
                if (info == null) {
                    status = 2;
                } else {
                    status = this.convertAppStatus(info.getStatus());
                    event.setContainer_components(info.getDeployedComponents());
                }
                event.setStatus(status);
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                break;
            }
        }
        int i = this.callbacks.length - 1;
        while (i >= 0) {
            block24: {
                try {
                    switch (componentType) {
                        case 0: {
                            this.callbacks[i].processApplicationEvent(event);
                            break;
                        }
                        case 2: {
                            this.callbacks[i].processLibraryEvent(event);
                            break;
                        }
                        case 5: {
                            this.callbacks[i].processServiceEvent(event);
                            break;
                        }
                        case 4: {
                            this.callbacks[i].processInterfaceEvent(event);
                            break;
                        }
                        case 3: {
                            this.callbacks[i].processReferenceEvent(event);
                            break;
                        }
                        case 1: {
                            this.callbacks[i].processStandaloneModuleEvent(event);
                        }
                    }
                }
                catch (P4ConnectionException p4cex) {
                    if (!this.deploy.isMarkedForShutdown()) {
                        ServerDeploymentException sdex = new ServerDeploymentException("deploy_5099", new String[]{event.toString()}, p4cex);
                        sdex.log();
                    }
                    this.removeDeployCallback(this.callbacks[i]);
                }
                catch (Exception ex) {
                    if (!this.deploy.isMarkedForShutdown()) {
                        ServerDeploymentException sdex = new ServerDeploymentException("deploy_5099", new String[]{event.toString()}, ex);
                        sdex.log();
                    }
                }
                catch (OutOfMemoryError oofme) {
                    throw oofme;
                }
                catch (Throwable th) {
                    if (this.deploy.isMarkedForShutdown()) break block24;
                    ServerDeploymentException sdex = new ServerDeploymentException("deploy_5099", new String[]{event.toString()}, th);
                    sdex.log();
                }
            }
            --i;
        }
    }

    public void unregister() {
        int j = this.callbacks.length - 1;
        while (j >= 0) {
            this.callbacks[j].callbackLost(this.serverName);
            --j;
        }
    }

    public void serverAdded(String serverName) {
        int j = this.callbacks.length - 1;
        while (j >= 0) {
            this.callbacks[j].serverAdded(serverName);
            --j;
        }
    }

    public void handleProgressEvent(ProgressEvent event) {
        int i = this.callbacks.length - 1;
        while (i >= 0) {
            try {
                this.callbacks[i].processContainerEvent(event);
            }
            catch (Exception ex) {
                ServerDeploymentException sdex = new ServerDeploymentException("deploy_5099", new String[]{event.toString()}, ex);
                sdex.log();
            }
            --i;
        }
    }

    public String getServerName() {
        return this.deploy.getClusterIDName();
    }

    public byte convertAppStatus(byte status) {
        switch (status) {
            case 0: {
                return 1;
            }
            case 4: {
                return 5;
            }
            case 1: {
                return 0;
            }
            case 3: {
                return 4;
            }
            case 6: {
                return 3;
            }
            case 2: {
                return 6;
            }
        }
        return -1;
    }
}

