/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ApplicationInManualStartUpException;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExceptionInfo;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DTransaction;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeployServiceImpl;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.application.RuntimeTransaction;
import com.sap.engine.services.deploy.server.application.StopTransaction;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DeployCommunicatorImpl
implements DeployCommunicator {
    private DeployServiceImpl deploy = null;
    private ApplicationServiceContext asc = null;
    private String contName = null;
    private Hashtable runtimeHandlers = new Hashtable();
    private Hashtable runtimeConfigs = new Hashtable();
    private Vector lockedApps = new Vector();

    public DeployCommunicatorImpl(DeployServiceImpl deploy, ApplicationServiceContext asc, String containerName) {
        this.deploy = deploy;
        this.asc = asc;
        this.contName = containerName;
    }

    public byte getStatus(String applicationName) {
        try {
            String status = this.deploy.getApplicationStatus(applicationName);
            if (status.equals("STOPPED")) {
                return 0;
            }
            if (status.equals("STARTED")) {
                return 1;
            }
            if (status.equals("UPGRADING")) {
                return 2;
            }
            if (status.equals("STARTING")) {
                return 3;
            }
            if (status.equals("STOPPING")) {
                return 4;
            }
            if (status.equals("UNKNOWN")) {
                return 5;
            }
            if (status.equals("IMPLICIT_STOPPED")) {
                return 6;
            }
        }
        catch (RemoteException rex) {
            new ServerDeploymentException("deploy_5030", new String[]{"Cannot get the status of application " + applicationName}, rex).log();
            return 5;
        }
        return 5;
    }

    public ExceptionInfo getExceptionInfo(String applicationName) {
        return this.deploy.getExceptionInfo(applicationName);
    }

    public String[] getAppNamesWithReference(String toLoader) {
        LoadContext loadCtx = this.asc.getCoreContext().getLoadContext();
        String[] resApps = null;
        try {
            String[] apps = this.deploy.listApplications(null, null);
            String[] libs = null;
            if (apps != null) {
                Vector<String> res = new Vector<String>();
                int i = 0;
                while (i < apps.length) {
                    libs = loadCtx.getReferences(apps[i]);
                    if (libs != null) {
                        int j = 0;
                        while (j < libs.length) {
                            if (libs[j].equals(toLoader)) {
                                res.add(apps[i]);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                resApps = new String[res.size()];
                res.toArray(resApps);
            }
        }
        catch (RemoteException rex) {
            new ServerDeploymentException("deploy_5030", new String[]{"Cannot list applications."}, rex).log();
            return resApps;
        }
        return resApps;
    }

    public void stopMyApplications(String[] appNames) throws RemoteException {
        Vector<StopTransaction> trans = new Vector<StopTransaction>();
        if (appNames != null) {
            StopTransaction stop = null;
            DeploymentInfo info = null;
            int i = 0;
            while (i < appNames.length) {
                try {
                    info = this.deploy.getApplicationInfo(appNames[i]);
                    if (info != null && info.getStatus() != 0 && info.getStatus() != 6) {
                        stop = new StopTransaction(appNames[i], this.deploy, true);
                        stop.setUnregister(true);
                        stop.setLockType('S');
                        trans.add(stop);
                    }
                }
                catch (DeploymentException rex) {
                    rex.log();
                }
                ++i;
            }
        }
        DTransaction[] sTrans = new StopTransaction[trans.size()];
        trans.toArray(sTrans);
        try {
            this.deploy.startTransactionsLocal(sTrans, false, true, this.contName, "stopApp");
        }
        catch (DeploymentException dex) {
            dex.log();
            throw new RemoteException("Error occurred while starting locally applications of container " + this.contName, dex);
        }
    }

    public Configuration startRuntimeChanges(String applicationName, boolean lockApplication) throws DeploymentException {
        applicationName = this.deploy.getApplicationID(applicationName);
        if (lockApplication) {
            this.deploy.lockApplication(applicationName, "runtimeChanges");
            this.lockedApps.add(applicationName);
            this.deploy.logInfo("Container " + this.contName + " locked application " + applicationName + " for making runtime changes.");
        }
        ConfigurationHandlerFactory factory = this.deploy.getApplicationServiceContext().getCoreContext().getConfigurationHandlerFactory();
        ConfigurationHandler handler = null;
        Configuration config = null;
        if (factory != null) {
            try {
                handler = factory.getConfigurationHandler();
            }
            catch (ConfigurationException ce) {
                throw new ServerDeploymentException("deploy_5027", new String[]{"runtimeChanges", applicationName, ce.getMessage()}, ce);
            }
        }
        if (handler == null) {
            throw new ServerDeploymentException("deploy_5027", new String[]{"runtimeChanges", applicationName, ""});
        }
        try {
            config = handler.openConfiguration("apps/" + applicationName, 1);
        }
        catch (ConfigurationException ce) {
            try {
                handler.rollback();
            }
            catch (ConfigurationException cex) {
                this.deploy.logThrowable(cex);
            }
            throw new ServerDeploymentException("deploy_5011", new String[]{"apps/" + applicationName, applicationName, "runtimeChanges", ce.getMessage()}, ce);
        }
        this.runtimeConfigs.put(applicationName, config);
        this.runtimeHandlers.put(applicationName, handler);
        return config;
    }

    public Configuration startRuntimeChanges(String applicationName) throws DeploymentException {
        return this.startRuntimeChanges(applicationName, true);
    }

    public void makeRuntimeChanges(String applicationName, boolean needRestartApplication) throws RemoteException {
        block19: {
            applicationName = this.deploy.getApplicationID(applicationName);
            Configuration config = (Configuration)this.runtimeConfigs.get(applicationName);
            ConfigurationHandler handler = (ConfigurationHandler)this.runtimeHandlers.get(applicationName);
            RuntimeTransaction runtime = null;
            try {
                if (config == null) {
                    throw new RemoteException("Configuration apps/" + applicationName + " is closed!");
                }
                if (handler == null) {
                    throw new RemoteException("Handler for runtime changes with appslication " + applicationName + " is closed!");
                }
                try {
                    runtime = new RuntimeTransaction(applicationName, this.deploy, this.contName, handler, config, needRestartApplication);
                }
                catch (DeploymentException dex) {
                    try {
                        handler.rollback();
                        handler.closeAllConfigurations();
                    }
                    catch (ConfigurationException cex) {
                        this.deploy.logThrowable(cex);
                    }
                    throw new RemoteException("Error occurred while making runtime changes with application " + applicationName, dex);
                }
                try {
                    try {
                        this.deploy.registerTransactionWithoutLock(runtime);
                        runtime.makeAllPhases();
                    }
                    catch (DeploymentException dex) {
                        throw new RemoteException("Error occurred while making runtime changes with application " + applicationName, dex);
                    }
                    Object var9_9 = null;
                    this.deploy.unregisterTransactionWithoutLock(runtime.getModuleID());
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.deploy.unregisterTransactionWithoutLock(runtime.getModuleID());
                    throw throwable;
                }
                this.runtimeHandlers.remove(applicationName);
                this.runtimeConfigs.remove(applicationName);
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (this.deploy.lock != null && this.lockedApps.contains(applicationName)) {
                        this.lockedApps.remove(applicationName);
                        this.deploy.lock.getAdministrativeLocking().unlock(this.deploy.getDeployLockOwner(), "DEPLOY_LOCK_AREA", applicationName, 'X', false);
                        this.deploy.logInfo("Container " + this.contName + " unlocked application " + applicationName);
                    } else {
                        this.deploy.logError("Locking manager is not available - can not unlock application.");
                    }
                }
                catch (TechnicalLockException lex) {
                    this.deploy.logThrowable(lex);
                }
                throw throwable;
            }
            try {
                if (this.deploy.lock != null && this.lockedApps.contains(applicationName)) {
                    this.lockedApps.remove(applicationName);
                    this.deploy.lock.getAdministrativeLocking().unlock(this.deploy.getDeployLockOwner(), "DEPLOY_LOCK_AREA", applicationName, 'X', false);
                    this.deploy.logInfo("Container " + this.contName + " unlocked application " + applicationName);
                    break block19;
                }
                this.deploy.logError("Locking manager is not available - can not unlock application.");
            }
            catch (TechnicalLockException lex) {
                this.deploy.logThrowable(lex);
            }
        }
    }

    /*
     * Loose catch block
     */
    public void rollbackRuntimeChanges(String applicationName) throws RemoteException {
        block16: {
            ConfigurationHandler handler;
            block15: {
                applicationName = this.deploy.getApplicationID(applicationName);
                Configuration config = (Configuration)this.runtimeConfigs.get(applicationName);
                handler = (ConfigurationHandler)this.runtimeHandlers.get(applicationName);
                try {
                    if (config == null) {
                        throw new RemoteException("Configuration apps/" + applicationName + " is closed!");
                    }
                    if (handler == null) {
                        throw new RemoteException("Handler for runtime changes with appslication " + applicationName + " is closed!");
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        if (this.deploy.lock != null && this.lockedApps.contains(applicationName)) {
                            this.lockedApps.remove(applicationName);
                            this.deploy.lock.getAdministrativeLocking().unlock(this.deploy.getDeployLockOwner(), "DEPLOY_LOCK_AREA", applicationName, 'X', false);
                            this.deploy.logInfo("Container " + this.contName + " unlocked application " + applicationName);
                        } else {
                            this.deploy.logError("Locking manager is not available - can not unlock application.");
                        }
                    }
                    catch (TechnicalLockException lex) {
                        this.deploy.logThrowable(lex);
                    }
                    throw throwable;
                }
                try {
                    if (this.deploy.lock != null && this.lockedApps.contains(applicationName)) {
                        this.lockedApps.remove(applicationName);
                        this.deploy.lock.getAdministrativeLocking().unlock(this.deploy.getDeployLockOwner(), "DEPLOY_LOCK_AREA", applicationName, 'X', false);
                        this.deploy.logInfo("Container " + this.contName + " unlocked application " + applicationName);
                        break block15;
                    }
                    this.deploy.logError("Locking manager is not available - can not unlock application.");
                }
                catch (TechnicalLockException lex) {
                    this.deploy.logThrowable(lex);
                }
            }
            if (handler != null) {
                try {
                    handler.rollback();
                    handler.closeAllConfigurations();
                    Object var8_10 = null;
                    this.runtimeConfigs.remove(applicationName);
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    this.runtimeConfigs.remove(applicationName);
                    this.runtimeHandlers.remove(applicationName);
                    throw throwable;
                }
                this.runtimeHandlers.remove(applicationName);
                {
                    break block16;
                    catch (ConfigurationException ce) {
                        this.deploy.logThrowable(ce);
                        Object var8_11 = null;
                        this.runtimeConfigs.remove(applicationName);
                        this.runtimeHandlers.remove(applicationName);
                    }
                }
            }
        }
    }

    public String getMyWorkDirectory(String applicationName) throws IOException {
        return this.deploy.getContainerWorkDir(this.contName, applicationName);
    }

    public String[] getAllAliases() throws DeploymentException {
        String[] aliases = null;
        DeploymentInfo[] infoes = this.deploy.getAllDeploymentInfoes();
        if (infoes != null) {
            int i = 0;
            while (i < infoes.length) {
                if (infoes[i] != null) {
                    aliases = DUtils.concatArrays(aliases, DUtils.getAliases(infoes[i]));
                }
                ++i;
            }
            return aliases;
        }
        return new String[0];
    }

    public String[] getAliases(String appName) throws DeploymentException {
        DeploymentInfo info = this.deploy.getDeploymentInfo(appName = this.deploy.getApplicationID(appName));
        if (info == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{appName, " get its aliases"});
        }
        return DUtils.getAliases(info);
    }

    public String[] getDeployedApplications() {
        return this.deploy.listApplications();
    }

    public String getWarName(String alias) {
        if (alias == null) {
            return null;
        }
        DeploymentInfo[] infoes = this.deploy.getAllDeploymentInfoes();
        if (infoes != null) {
            Properties props = null;
            String a = null;
            String tempAlias = null;
            int i = 0;
            while (i < infoes.length) {
                props = infoes[i].getProperties();
                if (props != null) {
                    Enumeration<?> aliases = props.propertyNames();
                    while (aliases.hasMoreElements()) {
                        a = (String)aliases.nextElement();
                        if (!a.startsWith("web:") || !(tempAlias = a.substring("web:".length())).equals(alias)) continue;
                        return props.getProperty(a);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public String getAlias(String warName, String appName) {
        if (warName == null) {
            return null;
        }
        DeploymentInfo info = this.deploy.getApplicationInfo(appName);
        if (info != null) {
            Properties props = null;
            props = info.getProperties();
            if (props != null) {
                Enumeration<?> aliases = props.propertyNames();
                String a = null;
                while (aliases.hasMoreElements()) {
                    a = (String)aliases.nextElement();
                    if (!a.startsWith("web:") || !props.getProperty(a).equals(warName)) continue;
                    return a.substring("web:".length());
                }
            }
        }
        return null;
    }

    public void startMyApplications(String[] appNames) throws RemoteException {
        if (this.deploy.getApplicationServiceContext().getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 3 && appNames != null) {
            try {
                this.deploy.startApplicationsLocal(appNames, false, this.contName);
            }
            catch (DeploymentException dex) {
                throw new RemoteException("Error occurred while starting applications", dex);
            }
        }
    }

    public String[] getMyApplications() {
        String[] res = null;
        try {
            res = this.deploy.getApplicationsForContainer(this.contName);
            if (res == null) {
                res = new String[]{};
            }
        }
        catch (DeploymentException dex) {
            dex.log();
        }
        return res;
    }

    public boolean isStandAloneApplication(String appName) throws DeploymentException {
        DeploymentInfo info = this.deploy.getApplicationInfo(appName = this.deploy.getApplicationID(appName));
        if (info == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{appName, " check whether it is stand alone"});
        }
        return info.isStandAloneArchive();
    }

    public void startApplicationLocalAndWait(String appName) throws RemoteException {
        this.checkApplicationStartUpMode(appName);
        try {
            this.deploy.startApplicationLocalAndWait(appName);
        }
        catch (DeploymentException dex) {
            throw new RemoteException("Error occurred while starting application locally and wait.", dex);
        }
    }

    public void stopApplicationLocalAndWait(String appName) throws RemoteException {
        try {
            this.deploy.stopApplicationLocalAndWait(appName, false);
        }
        catch (DeploymentException dex) {
            throw new RemoteException("Error occurred while stopping application locally and wait.", dex);
        }
    }

    public void startApplicationAndWait(String appName) throws RemoteException {
        this.startApplicationAndWait(appName, null);
    }

    public void startApplicationAndWait(String appName, String[] serverNames) throws RemoteException {
        this.checkApplicationStartUpMode(appName);
        try {
            this.deploy.startApplicationAndWait(appName, serverNames, true);
        }
        catch (DeploymentException dex) {
            throw new RemoteException("Error occurred while starting application in whole cluster and wait.", dex);
        }
    }

    public void stopApplicationAndWait(String appName) throws RemoteException {
        this.stopApplicationAndWait(appName, null);
    }

    public void stopApplicationAndWait(String appName, String[] serverNames) throws RemoteException {
        try {
            this.deploy.stopApplicationAndWait(appName, serverNames, true);
        }
        catch (DeploymentException dex) {
            throw new RemoteException("Error occurred while stopping application in whole cluster and wait.", dex);
        }
    }

    public void startApplicationLocal(String appName) throws RemoteException {
        this.checkApplicationStartUpMode(appName);
        try {
            this.deploy.startApplicationLocal(appName);
        }
        catch (DeploymentException dex) {
            throw new RemoteException("Error occurred while starting application locally.", dex);
        }
    }

    public void stopApplicationLocal(String appName) throws RemoteException {
        try {
            this.deploy.stopApplicationLocal(appName);
        }
        catch (DeploymentException dex) {
            throw new RemoteException("Error occurred while stopping application locally.", dex);
        }
    }

    protected void checkApplicationStartUpMode(String appName) throws ApplicationInManualStartUpException {
        DeploymentInfo info = this.deploy.getApplicationInfo(appName);
        if (info != null && info.getStartUp() == 1) {
            throw new ApplicationInManualStartUpException(appName);
        }
    }

    public void startApplication(String appName) throws RemoteException {
        this.checkApplicationStartUpMode(appName);
        this.deploy.startApplication(appName);
    }

    public void stopApplication(String appName) throws RemoteException {
        this.deploy.stopApplication(appName);
    }

    public void addAloneComponent(String componentName, String resourceType, String loaderName) throws DeploymentException {
        this.deploy.getReferenceResolver().addAloneComponent(componentName, resourceType, loaderName);
    }

    public void removeAloneComponent(String componentName, String resourceType) throws DeploymentException {
        this.deploy.getReferenceResolver().removeAloneComponent(componentName, resourceType);
    }

    public void addNonPersistentApplicationInfo(String originalAppName, boolean isStandAloneApplication, ApplicationDeployInfo applicationInfo) throws DeploymentException {
        DeploymentInfo info = new DeploymentInfo();
        String appName = DUtils.getApplicationID(originalAppName);
        if (this.deploy.getApplicationInfo(appName) != null) {
            throw new ServerDeploymentException("deploy_5090", new String[]{originalAppName});
        }
        info.setApplicationName(appName);
        info.setStandAloneArchive(isStandAloneApplication);
        info.setContainerNames(new String[]{this.contName});
        this.deploy.addApplicationInfo(appName, info, false);
        try {
            String[] warnings = this.deploy.fillDeploymentInfo(info, this.contName, applicationInfo);
        }
        catch (DeploymentException dex) {
            this.deploy.removeApplicationInfo(appName);
            throw dex;
        }
    }

    public void removeNonPersistentApplicationInfo(String appName) throws DeploymentException {
        appName = DUtils.getApplicationID(appName);
    }

    public void registerAsExternalContainer() {
        this.deploy.registerAsExternalContainer(this.contName);
    }

    public void unregisterAsExternalContainer() {
        this.deploy.unregisterAsExternalContainer(this.contName);
    }

    public String[] getAppsReferencedComponent(String component) {
        return this.deploy.getAppsReferencedComponent(component);
    }

    public void addReference(String from, String to, String refType) {
        ReferenceObject ref = new ReferenceObject();
        ref.setCompositeName(to);
        if (refType != null && (refType.equals("hard") || refType.equals("weak"))) {
            ref.setReferenceType(refType);
        }
        ref.setReferenceTargetType("application");
        this.deploy.addReferenceInternallyFrom(from, ref);
    }

    public void setStartUpMode(String appName, int mode) throws RemoteException {
        DeploymentInfo dinfo = this.deploy.getDeploymentInfo(appName);
        if (dinfo == null) {
            throw new RemoteException("Application " + appName + " doesn't exist. Please use fully qualified name.");
        }
        dinfo.setStartUp(mode);
        this.deploy.setAdditionalAppInfo(appName, dinfo);
    }

    public int getStartUpMode(String appName) throws RemoteException {
        DeploymentInfo dinfo = this.deploy.getDeploymentInfo(appName);
        return dinfo.getStartUp();
    }

    public String[] getApplicationComponents(String appName) throws DeploymentException {
        DeploymentInfo info = this.deploy.getDeploymentInfo(appName);
        if (info == null) {
            throw new ServerDeploymentException("deploy_5005", new String[]{appName, " get its additional modules"});
        }
        return info.getDeployedComponents(this.contName);
    }

    public String getAppConfigPath(String appname) {
        return "apps/" + appname;
    }

    public void startModification(String application) throws LockException {
        this.deploy.startAppModification(application);
    }

    public void modificationDone(String application) {
        this.deploy.appModificationDone(application);
    }
}

