/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import com.sap.engine.services.deploy.server.ObjectSerializer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class DUtils {
    private static final char DELIMITER = '\n';

    public static void addArrayToVector(File[] files, Vector all) {
        if (all == null) {
            all = new Vector<File>();
        }
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i] != null && files[i].exists()) {
                    all.add(files[i]);
                }
                ++i;
            }
        }
    }

    public static void addArrayToVector(SerializableFile[] files, Vector all) {
        if (all == null) {
            all = new Vector<SerializableFile>();
        }
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i] != null && files[i].getBytes() != null) {
                    all.add(files[i]);
                }
                ++i;
            }
        }
    }

    public static void addArrayToVector(String[] names, Vector all) {
        if (all == null) {
            all = new Vector<String>();
        }
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                if (names[i] != null) {
                    all.add(names[i]);
                }
                ++i;
            }
        }
    }

    public static String[] concatArrays(String[] s1, String[] s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        if (s1 == null && s2 == null) {
            return null;
        }
        Vector<String> elements = new Vector<String>(s1.length + s2.length);
        int i = 0;
        while (i < s1.length) {
            if (s1[i] != null) {
                elements.add(s1[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < s2.length) {
            if (s2[i2] != null && !elements.contains(s2[i2])) {
                elements.add(s2[i2]);
            }
            ++i2;
        }
        if (elements.size() > 0) {
            Object[] concatination = new String[elements.size()];
            elements.copyInto(concatination);
            return concatination;
        }
        return null;
    }

    public static int[] concatArrays(int[] s1, int[] s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        if (s1 == null && s2 == null) {
            return null;
        }
        int[] temp = new int[s1.length + s2.length];
        int counter = 0;
        boolean found = false;
        int i = 0;
        while (i < s1.length) {
            found = false;
            int j = 0;
            while (j < counter) {
                if (s1[i] == temp[j]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                temp[counter++] = s1[i];
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < s2.length) {
            found = false;
            int j = 0;
            while (j < counter) {
                if (s2[i2] == temp[j]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                temp[counter++] = s2[i2];
            }
            ++i2;
        }
        int[] res = new int[counter];
        System.arraycopy(temp, 0, res, 0, counter);
        return res;
    }

    public static String[] addToElements(String[] s1, String additional) {
        if (s1 == null) {
            return null;
        }
        if (additional == null || additional.trim().equals("") || s1.length == 0) {
            return s1;
        }
        String[] enlarged = new String[s1.length];
        int i = 0;
        while (i < s1.length) {
            enlarged[i] = s1[i] + " " + additional;
            ++i;
        }
        return enlarged;
    }

    public static String[] addToElements(String additional, String[] s1) {
        if (s1 == null) {
            return null;
        }
        if (additional == null || additional.trim().equals("") || s1.length == 0) {
            return s1;
        }
        String[] enlarged = new String[s1.length];
        int i = 0;
        while (i < s1.length) {
            enlarged[i] = additional + " " + s1[i];
            ++i;
        }
        return enlarged;
    }

    public static Vector concatVectors(Vector v1, Vector v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        Vector res = new Vector(v1.size() + v2.size());
        int i = 0;
        while (i < v1.size()) {
            res.add(v1.elementAt(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < v2.size()) {
            res.add(v2.elementAt(i2));
            ++i2;
        }
        return res;
    }

    protected static Hashtable mergeHashtables(Hashtable h1, Hashtable h2) {
        if (h1 == null) {
            return h2;
        }
        if (h2 == null) {
            return h1;
        }
        Hashtable res = new Hashtable();
        Object key = null;
        Enumeration enumeration = h1.keys();
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement();
            res.put(key, h1.get(key));
        }
        enumeration = h2.keys();
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement();
            res.put(key, h2.get(key));
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public static SerializableFile mergeClientJars(SerializableFile[] all, String applicationName, String serviceRootDir) throws RemoteException {
        if (all == null || all.length == 0) {
            return null;
        }
        tempName = serviceRootDir + File.separator + "temp" + System.currentTimeMillis();
        file = null;
        fileResOut = null;
        zipOut = null;
        zipEntry = null;
        dir = new File(tempName);
        dir.mkdirs();
        resPath = dir + File.separator + "result" + File.separator + applicationName + "_client" + ".jar";
        resPath = resPath.replace('/', File.separatorChar);
        resultDir = new File(resPath.substring(0, resPath.lastIndexOf(File.separator)));
        resultDir.mkdirs();
        resultFile = new File(resPath);
        try {
            fileResOut = new FileOutputStream(resultFile);
            zipOut = new ZipOutputStream(fileResOut);
            zipOut.setMethod(0);
        }
        catch (FileNotFoundException mcjexc) {
            throw new RemoteException("Error occurred while merging client jars for application " + applicationName + ".\nReason: " + mcjexc.toString(), mcjexc);
        }
        zipFile = null;
        e = null;
        length = 0;
        in = null;
        buf = new byte[1024];
        i = 0;
        while (i < all.length) {
            block12: {
                if (all[i] == null || all[i].getBytes() == null) break block12;
                name = all[i].getFileName();
                file = new File(tempName + File.separator + name);
                try {
                    fileOut = new FileOutputStream(file);
                    fileOut.write(all[i].getBytes());
                    fileOut.flush();
                    fileOut.close();
                    zipFile = new ZipFile(file);
                    e = zipFile.entries();
                    while (e.hasMoreElements()) {
                        zipEntry = e.nextElement();
                        in = zipFile.getInputStream(zipEntry);
                        try {
                            zipOut.putNextEntry(zipEntry);
                            if (true) ** GOTO lbl53
                        }
                        catch (Exception deexc) {
                            zipOut.closeEntry();
                            in.close();
                            continue;
                        }
                        do {
                            zipOut.write(buf, 0, length);
lbl53:
                            // 2 sources

                        } while ((length = in.read(buf, 0, buf.length)) != -1);
                        zipOut.closeEntry();
                        in.close();
                    }
                    zipFile.close();
                }
                catch (IOException zfexc) {
                    throw new RemoteException("Error occurred while merging client jars for application " + applicationName + ".\nReason: " + zfexc.toString(), zfexc);
                }
            }
            ++i;
        }
        try {
            zipOut.close();
            fileResOut.close();
        }
        catch (IOException clsexc) {
            throw new RemoteException("Error occurred while merging client jars for application " + applicationName + ".\nReason: " + clsexc.toString(), clsexc);
        }
        ser = new SerializableFile(resultFile);
        FileUtils.deleteDirectory((File)dir);
        return ser;
    }

    public static ExportInfo[] concatInfos(ExportInfo[] infos1, ExportInfo[] infos2) {
        if (infos1 == null) {
            return infos2;
        }
        if (infos2 == null) {
            return infos1;
        }
        if (infos1 == null && infos2 == null) {
            return null;
        }
        Vector<ExportInfo> elements = new Vector<ExportInfo>(infos1.length + infos2.length);
        int i = 0;
        while (i < infos1.length) {
            if (infos1[i] != null) {
                elements.add(infos1[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < infos2.length) {
            if (infos2[i2] != null && !elements.contains(infos2[i2])) {
                elements.add(infos2[i2]);
            }
            ++i2;
        }
        if (elements.size() > 0) {
            Object[] concatenation = new ExportInfo[elements.size()];
            elements.copyInto(concatenation);
            return concatenation;
        }
        return null;
    }

    public static ContainerInterface[] addAsLastElement(ContainerInterface[] containers, ContainerInterface cont) {
        if (containers == null) {
            return new ContainerInterface[]{cont};
        }
        int i = 0;
        while (i < containers.length) {
            if (containers[i].getContainerInfo().getName().equals(cont.getContainerInfo().getName())) {
                return containers;
            }
            ++i;
        }
        ContainerInterface[] temp = new ContainerInterface[containers.length + 1];
        System.arraycopy(containers, 0, temp, 0, containers.length);
        temp[containers.length] = cont;
        return temp;
    }

    public static Properties[] addAsLastElement(Properties[] properties, Properties props) {
        if (properties == null) {
            return new Properties[]{props};
        }
        Properties[] temp = new Properties[properties.length + 1];
        System.arraycopy(properties, 0, temp, 0, properties.length);
        temp[properties.length] = props;
        return temp;
    }

    public static Hashtable[] addAsLastElement(Hashtable[] tables, Hashtable table) {
        if (tables == null) {
            return new Hashtable[]{table};
        }
        Hashtable[] temp = new Hashtable[tables.length + 1];
        System.arraycopy(tables, 0, temp, 0, tables.length);
        temp[tables.length] = table;
        return temp;
    }

    public static File[][] addAsLastElement(File[][] allFiles, File[] files) {
        if (allFiles == null) {
            File[][] temp = files == null ? new File[1][0] : new File[1][files.length];
            return temp;
        }
        File[][] temp = new File[allFiles.length + 1][];
        System.arraycopy(allFiles, 0, temp, 0, allFiles.length);
        temp[allFiles.length] = files;
        return temp;
    }

    public static File[] addFiles(File[] files1, File[] files2) {
        if (files1 == null) {
            return files2;
        }
        if (files2 == null) {
            return files1;
        }
        File[] temp = new File[files1.length + files2.length];
        System.arraycopy(files1, 0, temp, 0, files1.length);
        System.arraycopy(files2, 0, temp, files1.length, files2.length);
        return temp;
    }

    public static String[] getRealPaths(String parentDir, String[] dbFileNameEntries) {
        if (dbFileNameEntries == null) {
            return null;
        }
        String[] res = new String[dbFileNameEntries.length];
        parentDir = parentDir.replace('\\', '/');
        int i = 0;
        while (i < dbFileNameEntries.length) {
            res[i] = dbFileNameEntries[i].replace('\\', '/');
            res[i] = (parentDir + File.separator + res[i]).replace('/', File.separatorChar);
            ++i;
        }
        return res;
    }

    public static String[] removeElements(String[] from, String[] remove) {
        Object[] res = null;
        if (remove == null || remove.length == 0) {
            return from;
        }
        if (from == null) {
            return null;
        }
        Vector<String> refs = new Vector<String>();
        int i = 0;
        while (i < from.length) {
            refs.add(from[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < remove.length) {
            if (refs.contains(remove[i2])) {
                refs.remove(remove[i2]);
            }
            ++i2;
        }
        if (refs.size() > 0) {
            res = new String[refs.size()];
            refs.copyInto(res);
        }
        return res;
    }

    public static String[] deleteDirectory(File file) {
        FileUtils.deleteDirectory((File)file);
        File[] undeleted = file.listFiles();
        Vector<String> res = new Vector<String>();
        if (undeleted != null) {
            int i = 0;
            while (i < undeleted.length) {
                res.add("File " + undeleted[i].getPath() + " could not be deleted!");
                ++i;
            }
        }
        String[] logs = new String[res.size()];
        res.toArray(logs);
        return logs;
    }

    public static String parseReferencesInternal(String ref) {
        if (!(ref == null || ref.startsWith("interface:") || ref.startsWith("service:") || ref.startsWith("library:"))) {
            ref = "application:" + ref;
        }
        return ref;
    }

    public static String getApplicationID(String appName) {
        if (appName == null) {
            return null;
        }
        int index = appName.indexOf("/");
        if (index != -1 && index != 0) {
            String compName = appName.substring(index + 1);
            return appName.substring(0, index + 1) + DUtils.replaceForbiddenSymbols(compName);
        }
        return "sap.com/" + DUtils.replaceForbiddenSymbols(appName);
    }

    public static String replaceForbiddenSymbols(String compName) {
        compName = compName.replace('/', '~');
        compName = compName.replace('\\', '~');
        compName = compName.replace(':', '~');
        compName = compName.replace('*', '~');
        compName = compName.replace('?', '~');
        compName = compName.replace('\"', '~');
        compName = compName.replace('<', '~');
        compName = compName.replace('>', '~');
        if ((compName = compName.replace('|', '~')).endsWith(".")) {
            compName = compName.substring(0, compName.length() - 1) + "~";
        }
        return compName;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getDeserializedObject(Configuration appConfig, String fileName) throws ServerDeploymentException, ConfigurationException {
        block10: {
            block9: {
                iStream = null;
                try {
                    if (appConfig.existsFile(fileName)) {
                        iStream = appConfig.getFile(fileName);
                        try {
                            var3_3 = ObjectSerializer.getObject(iStream);
                            var6_6 = null;
                            break block9;
                        }
                        catch (Exception ex) {
                            sde = new ServerDeploymentException("deploy_5032", ex);
                            throw sde;
                        }
                    }
                    var3_5 = appConfig.getConfigEntry(fileName);
                    break block10;
                }
                catch (Throwable var5_16) {
                    var6_8 = null;
                    try {
                        if (iStream == null) throw var5_16;
                        iStream.close();
                        throw var5_16;
                    }
                    catch (IOException ioe) {
                        sde = new ServerDeploymentException("deploy_5082", new String[]{"closing a stream."}, ioe);
                        sde.log();
                        throw var5_16;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 69->80)] { 
lbl29:
            // 1 sources

            if (iStream == null) return var3_3;
            iStream.close();
            return var3_3;
lbl32:
            // 1 sources

            catch (IOException ioe) {
                sde = new ServerDeploymentException("deploy_5082", new String[]{"closing a stream."}, ioe);
                sde.log();
            }
            return var3_3;
        }
        var6_7 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 69->80)] { 
lbl39:
        // 1 sources

        if (iStream == null) return var3_5;
        iStream.close();
        return var3_5;
lbl42:
        // 1 sources

        catch (IOException ioe) {
            sde = new ServerDeploymentException("deploy_5082", new String[]{"closing a stream."}, ioe);
            sde.log();
        }
        return var3_5;
    }

    public static void setSerializedObject(Configuration config, String fileName, Object info, String errorMessage) throws ServerDeploymentException, ConfigurationException {
        ByteArrayInputStream baiStream = null;
        try {
            try {
                baiStream = new ByteArrayInputStream(ObjectSerializer.getByteArray(info));
            }
            catch (Exception ex) {
                throw new ServerDeploymentException("deploy_5031", new String[]{errorMessage}, ex);
            }
            config.updateFileAsStream(fileName, (InputStream)baiStream, true);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (baiStream != null) {
                    baiStream.close();
                }
            }
            catch (IOException ioe) {
                ServerDeploymentException sde = new ServerDeploymentException("deploy_5082", new String[]{"closing a stream."}, ioe);
                sde.log();
            }
            throw throwable;
        }
        try {
            if (baiStream != null) {
                baiStream.close();
            }
        }
        catch (IOException ioe) {
            ServerDeploymentException sde = new ServerDeploymentException("deploy_5082", new String[]{"closing a stream."}, ioe);
            sde.log();
        }
    }

    public static String[] decodeReferenceObjectArray(ReferenceObject[] refObjects) {
        String[] refStrings = null;
        if (refObjects != null) {
            refStrings = new String[refObjects.length];
            int i = 0;
            while (i < refObjects.length) {
                if (refObjects[i] != null) {
                    refStrings[i] = refObjects[i].decode();
                }
                ++i;
            }
        }
        return refStrings;
    }

    public static ReferenceObject[] encodeReferenceObjectArray(String[] refStrings) {
        ReferenceObject[] refObject = null;
        if (refStrings != null) {
            refObject = new ReferenceObject[refStrings.length];
            int i = 0;
            while (i < refStrings.length) {
                if (refStrings[i] != null) {
                    refObject[i] = ReferenceObject.encode(refStrings[i]);
                }
                ++i;
            }
        }
        return refObject;
    }

    public static ReferenceObject[] concatReferences(ReferenceObject[] oldRefs, ReferenceObject[] newRefs) {
        int j;
        if (oldRefs == null) {
            return newRefs;
        }
        if (newRefs == null) {
            return oldRefs;
        }
        ArrayList<ReferenceObject> concatedRefs = new ArrayList<ReferenceObject>();
        int i = 0;
        while (i < oldRefs.length) {
            if (oldRefs[i] != null) {
                j = 0;
                while (j < newRefs.length) {
                    if (newRefs[j] != null && !oldRefs[i].equalsSimple(newRefs[j]) && !DUtils.isAlreadyAdded(concatedRefs, oldRefs[i])) {
                        concatedRefs.add(oldRefs[i]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        j = 0;
        while (j < newRefs.length) {
            if (!DUtils.isAlreadyAdded(concatedRefs, newRefs[j])) {
                concatedRefs.add(newRefs[j]);
            }
            ++j;
        }
        ReferenceObject[] refs = null;
        if (concatedRefs != null && concatedRefs.size() > 0) {
            refs = new ReferenceObject[concatedRefs.size()];
            concatedRefs.toArray(refs);
        }
        return refs;
    }

    public static boolean isAlreadyAdded(String[] container, String obj) {
        if (obj == null) {
            return false;
        }
        if (container == null) {
            container = new String[]{};
            return false;
        }
        int i = 0;
        while (i < container.length) {
            if (obj.equals(container[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAlreadyAdded(ArrayList container, Object obj) {
        if (obj == null) {
            return false;
        }
        if (container == null) {
            container = new ArrayList();
            return false;
        }
        int i = 0;
        while (i < container.size()) {
            if (obj.equals(container.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Configuration getSubConfiguration(ConfigurationHandler handler, String root, String provider, String appName) throws ConfigurationException {
        try {
            return handler.openConfiguration(root + "/" + provider + "/" + appName, 1);
        }
        catch (NameNotFoundException ce) {
            try {
                return handler.createSubConfiguration(root + "/" + provider + "/" + appName);
            }
            catch (NameAlreadyExistsException naex) {
                naex.log();
            }
            catch (NameNotFoundException nnfe) {
                Configuration providerConfig = handler.createSubConfiguration(root + "/" + provider);
                return providerConfig.createSubConfiguration(appName);
            }
            throw new ConfigurationException("Cannot open or create configuration " + root + "/" + provider + "/" + appName);
        }
    }

    public static String encodeResourceType(String resName, String resType, String refType) {
        String res = "";
        res = res + (resName == null ? "" : resName) + '\n';
        res = res + (resType == null ? "" : resType) + '\n';
        res = res + (refType == null ? "" : refType) + '\n';
        return res;
    }

    public static String decodeResourceName(String encode) {
        return DUtils.getWord(encode, 1);
    }

    public static String decodeResourceType(String encode) {
        return DUtils.getWord(encode, 2);
    }

    public static String decodeResourceReferenceType(String encode) {
        return DUtils.getWord(encode, 3);
    }

    private static String getWord(String sentence, int number) {
        if (sentence == null || number < 0 && number > 3) {
            return null;
        }
        String res = null;
        while (number > 0) {
            if (sentence.indexOf(10) != -1) {
                res = sentence.substring(0, sentence.indexOf(10));
                if (sentence.indexOf(10) + 1 < sentence.length()) {
                    sentence = sentence.substring(sentence.indexOf(10) + 1);
                }
            } else {
                return null;
            }
            --number;
        }
        return res;
    }

    public static String[] processListElement(String[] temp, String key) {
        ArrayList<String> plus = new ArrayList<String>();
        ArrayList<String> minus = new ArrayList<String>();
        int i = 0;
        while (i < temp.length) {
            if (temp[i] != null) {
                if (temp[i].indexOf(key) != -1) {
                    minus.add(temp[i]);
                } else {
                    plus.add(temp[i]);
                }
            }
            ++i;
        }
        String current = null;
        int index = -1;
        int i2 = 0;
        while (i2 < minus.size()) {
            current = (String)minus.get(i2);
            if (current != null && (index = current.indexOf("-")) != -1 && DUtils.findElement(current.substring(0, index), plus) != -1) {
                minus.set(i2, null);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < minus.size()) {
            current = (String)minus.get(i3);
            if (current != null) {
                plus.add(current);
            }
            ++i3;
        }
        temp = new String[plus.size()];
        plus.toArray(temp);
        return temp;
    }

    public static int findElement(String target, ArrayList source) {
        String current = null;
        if (target != null && source != null) {
            int i = 0;
            while (i < source.size()) {
                current = (String)source.get(i);
                if (current != null && current.startsWith(target)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int findElement(String target, String[] source) {
        if (target != null && source != null) {
            int i = 0;
            while (i < source.length) {
                if (source[i] != null && source[i].equals(target)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static Hashtable convertHashtable(Hashtable source) {
        Hashtable<String, String[]> res = null;
        if (source != null) {
            res = new Hashtable<String, String[]>();
            Enumeration keys = source.keys();
            if (keys != null) {
                String key = null;
                File[] files = null;
                String[] fileNames = null;
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    files = (File[])source.get(key);
                    fileNames = new String[files.length];
                    int i = 0;
                    while (i < files.length) {
                        if (files[i] != null) {
                            fileNames[i] = files[i].getName();
                        }
                        ++i;
                    }
                    res.put(key, fileNames);
                }
            }
        }
        return res;
    }

    public static String[] getAliases(DeploymentInfo info) {
        Properties props = info.getProperties();
        if (props == null) {
            return null;
        }
        Enumeration<?> names = props.propertyNames();
        String name = null;
        Vector<String> aliases = new Vector<String>();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            if (!name.startsWith("web:")) continue;
            aliases.add(name.substring("web:".length()));
        }
        String[] res = new String[aliases.size()];
        aliases.toArray(res);
        return res;
    }
}

