/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.event.ServiceEventListener;
import com.sap.engine.frame.container.event.AdminContainerEventListener;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.cross.CrossInterface;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.services.deploy.DeployResourceAccessor;
import com.sap.engine.services.deploy.container.ContainerResourceAccessor;
import com.sap.engine.services.deploy.server.ClusterChangeListener;
import com.sap.engine.services.deploy.server.ReferenceResolver;
import com.sap.engine.services.deploy.server.Resource;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.rmi.Remote;
import java.util.Properties;

public class ClusterServicesAdapter
implements AdminContainerEventListener,
ServiceEventListener {
    private ClusterChangeListener changeListener = null;
    int commandsId = -1;
    private CrossInterface crossInterface = null;
    private SecurityContext security = null;
    private ReferenceResolver resolver = null;
    public static final String DEPLOY_COMPONENT_NAME = "deploy";
    public static final String DEPLOY_CATEGORY_SERVER = "/System/Server";
    public static final String DEPLOY_LOCATION = "com.sap.engine.services.deploy";

    public ClusterServicesAdapter(ClusterChangeListener changeL, ReferenceResolver res) {
        this.changeListener = changeL;
        this.resolver = res;
    }

    public void containerStarted() {
        this.changeListener.clusterElementReady();
    }

    public void markForShutdown(long timeout) {
    }

    public void serviceStarted(ClusterElement element) {
        this.changeListener.elementJoin(element);
    }

    public void serviceStopped(ClusterElement element) {
        this.changeListener.elementLoss(element);
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        this.resolver.resourceAvailable(Resource.createResource((byte)3, serviceName));
    }

    public void beginServiceStop(String serviceName) {
        this.resolver.resourceUnavailable(Resource.createResource((byte)3, serviceName));
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            ShellInterface shell = (ShellInterface)interfaceImpl;
            if (this.changeListener.getCommands() != null) {
                this.commandsId = shell.registerCommands(this.changeListener.getCommands());
            }
        } else if (interfaceName.equals("cross")) {
            this.crossInterface = (CrossInterface)interfaceImpl;
            if (this.changeListener.getDeployService() != null) {
                this.crossInterface.setInitialObject(DEPLOY_COMPONENT_NAME, (Remote)this.changeListener.getDeployService());
            }
        } else if (interfaceName.equals("log")) {
            Category category = Category.getCategory((String)DEPLOY_CATEGORY_SERVER);
            Location location = Location.getLocation((String)DEPLOY_LOCATION);
            new DeployResourceAccessor().init(category, location);
            new ContainerResourceAccessor().init(category, location);
        } else if (interfaceName.equals("security")) {
            this.security = (SecurityContext)interfaceImpl;
        }
        this.resolver.resourceAvailable(Resource.createResource((byte)4, interfaceName));
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals("cross")) {
            this.crossInterface = null;
        } else if (interfaceName.equals("security")) {
            this.security = null;
        }
        this.resolver.resourceUnavailable(Resource.createResource((byte)4, interfaceName));
    }

    public void componentLoaded(String componentName, byte componentType) {
        if (componentType == 1) {
            this.resolver.resourceAvailable(Resource.createResource((byte)2, componentName));
        }
    }

    public void beginComponentUnload(String componentName, byte componentType) {
        if (componentType == 1) {
            this.resolver.resourceUnavailable(Resource.createResource((byte)2, componentName));
        }
    }

    public void unregister() {
        ApplicationServiceContext sdc = this.changeListener.getApplicationServiceContext();
        CrossInterface cross = (CrossInterface)sdc.getContainerContext().getObjectRegistry().getProvidedInterface("cross");
        if (cross != null) {
            cross.removeInitialObject(DEPLOY_COMPONENT_NAME);
        }
    }

    public boolean isAdministratorInRole() {
        if (this.security != null) {
            return this.security.getAuthorizationContext().getSecurityRoleContext().getSecurityRole("administrators").isCallerInRole();
        }
        return true;
    }

    public void beginContainerStop() {
        this.changeListener.markForShutdown();
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
    }

    public boolean setServiceProperty(String key, String value) {
        return false;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return false;
    }

    public void componentRegistered(String componentName, byte componentType) {
    }

    public void componentResolved(String componentName, byte componentType) {
    }

    public void componentUnresolved(String componentName, byte componentType) {
    }

    public void componentUnloaded(String componentName, byte componentType) {
    }

    public void beginComponentUndeploy(String componentName, byte componentType) {
    }

    public void componentUndeployed(String componentName, byte componentType) {
    }

    public void managementInterfaceRegistered(String serviceName, ManagementInterface managementInterface) {
    }

    public void managementInterfaceUnregistered(String serviceName) {
    }

    public void componentNotLoaded(String componentName, byte componentType) {
    }
}

