/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.server;

import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.frame.core.load.res.ClassInfo;
import com.sap.engine.frame.core.load.res.Resource;
import com.sap.engine.services.deploy.server.ApplicationLoadingInterceptor;
import java.io.File;
import java.security.ProtectionDomain;

public class ApplicationLoader
extends ResourceLoader {
    private static ApplicationLoadingInterceptor interceptor;

    public ApplicationLoader(Resource resource, ClassLoader parentLoader, String name, ProtectionDomain prDomain) {
        super(name, resource, parentLoader, prDomain);
    }

    protected Class loadLocalClass(String className, String fileName) throws ClassNotFoundException {
        ClassInfo classInfo = this.resource.getClassInfo(className, fileName);
        Class<?> result = null;
        if (classInfo == null) {
            throw new ClassNotFoundException(className);
        }
        ApplicationLoader applicationLoader = this;
        synchronized (applicationLoader) {
            result = ((ClassLoader)((Object)this)).findLoadedClass(className);
            if (result != null) {
                Class<?> clazz = result;
                return clazz;
            }
            String pkgName = classInfo.getPackageName();
            if (pkgName != null && ((ClassLoader)((Object)this)).getPackage(pkgName) == null) {
                this.definePackage(pkgName, classInfo.getAttributes());
            }
            Class clazz = this.defineClassWithInterception(className, classInfo.getBytes(), 0, classInfo.getBytes().length, classInfo.getProtectionDomain() != null ? classInfo.getProtectionDomain() : ((ReferencedLoader)this).domain);
            return clazz;
        }
    }

    public static void setInterceptor(ApplicationLoadingInterceptor interceptor) {
        ApplicationLoader.interceptor = interceptor;
    }

    private Class defineClassWithInterception(String className, byte[] data, int offset, int length, ProtectionDomain protectionDomain) {
        byte[] substitute;
        if (interceptor != null && (substitute = interceptor.intercept(super.getName(), className, data, offset, length)) != null) {
            data = substitute;
            offset = 0;
            length = substitute.length;
        }
        return super.defineClass(className, data, offset, length, protectionDomain);
    }

    public String getClassPath() {
        String result = "";
        String[] names = this.resource.getResourceNames();
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                result = result + names[i] + File.pathSeparator;
                ++i;
            }
        }
        return result;
    }
}

