/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.sfilechooser;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.services.deploy.gui.sfilechooser.variables.PropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class VariablesDialog
extends CEscapeDialog
implements ActionListener {
    private Properties variables = new Properties();
    private PropertyEditor editor;
    private boolean isOKAction = false;

    public VariablesDialog(Dialog dialog) {
        super(dialog, "Classpath Variables", true);
        this.init();
    }

    private void init() {
        ((JDialog)((Object)this)).getContentPane().setLayout(new BorderLayout());
        this.editor = new PropertyEditor("Variable Name", "Variable Path");
        this.editor.setParentComponent((Dialog)((Object)this));
        ((JDialog)((Object)this)).getContentPane().add((Component)this.editor, "Center");
        this.editor.initProperties(this.variables);
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton("Ok");
        JButton cancel = new JButton("Cancel");
        ok.setActionCommand("OK_ACTION");
        ok.addActionListener(this);
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener(this);
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add((Component)ok, null);
        buttonPanel.add((Component)cancel, null);
        ((JDialog)((Object)this)).getContentPane().add((Component)buttonPanel, "South");
    }

    public Properties getVariables() {
        return VariablesDialog.putVariablePathPrefix(this.editor.getProps());
    }

    public void setVariables(Properties variables) {
        this.isOKAction = false;
        this.variables = VariablesDialog.removeVariablePathPrefix(variables);
        this.editor.initProperties(this.variables);
        ((Window)((Object)this)).pack();
    }

    protected void performEnterAction(KeyEvent e) {
        super.performEnterAction(e);
        this.isOKAction = true;
        ((Component)((Object)this)).setVisible(false);
    }

    public boolean isOKAction() {
        return this.isOKAction;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK_ACTION")) {
            this.isOKAction = true;
            ((Component)((Object)this)).setVisible(false);
        } else if (e.getActionCommand().equals("CANCEL")) {
            ((Component)((Object)this)).setVisible(false);
        }
    }

    public static Properties removeVariablePathPrefix(Properties prop) {
        Properties result = new Properties();
        Enumeration enumeration = ((Hashtable)prop).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String newKey = key.startsWith("Path_Variable:") ? key.substring("Path_Variable:".length()) : key;
            result.setProperty(newKey, prop.getProperty(key));
        }
        return result;
    }

    public static Properties putVariablePathPrefix(Properties prop) {
        Properties result = new Properties();
        Enumeration enumeration = ((Hashtable)prop).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String newKey = !key.startsWith("Path_Variable:") ? "Path_Variable:" + key : key;
            result.setProperty(newKey, prop.getProperty(key));
        }
        return result;
    }
}

