/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.sfilechooser;

import com.sap.engine.gui.images.ImageHolder;
import com.sap.engine.services.deploy.gui.sfilechooser.ExplorerPanel;
import com.sap.engine.services.deploy.gui.sfilechooser.FileObject;
import com.sap.engine.services.deploy.gui.sfilechooser.tree.DriveTreeNode;
import com.sap.engine.services.deploy.gui.sfilechooser.tree.FolderTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FavouritesDialog
extends JDialog
implements ListSelectionListener,
ActionListener {
    protected JList favouritesList = new JList();
    private JButton plusButton = new JButton();
    private JButton minusButton = new JButton();
    private JScrollPane scrollFavourites = new JScrollPane(this.favouritesList);
    private JDialog owner;
    private ExplorerPanel explorer;
    private Vector favourites = new Vector();

    public FavouritesDialog(JDialog owner, ExplorerPanel explorer) {
        super(owner);
        this.owner = owner;
        this.explorer = explorer;
        this.init();
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FavouritesDialog.this.explorer.setHasFavourites(false);
            }
        });
        this.setTitle("Favourites");
        this.getContentPane().setLayout(new BorderLayout());
        this.favouritesList.addListSelectionListener(this);
        this.plusButton.addActionListener(this);
        this.minusButton.addActionListener(this);
        this.plusButton.setActionCommand("addFav");
        this.minusButton.setActionCommand("removeFav");
        this.plusButton.setIcon(ImageHolder.addIcon);
        this.minusButton.setIcon(ImageHolder.removeIcon);
        JPanel addRemoveButtonPanel = new JPanel();
        addRemoveButtonPanel.setLayout(new FlowLayout());
        addRemoveButtonPanel.add((Component)this.plusButton, null);
        addRemoveButtonPanel.add((Component)this.minusButton, null);
        JPanel favouritesPanel = new JPanel();
        favouritesPanel.setLayout(new BorderLayout());
        favouritesPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Favorites"));
        favouritesPanel.add((Component)addRemoveButtonPanel, "North");
        favouritesPanel.add((Component)this.scrollFavourites, "Center");
        this.getContentPane().add((Component)favouritesPanel, "Center");
    }

    public void valueChanged(ListSelectionEvent listEvent) {
        if (listEvent.getSource() == this.favouritesList && !this.favouritesList.isSelectionEmpty()) {
            this.explorer.goTo((File)this.favouritesList.getSelectedValue());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("addFav")) {
            this.addToFav();
        } else if (actionEvent.getActionCommand().equals("removeFav")) {
            this.removeFav();
        } else if (actionEvent.getActionCommand().startsWith("file:")) {
            String location = actionEvent.getActionCommand().substring(5);
            this.explorer.goTo(new File(location));
        }
    }

    public void favouritesPanelAddRemove(boolean willBeAdded) {
        if (willBeAdded) {
            ((Component)this).setLocation(new Point(this.owner.getLocationOnScreen().x + this.owner.getWidth() + 20, this.owner.getLocationOnScreen().y));
            ((Component)this).setSize(new Dimension(200, 250));
            ((Component)this).setVisible(true);
        } else {
            ((Component)this).setVisible(false);
        }
    }

    public void addToFav() {
        if (!this.explorer.getFileList().isSelectionEmpty()) {
            if (!this.favourites.contains(this.explorer.getFileList().getSelectedValue()) && ((FileObject)this.explorer.getFileList().getSelectedValue()).isDirectory()) {
                this.favourites.add(this.explorer.getFileList().getSelectedValue());
                JMenuItem m1 = new JMenuItem(this.explorer.getFileList().getSelectedValue().toString());
                m1.setActionCommand("file:" + ((File)this.explorer.getFileList().getSelectedValue()).getAbsolutePath());
                m1.addActionListener(this);
                this.explorer.getPopup().add(m1);
                this.favouritesList.setListData(this.favourites);
            }
        } else if (!this.explorer.getDirTree().isSelectionEmpty()) {
            String tempPath = null;
            if (this.explorer.getLastSelectedTreeNode() instanceof DriveTreeNode) {
                tempPath = ((DriveTreeNode)this.explorer.getLastSelectedTreeNode()).getDriveObject().getName();
            } else if (this.explorer.getLastSelectedTreeNode() instanceof FolderTreeNode) {
                tempPath = ((FolderTreeNode)this.explorer.getLastSelectedTreeNode()).getAbsolutePath();
            }
            FileObject fileObj = new FileObject(tempPath);
            if (!this.favourites.contains(fileObj) && fileObj.isDirectory()) {
                this.favourites.add(fileObj);
                JMenuItem m1 = new JMenuItem(fileObj.toString());
                m1.setActionCommand("file:" + fileObj.getAbsolutePath());
                m1.addActionListener(this);
                this.explorer.getPopup().add(m1);
                this.favouritesList.setListData(this.favourites);
            }
        }
        this.explorer.getExplorerButtons()[8].setEnabled(this.favourites.size() != 0);
    }

    public void removeFav() {
        if (!this.favouritesList.isSelectionEmpty()) {
            Component[] tempMenus = this.explorer.getPopup().getComponents();
            int i = 0;
            while (i < tempMenus.length) {
                if (((JMenuItem)tempMenus[i]).getText().equals(this.favouritesList.getSelectedValue().toString())) {
                    this.explorer.getPopup().remove(tempMenus[i]);
                    break;
                }
                ++i;
            }
            this.favourites.remove(this.favouritesList.getSelectedValue());
            this.favouritesList.setListData(this.favourites);
            this.explorer.getExplorerButtons()[8].setEnabled(this.favourites.size() != 0);
        }
    }

    public Vector getFavouritesVector() {
        return this.favourites;
    }

    public void clearFavourites() {
        this.favouritesList.removeAll();
    }

    public String getFavourites() {
        String result = "";
        int i = 0;
        while (i < this.favourites.size()) {
            result = result + ((FileObject)this.favourites.elementAt(i)).getAbsolutePath() + ";";
            ++i;
        }
        return result.length() > 2 ? result.substring(0, result.length() - 1) : result;
    }

    public void setFavourites(String fav) {
        this.favourites = new Vector();
        if (fav == null) {
            this.clearFavourites();
            return;
        }
        StringTokenizer st = new StringTokenizer(fav, ";");
        while (st.hasMoreTokens()) {
            FileObject fo = new FileObject((String)st.nextElement());
            if (!fo.exists()) continue;
            this.favourites.add(fo);
            JMenuItem m1 = new JMenuItem(fo.toString());
            m1.setActionCommand("file:" + fo.getAbsolutePath());
            m1.addActionListener(this);
            this.explorer.getPopup().add(m1);
        }
        this.explorer.getExplorerButtons()[8].setEnabled(this.favourites.size() > 0);
        this.favouritesList.setListData(this.favourites);
    }
}

