/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.sfilechooser;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.gui.sfilechooser.ExplorerPanel;
import com.sap.engine.services.deploy.gui.sfilechooser.FileObject;
import com.sap.engine.services.deploy.gui.sfilechooser.VariablesDialog;
import com.sap.engine.services.deploy.gui.sfilechooser.tree.FileListRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClassPathPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private JList fileList = new JList();
    private Vector fileVector = new Vector();
    private ExplorerPanel explorer;
    private JButton minusButton;
    private Properties variables;
    private VariablesDialog varDialog;
    private Dialog dialog_parent;

    public ClassPathPanel(Dialog dialog_parent) {
        this.dialog_parent = dialog_parent;
        this.init();
    }

    private void init() {
        FileListRenderer render = new FileListRenderer();
        this.fileList.setCellRenderer(render);
        this.varDialog = new VariablesDialog(this.dialog_parent);
        this.setLayout(new GridBagLayout());
        JPanel filePanel = new JPanel();
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        filePanel.setLayout(new BorderLayout());
        filePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Classpath"));
        JButton plusButton = new JButton("Add");
        plusButton.addActionListener(this);
        plusButton.setActionCommand("add_classpath");
        this.minusButton = new JButton("Remove");
        this.minusButton.addActionListener(this);
        this.minusButton.setActionCommand("remove_classpath");
        JButton varButton = new JButton("Variables");
        varButton.addActionListener(this);
        varButton.setActionCommand("variables");
        buttonPanel.add((Component)plusButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)this.minusButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)varButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.fileList.addListSelectionListener(this);
        filePanel.add((Component)new JScrollPane(this.fileList), "Center");
        this.add((Component)buttonPanel, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.1, 13, 3, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)filePanel, new GridBagConstraints(0, 0, 2, 2, 0.1, 0.1, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.minusButton.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("add_classpath")) {
            if (this.explorer.getSeleectedItems() == null) {
                return;
            }
            Object[] obj = this.explorer.getSeleectedItems();
            String[] stupyFiles = null;
            stupyFiles = new String[obj.length];
            int i = 0;
            while (i < stupyFiles.length) {
                stupyFiles[i] = obj[i] instanceof FileObject ? (ApplicationInformationProvider.getVariableUsed((String)((FileObject)obj[i]).getPath()) != null ? ((FileObject)obj[i]).getPath() : ((FileObject)obj[i]).getAbsolutePath()) : (String)obj[i];
                ++i;
            }
            this.addFiles(stupyFiles);
        } else if (e.getActionCommand().equals("remove_classpath")) {
            if (!this.fileList.isSelectionEmpty()) {
                this.removeSelected(this.fileList.getSelectedValues());
            }
        } else if (e.getActionCommand().equals("variables")) {
            this.varDialog.setVariables(this.variables);
            ((Window)((Object)this.varDialog)).setLocationRelativeTo(this.dialog_parent);
            ((Component)((Object)this.varDialog)).setVisible(true);
            if (this.varDialog.isOKAction()) {
                this.variables = this.varDialog.getVariables();
            }
        }
    }

    public void valueChanged(ListSelectionEvent listEvent) {
        if (listEvent.getSource() == this.fileList) {
            this.minusButton.setEnabled(!this.fileList.isSelectionEmpty());
        }
    }

    public void addFiles(FileObject[] filesTemp) {
        FileObject temporary = null;
        int i = 0;
        while (i < filesTemp.length) {
            temporary = filesTemp[i];
            if (temporary.exists() && !this.fileVector.contains(temporary.getAbsolutePath())) {
                this.fileVector.add(temporary.getAbsolutePath());
            }
            ++i;
        }
        this.fileList.setListData(this.fileVector);
    }

    public void addFiles(String[] filesTemp) {
        File temporary = null;
        int i = 0;
        while (i < filesTemp.length) {
            if (ApplicationInformationProvider.getVariableUsed((String)filesTemp[i]) != null) {
                this.fileVector.add(filesTemp[i]);
            }
            if ((temporary = new File(filesTemp[i])).exists() && !this.fileVector.contains(temporary.getAbsolutePath())) {
                this.fileVector.add(this.switchPathWithVariable(temporary.getAbsolutePath()));
            }
            ++i;
        }
        this.fileList.setListData(this.fileVector);
    }

    private String switchPathWithVariable(String str) {
        String result = str;
        Enumeration enumeration = ((Hashtable)this.variables).keys();
        while (enumeration.hasMoreElements()) {
            String element = (String)enumeration.nextElement();
            if (this.explorer.isWindowsOS()) {
                if (!str.toLowerCase().startsWith(this.variables.getProperty(element).toLowerCase())) continue;
                result = ApplicationInformationProvider.removePrefixPath_Variable((String)element) + str.substring(this.variables.getProperty(element).length());
                continue;
            }
            if (!str.startsWith(this.variables.getProperty(element))) continue;
            result = ApplicationInformationProvider.removePrefixPath_Variable((String)element) + str.substring(this.variables.getProperty(element).length());
        }
        return result;
    }

    private String switchVariableWithPath(String str) {
        String result = str;
        Enumeration enumeration = ((Hashtable)this.variables).keys();
        while (enumeration.hasMoreElements()) {
            String element = (String)enumeration.nextElement();
            if (!str.startsWith(element)) continue;
            result = this.variables.getProperty(element) + str.substring(element.length());
        }
        return result;
    }

    private void removeSelected(Object[] items) {
        int i = 0;
        while (i < items.length) {
            this.fileVector.remove(items[i]);
            ++i;
        }
        this.fileList.setListData(this.fileVector);
    }

    private String[] tokenizertoArray(String filesTemp) {
        Object[] result = null;
        Vector<String> resultV = new Vector<String>();
        StringTokenizer st = new StringTokenizer(filesTemp, File.pathSeparator);
        while (st.hasMoreTokens()) {
            resultV.add(st.nextToken());
        }
        result = new String[resultV.size()];
        resultV.copyInto(result);
        return result;
    }

    public void addFiles(String filesStringTemp) {
        File temporary = null;
        String[] filesTemp = this.tokenizertoArray(filesStringTemp);
        int i = 0;
        while (i < filesTemp.length) {
            temporary = new File(filesTemp[i]);
            if (temporary == null) {
                return;
            }
            if (temporary.exists() && !this.fileVector.contains(temporary.getAbsolutePath())) {
                this.fileVector.add(temporary.getAbsolutePath());
            }
            ++i;
        }
    }

    public Vector getValues() {
        return this.fileVector;
    }

    public void setExplorerPanel(ExplorerPanel exp) {
        this.explorer = exp;
    }

    public String[] getClassPath() {
        String[] result = new String[this.fileVector.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.switchVariableWithPath((String)this.fileVector.elementAt(i));
            ++i;
        }
        return result;
    }

    public void setClassPath(String[] cp) {
        this.fileVector.removeAllElements();
        if (cp == null) {
            return;
        }
        int i = 0;
        while (i < cp.length) {
            this.fileVector.add(cp[i]);
            ++i;
        }
        this.fileList.setListData(this.fileVector);
    }

    public void setVariables(Properties props) {
        this.variables = props;
    }

    public Properties getVariables() {
        return this.variables;
    }
}

