/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.runtime;

import com.sap.engine.deploy.SimpleEARClassLoader;
import com.sap.engine.deploy.ejb.gui.BeanPropPanel;
import com.sap.engine.deploy.ejb.gui.EJBJarPanel;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.tree.ArchiveDescriptorNode;
import com.sap.engine.deploy.tool.tree.BasicDescriptorNode;
import com.sap.engine.deploy.tool.tree.ClientDescriptorNode;
import com.sap.engine.deploy.tool.tree.ConnectorDescriptorNode;
import com.sap.engine.deploy.tool.tree.DescriptorNode;
import com.sap.engine.deploy.tool.tree.DescriptorUserObject;
import com.sap.engine.deploy.tool.tree.EARDescriptorNode;
import com.sap.engine.deploy.tool.tree.EJBDescriptorNode;
import com.sap.engine.deploy.tool.tree.EJBJarDescriptorNode;
import com.sap.engine.deploy.tool.tree.FilterDescriptorNode;
import com.sap.engine.deploy.tool.tree.ListenerDescriptorNode;
import com.sap.engine.deploy.tool.tree.ServiceJarDescriptorNode;
import com.sap.engine.deploy.tool.tree.ServletDescriptorNode;
import com.sap.engine.deploy.tool.tree.WebDescriptorNode;
import com.sap.engine.gui.CFileChooser;
import com.sap.engine.gui.TreeUtils;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.appclient.descriptor.gui.AppClientPanel;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.RarPanel;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.extended.ear.EARDescriptor;
import com.sap.engine.services.deploy.extended.ear.ExtendedJar;
import com.sap.engine.services.deploy.gui.common.ArchiveDescriptorPanel;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.DescriptorPanel;
import com.sap.engine.services.deploy.gui.ear.EARDescriptorPanel;
import com.sap.engine.services.deploy.gui.runtime.EarLoader;
import com.sap.engine.services.deploy.gui.runtime.MainDeployPanel;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.servlets_jsp.descriptor.FilterDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ListenerDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.gui.FilterPanelLogical;
import com.sap.engine.services.servlets_jsp.descriptor.gui.JSP_ServletPanel;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ListenersPanelLogical;
import com.sap.engine.services.servlets_jsp.descriptor.gui.MainWebPanel;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.naming.Context;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MainDeployPanelLogical
extends MainDeployPanel
implements TreeSelectionListener {
    protected MainDeployPanel mainPanel;
    protected EarLoader earLoad;
    protected BasicDescriptorNode lastSelectedNode = null;
    protected BasicPanelView lastSelectedPanel;
    protected String classpath = "";
    protected MainWebPanel mainWPanel = null;
    protected JSP_ServletPanel mainServletPanel = null;
    protected FilterPanelLogical filterPanel = null;
    protected ListenersPanelLogical listenerPanel = null;
    protected ClassLoader loader = null;
    protected JPanel descrPanel;
    protected AppClientPanel mainClPanel = null;
    protected EJBJarPanel mainBJarPanel = null;
    protected EARDescriptorPanel mainEarPanel = null;
    protected BeanPropPanel mainBeanPanel = null;
    protected RarPanel mainRarPanel = null;
    protected DeployService deploy;
    protected ApplicationInformationProvider appInfoProvider = null;
    Context ctx;
    CFileChooser chooser = null;
    RemoteSecurity node = null;
    Vector earLoaders = new Vector();
    Frame mainFrame;

    public MainDeployPanelLogical(Frame _frame) {
        this.mainFrame = _frame;
        this.appInfoProvider = new ApplicationInformationProvider(null, 4);
        this.initComponents();
    }

    public void initComponents() {
        this.earLoad = new EarLoader(this.earTree, this.mainFrame);
        this.earTree.addTreeSelectionListener(this);
        this.earTree.setRootVisible(false);
        this.mainWPanel = new MainWebPanel(this.mainFrame, 4);
        this.mainWPanel.setApplicationInformationProvider(this.appInfoProvider);
        this.mainBJarPanel = new EJBJarPanel(this.mainFrame, this.loader, 4);
        this.mainBJarPanel.setApplicationInformationProvider(this.appInfoProvider);
        this.mainServletPanel = new JSP_ServletPanel(this.mainFrame, 4);
        this.mainServletPanel.setApplicationInformationProvider(this.appInfoProvider);
        this.filterPanel = new FilterPanelLogical(this.mainFrame, 4);
        this.filterPanel.setApplicationInformationProvider(this.appInfoProvider);
        this.listenerPanel = new ListenersPanelLogical(4);
        this.listenerPanel.setApplicationInformationProvider(this.appInfoProvider);
        this.mainClPanel = new AppClientPanel(this.mainFrame, new Vector(), 4);
        this.mainClPanel.setApplicationInformationProvider(this.appInfoProvider);
        this.mainRarPanel = new RarPanel(this.mainFrame, new Vector(), 4);
        this.mainRarPanel.setApplicationInformationProvider(this.appInfoProvider);
        this.mainEarPanel = new EARDescriptorPanel(this.mainFrame, 4);
        this.mainEarPanel.setApplicationInformationProvider(this.appInfoProvider);
        this.mainBeanPanel = new BeanPropPanel(this.mainFrame, null, 4);
        this.mainBeanPanel.setApplicationInformationProvider(this.appInfoProvider);
        this.mainBeanPanel.anAdditionalPanel.enableAddingAdditionalFiles(this.mainBJarPanel != null ? this.mainBJarPanel.getAdditionalFilesPanel() : null);
        this.mainBeanPanel.setApplicationInformationProvider(this.appInfoProvider);
        this.mainBeanPanel.setLoader(this.loader);
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void setRemoteSecurity(RemoteSecurity node) {
        this.node = node;
    }

    protected boolean loadEarAction(String earName, String addClassPath) throws IOException {
        boolean isLoaded = false;
        String parentFolder = ".";
        if (earName.lastIndexOf(File.separator) != -1) {
            parentFolder = earName.substring(0, earName.lastIndexOf(File.separator));
        }
        String subFolder = "deploy_temp";
        SimpleEARClassLoader earLoader = new SimpleEARClassLoader(null, earName, parentFolder, subFolder, this.getClass().getClassLoader());
        earLoader.addClasspath(addClassPath);
        this.classpath = this.classpath + earLoader.getClassPath();
        this.loader = earLoader;
        this.earLoaders.add(earLoader);
        isLoaded = this.earLoad.loadEar(this.earTree, earName, this.loader, parentFolder + File.separator + subFolder, this.appInfoProvider);
        if (!this.earLoad.getErrors().isEmpty()) {
            String message = "Errors while reading ear: \n";
            Vector err = this.earLoad.getErrors();
            int i = 0;
            while (i < err.size()) {
                message = message + err.get(i) + "\n";
                ++i;
            }
            JOptionPane.showConfirmDialog(this.mainFrame, message, "Error", 0, 0);
        }
        ((DefaultTreeModel)this.earTree.getModel()).reload();
        if (this.mainBeanPanel != null) {
            this.mainBeanPanel.setLoader(this.loader);
        }
        return isLoaded;
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        BasicDescriptorNode sellNode = (BasicDescriptorNode)path.getLastPathComponent();
        if (this.earTree.isSelectionEmpty()) {
            if (this.lastSelectedNode != null) {
                this.updateNodeProperties();
            }
            this.lastSelectedNode = null;
            this.lastSelectedPanel = null;
            this.propertiesPanel.removeAll();
            this.mainFrame.repaint();
            this.mainFrame.validate();
        }
        if (!this.earTree.isSelectionEmpty()) {
            if (this.lastSelectedNode != null && !this.updateNodeProperties()) {
                return;
            }
            this.showSelectedNodeProperties(sellNode);
            if (this.descrPanel != null) {
                this.propertiesPanel.removeAll();
                this.propertiesPanel.add((Component)this.descrPanel, "Center");
                this.descrPanel.repaint();
                this.descrPanel.revalidate();
            }
            this.lastSelectedNode = sellNode;
            this.lastSelectedPanel = (BasicPanelView)this.propertiesPanel.getComponent(0);
        }
    }

    protected boolean updateNodeProperties() {
        boolean flag = true;
        if (this.lastSelectedPanel == null || this.lastSelectedNode == null || this.lastSelectedNode.getParent() == null && !(this.lastSelectedNode instanceof EARDescriptorNode)) {
            this.lastSelectedNode = null;
            return true;
        }
        if (this.lastSelectedPanel instanceof ArchiveDescriptorPanel) {
            DeploymentDescriptor[] tempDDescr;
            String old_name = null;
            int correctIndex = this.lastSelectedPanel.isCorrect();
            this.lastSelectedNode.setLastIsCorrectStatus(correctIndex);
            if (correctIndex > 1) {
                flag = true;
                this.lastSelectedNode.setErrors(this.lastSelectedPanel.getErrorObject());
                return flag;
            }
            if (correctIndex == 1) {
                this.lastSelectedNode.setErrors(this.lastSelectedPanel.getErrorObject());
            }
            old_name = ((ArchiveDescriptorPanel)this.lastSelectedPanel).getDescriptor().getDisplayName();
            this.lastSelectedPanel.commitChange();
            if (this.lastSelectedPanel instanceof MainWebPanel) {
                this.changeSecurityRoles(((WebDeploymentDescriptor)((ArchiveDescriptorPanel)this.lastSelectedPanel).getDescriptor()).getSecRoles(), ((WebDeploymentDescriptor)((ArchiveDescriptorNode)this.lastSelectedNode).getCurrentDescriptor()).getSecRoles());
            } else if (this.lastSelectedPanel instanceof EJBJarPanel) {
                this.changeSecurityRoles(((EJBJarDescriptor)((ArchiveDescriptorPanel)this.lastSelectedPanel).getDescriptor()).getSecurityRoles(), ((EJBJarDescriptor)((ArchiveDescriptorNode)this.lastSelectedNode).getCurrentDescriptor()).getSecurityRoles());
            }
            if (!this.checkArchiveName(((ArchiveDescriptorPanel)this.lastSelectedPanel).getDescriptor(), old_name)) {
                return false;
            }
            if (this.lastSelectedPanel instanceof MainWebPanel) {
                ((ArchiveDescriptorNode)this.lastSelectedNode).setAdditionalFiles(((MainWebPanel)this.lastSelectedPanel).getAdditionalFiles());
                flag = true;
            } else if (this.lastSelectedPanel instanceof EJBJarPanel) {
                if (((EJBJarPanel)this.lastSelectedPanel).getAdditionalFiles() != null) {
                    ((ArchiveDescriptorNode)this.lastSelectedNode).setAdditionalFiles(((EJBJarPanel)this.lastSelectedPanel).getAdditionalFiles());
                    flag = true;
                }
            } else if (this.lastSelectedPanel instanceof AppClientPanel) {
                ((ArchiveDescriptorNode)this.lastSelectedNode).setAdditionalFiles(((AppClientPanel)this.lastSelectedPanel).getAdditionalFiles());
                flag = true;
            } else if (this.lastSelectedPanel instanceof RarPanel) {
                ((ArchiveDescriptorNode)this.lastSelectedNode).setAdditionalFiles(((RarPanel)this.lastSelectedPanel).getAdditionalFiles());
                flag = true;
            }
            if (this.lastSelectedPanel instanceof EJBJarPanel && (tempDDescr = (DeploymentDescriptor[])((ArchiveDescriptorNode)this.lastSelectedNode).getCurrentDescriptor().getDescriptors()) != null) {
                int lengthIndex = this.lastSelectedNode.getChildCount();
                int i0 = 0;
                while (i0 < tempDDescr.length) {
                    int i1 = 0;
                    while (i1 < lengthIndex) {
                        if ((DeploymentDescriptor)((EJBDescriptorNode)this.lastSelectedNode.getChildAt(i1)).getCurrentDescriptor() != null && ((DeploymentDescriptor)((EJBDescriptorNode)this.lastSelectedNode.getChildAt(i1)).getCurrentDescriptor()).getEjbName().equals(tempDDescr[i0].getEjbName())) {
                            ((EJBDescriptorNode)this.lastSelectedNode.getChildAt(i1)).setModifiedDescriptor((Descriptor)tempDDescr[i0]);
                        }
                        ++i1;
                    }
                    ++i0;
                }
            }
        } else if (this.lastSelectedPanel instanceof DescriptorPanel) {
            EJBJarDescriptorNode jarDescrNode;
            DeploymentDescriptor[] ddArray;
            String old_name = null;
            int correctIndex = this.lastSelectedPanel.isCorrect();
            this.lastSelectedNode.setLastIsCorrectStatus(correctIndex);
            if (correctIndex > 1) {
                this.lastSelectedNode.setErrors(this.lastSelectedPanel.getErrorObject());
                return true;
            }
            if (correctIndex == 1) {
                this.lastSelectedNode.setErrors(this.lastSelectedPanel.getErrorObject());
            }
            Descriptor old_descr = ((DescriptorPanel)this.lastSelectedPanel).getDescriptor();
            this.lastSelectedPanel.commitChange();
            ((DescriptorNode)this.lastSelectedNode).setModifiedDescriptor(((DescriptorPanel)this.lastSelectedPanel).getDescriptor());
            String modifyed_name = null;
            if (this.lastSelectedPanel instanceof BeanPropPanel) {
                old_name = ((DescriptorNode)this.lastSelectedNode).getCurrentDescriptor().getName();
                modifyed_name = ((DeploymentDescriptor)((DescriptorPanel)this.lastSelectedPanel).getDescriptor()).getDisplayName();
                if (modifyed_name != null && old_name != null && !modifyed_name.equals(old_name)) {
                    this.lastSelectedNode.setName(modifyed_name);
                }
            }
            Descriptor new_descr = ((DescriptorPanel)this.lastSelectedPanel).getDescriptor();
            this.checkDescriptorName(old_descr);
            if (new_descr instanceof DeploymentDescriptor && (ddArray = ((EJBJarDescriptor)(jarDescrNode = (EJBJarDescriptorNode)this.lastSelectedNode.getParent()).getCurrentDescriptor()).getDDescriptors()) != null) {
                int ii = 0;
                while (ii < ddArray.length) {
                    if (ddArray[ii] != null && ddArray[ii].getEjbName() != null && (DeploymentDescriptor)new_descr != null && ddArray[ii].getEjbName().equals(((DeploymentDescriptor)new_descr).getEjbName())) {
                        ddArray[ii] = (DeploymentDescriptor)new_descr;
                    }
                    ++ii;
                }
            }
        } else if (this.lastSelectedPanel instanceof EARDescriptorPanel) {
            String old_name = null;
            int isCorrectIndex = -1;
            isCorrectIndex = this.lastSelectedPanel.isCorrect();
            this.lastSelectedNode.setLastIsCorrectStatus(isCorrectIndex);
            if (isCorrectIndex > 1) {
                this.lastSelectedNode.setErrors(this.lastSelectedPanel.getErrorObject());
                return true;
            }
            if (isCorrectIndex == 1) {
                this.lastSelectedNode.setErrors(this.lastSelectedPanel.getErrorObject());
            }
            old_name = ((EARDescriptorPanel)this.lastSelectedPanel).getDescriptor().getDisplayName();
            this.lastSelectedPanel.commitChange();
            EARDescriptor earDescriptor = ((EARDescriptorPanel)this.lastSelectedPanel).getDescriptor();
            if (earDescriptor.getDisplayName() != null && earDescriptor.getDisplayName().equals("")) {
                return false;
            }
            ((EARDescriptorNode)this.lastSelectedNode).setModifiedDescriptor(earDescriptor);
            this.earTree.repaint();
            this.earTree.revalidate();
            ((EARDescriptorNode)this.lastSelectedNode).setAdditionalFiles(((EARDescriptorPanel)this.lastSelectedPanel).getAdditionalFiles());
            flag = true;
            this.overwriteSecurityRoles(earDescriptor.getRoles());
        }
        return flag;
    }

    protected void showSelectedNodeProperties(BasicDescriptorNode sellNode) {
        if (sellNode instanceof WebDescriptorNode) {
            WebDeploymentDescriptor wDescriptor = (WebDeploymentDescriptor)((WebDescriptorNode)sellNode).getCurrentDescriptor();
            if (wDescriptor.getDisplayName() == null) {
                wDescriptor.setDisplayName(sellNode.getName().substring(0, sellNode.getName().lastIndexOf(46)));
            }
            this.mainWPanel.setApplicationInformationProvider(this.appInfoProvider);
            this.mainWPanel.setArchiveName(sellNode.getArchiveFileName());
            this.mainWPanel.setAdditionalClassPath(this.getAdditionalClassPaths());
            this.mainWPanel.setAdditionalFiles(((WebDescriptorNode)sellNode).getAdditionalFiles());
            this.mainWPanel.setDescriptor((ArchiveDescriptor)wDescriptor);
            this.descrPanel = this.mainWPanel;
        } else if (!(sellNode instanceof ServiceJarDescriptorNode)) {
            if (sellNode instanceof EJBJarDescriptorNode) {
                EJBJarDescriptor bjDescriptor = (EJBJarDescriptor)((EJBJarDescriptorNode)sellNode).getCurrentDescriptor();
                if (bjDescriptor.getJarName() == null && sellNode instanceof EJBJarDescriptorNode) {
                    bjDescriptor.setJarName(sellNode.getName());
                }
                this.mainBJarPanel.setApplicationInformationProvider(this.appInfoProvider);
                this.mainBJarPanel.setArchiveName(sellNode.getArchiveFileName());
                this.mainBJarPanel.setLoader(this.loader);
                this.mainBJarPanel.setClassPath(this.getAdditionalClassPaths());
                this.mainBJarPanel.setAdditionalFiles(((EJBJarDescriptorNode)sellNode).getAdditionalFiles());
                this.mainBJarPanel.setLoader(this.loader);
                this.mainBJarPanel.setDescriptor((ArchiveDescriptor)bjDescriptor);
                this.descrPanel = this.mainBJarPanel;
            } else if (sellNode instanceof ServletDescriptorNode) {
                ServletDescriptor sDescriptor = (ServletDescriptor)((ServletDescriptorNode)sellNode).getCurrentDescriptor();
                this.mainServletPanel.setLoader(this.loader);
                this.mainServletPanel.additional.enableAddingAdditionalFiles(this.mainWPanel != null ? this.mainWPanel.getAdditionalFilesPanel() : null);
                this.mainServletPanel.setApplicationInformationProvider(this.appInfoProvider);
                this.mainServletPanel.setAddFiles(((ArchiveDescriptorNode)sellNode.getParent()).getAdditionalFiles());
                this.mainServletPanel.setDescriptor((Descriptor)sDescriptor);
                this.descrPanel = this.mainServletPanel;
            } else if (sellNode instanceof FilterDescriptorNode) {
                FilterDescriptor fDescriptor = (FilterDescriptor)((FilterDescriptorNode)sellNode).getCurrentDescriptor();
                this.filterPanel.additional.enableAddingAdditionalFiles(this.mainWPanel != null ? this.mainWPanel.getAdditionalFilesPanel() : null);
                this.filterPanel.setApplicationInformationProvider(this.appInfoProvider);
                this.filterPanel.setDescriptor((Descriptor)fDescriptor);
                this.descrPanel = this.filterPanel;
            } else if (sellNode instanceof ListenerDescriptorNode) {
                ListenerDescriptor lDescriptor = (ListenerDescriptor)((ListenerDescriptorNode)sellNode).getCurrentDescriptor();
                this.listenerPanel.setApplicationInformationProvider(this.appInfoProvider);
                this.listenerPanel.setDescriptor((Descriptor)lDescriptor);
                this.descrPanel = this.listenerPanel;
            } else if (sellNode instanceof ClientDescriptorNode) {
                ApplicationClientDescriptor clDescriptor = (ApplicationClientDescriptor)((ClientDescriptorNode)sellNode).getCurrentDescriptor();
                if (clDescriptor != null && clDescriptor.getDisplayName() == null) {
                    clDescriptor.setDisplayName(sellNode.getName().substring(0, sellNode.getName().lastIndexOf(46)));
                }
                this.mainClPanel.setApplicationInformationProvider(this.appInfoProvider);
                this.mainClPanel.setAdditionalFiles(((ClientDescriptorNode)sellNode).getAdditionalFiles());
                this.mainClPanel.setArchiveName(sellNode.getArchiveFileName());
                this.mainClPanel.setDescriptor((ArchiveDescriptor)clDescriptor);
                this.descrPanel = this.mainClPanel;
            } else if (sellNode instanceof ConnectorDescriptorNode) {
                JCDescriptor jcDescriptor = null;
                jcDescriptor = (JCDescriptor)((ConnectorDescriptorNode)sellNode).getCurrentDescriptor();
                if (jcDescriptor != null && jcDescriptor.getDisplayName() == null) {
                    jcDescriptor.setDisplayName(sellNode.getName().substring(0, sellNode.getName().lastIndexOf(46)));
                }
                this.mainRarPanel.setApplicationInformationProvider(this.appInfoProvider);
                this.mainRarPanel.setContext(this.node);
                this.mainRarPanel.setDescriptor((ArchiveDescriptor)jcDescriptor);
                this.mainRarPanel.setArchiveName(sellNode.getArchiveFileName());
                this.mainRarPanel.setAdditionalFiles(((ConnectorDescriptorNode)sellNode).getAdditionalFiles());
                this.descrPanel = this.mainRarPanel;
            } else if (sellNode instanceof EARDescriptorNode) {
                EARDescriptor earDescriptor = ((EARDescriptorNode)sellNode).getModifiedDescriptor();
                this.setContext(earDescriptor);
                this.mainEarPanel.setApplicationInformationProvider(this.appInfoProvider);
                this.mainEarPanel.setArchiveName(sellNode.getArchiveFileName());
                this.mainEarPanel.setDescriptor(earDescriptor);
                this.mainEarPanel.setContext(this.node);
                this.mainEarPanel.setAdditionalFiles(((EARDescriptorNode)sellNode).getAdditionalFiles());
                this.descrPanel = this.mainEarPanel;
            } else if (sellNode instanceof EJBDescriptorNode) {
                DeploymentDescriptor dDescriptor = (DeploymentDescriptor)((EJBDescriptorNode)sellNode).getCurrentDescriptor();
                this.mainBeanPanel.anAdditionalPanel.enableAddingAdditionalFiles(this.mainBJarPanel != null ? this.mainBJarPanel.getAdditionalFilesPanel() : null);
                this.mainBeanPanel.setApplicationInformationProvider(this.appInfoProvider);
                this.mainBeanPanel.setLoader(this.loader);
                this.mainBeanPanel.setApplicationInformationProvider(this.appInfoProvider);
                this.mainBeanPanel.setDescriptor(dDescriptor);
                this.descrPanel = this.mainBeanPanel;
            } else {
                this.descrPanel = new JPanel();
                this.propertiesPanel.updateUI();
            }
        }
    }

    public BasicDescriptorNode findNode(BasicDescriptorNode earNode, String jarName) {
        if (earNode != null) {
            int i = 0;
            while (i < earNode.getChildCount()) {
                BasicDescriptorNode currentNode = (BasicDescriptorNode)earNode.getChildAt(i);
                if (currentNode.getName().equals(jarName)) {
                    return currentNode;
                }
                ++i;
            }
        }
        return null;
    }

    public ExtendedJar[] getDescriptors() {
        ExtendedJar[] descrs = null;
        ArchiveDescriptor currDesc = null;
        EARDescriptorNode ear = (EARDescriptorNode)this.earTree.getModel().getRoot();
        if (ear != null) {
            int count = ear.getChildCount();
            if (count != 0) {
                descrs = new ExtendedJar[count];
                DeploymentDescriptor[] dds = null;
                int i = 0;
                while (i < count) {
                    BasicDescriptorNode current = (BasicDescriptorNode)ear.getChildAt(i);
                    if (current instanceof EJBJarDescriptorNode) {
                        if (current.getChildCount() != 0) {
                            dds = new DeploymentDescriptor[current.getChildCount()];
                            currDesc = ((EJBJarDescriptorNode)current).getCurrentDescriptor();
                            int j = 0;
                            while (j < current.getChildCount()) {
                                dds[j] = (DeploymentDescriptor)((EJBDescriptorNode)current.getChildAt(j)).getCurrentDescriptor();
                                ++j;
                            }
                            ((EJBJarDescriptor)currDesc).setDescriptors(dds);
                            descrs[i] = new ExtendedJar(currDesc, this.getName(current.getArchiveFileName()), 1);
                        }
                    } else if (current instanceof ClientDescriptorNode) {
                        currDesc = ((ClientDescriptorNode)current).getCurrentDescriptor();
                        descrs[i] = new ExtendedJar(currDesc, this.getName(current.getArchiveFileName()), 3);
                    } else if (current instanceof WebDescriptorNode) {
                        currDesc = ((WebDescriptorNode)current).getCurrentDescriptor();
                        descrs[i] = new ExtendedJar(currDesc, this.getName(current.getArchiveFileName()), 4);
                    } else if (current instanceof ConnectorDescriptorNode) {
                        currDesc = ((ConnectorDescriptorNode)current).getCurrentDescriptor();
                        descrs[i] = new ExtendedJar(currDesc, this.getName(current.getArchiveFileName()), 5);
                    }
                    ++i;
                }
            }
            return descrs;
        }
        return null;
    }

    private String getName(String fileName) {
        return new File(fileName).getName();
    }

    public EARDescriptor getEARDescriptor() {
        EARDescriptor desc = null;
        EARDescriptorNode ear = (EARDescriptorNode)this.earTree.getModel().getRoot();
        if (ear != null) {
            desc = ear.getModifiedDescriptor();
        }
        int i = 0;
        while (i < this.earLoaders.size()) {
            ((SimpleEARClassLoader)this.earLoaders.elementAt(i)).clear();
            ++i;
        }
        return desc;
    }

    private void changeSecurityRoles(SecurityRoles[] newRoles, SecurityRoles[] oldRoles) {
        EARDescriptorNode root = null;
        if (this.earTree.getModel() != null) {
            root = (EARDescriptorNode)this.earTree.getModel().getRoot();
        }
        if (root == null) {
            return;
        }
        EARDescriptor descr = root.getModifiedDescriptor();
        if (descr == null) {
            return;
        }
        Vector<SecurityRoles> addedRoles = new Vector<SecurityRoles>();
        Vector<SecurityRoles> removedRoles = new Vector<SecurityRoles>();
        SecurityRoles[] allRoles = null;
        ArchiveDescriptorNode archNode = null;
        WebDeploymentDescriptor webDescr = null;
        EJBJarDescriptor ejbDescr = null;
        boolean removeAll = false;
        boolean addAll = false;
        if (newRoles == null) {
            removeAll = true;
        } else if (oldRoles == null) {
            addAll = true;
        } else {
            boolean found = false;
            int i = 0;
            while (i < newRoles.length) {
                found = false;
                int j = 0;
                while (j < oldRoles.length) {
                    if (oldRoles[j].getRoleName().equals(newRoles[i].getRoleName())) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    addedRoles.add(newRoles[i]);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < oldRoles.length) {
                found = false;
                int j = 0;
                while (j < newRoles.length) {
                    if (oldRoles[i2].getRoleName().equals(newRoles[j].getRoleName())) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    removedRoles.add(oldRoles[i2]);
                }
                ++i2;
            }
        }
        allRoles = descr.getRoles();
        if (removeAll) {
            allRoles = null;
        } else if (addAll) {
            allRoles = newRoles;
        } else {
            if (addedRoles.size() == 0 && removedRoles.size() == 0) {
                return;
            }
            allRoles = this.mergeRoles(allRoles, addedRoles, removedRoles);
        }
        descr.setRoles(allRoles);
        root.setModifiedDescriptor(descr);
        int i = 0;
        while (i < root.getChildCount()) {
            archNode = (ArchiveDescriptorNode)root.getChildAt(i);
            if (archNode instanceof EJBJarDescriptorNode) {
                ejbDescr = (EJBJarDescriptor)archNode.getModifiedDescriptor();
                if (ejbDescr != null) {
                    ejbDescr.setSecurityRoles(allRoles);
                }
            } else if (archNode instanceof WebDescriptorNode && (webDescr = (WebDeploymentDescriptor)archNode.getModifiedDescriptor()) != null) {
                webDescr.setSecRoles(allRoles);
            }
            ++i;
        }
    }

    private SecurityRoles[] mergeRoles(SecurityRoles[] s1, Vector added, Vector removed) {
        int i;
        Vector<Object> elements = new Vector<Object>();
        if (s1 != null) {
            i = 0;
            while (i < s1.length) {
                if (s1[i] != null && !this.containsRole(s1[i], removed)) {
                    elements.add(s1[i]);
                }
                ++i;
            }
        }
        i = 0;
        while (i < added.size()) {
            if (!this.containsRole((SecurityRoles)added.elementAt(i), elements)) {
                elements.add(added.elementAt(i));
            }
            ++i;
        }
        if (elements.size() > 0) {
            Object[] concatination = new SecurityRoles[elements.size()];
            elements.copyInto(concatination);
            return concatination;
        }
        return null;
    }

    private boolean containsRole(SecurityRoles role, Vector v) {
        if (v == null || role == null || role.getRoleName() == null) {
            return false;
        }
        int i = 0;
        while (i < v.size()) {
            if (role.getRoleName().equals(((SecurityRoles)v.elementAt(i)).getRoleName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void overwriteSecurityRoles(SecurityRoles[] roles) {
        EARDescriptorNode root = null;
        if (this.earTree.getModel() != null) {
            root = (EARDescriptorNode)this.earTree.getModel().getRoot();
        }
        if (root == null || root.getModifiedDescriptor() == null) {
            return;
        }
        SecurityRoles[] allRoles = null;
        ArchiveDescriptorNode archNode = null;
        WebDeploymentDescriptor webDescr = null;
        EJBJarDescriptor ejbDescr = null;
        allRoles = roles;
        int i = 0;
        while (i < root.getChildCount()) {
            archNode = (ArchiveDescriptorNode)root.getChildAt(i);
            if (archNode instanceof EJBJarDescriptorNode) {
                ejbDescr = (EJBJarDescriptor)archNode.getModifiedDescriptor();
                if (ejbDescr != null) {
                    ejbDescr.setSecurityRoles(allRoles);
                    archNode.setModifiedDescriptor((ArchiveDescriptor)ejbDescr);
                }
            } else if (archNode instanceof WebDescriptorNode && (webDescr = (WebDeploymentDescriptor)archNode.getModifiedDescriptor()) != null) {
                webDescr.setSecRoles(allRoles);
                archNode.setModifiedDescriptor((ArchiveDescriptor)webDescr);
            }
            ++i;
        }
    }

    protected boolean checkArchiveName(ArchiveDescriptor descr, String old_name) {
        String name = descr.getDisplayName();
        ArchiveDescriptorNode node = (ArchiveDescriptorNode)this.findNode((BasicDescriptorNode)this.lastSelectedNode.getParent(), name);
        if (node == null) {
            ((ArchiveDescriptorNode)this.lastSelectedNode).setModifiedDescriptor(descr);
            this.earTree.repaint();
            this.earTree.revalidate();
        } else {
            ((ArchiveDescriptorNode)this.lastSelectedNode).setModifiedDescriptor(descr);
        }
        return true;
    }

    protected boolean checkDescriptorName(Descriptor old_descr) {
        String name = null;
        Descriptor descrTemp1 = ((DescriptorPanel)this.lastSelectedPanel).getDescriptor();
        if (descrTemp1 instanceof DeploymentDescriptor) {
            name = ((DeploymentDescriptor)descrTemp1).getDisplayName();
        } else if (descrTemp1 instanceof ServletDescriptor) {
            name = ((ServletDescriptor)descrTemp1).getDisplayName();
            if (name == null || name.equals("")) {
                name = ((ServletDescriptor)descrTemp1).getServletName();
            }
        } else if (descrTemp1 instanceof FilterDescriptor) {
            name = ((FilterDescriptor)descrTemp1).getDisplayName();
            if (name == null || name.equals("")) {
                name = ((FilterDescriptor)descrTemp1).getFilterName();
            }
        } else if (descrTemp1 instanceof ListenerDescriptor) {
            name = descrTemp1.getName();
        }
        DescriptorNode node = (DescriptorNode)this.findNode((BasicDescriptorNode)this.lastSelectedNode.getParent(), name);
        if (node == null) {
            ((DescriptorNode)this.lastSelectedNode).setModifiedDescriptor(((DescriptorPanel)this.lastSelectedPanel).getDescriptor());
            this.lastSelectedNode.setName(name);
            int[] indexRow = this.earTree.getSelectionRows();
            ((DefaultTreeModel)this.earTree.getModel()).reload((TreeNode)this.lastSelectedNode);
            if (indexRow != null) {
                this.earTree.setSelectionRow(indexRow[indexRow.length - 1]);
            }
        } else if (node != this.lastSelectedNode) {
            int answer = 1;
            if (this.lastSelectedNode instanceof EJBDescriptorNode) {
                answer = JOptionPane.showConfirmDialog(this.mainFrame, "EJB with this name already exists! \nWould you like to replace it?", "Warning", 2, 0);
            } else if (this.lastSelectedNode instanceof ServletDescriptorNode) {
                answer = JOptionPane.showConfirmDialog(this.mainFrame, "EJB with this name already exists! \nWould you like to replace it?", "Warning", 2, 0);
            }
            if (answer == 0) {
                if (this.lastSelectedNode instanceof EJBDescriptorNode) {
                    this.lastSelectedNode.setUserObject(new DescriptorUserObject(name, 0));
                } else if (this.lastSelectedNode instanceof ServletDescriptorNode) {
                    this.lastSelectedNode.setUserObject(new DescriptorUserObject(name, 2));
                } else if (this.lastSelectedNode instanceof FilterDescriptorNode) {
                    this.lastSelectedNode.setUserObject(new DescriptorUserObject(name, 10));
                } else if (this.lastSelectedNode instanceof ListenerDescriptorNode) {
                    this.lastSelectedNode.setUserObject(new DescriptorUserObject(name, 11));
                }
                this.lastSelectedNode.setName(name);
                ((DescriptorNode)this.lastSelectedNode).setModifiedDescriptor(((DescriptorPanel)this.lastSelectedPanel).getDescriptor());
                this.lastSelectedPanel = null;
                this.lastSelectedNode = null;
                ((DefaultTreeModel)this.earTree.getModel()).removeNodeFromParent((MutableTreeNode)node);
                this.propertiesPanel.removeAll();
                this.mainFrame.repaint();
                this.earTree.clearSelection();
                ((DefaultTreeModel)this.earTree.getModel()).reload();
                TreeUtils.expandTree((JTree)this.earTree, (int)2);
                return false;
            }
            ((DescriptorPanel)this.lastSelectedPanel).setDescriptor(old_descr);
        } else {
            ((DescriptorNode)this.lastSelectedNode).setModifiedDescriptor(((DescriptorPanel)this.lastSelectedPanel).getDescriptor());
        }
        return true;
    }

    public void setContext(EARDescriptor descr) {
        int count;
        EARDescriptorNode root = null;
        ArchiveDescriptorNode current = null;
        Vector<String> wars = new Vector<String>();
        String contRootName = null;
        if (this.earTree.getModel() != null && (root = (EARDescriptorNode)this.earTree.getModel().getRoot()) != null && (count = root.getChildCount()) != 0) {
            int i = 0;
            while (i < count) {
                current = (ArchiveDescriptorNode)root.getChildAt(i);
                if (current instanceof WebDescriptorNode) {
                    wars.add(current.toString());
                }
                ++i;
            }
        }
        int j = 0;
        while (j < wars.size()) {
            String name = (String)wars.elementAt(j);
            contRootName = name;
            if (contRootName.endsWith(".war")) {
                contRootName = contRootName.substring(0, contRootName.indexOf(".war"));
            }
            descr.addModule(new J2EEModule(name, contRootName));
            ++j;
        }
    }

    public String[] getAdditionalClassPaths() {
        return null;
    }
}

