/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.mapping.dependancy;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.SortTable;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.services.deploy.gui.mapping.dependancy.DependancyTableModel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class DependancyDialog
extends CEscapeDialog
implements ActionListener,
KeyListener {
    private DependancyTableModel tableModel = new DependancyTableModel();
    private Frame frame;
    private SortTable table;
    private JPanel panel;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton selectAllBtn;
    private JButton deselectAllBtn;
    private final String OK_CMD = "OK";
    private final String CANCEL_CMD = "CANCEL";
    private final String SELECT_ALL_CMD = "SELECT_ALL";
    private final String DESELECT_ALL_CMD = "DESELECT_ALL";
    private boolean isOk = false;

    public DependancyDialog(Frame frame1) {
        super(frame1);
        this.frame = frame1;
        this.init();
        LookAndFeelHandler.add((Component)((Object)this));
    }

    private void init() {
        ((Component)((Object)this)).addKeyListener(this);
        this.table = new SortTable((TableModel)this.tableModel);
        this.table.setModel((AbstractTableModel)this.tableModel);
        this.panel = new JPanel();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("CANCEL");
        this.cancelButton.addActionListener(this);
        this.selectAllBtn = new JButton("Select All");
        this.selectAllBtn.setActionCommand("SELECT_ALL");
        this.selectAllBtn.addActionListener(this);
        this.deselectAllBtn = new JButton("Deselect All");
        this.deselectAllBtn.setActionCommand("DESELECT_ALL");
        this.deselectAllBtn.addActionListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(400);
        this.buttonPanel.add(this.selectAllBtn);
        this.buttonPanel.add(this.deselectAllBtn);
        this.buttonPanel.add(new JSeparator());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.panel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Dependencies editor panel"));
        this.panel.setLayout(new GridBagLayout());
        this.panel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.01, 0.01, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.setPreferredSize(new Dimension(300, 300));
        ((Dialog)((Object)this)).setModal(true);
        ((Component)((Object)this)).setSize(new Dimension(640, 460));
        ((Dialog)((Object)this)).setResizable(true);
        ((Dialog)((Object)this)).setTitle("Dependencies");
        ((JDialog)((Object)this)).getContentPane().add(this.panel);
        ((Window)((Object)this)).setLocationRelativeTo(this.frame);
    }

    public void initData(InfoObject[] infos) {
        this.tableModel.initData(infos);
    }

    public void updateData(String[] servlJsp) {
        this.tableModel.updateData(servlJsp);
    }

    public InfoObject[] getInfoObjects() {
        InfoObject[] infos = this.tableModel.getSelected(1);
        return infos;
    }

    public boolean isOk() {
        return this.isOk;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("OK")) {
            this.okAction();
        } else if (cmd.equals("CANCEL")) {
            this.cancelAction();
        } else if (cmd.equals("SELECT_ALL")) {
            this.tableModel.selectAll(true);
        } else if (cmd.equals("DESELECT_ALL")) {
            this.tableModel.selectAll(false);
        }
    }

    private void okAction() {
        this.isOk = true;
        ((Component)((Object)this)).setVisible(false);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.okAction();
        } else if (keyEvent.getKeyCode() == 27) {
            ((Component)((Object)this)).setVisible(false);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void cancelAction() {
        this.isOk = false;
        ((Component)((Object)this)).setVisible(false);
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }
}

