/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.mapping;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.gui.mapping.FileMapFilter;
import com.sap.engine.services.deploy.gui.mapping.MappingObject;
import com.sap.engine.services.deploy.gui.mapping.tree.DirMappingTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DirMappingPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ChangeListener {
    private DirMappingTreeNode treeNode;
    private JList fileList;
    private JList propertyList;
    private JList filterExcludeList;
    private JTextField mapName;
    private JTextField filter;
    private JTextField excludedTextField;
    private JTabbedPane includeExcludeTabPane;
    private MappingObject mapping = new MappingObject();
    private Vector filteredFileList;
    private JCheckBox filterCheckBox = new JCheckBox("Show with Filters", false);
    private JButton addButton;
    private JButton removeButton;
    private JButton removeExcludeButton;
    private JButton addExcludeButton;
    private JPanel mainPanel;
    private boolean flagman;
    private boolean filterFlag = false;
    private Vector flatTree;
    private DirMappingTreeNode directories;
    private JTree theTree;
    private JLabel statusLabel;

    public DirMappingPanel(DirMappingTreeNode directories) {
        this.directories = directories;
        this.init();
        LookAndFeelHandler.add((Component)this);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Directories Panel"));
        this.mainPanel.setLayout(new GridBagLayout());
        JPanel textFieldPanel = new JPanel();
        textFieldPanel.setLayout(new GridBagLayout());
        JPanel fileListPanel = new JPanel();
        JPanel propListPanel = new JPanel();
        JPanel excludePanel = new JPanel();
        JPanel buttonAddRemovePanel = new JPanel();
        JPanel statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        statusPanel.setLayout(new BorderLayout());
        statusPanel.add((Component)this.statusLabel, "Center");
        buttonAddRemovePanel.setLayout(new GridBagLayout());
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(this);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(this);
        buttonAddRemovePanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        buttonAddRemovePanel.add((Component)this.removeButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel excludeButtonPanel = new JPanel();
        excludeButtonPanel.setLayout(new FlowLayout());
        this.addExcludeButton = new JButton("Add");
        this.addExcludeButton.setActionCommand("ADD_EXCLUDE");
        this.addExcludeButton.addActionListener(this);
        this.removeExcludeButton = new JButton("Remove");
        this.removeExcludeButton.setActionCommand("REMOVE_EXCLUDE");
        this.removeExcludeButton.addActionListener(this);
        excludeButtonPanel.add((Component)this.addExcludeButton, null);
        excludeButtonPanel.add((Component)this.removeExcludeButton, null);
        this.filterCheckBox.addChangeListener(this);
        fileListPanel.setLayout(new BorderLayout());
        propListPanel.setLayout(new BorderLayout());
        propListPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Filters & Mappings"));
        fileListPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Files in Directory"));
        excludePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Exclude Filters"));
        if (this.filteredFileList == null) {
            this.filteredFileList = new Vector();
        }
        this.fileList = new JList();
        this.propertyList = new JList(this.getPropertiesVector(this.mapping));
        this.propertyList.addListSelectionListener(this);
        this.filterExcludeList = new JList(this.mapping.getExcludedFilters());
        JScrollPane fileListScrollPane = new JScrollPane(this.fileList);
        JScrollPane propertyListScrollPane = new JScrollPane(this.propertyList);
        JScrollPane filterExcludePane = new JScrollPane(this.filterExcludeList);
        JLabel excludeLabel = new JLabel("Exclude Filters: ");
        this.excludedTextField = new JTextField();
        excludePanel.setLayout(new GridBagLayout());
        excludePanel.add((Component)filterExcludePane, new GridBagConstraints(0, 0, 5, 1, 0.1, 0.1, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        excludePanel.add((Component)excludeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        excludePanel.add((Component)this.excludedTextField, new GridBagConstraints(1, 1, 4, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        excludePanel.add((Component)excludeButtonPanel, new GridBagConstraints(0, 2, 5, 1, 0.1, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.filterExcludeList.addListSelectionListener(this);
        this.mapName = new JTextField();
        this.filter = new JTextField();
        JLabel mapLabel = new JLabel("Mapping:");
        JLabel filterLabel = new JLabel("Filter:");
        propListPanel.add((Component)propertyListScrollPane, "Center");
        propListPanel.add((Component)buttonAddRemovePanel, "East");
        propListPanel.add((Component)textFieldPanel, "South");
        fileListPanel.add((Component)fileListScrollPane, "Center");
        fileListPanel.add((Component)this.filterCheckBox, "North");
        propListPanel.setMinimumSize(new Dimension(80, 150));
        this.includeExcludeTabPane = new JTabbedPane();
        this.includeExcludeTabPane.add("Extension Mappings", propListPanel);
        this.includeExcludeTabPane.add("Exclude Filters", excludePanel);
        this.mainPanel.add((Component)statusPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)fileListPanel, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.includeExcludeTabPane, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.1, 15, 1, new Insets(5, 5, 5, 5), 0, 0));
        textFieldPanel.add((Component)mapLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        textFieldPanel.add((Component)filterLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        textFieldPanel.add((Component)this.mapName, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        textFieldPanel.add((Component)this.filter, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.mainPanel, "Center");
    }

    private Vector getPropertiesVector(MappingObject helpMapObj) {
        Vector<String> tempVector = new Vector<String>();
        String passer = "";
        String helpEnum = "";
        Enumeration<?> maps = helpMapObj.getMappings().propertyNames();
        while (maps.hasMoreElements()) {
            helpEnum = (String)maps.nextElement();
            passer = helpEnum + " - " + helpMapObj.getMappings().getProperty(helpEnum);
            tempVector.add(passer);
        }
        return tempVector;
    }

    private Vector listFilesInDir(String pathDir) {
        Vector<String> tempListFilesVector = new Vector<String>();
        File tmpFile = new File(pathDir);
        if (tmpFile.exists()) {
            File[] listOfFiles;
            if (this.filterFlag) {
                FileMapFilter filterMap = new FileMapFilter(this.mapping);
                listOfFiles = tmpFile.listFiles(filterMap);
            } else {
                listOfFiles = tmpFile.listFiles();
            }
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile() && listOfFiles[i].exists()) {
                    tempListFilesVector.add(listOfFiles[i].getName());
                }
                ++i;
            }
        }
        return tempListFilesVector;
    }

    public void setData(DirMappingTreeNode treeNodePassed) {
        this.clearWithoutDisable();
        this.treeNode = treeNodePassed;
        this.mapping = treeNodePassed.getMapObjValue();
        this.fileList.setListData(this.listFilesInDir(this.mapping.getFilePath()));
        this.propertyList.setListData(this.getPropertiesVector(this.mapping));
        this.statusLabel.setText(this.treeNode.getMapObjValue().getFilePath());
        this.filterExcludeList.setListData(this.mapping.getExcludedFilters());
        this.removeButton.setEnabled(false);
    }

    private String[] stringTokenizerToArray(String s) {
        StringTokenizer st = new StringTokenizer(s, ";");
        String[] tokenArray = new String[st.countTokens()];
        String usage = "";
        int i = 0;
        while (i < tokenArray.length) {
            usage = st.nextToken();
            tokenArray[i] = usage.startsWith(".") ? usage : "." + usage;
            ++i;
        }
        int lastCount = 0;
        Vector<String> tempVector = new Vector<String>();
        int i2 = 0;
        while (i2 < tokenArray.length) {
            int j = i2 + 1;
            while (j < tokenArray.length) {
                if (tokenArray[i2].equals(tokenArray[j])) {
                    tokenArray[j] = "";
                    ++lastCount;
                }
                ++j;
            }
            if (!tokenArray[i2].equals("")) {
                tempVector.add(tokenArray[i2]);
            }
            ++i2;
        }
        Object[] tokenArrayLast = new String[tempVector.size()];
        tempVector.copyInto(tokenArrayLast);
        return tokenArrayLast;
    }

    private void removeMappingFilter(String filterStrigForRemoval) {
        Enumeration enumeration = ((Hashtable)this.mapping.getMappings()).keys();
        String filt = "";
        while (enumeration.hasMoreElements()) {
            filt = (String)enumeration.nextElement();
            String replace = "";
            if (filt.indexOf(filterStrigForRemoval) == -1) continue;
            StringTokenizer sttToken = new StringTokenizer(filt, ";");
            boolean exist = false;
            while (sttToken.hasMoreTokens()) {
                String comparableOne = sttToken.nextToken();
                if (!filterStrigForRemoval.equals(comparableOne)) {
                    if (replace.trim().equals("")) {
                        replace = comparableOne;
                        continue;
                    }
                    replace = replace + ";" + comparableOne;
                    continue;
                }
                exist = true;
            }
            String value = this.mapping.getMappings().getProperty(filt);
            if (!exist) continue;
            ((Hashtable)this.mapping.getMappings()).remove(filt);
            Properties ttmpp = new Properties();
            ttmpp.setProperty(filt, value);
            Properties origPropForClone = (Properties)((Hashtable)ttmpp).clone();
            this.passRemoveToChildren(origPropForClone, ttmpp, this.treeNode);
            if (replace.trim().equals("")) continue;
            this.mapping.getMappings().setProperty(replace, value);
            Properties ttmpp2 = new Properties();
            ttmpp2.setProperty(replace, value);
            Properties proporiginal = (Properties)((Hashtable)ttmpp2).clone();
            this.passToChildren(proporiginal, ttmpp2, this.treeNode);
        }
    }

    private String checkForExtentionExistence(String prop) {
        Properties temp = this.mapping.getMappings();
        String[] tmp = this.stringTokenizerToArray(prop);
        Enumeration enThis = ((Hashtable)temp).keys();
        boolean existsAtAll = false;
        boolean goAtAll = false;
        while (enThis.hasMoreElements()) {
            goAtAll = true;
            String[] tmpThis = this.stringTokenizerToArray((String)enThis.nextElement());
            String extt = "";
            int i = 0;
            while (i < tmp.length) {
                boolean exists = false;
                int j = 0;
                while (j < tmpThis.length) {
                    if (tmp[i].equals(tmpThis[j])) {
                        extt = tmp[i];
                        exists = true;
                        existsAtAll = true;
                    }
                    ++j;
                }
                if (exists) {
                    int option = JOptionPane.showConfirmDialog(this, "You have already specyfied such mapping: \" " + extt + " \" .\n    Would you like to replace?", "Replace Mapping.", 0);
                    if (option == 0) {
                        this.removeMappingFilter(tmp[i]);
                    } else {
                        tmp[i] = "";
                    }
                }
                ++i;
            }
        }
        if (!goAtAll) {
            return prop;
        }
        String result = "";
        if (existsAtAll) {
            int i = 0;
            while (i < tmp.length) {
                if (tmp[i] != "") {
                    result = !result.trim().equals("") ? result + ";" + tmp[i] : tmp[i];
                }
                ++i;
            }
        } else {
            return prop;
        }
        return result;
    }

    private String removeDoubleSlashes(String tem) {
        tem = tem.replace('\\', '/');
        while (tem.indexOf("//") != -1) {
            int index = tem.indexOf("//");
            tem = tem.substring(0, index) + tem.substring(index + 1);
        }
        if (tem.startsWith("/")) {
            tem = tem.substring(1);
        }
        return tem;
    }

    private void addMappings() {
        String ifChange = "";
        if (this.filter.getText().trim().equals("") || this.filter.getText().trim().equals(".")) {
            return;
        }
        if (!(FileUtils.isCorrectFileName((String)this.filter.getText()) && this.filter.getText().indexOf("-") == -1 || this.filter.getText().startsWith("*.") && this.filter.getText().length() > 2 || this.filter.getText().equals(".*") || this.filter.getText().equals("*"))) {
            JOptionPane.showMessageDialog(this, "The filter field contains forbiden symbols like: \" \\ / ? < > | *\n Symbols like \" * \" or  \" .* \" or \" *.* \"are mappings for all files and will be accepted.");
            return;
        }
        if (this.filter.getText().startsWith("*.")) {
            this.filter.setText(this.filter.getText().substring(1));
        }
        Properties proper = this.mapping.getMappings();
        Properties passer = new Properties();
        if (!this.mapName.getText().trim().equals("") && !this.filter.getText().trim().equals("") && this.mapName.getText() != null && this.filter.getText() != null) {
            String filter1;
            String[] myTokenArray = this.stringTokenizerToArray(this.filter.getText());
            String filterString = "";
            this.mapName.setText(this.removeDoubleSlashes(this.mapName.getText()));
            int i = 0;
            while (i < myTokenArray.length) {
                filterString = !filterString.trim().equals("") ? filterString + ";" + myTokenArray[i] : myTokenArray[i];
                if (this.mapping.getExcludedFilters().contains(myTokenArray[i])) {
                    JOptionPane.showMessageDialog(this, "The extention " + myTokenArray[i] + " already exists in exclude list.");
                }
                ++i;
            }
            this.filter.setText(filterString);
            Enumeration en = ((Hashtable)this.mapping.getMappings()).keys();
            String value = "";
            String key = "";
            boolean isIn = false;
            while (en.hasMoreElements()) {
                key = (String)en.nextElement();
                value = this.mapping.getMappings().getProperty(key);
                if (!this.mapName.getText().equals(value)) continue;
                isIn = true;
                ((Hashtable)this.mapping.getMappings()).remove(key);
                String[] panelTokenArray = this.stringTokenizerToArray(key);
                int forRemove = 0;
                int i2 = 0;
                while (i2 < myTokenArray.length) {
                    boolean areEqual = false;
                    int j = 0;
                    while (j < panelTokenArray.length) {
                        if (myTokenArray[i2].equals(panelTokenArray[j])) {
                            areEqual = true;
                            ++forRemove;
                            break;
                        }
                        ++j;
                    }
                    if (!areEqual) {
                        key = key + ";" + myTokenArray[i2];
                    }
                    ++i2;
                }
                if (forRemove != panelTokenArray.length) {
                    Properties propertyOne = new Properties();
                    propertyOne.setProperty(key, value);
                    Properties propertyOneClone = (Properties)((Hashtable)propertyOne).clone();
                    this.passRemoveToChildren(propertyOneClone, propertyOne, this.treeNode);
                    key = this.filter.getText();
                }
                if ((key = this.checkForExtentionExistence(key)).trim().equals("")) continue;
                this.mapping.getMappings().setProperty(key, value);
                passer.setProperty(key, value);
            }
            if (!isIn && !(filter1 = this.checkForExtentionExistence(this.filter.getText())).trim().equals("")) {
                this.filter.setText(filter1);
                proper.setProperty(this.filter.getText(), this.mapName.getText());
                passer.setProperty(this.filter.getText(), this.mapName.getText());
            }
            Properties proporiginal = (Properties)((Hashtable)passer).clone();
            this.passToChildren(proporiginal, passer, this.treeNode);
        }
        this.filter.setText("");
        this.mapName.setText("");
        this.setData(this.treeNode);
        this.ultimateCheckForCyclicDirectories();
    }

    private void removeMappings() {
        Properties proper = new Properties();
        proper = this.mapping.getMappings();
        Properties prop2 = new Properties();
        prop2.setProperty(this.filter.getText(), this.mapName.getText());
        ((Hashtable)proper).remove(this.filter.getText());
        Properties origPropForClone = (Properties)((Hashtable)prop2).clone();
        this.passRemoveToChildren(origPropForClone, prop2, this.treeNode);
        this.propertyList.setListData(this.getPropertiesVector(this.mapping));
        this.filter.setText("");
        this.mapName.setText("");
        this.setData(this.treeNode);
    }

    private void processPropertyString(String s) {
        String mapStr = "";
        String filterStr = "";
        int firstHash = s.indexOf("-");
        filterStr = s.substring(0, --firstHash).trim();
        mapStr = s.substring(firstHash += 2, s.length()).trim();
        this.filter.setText(filterStr);
        this.mapName.setText(mapStr);
    }

    private Properties updateMappingTreeStructure(Properties original, Properties p, DirMappingTreeNode dirMapTreeNode) {
        Properties result = new Properties();
        Enumeration en = ((Hashtable)p).keys();
        boolean toRoot = false;
        String temporal = "";
        String key = "";
        String dirName = dirMapTreeNode.toString();
        if (((DirMappingTreeNode)dirMapTreeNode.getParent().getParent()).toString().equals("Directories")) {
            toRoot = true;
        }
        String parentDirNameTemp = ((DirMappingTreeNode)dirMapTreeNode.getParent()).getMapObjValue().getFilePath();
        int index = parentDirNameTemp.lastIndexOf(File.separator);
        String parentDirName = "";
        parentDirName = index != -1 ? parentDirNameTemp.substring(++index - 1, parentDirNameTemp.length()) : parentDirNameTemp;
        parentDirName = parentDirName.replace(File.separatorChar, '/');
        while (en.hasMoreElements()) {
            int index1;
            key = (String)en.nextElement();
            String temporal21 = temporal = p.getProperty(key);
            if (!temporal.endsWith("\\") || !temporal.endsWith("/")) {
                temporal21 = temporal + "/";
            }
            if (!parentDirName.endsWith("\\") || !parentDirName.endsWith("/")) {
                parentDirName = parentDirName + "/";
            }
            if ((index1 = temporal21.indexOf(parentDirName)) != -1) {
                temporal = temporal21.substring(0, index1 + parentDirName.length());
            } else if (toRoot) {
                temporal = original.getProperty(key);
            }
            temporal = temporal.endsWith("/") ? temporal + dirName : temporal + "/" + dirName;
            result.setProperty(key, temporal);
        }
        return result;
    }

    public void passToChildren(Properties originalProp, Properties pp, DirMappingTreeNode treeNodeTemp) {
        int index = treeNodeTemp.getChildCount();
        int i = 0;
        while (i < index) {
            pp = this.updateMappingTreeStructure(originalProp, pp, (DirMappingTreeNode)treeNodeTemp.getChildAt(i));
            if (((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).isLeaf()) {
                ((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).addProperties(pp);
            } else {
                ((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).addProperties(pp);
                this.passToChildren(originalProp, pp, (DirMappingTreeNode)treeNodeTemp.getChildAt(i));
            }
            ++i;
        }
    }

    private void passRemoveToChildren(Properties originalProp, Properties pp, DirMappingTreeNode treeNodeTemp) {
        int index = treeNodeTemp.getChildCount();
        int i = 0;
        while (i < index) {
            pp = this.updateMappingTreeStructure(originalProp, pp, (DirMappingTreeNode)treeNodeTemp.getChildAt(i));
            if (((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).isLeaf()) {
                ((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).removeFromProperties(pp);
            } else {
                ((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).removeFromProperties(pp);
                this.passRemoveToChildren(originalProp, pp, (DirMappingTreeNode)treeNodeTemp.getChildAt(i));
            }
            ++i;
        }
    }

    private void flattenRekursy(DirMappingTreeNode treeNodeTemp) {
        int index = treeNodeTemp.getChildCount();
        int i = 0;
        while (i < index) {
            if (((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).isLeaf()) {
                this.flatTree.add(((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).getMapObjValue());
            } else {
                this.flatTree.add(((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).getMapObjValue());
                this.flattenRekursy((DirMappingTreeNode)treeNodeTemp.getChildAt(i));
            }
            ++i;
        }
    }

    private void passIncludeToChildren(boolean isIncluden, DirMappingTreeNode treeNodeTemp) {
        int index = treeNodeTemp.getChildCount();
        int i = 0;
        while (i < index) {
            if (((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).isLeaf()) {
                ((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).getMapObjValue().setIncluded(isIncluden);
            } else {
                ((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).getMapObjValue().setIncluded(isIncluden);
                this.passIncludeToChildren(isIncluden, (DirMappingTreeNode)treeNodeTemp.getChildAt(i));
            }
            ++i;
        }
    }

    private boolean checkInIncludeForExistance(String str) {
        boolean result = false;
        Properties tmp = this.mapping.getMappings();
        Enumeration en = ((Hashtable)tmp).keys();
        String key = "";
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            StringTokenizer st = new StringTokenizer(key, ";");
            String keyToken = "";
            while (st.hasMoreTokens()) {
                keyToken = st.nextToken();
                if (!keyToken.equals(str)) continue;
                return true;
            }
        }
        return result;
    }

    private void passExclude(Vector vec, DirMappingTreeNode node) {
        int index = node.getChildCount();
        int i = 0;
        while (i < index) {
            if (((DirMappingTreeNode)node.getChildAt(i)).isLeaf()) {
                ((DirMappingTreeNode)node.getChildAt(i)).addExcludes(vec);
            } else {
                ((DirMappingTreeNode)node.getChildAt(i)).addExcludes(vec);
                this.passExclude(vec, (DirMappingTreeNode)node.getChildAt(i));
            }
            ++i;
        }
    }

    private void passRemoveExclude(String vec, DirMappingTreeNode node) {
        int index = node.getChildCount();
        int i = 0;
        while (i < index) {
            if (((DirMappingTreeNode)node.getChildAt(i)).isLeaf()) {
                ((DirMappingTreeNode)node.getChildAt(i)).removeExcludes(vec);
            } else {
                ((DirMappingTreeNode)node.getChildAt(i)).removeExcludes(vec);
                this.passRemoveExclude(vec, (DirMappingTreeNode)node.getChildAt(i));
            }
            ++i;
        }
    }

    private void addExcludeToVector() {
        if (!(FileUtils.isCorrectFileName((String)this.excludedTextField.getText()) && this.excludedTextField.getText().indexOf("-") == -1 || this.excludedTextField.getText().startsWith("*.") && this.excludedTextField.getText().length() > 2 && !this.excludedTextField.getText().startsWith("*.*"))) {
            JOptionPane.showMessageDialog(this, "The filter field contains forbiden symbols like: \" \\ / ? < > | *");
            return;
        }
        if (this.excludedTextField.getText().startsWith("*.")) {
            this.excludedTextField.setText(this.excludedTextField.getText().substring(1));
        }
        String filterExcludeString = this.excludedTextField.getText();
        String[] fiterExcludeArray = this.stringTokenizerToArray(filterExcludeString);
        Vector<String> forSend = new Vector<String>();
        int i = 0;
        while (i < fiterExcludeArray.length) {
            if (!this.mapping.getExcludedFilters().contains(fiterExcludeArray[i])) {
                this.mapping.getExcludedFilters().add(fiterExcludeArray[i]);
                forSend.add(fiterExcludeArray[i]);
                if (this.checkInIncludeForExistance(fiterExcludeArray[i])) {
                    JOptionPane.showMessageDialog(this, "The extention " + fiterExcludeArray[i] + " already exists in include list.");
                }
            }
            ++i;
        }
        this.passExclude(forSend, this.treeNode);
        this.setData(this.treeNode);
        this.excludedTextField.setText("");
    }

    private void removeExcludeToVector() {
        if (!this.filterExcludeList.isSelectionEmpty()) {
            String removedExclude = (String)this.filterExcludeList.getSelectedValue();
            this.mapping.getExcludedFilters().remove(removedExclude);
            this.passRemoveExclude(removedExclude, this.treeNode);
            this.setData(this.treeNode);
            this.excludedTextField.setText("");
        }
    }

    public Vector flattenTree() {
        this.flatTree = new Vector();
        this.flattenRekursy(this.directories);
        return this.flatTree;
    }

    public void setAllDisable() {
        this.flagman = true;
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.propertyList.setEnabled(false);
        this.fileList.setEnabled(false);
        this.mapName.setEnabled(false);
        this.filter.setEnabled(false);
        this.filterCheckBox.setEnabled(false);
        this.includeExcludeTabPane.setEnabled(false);
        this.filterExcludeList.setEnabled(false);
        this.removeExcludeButton.setEnabled(false);
        this.addExcludeButton.setEnabled(false);
    }

    public void setAllEnable() {
        this.flagman = false;
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        this.propertyList.setEnabled(true);
        this.fileList.setEnabled(true);
        this.mapName.setEnabled(true);
        this.filter.setEnabled(true);
        this.filterCheckBox.setEnabled(true);
        this.includeExcludeTabPane.setEnabled(true);
        this.filterExcludeList.setEnabled(true);
        this.addExcludeButton.setEnabled(true);
        this.removeExcludeButton.setEnabled(true);
    }

    public void clear() {
        this.mapping = new MappingObject();
        this.mapName.setText("");
        this.filter.setText("");
        this.filteredFileList.removeAllElements();
        this.propertyList.setListData(this.filteredFileList);
        this.fileList.setListData(this.filteredFileList);
        this.excludedTextField.setText("");
        this.filterExcludeList.setListData(this.filteredFileList);
        this.setAllDisable();
    }

    public void clearWithoutDisable() {
        this.mapping = new MappingObject();
        this.mapName.setText("");
        this.filter.setText("");
        this.filteredFileList.removeAllElements();
        this.propertyList.setListData(this.filteredFileList);
        this.fileList.setListData(this.filteredFileList);
        this.excludedTextField.setText("");
        this.filterExcludeList.setListData(this.filteredFileList);
    }

    public void resetFields() {
        this.mapName.setText("");
        this.filter.setText("");
        this.propertyList.setListData(new Vector());
        this.fileList.setListData(new Vector());
        this.excludedTextField.setText("");
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!this.propertyList.isSelectionEmpty()) {
            this.removeButton.setEnabled(true);
            this.processPropertyString((String)this.propertyList.getSelectedValue());
        } else {
            this.mapName.setText("");
            this.filter.setText("");
            this.excludedTextField.setText("");
            this.removeButton.setEnabled(false);
        }
        if (!this.filterExcludeList.isSelectionEmpty()) {
            this.excludedTextField.setText((String)this.filterExcludeList.getSelectedValue());
        }
    }

    public void actionPerformed(ActionEvent action) {
        if (action.getActionCommand().equals("Add")) {
            this.addMappings();
        }
        if (action.getActionCommand().equals("Remove") && !this.propertyList.isSelectionEmpty()) {
            this.removeMappings();
        }
        if (action.getActionCommand().equals("ADD_EXCLUDE")) {
            this.addExcludeToVector();
        }
        if (action.getActionCommand().equals("REMOVE_EXCLUDE") && !this.filterExcludeList.isSelectionEmpty()) {
            this.removeExcludeToVector();
        }
    }

    public void stateChanged(ChangeEvent change) {
        if (((JCheckBox)change.getSource()).getText().trim().equals("Show with Filters")) {
            if (this.filterCheckBox.isSelected()) {
                this.filterFlag = true;
                this.fileList.setListData(this.listFilesInDir(this.mapping.getFilePath()));
            } else {
                this.filterFlag = false;
                if (!this.mapping.getFilePath().trim().equals("")) {
                    this.fileList.setListData(this.listFilesInDir(this.mapping.getFilePath()));
                }
            }
        }
    }

    public void setTree(JTree theTree) {
        this.theTree = theTree;
    }

    public void ultimateCheckForCyclicDirectories() {
        String ext = "";
        String mappingTemp = "";
        String resultMapping = "";
        int i = 0;
        while (i < this.directories.getChildCount()) {
            DirMappingTreeNode tempNode;
            DirMappingTreeNode secTempNode = tempNode = (DirMappingTreeNode)this.directories.getChildAt(i);
            MappingObject moTemp = tempNode.getMapObjValue();
            Properties propTemp = moTemp.getMappings();
            Enumeration en = ((Hashtable)propTemp).keys();
            block1: while (en.hasMoreElements()) {
                secTempNode = tempNode;
                ext = (String)en.nextElement();
                mappingTemp = propTemp.getProperty(ext);
                String[] mappingArray = this.tokenizerToArray(mappingTemp, "/");
                int j = 0;
                while (j < mappingArray.length) {
                    Properties innerPropperties;
                    if ((secTempNode = this.findChildNodeByDirectoryName(secTempNode, mappingArray[j])) == null || (innerPropperties = secTempNode.getMapObjValue().getMappings()) == null || innerPropperties.getProperty(ext) == null) continue block1;
                    resultMapping = this.makeStringFromArray(mappingArray, "/", j);
                    if (resultMapping != null) {
                        if (resultMapping.trim().equals("")) {
                            innerPropperties.setProperty(ext, mappingTemp);
                        } else {
                            innerPropperties.setProperty(ext, resultMapping);
                        }
                        secTempNode.setMapObjValue(new MappingObject(secTempNode.getMapObjValue().getFilePath(), innerPropperties, secTempNode.getMapObjValue().isIncluded()));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private String makeStringFromArray(String[] origin, String delimeter, int lastIndex) {
        String result = "";
        if (origin == null || lastIndex > origin.length) {
            return null;
        }
        int i = 0;
        while (i == lastIndex) {
            result = result + origin[i] + delimeter;
            ++i;
        }
        return result;
    }

    private DirMappingTreeNode findChildNodeByDirectoryName(DirMappingTreeNode parent, String name) {
        int count = parent.getChildCount();
        int i = 0;
        while (i < count) {
            if (((DirMappingTreeNode)parent.getChildAt(i)).toString().equals(name)) {
                return (DirMappingTreeNode)parent.getChildAt(i);
            }
            ++i;
        }
        return null;
    }

    private String[] tokenizerToArray(String str, String delimeter) {
        if (str == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(str, delimeter);
        int tokCount = tok.countTokens();
        String[] clsPaths = new String[tokCount];
        int i = 0;
        while (i < tokCount) {
            clsPaths[i] = tok.nextToken();
            ++i;
        }
        return clsPaths;
    }
}

