/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.ear;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.ear.common.MadeFromConstants;
import com.sap.engine.services.deploy.extended.ear.EARDescriptor;
import com.sap.engine.services.deploy.gui.common.AdditionalPanelLogical;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.ear.DataSourceAliasePanel;
import com.sap.engine.services.deploy.gui.ear.PropsEditorPanelLogical;
import com.sap.engine.services.deploy.gui.ear.SimpleEarDescriptorTabPanel;
import com.sap.engine.services.jmsconnector.descriptor.JMSConnectorDescriptor;
import com.sap.engine.services.jmsconnector.descriptor.gui.JMSDestinationsPanelLogical;
import com.sap.engine.services.jmsconnector.descriptor.gui.JMSFactoriesPanelLogical;
import com.sap.engine.services.log_configurator.admin.gui.GeneralLogControllerPanel;
import com.sap.engine.services.security.remote.RemoteSecurity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class EARDescriptorTabPanel
extends BasicPanelView
implements MadeFromConstants {
    protected JTabbedPane theTabbedPane = new JTabbedPane(1);
    protected SimpleEarDescriptorTabPanel simplePanel;
    protected GeneralLogControllerPanel logControlerPanel;
    protected JMSFactoriesPanelLogical jmsFactPanel;
    protected JMSDestinationsPanelLogical jmsDestPanel;
    protected PropsEditorPanelLogical propsEditorPanel;
    protected DataSourceAliasePanel dataSourceAliasePanel;
    protected JPanel jmsPanel = new JPanel();
    protected JTabbedPane jmsTabbedPane = new JTabbedPane(1);
    protected int madeFrom;
    protected EARDescriptor descriptor;
    private ApplicationInformationProvider appProvider;

    public EARDescriptorTabPanel(Frame _frame, int _madeFrom) {
        this.mainFrame = _frame;
        this.madeFrom = _madeFrom;
        this.simplePanel = new SimpleEarDescriptorTabPanel(this.mainFrame, this.madeFrom);
        this.logControlerPanel = new GeneralLogControllerPanel(this.mainFrame, true, true);
        this.jmsFactPanel = new JMSFactoriesPanelLogical(this.mainFrame, this.madeFrom);
        this.jmsDestPanel = new JMSDestinationsPanelLogical(this.mainFrame, this.madeFrom);
        this.propsEditorPanel = new PropsEditorPanelLogical(this.mainFrame, this.madeFrom);
        this.dataSourceAliasePanel = new DataSourceAliasePanel(this.mainFrame, this.madeFrom);
        this.jbInit();
    }

    protected void jbInit() {
        this.theTabbedPane.removeAll();
        if (this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 5) {
            this.jmsPanel.setLayout(new BorderLayout());
            this.jmsPanel.add((Component)this.jmsTabbedPane, "Center");
            this.jmsTabbedPane.addTab("Factories", (Component)this.jmsFactPanel);
            this.jmsTabbedPane.addTab("Destinations", (Component)this.jmsDestPanel);
            this.logControlerPanel.setAdvancedMode(true);
            this.logControlerPanel.setChangeStatePossible(false);
            this.logControlerPanel.setResetToDefaultVisible(false);
            this.theTabbedPane.addTab("Descriptor", this.simplePanel);
            this.theTabbedPane.addTab("Log Configuration", (Component)this.logControlerPanel);
            this.theTabbedPane.addTab("JMS Connectivity", this.jmsPanel);
            this.theTabbedPane.addTab("DataSource", this.propsEditorPanel);
            this.theTabbedPane.addTab("DataSource Aliases", this.dataSourceAliasePanel);
        } else {
            this.theTabbedPane = this.simplePanel.getTheTab();
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.theTabbedPane, "Center");
    }

    public String getDisplayName() {
        return this.simplePanel.getDisplayName();
    }

    public void init(int madeFromConstant) {
        this.theTabbedPane.removeAll();
        if (this.madeFrom != 3 && madeFromConstant == 3 || this.madeFrom != 5 && madeFromConstant == 5 || this.madeFrom != 4 && madeFromConstant == 4) {
            this.theTabbedPane.addTab("Descriptor", this.simplePanel);
            this.theTabbedPane.addTab("Log Configuration", (Component)this.logControlerPanel);
            this.theTabbedPane.addTab("JMS Connectivity", this.jmsPanel);
            this.theTabbedPane.addTab("DataSource", this.propsEditorPanel);
            this.theTabbedPane.addTab("DataSource Aliases", this.dataSourceAliasePanel);
        } else {
            this.theTabbedPane = this.simplePanel.getTheTab();
        }
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        this.simplePanel.clear();
        this.logControlerPanel.clear();
        this.jmsFactPanel.clear();
        this.jmsDestPanel.clear();
        this.propsEditorPanel.clear();
        this.dataSourceAliasePanel.clear();
    }

    public int isCorrect() {
        int isCorrectIndex = this.simplePanel.isCorrect();
        if (this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 5) {
            int secondIndex = this.logControlerPanel.isCorrect();
            if (isCorrectIndex < secondIndex) {
                isCorrectIndex = secondIndex;
            }
            if (isCorrectIndex < (secondIndex = this.jmsFactPanel.isCorrect())) {
                isCorrectIndex = secondIndex;
            }
            if (isCorrectIndex < (secondIndex = this.jmsDestPanel.isCorrect())) {
                isCorrectIndex = secondIndex;
            }
            if (isCorrectIndex < (secondIndex = this.propsEditorPanel.isCorrect())) {
                isCorrectIndex = secondIndex;
            }
            if (isCorrectIndex < (secondIndex = this.dataSourceAliasePanel.isCorrect())) {
                isCorrectIndex = secondIndex;
            }
        }
        return isCorrectIndex;
    }

    public void commitChange() {
        this.simplePanel.commitChange();
        if (this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 5) {
            this.logControlerPanel.commitChange();
            this.jmsFactPanel.commitChange();
            this.jmsDestPanel.commitChange();
            this.propsEditorPanel.commitChange();
            this.dataSourceAliasePanel.commitChange();
            this.descriptor.setlogConfiguration(this.logControlerPanel.getDescriptor());
            if (this.descriptor.getJMSConnector() == null) {
                this.descriptor.setJMSConnector(new JMSConnectorDescriptor());
            }
            this.descriptor.getJMSConnector().setFactories(this.jmsFactPanel.getFactories());
            this.descriptor.getJMSConnector().setDestinations(this.jmsDestPanel.getDestinations());
        }
    }

    public void setDescriptor(EARDescriptor descr) {
        this.descriptor = descr;
        this.simplePanel.setDescriptor(this.descriptor);
        if (this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 5) {
            if (this.descriptor != null) {
                this.logControlerPanel.setDescriptor(this.descriptor.getlogConfiguration(), null, null);
            }
            this.jmsFactPanel.setDescriptor(this.descriptor.getJMSConnector());
            this.jmsDestPanel.setDestinations(this.descriptor.getJMSConnector() == null ? null : this.descriptor.getJMSConnector().getDestinations());
            this.propsEditorPanel.setDescriptor(this.descriptor);
            this.dataSourceAliasePanel.setDescriptor(this.descriptor);
        }
    }

    public void setContext(RemoteSecurity node) {
        this.simplePanel.setContext(node);
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setLoader(ClassLoader loader) {
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider _appProvider) {
        if (this.simplePanel != null) {
            this.simplePanel.setApplicationInformationProvider(_appProvider);
        }
        if (this.jmsFactPanel != null) {
            this.jmsFactPanel.setApplicationInformationProvider(_appProvider);
        }
        if (this.jmsDestPanel != null) {
            this.jmsDestPanel.setApplicationInformationProvider(_appProvider);
        }
        if (this.propsEditorPanel != null) {
            this.propsEditorPanel.setApplicationInformationProvider(_appProvider);
        }
        if (this.dataSourceAliasePanel != null) {
            this.dataSourceAliasePanel.setApplicationInformationProvider(_appProvider);
        }
        this.appProvider = _appProvider;
    }

    public void setDisplayName(String displayName) {
        this.simplePanel.setDisplayName(displayName);
    }

    public AdditionalPanelLogical getAdditionalPanelLogical() {
        return this.simplePanel.getAdditionalPanelLogical();
    }
}

