/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.ear;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.SimpleListPanel;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.extended.ear.EARDescriptor;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import com.sap.engine.services.deploy.gui.common.additional.ListRenderer;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataSourceAliasePanel
extends BasicPanelView
implements ActionListener,
DocumentListener,
ListSelectionListener,
Runnable {
    public static final String ADD_CMD = "ADD_CMD";
    public static final String REMOVE_CMD = "REMOVE_CMD";
    public static final String CLEAR_CMD = "CLEAR_CMD";
    public static final String MODIFY_CMD = "MODIFY_CMD";
    private EARDescriptor descr = null;
    private int lastSelected = -1;
    private boolean selectWithMouse = true;
    private boolean setText = false;
    private int madeFrom = 0;
    private ErrorReportObject errorOblect = null;
    private ApplicationInformationProvider appProvider = null;
    private JTextField nameTextField = new JTextField();
    private SimpleListPanel aliasePanel = new SimpleListPanel("Aliases");
    private DefaultListModel listModel = new DefaultListModel();
    private JList theList = new JList(this.listModel);
    private JButton addButton = new JButton();
    private JButton removeButton = new JButton();
    private JButton clearButton = new JButton();
    private JButton modifyButton = new JButton();

    public DataSourceAliasePanel(Frame mainFrame, int madeFrom) {
        this.mainFrame = mainFrame;
        this.madeFrom = madeFrom;
        this.init();
    }

    private void init() {
        JLabel nameLabel = new JLabel("Name: ");
        JSplitPane mainSplitPane = new JSplitPane();
        JPanel listPanel = new JPanel();
        JScrollPane listScrollPane = new JScrollPane();
        JPanel valuesPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        this.nameTextField.getDocument().addDocumentListener(this);
        this.addButton.setText(GuiSettings.getResourceString("Add_Button", "Add"));
        this.addButton.addActionListener(this);
        this.addButton.setActionCommand(ADD_CMD);
        this.removeButton.setText(GuiSettings.getResourceString("Remove_Button", "Remove"));
        this.removeButton.addActionListener(this);
        this.removeButton.setActionCommand(REMOVE_CMD);
        this.clearButton.setText(GuiSettings.getResourceString("Clear_Button", "Clear"));
        this.clearButton.addActionListener(this);
        this.clearButton.setActionCommand(CLEAR_CMD);
        this.modifyButton.setText(GuiSettings.getResourceString("Modify_Button", "Modify"));
        this.modifyButton.addActionListener(this);
        this.modifyButton.setActionCommand(MODIFY_CMD);
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add((Component)this.addButton, null);
        buttonPanel.add((Component)this.modifyButton, null);
        buttonPanel.add((Component)this.removeButton, null);
        buttonPanel.add((Component)this.clearButton, null);
        this.theList.setSelectionMode(0);
        this.theList.addListSelectionListener(this);
        this.theList.setCellRenderer(new ListRenderer());
        valuesPanel.setLayout(new GridBagLayout());
        int i = 1;
        valuesPanel.add((Component)nameLabel, new GridBagConstraints(0, i++, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        int j = 1;
        valuesPanel.add((Component)this.nameTextField, new GridBagConstraints(2, j++, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        valuesPanel.add((Component)this.aliasePanel, new GridBagConstraints(1, j++, 2, 1, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        valuesPanel.add((Component)buttonPanel, new GridBagConstraints(1, j++, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        listPanel.setLayout(new BorderLayout());
        listPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Data Source Aliases"));
        listScrollPane.getViewport().add((Component)this.theList, null);
        listPanel.add((Component)listScrollPane, "Center");
        mainSplitPane.setDividerLocation(200);
        mainSplitPane.add((Component)listPanel, "left");
        mainSplitPane.add((Component)valuesPanel, "right");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
        this.add((Component)mainSplitPane, "Center");
        this.addButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        if (this.selectWithMouse) {
            this.setText = true;
            this.nameTextField.setText("");
            this.setText = false;
        }
        this.aliasePanel.initList(new String[0]);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
        this.theList.clearSelection();
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        if (this.descr != null) {
            Hashtable hash = null;
            Hashtable value = null;
            String key = null;
            int i = 0;
            while (i < this.listModel.size()) {
                value = ((ListValues)this.listModel.elementAt(i)).getDataSourceAliases();
                if (value != null) {
                    key = this.getName(value);
                    if (hash == null) {
                        hash = new Hashtable();
                    }
                    hash.put(key, value.get(key));
                }
                ++i;
            }
            this.descr.setDataSourceAliase(hash);
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public ErrorReportObject getErrorObject() {
        return this.errorOblect;
    }

    public void proccessErrors(ErrorReportObject errObj) {
        this.errorOblect = errObj;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setDescriptor(EARDescriptor _descr) {
        Hashtable hash;
        this.descr = _descr;
        this.listModel.clear();
        if (this.descr != null && (hash = this.descr.getDataSourceAliase()) != null) {
            Enumeration enumeration = hash.keys();
            String key = null;
            String[] aliases = null;
            Hashtable<String, String[]> temp = null;
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                aliases = (String[])hash.get(key);
                if (aliases == null) {
                    aliases = new String[]{};
                }
                temp = new Hashtable<String, String[]>();
                temp.put(key, aliases);
                this.listModel.addElement(this.getListValue(temp));
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(REMOVE_CMD)) {
            this.deleteActionPerformed();
            this.clear();
        } else if (cmd.equals(CLEAR_CMD)) {
            this.clearActionPerformed();
        } else if (cmd.equals(ADD_CMD)) {
            this.addActionPerformed();
        } else if (cmd.equals(MODIFY_CMD)) {
            this.modifyActionPerformed();
        }
    }

    public void modifyActionPerformed() {
        Hashtable panelDescr = this.getDataSourceAliasesFromFields(true);
        if (!this.theList.isSelectionEmpty() && panelDescr != null && !((ListValues)this.theList.getSelectedValue()).getDataSourceAliases().equals(panelDescr)) {
            ((ListValues)this.theList.getSelectedValue()).setDataSourceAliases(panelDescr);
            this.clear();
        }
    }

    public void addActionPerformed() {
        Hashtable panelDescr;
        if (!this.containsInModel(this.nameTextField.getText()) && (panelDescr = this.getDataSourceAliasesFromFields(true)) != null) {
            this.listModel.addElement(this.getListValue(panelDescr));
            this.clear();
        }
    }

    public void deleteActionPerformed() {
        if (!this.theList.isSelectionEmpty()) {
            this.lastSelected = -1;
            this.listModel.remove(this.theList.getSelectedIndex());
        }
    }

    private void clearActionPerformed() {
        this.clear();
    }

    private boolean containsInModel(String logName) {
        int i = 0;
        while (i < this.listModel.size()) {
            String name = this.getName(((ListValues)this.listModel.getElementAt(i)).getDataSourceAliases());
            if (name != null && name.equalsIgnoreCase(logName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ListValues getListValue(Hashtable dataSourceAliases) {
        return new ListValues(dataSourceAliases, 21);
    }

    private Hashtable getDataSourceAliasesFromFields(boolean flag) {
        Hashtable<String, String[]> hash = null;
        String[] arr = this.aliasePanel.getListDataArray();
        if (!this.nameTextField.getText().trim().equals("") && arr != null) {
            hash = new Hashtable<String, String[]>();
            hash.put(this.nameTextField.getText().trim(), arr);
        } else if (arr == null && flag) {
            JOptionPane.showMessageDialog(this.mainFrame, "Each data source alias must have at least one defined alias.", "WARNING", 2);
        }
        return hash;
    }

    private void setDataSourceAliasesFromFields(Hashtable table) {
        String name;
        if (table != null && (name = this.getName(table)) != null) {
            if (this.selectWithMouse) {
                this.setText = true;
                this.nameTextField.setText(name);
                this.setText = false;
            }
            this.aliasePanel.initList((String[])table.get(name));
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        String name;
        this.checkEnable();
        this.modifyButton.setEnabled(true);
        this.clearButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        Hashtable oldDataSourceAliase = null;
        if (this.lastSelected >= 0 && this.lastSelected < this.listModel.size()) {
            oldDataSourceAliase = ((ListValues)this.listModel.elementAt(this.lastSelected)).getDataSourceAliases();
        }
        Hashtable newDataSourceAliase = this.getDataSourceAliasesFromFields(false);
        if (oldDataSourceAliase != null && newDataSourceAliase != null && (name = this.getName(newDataSourceAliase)) != null && !name.trim().equals("") && this.getName(oldDataSourceAliase).equals(name) && !EqualUtils.equalHashtableObjectToUnOrderedObjectArray((Hashtable)oldDataSourceAliase, (Hashtable)newDataSourceAliase)) {
            Object[] options = new Object[]{"Yes", "No"};
            int result = JOptionPane.showOptionDialog(this.mainFrame, "The data source aliase " + this.getName(oldDataSourceAliase) + " " + "has been changed. Do you want to commit these changes?", "Warning", -1, 2, null, options, options[0]);
            if (result == 0) {
                ((ListValues)this.listModel.elementAt(this.lastSelected)).setDataSourceAliases(newDataSourceAliase);
            }
        }
        if (!this.theList.isSelectionEmpty()) {
            this.setDataSourceAliasesFromFields(((ListValues)this.theList.getSelectedValue()).getDataSourceAliases());
        } else {
            this.clear();
        }
        this.lastSelected = this.theList.getSelectedIndex();
    }

    private String getName(Hashtable table) {
        Enumeration enumeration;
        String name = null;
        if (table != null && (enumeration = table.keys()).hasMoreElements()) {
            name = (String)enumeration.nextElement();
        }
        return name;
    }

    public void insertUpdate(DocumentEvent e) {
        SwingUtilities.invokeLater(this);
    }

    public void removeUpdate(DocumentEvent e) {
        SwingUtilities.invokeLater(this);
    }

    public void changedUpdate(DocumentEvent e) {
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    private void checkDisabled() {
        String target = this.nameTextField.getText();
        this.checkEnable();
        this.selectWithMouse = false;
        boolean toAdd = true;
        this.theList.clearSelection();
        int i = 0;
        while (i < this.listModel.size()) {
            String name = this.getName(((ListValues)this.listModel.getElementAt(i)).getDataSourceAliases());
            if (target.equals(name)) {
                toAdd = false;
                this.theList.setSelectedValue(this.listModel.elementAt(i), true);
                break;
            }
            ++i;
        }
        if (target.trim().length() != 0) {
            if (toAdd) {
                this.addButton.setEnabled(true);
                this.modifyButton.setEnabled(false);
                this.clearButton.setEnabled(true);
                this.removeButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(true);
                this.clearButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
        } else {
            this.addButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        this.selectWithMouse = true;
    }

    private void checkEnable() {
        this.nameTextField.setEnabled(true);
        if (this.nameTextField.getText() != null && this.nameTextField.getText().trim().length() != 0) {
            this.aliasePanel.setEnabled(true);
        } else {
            this.aliasePanel.setEnabled(false);
        }
    }
}

