/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.ear;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.ear.SimpleEarDescriptor;
import com.sap.engine.services.deploy.ear.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.deploy.gui.CClassPathPanel;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ApplicationAdditonalPanel
extends BasicPanelView
implements DocumentListener,
Runnable {
    private int madeFrom = 3;
    private JTextField providerTextField = null;
    private JComboBox failOverCombo = new JComboBox();
    private CClassPathPanel pathPanel = null;
    private SimpleEarDescriptor descr = null;
    private String[] forbiddenAtAll = new String[]{"/", "@", "\\", ":", "*", "?", "\"", "<", ">", "|"};
    private String[] forbiddenForEnd = new String[]{"."};
    private boolean isCorrect = false;
    private Vector indexes = new Vector();
    private String errors = "";

    public ApplicationAdditonalPanel(Frame mainFrame, int madeFromConstant) {
        this.mainFrame = mainFrame;
        this.madeFrom = madeFromConstant;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
        JLabel providerLabel = new JLabel("Provider: ");
        JLabel failOverLable = new JLabel("Failover: ");
        this.providerTextField = new JTextField();
        this.providerTextField.getDocument().addDocumentListener(this);
        this.failOverCombo = new JComboBox<String>(new String[]{"disable", "on_request", "on_attribute"});
        this.pathPanel = new CClassPathPanel(this.mainFrame);
        this.pathPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Additional Classpath"));
        int y = 1;
        this.add((Component)providerLabel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        int i = 0;
        this.add((Component)this.providerTextField, new GridBagConstraints(2, i++, 1, 2, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)failOverLable, new GridBagConstraints(1, ++i, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.failOverCombo, new GridBagConstraints(2, i++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.pathPanel, new GridBagConstraints(1, i++, 3, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setDescriptor(new SimpleEarDescriptor());
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        this.setDescriptor(new SimpleEarDescriptor());
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        if (this.descr != null) {
            String provider = this.providerTextField.getText().trim();
            if (provider.equals(new SimpleEarDescriptor().getProviderName())) {
                provider = null;
            }
            this.descr.setProviderName(provider);
            try {
                this.descr.setFailOverValue((String)this.failOverCombo.getSelectedItem());
            }
            catch (BaseIllegalArgumentException biae) {
                JOptionPane.showMessageDialog(this.mainFrame, biae.toString(), "ERROR", 0);
            }
            this.descr.setClassPath(this.getStringFromVector(this.pathPanel.getClassPath()));
        }
    }

    private String getStringFromVector(Vector vec) {
        String str = "";
        int i = 0;
        while (i < vec.size()) {
            str = str + (String)vec.elementAt(i) + ";";
            ++i;
        }
        return str;
    }

    private String[] getStringArrayFromString(String classPath) {
        StringTokenizer strToken;
        Vector<String> pathsVector = null;
        if (classPath != null && (strToken = new StringTokenizer(classPath, File.pathSeparator)) != null) {
            pathsVector = new Vector<String>();
            while (strToken.hasMoreTokens()) {
                String temp = strToken.nextToken();
                pathsVector.addElement(temp);
            }
        }
        String[] pathsArray = null;
        if (pathsVector != null) {
            pathsArray = new String[pathsVector.size()];
            int i = 0;
            while (i < pathsVector.size()) {
                pathsArray[i] = (String)pathsVector.elementAt(i);
                ++i;
            }
        }
        return pathsArray;
    }

    public void setLoader(ClassLoader loader) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return null;
    }

    public void setDescriptor(SimpleEarDescriptor descr) {
        this.descr = descr;
        if (descr != null) {
            String provider = descr.getProviderName();
            if (provider == null) {
                provider = new SimpleEarDescriptor().getProviderName();
            }
            this.providerTextField.setText(provider);
            this.failOverCombo.setSelectedItem(descr.getFailOverValue());
            this.pathPanel.setClasspath(this.getStringArrayFromString(descr.getClassPath()));
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.isCorrect) {
            this.documentAction(e);
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.isCorrect) {
            this.documentAction(e);
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.isCorrect) {
            this.documentAction(e);
        }
    }

    private void documentAction(DocumentEvent e) {
        String providerChangedName = this.providerTextField.getText();
        String endErrorMessage = "";
        this.indexes = new Vector();
        this.errors = "";
        int i = 0;
        while (i < this.forbiddenForEnd.length) {
            if (providerChangedName.endsWith(this.forbiddenForEnd[i])) {
                if (!endErrorMessage.trim().equals("")) {
                    endErrorMessage = endErrorMessage + ", ";
                }
                endErrorMessage = endErrorMessage + this.forbiddenForEnd[i];
                this.indexes.add(new Integer(providerChangedName.length() - 1));
            }
            ++i;
        }
        if (!endErrorMessage.trim().equals("")) {
            endErrorMessage = "There is a forbidden symbol at the end of the provider name: " + endErrorMessage;
        }
        String allErrorMessage = "";
        if (!e.getType().equals(DocumentEvent.EventType.REMOVE) && providerChangedName != null) {
            int index = -1;
            int i2 = 0;
            while (i2 < this.forbiddenAtAll.length) {
                index = providerChangedName.indexOf(this.forbiddenAtAll[i2]);
                if (index != -1) {
                    if (!allErrorMessage.trim().equals("")) {
                        allErrorMessage = allErrorMessage + ", ";
                    }
                    allErrorMessage = allErrorMessage + this.forbiddenAtAll[i2];
                    this.indexes.add(new Integer(index));
                }
                ++i2;
            }
        }
        if (!allErrorMessage.trim().equals("")) {
            allErrorMessage = "There are forbidden symbols in the provider name: " + allErrorMessage;
        }
        if (!endErrorMessage.trim().equals("")) {
            endErrorMessage = endErrorMessage + "\n";
        }
        this.errors = endErrorMessage + allErrorMessage;
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        String providerChangedName = this.providerTextField.getText();
        String correctProviderName = "";
        if (this.errors != null && !this.errors.trim().equals("")) {
            JOptionPane.showMessageDialog(this.mainFrame, this.errors + "\nThis symblo(s) will be removed.", "WARNING", 2);
            int i = 0;
            while (i < providerChangedName.length()) {
                if (!this.indexes.contains(new Integer(i))) {
                    correctProviderName = correctProviderName + providerChangedName.charAt(i) + "";
                }
                ++i;
            }
            providerChangedName = correctProviderName;
        }
        this.isCorrect = true;
        this.providerTextField.setText(providerChangedName);
        this.isCorrect = false;
    }
}

