/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common.additional;

import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.gui.common.additional.SecurityUserObject;
import com.sap.engine.services.ejb.deploy.descriptors.AccessControls;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class SecurityTreeNode
extends DefaultMutableTreeNode {
    private String name = null;
    private MethodEntry method = null;
    private SecurityRoles role = null;
    private SecurityRoleReference refSecRole = null;
    private AccessControls access = null;
    private RunAsIdentity runAs = null;
    private boolean excludedNode = false;
    private static final int CMP_ENTITY_EJB = 1;
    private static final int SESSION_EJB = 2;
    private static final int MESSAGE_DRIVEN_EJB = 3;
    private int ejbType = -1;
    private boolean hasBeanIsoLevel = false;
    private int userSID;

    public SecurityTreeNode(MethodEntry theEntry, int methodType) {
        this.method = theEntry;
        this.name = theEntry != null ? (theEntry.isMethodSpecified() ? this.methodToString(theEntry) : (theEntry.getMethodName() != null ? theEntry.getMethodName() : "Root")) : "Root";
        this.setUserObject(new SecurityUserObject(this.name, methodType));
        this.role = null;
    }

    public SecurityTreeNode(RunAsIdentity identity, int type) {
        this.runAs = identity;
        if (this.runAs != null) {
            this.name = identity.getComponentName();
            this.setUserObject(new SecurityUserObject(this.name, type));
        }
    }

    public SecurityTreeNode(AccessControls theControl, int type) {
        this.access = theControl;
        if (theControl != null) {
            this.method = theControl.getMethod();
            this.name = this.method != null ? (theControl.getMethod().isMethodSpecified() ? this.methodToString(this.method) : "Root") : "Root";
        } else {
            this.name = "Root";
        }
        this.setUserObject(new SecurityUserObject(this.name, type));
        this.role = null;
    }

    public SecurityTreeNode(SecurityRoles theRole, int type) {
        this.role = theRole;
        this.name = theRole != null && theRole.getRoleName() != null ? theRole.getRoleName() : "Security Role";
        this.setUserObject(new SecurityUserObject(this.name, type));
        this.method = null;
    }

    public SecurityTreeNode(SecurityRoleReference theReference, int type) {
        this.refSecRole = theReference;
        this.name = theReference != null && theReference.getRoleName() != null ? theReference.getRoleName() : "Security Role Reference";
        this.setUserObject(new SecurityUserObject(this.name, type));
        this.method = null;
    }

    public SecurityTreeNode(int SID, String name, int type) {
        this.userSID = SID;
        this.name = name;
        if (name == null) {
            this.name = "Unknown User";
        }
        this.setUserObject(new SecurityUserObject(name, type));
        this.method = null;
        this.role = null;
        this.access = null;
    }

    public SecurityTreeNode(String theRole, int type) {
        this.name = theRole;
        this.setUserObject(new SecurityUserObject(this.name, type));
        this.method = null;
        this.role = null;
    }

    public String getName() {
        return ((SecurityUserObject)this.getUserObject()).getName();
    }

    public void setName(String newName) {
        this.name = newName;
        ((SecurityUserObject)this.getUserObject()).setName(newName);
    }

    public MethodEntry getMethodEntry() {
        return this.method;
    }

    public SecurityRoles getSecurityRole() {
        return this.role;
    }

    public SecurityRoleReference getSecurityRoleReference() {
        return this.refSecRole;
    }

    public void setSecurityRole(SecurityRoles newRole) {
        this.role = newRole;
        if (this.role != null) {
            this.setName(this.role.getRoleName());
        }
    }

    public void setSecurityRoleReference(SecurityRoleReference newRef) {
        this.refSecRole = newRef;
    }

    public void setAccessControls(AccessControls theControl) {
        this.access = theControl;
    }

    public AccessControls getAccessControls() {
        return this.access;
    }

    public void setIdentity(int userSID) {
        this.userSID = userSID;
    }

    public int getIdentity() {
        return this.userSID;
    }

    public Vector getNames(String[] names) {
        Vector<String> res = new Vector<String>();
        int depth = 0;
        String temp = "";
        int i = 0;
        while (i < names.length) {
            temp = names[i];
            while (temp.startsWith("[")) {
                temp = temp.substring(1);
                ++depth;
            }
            if (temp.startsWith("L")) {
                temp = temp.substring(1, temp.length() - 1);
            }
            if (depth > 0) {
                int j = 0;
                while (j < depth) {
                    temp = temp + "[]";
                    ++j;
                }
            }
            if (temp != null && !temp.equals("")) {
                res.addElement(temp);
            }
            temp = "";
            depth = 0;
            ++i;
        }
        return res;
    }

    public String methodToString(MethodEntry method) {
        Vector arguments = this.getNames(method.getParameters());
        String args = "";
        int i = 0;
        while (i < arguments.size()) {
            args = i < arguments.size() - 1 ? args + arguments.elementAt(i) + ", " : args + arguments.elementAt(i);
            ++i;
        }
        return method.getMethodName() + "(" + args + ")";
    }

    public String toString() {
        return this.name;
    }

    public boolean isExcludedNode() {
        return this.excludedNode;
    }

    public void setExcludedNode(boolean excludedNode) {
        this.excludedNode = excludedNode;
    }

    public boolean hasBeanIsoLevel() {
        return this.hasBeanIsoLevel;
    }

    public void setBeanIsoLevel(boolean hasBeanIsoLevel) {
        this.hasBeanIsoLevel = hasBeanIsoLevel;
    }

    public boolean isCmpBean() {
        return this.ejbType == 1;
    }

    public void setCmpBean() {
        this.ejbType = 1;
    }

    public boolean isMDBean() {
        return this.ejbType == 3;
    }

    public void setMDBean() {
        this.ejbType = 3;
    }

    public boolean isSessBean() {
        return this.ejbType == 2;
    }

    public void setSessBean() {
        this.ejbType = 2;
    }

    public RunAsIdentity getRunAs() {
        return this.runAs;
    }
}

