/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.gui.UserNode;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import com.sap.engine.services.deploy.gui.common.additional.SecurityTreeNode;
import com.sap.engine.services.deploy.gui.common.additional.UsersTreeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UsersPanel
extends JPanel
implements TreeSelectionListener {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane idScrollPane = new JScrollPane();
    private JTree identityTree = new JTree();
    private SecurityTreeNode root = new SecurityTreeNode(Integer.MIN_VALUE, "NoConnection", 10);
    private Border eatchedBorder = BorderFactory.createEtchedBorder();
    private TitledBorder titledBorder3 = BorderFactory.createTitledBorder(this.eatchedBorder, GuiSettings.getResourceString("Users_border", "Users on Server"));
    private UserNode node;

    public UsersPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(this.borderLayout1);
        this.idScrollPane.setBorder(this.titledBorder3);
        this.add((Component)this.idScrollPane, "Center");
        this.idScrollPane.getViewport().add((Component)this.identityTree, null);
        this.identityTree.getSelectionModel().setSelectionMode(1);
        ((DefaultTreeModel)this.identityTree.getModel()).setRoot(this.root);
        this.identityTree.setCellRenderer(new UsersTreeRenderer());
        this.identityTree.addTreeSelectionListener(this);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelListener) {
        this.identityTree.addTreeSelectionListener(treeSelListener);
    }

    public void valueChanged(TreeSelectionEvent e) {
    }

    public int getSelectedId() {
        return this.getSelectedNode().getIdentity();
    }

    public void init(UserNode node) {
        this.node = node;
        if (node == null) {
            this.root = new SecurityTreeNode(Integer.MIN_VALUE, "NoConnection", 10);
            ((DefaultTreeModel)this.identityTree.getModel()).setRoot(this.root);
            return;
        }
        this.root = new SecurityTreeNode(node.getSID(), node.getName(), 10);
        this.initTree(node, this.root);
        ((DefaultTreeModel)this.identityTree.getModel()).setRoot(this.root);
    }

    public SecurityTreeNode getSelectedNode() {
        TreePath selPath = this.identityTree.getSelectionPath();
        if (selPath != null) {
            return (SecurityTreeNode)selPath.getLastPathComponent();
        }
        return null;
    }

    protected void initTree(UserNode node, SecurityTreeNode treeNode) {
        UserNode[] children = null;
        SecurityTreeNode tempNode = null;
        if (this.root == null) {
            return;
        }
        children = node.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (children[i].isUser()) {
                    tempNode = new SecurityTreeNode(children[i].getSID(), children[i].getName(), 9);
                    treeNode.add(tempNode);
                } else {
                    tempNode = new SecurityTreeNode(children[i].getSID(), children[i].getName(), 10);
                    treeNode.add(tempNode);
                    this.initTree(children[i], tempNode);
                }
                ++i;
            }
        }
    }

    public String findUser(int sid) {
        String res = "Unknown User";
        SecurityTreeNode tempNode = null;
        Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            tempNode = (SecurityTreeNode)enumeration.nextElement();
            if (tempNode.getIdentity() != sid) continue;
            return tempNode.toString();
        }
        return res;
    }

    public int findUser(String name) {
        int res = Integer.MIN_VALUE;
        SecurityTreeNode tempNode = null;
        Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            tempNode = (SecurityTreeNode)enumeration.nextElement();
            if (!tempNode.toString().equals(name)) continue;
            return tempNode.getIdentity();
        }
        return res;
    }

    public String[] getUsersFromGroup(String name) {
        Vector<String> res = new Vector<String>();
        Vector<UserNode> groups = new Vector<UserNode>();
        groups.add(this.node);
        UserNode group = this.findNode(name, groups);
        if (group == null) {
            return new String[0];
        }
        groups = new Vector();
        groups.add(group);
        while (groups.size() != 0) {
            UserNode[] children = ((UserNode)groups.remove(0)).getChildren();
            int size = children.length;
            UserNode temp = null;
            int i = 0;
            while (i < size) {
                temp = children[i];
                if (temp.isUser()) {
                    res.add(temp.getName());
                } else {
                    groups.add(temp);
                }
                ++i;
            }
        }
        Object[] users = new String[res.size()];
        if (res.size() != 0) {
            res.copyInto(users);
        }
        return users;
    }

    /*
     * Unable to fully structure code
     */
    private UserNode findNode(String name, Vector groups) {
        if (name != null) ** GOTO lbl18
        return null;
lbl-1000:
        // 1 sources

        {
            temp = (UserNode)groups.remove(0);
            if (name.equals(temp.getName())) {
                return temp;
            }
            children = temp.getChildren();
            size = children.length;
            i = 0;
            while (i < size) {
                temp = children[i];
                if (!temp.isUser()) {
                    if (temp.getName().equals(name)) {
                        return temp;
                    }
                    groups.add(temp);
                }
                ++i;
            }
lbl18:
            // 2 sources

            ** while (groups.size() != 0)
        }
lbl19:
        // 1 sources

        return null;
    }

    public void updateLook_Feel() {
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void clear() {
        this.node = null;
        ((SecurityTreeNode)this.identityTree.getModel().getRoot()).removeAllChildren();
    }

    public void clearTreeSelection() {
        this.identityTree.clearSelection();
    }

    public void setEnabled(boolean flag) {
        this.clearTreeSelection();
        this.identityTree.setEnabled(flag);
    }

    public boolean isSelectionEmty() {
        return this.identityTree.isSelectionEmpty();
    }
}

