/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.TreeUtils;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.UserMappingPanel;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import com.sap.engine.services.deploy.gui.common.additional.SecurityTreeNode;
import com.sap.engine.services.security.remote.RemoteGroupContext;
import com.sap.engine.services.security.remote.RemoteGroupInfo;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remote.RemoteUserContext;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UserMappingPanelLogical
extends UserMappingPanel {
    private SecurityTreeNode currentNode = null;
    private SecurityRoles[] roles = null;
    private RunAsIdentity[] identities = null;
    private boolean correct = true;
    private Vector incorrect = null;
    private SecurityTreeNode lastNode = null;
    private ApplicationInformationProvider appProvider;
    private boolean changeNow = false;
    private boolean userPanelAdded = false;
    private RemoteGroupContext groupContext = null;
    private RemoteUserContext userContext = null;

    public UserMappingPanelLogical() {
        this.userManagmentButton.setEnabled(false);
    }

    public UserMappingPanelLogical(Frame frame) {
        this.mainFrame = frame;
        this.userManagmentButton.setEnabled(false);
    }

    public void setSecurityInfo(SecurityRoles[] roles1, RunAsIdentity[] identities1) {
        this.roles = roles1;
        this.identities = identities1;
        this.initValues(this.roles, this.identities);
    }

    public void initValues(SecurityRoles[] roles1, RunAsIdentity[] identities1) {
        this.incorrect = new Vector();
        if (roles1 == null && identities1 != null && identities1.length != 0) {
            this.correct = false;
            return;
        }
        this.initValues(roles1);
        if (identities1 == null || identities1.length == 0) {
            return;
        }
        int size = identities1.length;
        RunAsIdentity identity = null;
        int i = 0;
        while (i < size) {
            identity = identities1[i];
            if (identity != null) {
                SecurityTreeNode parent = this.findRole(identity.getSecurityRoleName());
                if (parent == null) {
                    this.incorrect.add(identity);
                    this.correct = false;
                } else {
                    this.currentNode = identity.getComponentType() == 1 ? new SecurityTreeNode(identity, 13) : new SecurityTreeNode(identity, 14);
                    parent.add(this.currentNode);
                }
            }
            ++i;
        }
        TreeUtils.expandTree((JTree)this.rolesTree, (int)2);
    }

    public void initValues(SecurityRoles[] roles1) {
        Vector<ListValues> availableValues = new Vector<ListValues>();
        if (roles1 != null) {
            int size = roles1.length;
            int i = 0;
            while (i < size) {
                this.root.add(new SecurityTreeNode(roles1[i], 5));
                availableValues.addElement(new ListValues(roles1[i], 0));
                ++i;
            }
            this.rolesTree.setRootVisible(false);
            TreeUtils.expandTree((JTree)this.rolesTree, (int)1);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (this.changeNow) {
            return;
        }
        this.colectInformation();
        if (e.getSource() == this.rolesTree) {
            if (!this.rolesTree.isSelectionEmpty()) {
                this.lastNode = this.currentNode = this.getSelectedNode();
                RunAsIdentity runAs = this.currentNode.getRunAs();
                if (runAs != null) {
                    this.processRunAs(runAs);
                } else {
                    this.processSecurityRole();
                }
                this.serverSecRoleButton.setEnabled(true);
                this.userManagmentButton.setEnabled(true);
            } else {
                this.lastNode = null;
                this.addButton.setEnabled(false);
                this.selectedModel.removeAllElements();
                this.repaint();
                this.validate();
                this.serverSecRoleButton.setEnabled(false);
                this.userManagmentButton.setEnabled(false);
            }
        } else if (!this.isSelectionEmpty() && !this.rolesTree.isSelectionEmpty()) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
        this.mainSplitPane.setDividerLocation(200);
    }

    private void processSecurityRole() {
        this.mainSplitPane.add((Component)this.identityPanel, "right");
        SecurityRoles mainRole = this.currentNode.getSecurityRole();
        this.selectedModel.removeAllElements();
        if (mainRole.getServerRoleName() != null) {
            if (!this.userPanelAdded) {
                SecurityRoles role = new SecurityRoles();
                role.setServerRoleName(mainRole.getServerRoleName());
                this.selectedModel.addElement(new ListValues(role, 22));
            } else {
                this.serverSecRoleButton.setSelected(true);
            }
        } else if (mainRole.getUserGroup() != null || mainRole.getUserNames() != null) {
            if (this.userPanelAdded) {
                this.setMapped(mainRole);
            } else {
                this.userManagmentButton.setSelected(true);
            }
        }
    }

    private void processRunAs(RunAsIdentity runAs) {
        SecurityRoles role = ((SecurityTreeNode)this.currentNode.getParent()).getSecurityRole();
        String[] users = role.getUserNames();
        String[] groups = role.getUserGroup();
        this.runAsPanel.setUsersAndGroups(runAs.getUserName(), users, groups);
        this.mainSplitPane.add((Component)this.runAsPanel, "right");
    }

    private void colectInformation() {
        if (this.lastNode == null) {
            return;
        }
        RunAsIdentity runAs = this.lastNode.getRunAs();
        if (runAs != null) {
            runAs.setUserName(this.runAsPanel.getSelectedItem());
        } else {
            SecurityRoles role = this.lastNode.getSecurityRole();
            ListValues temp = null;
            int i = 0;
            while (i < this.selectedModel.size()) {
                temp = (ListValues)this.selectedModel.get(i);
                if (temp.getType() == 3) {
                    role.setUserName(temp.getName());
                } else if (temp.getType() == 4) {
                    role.setUserGroup(temp.getName());
                } else if (temp.getType() == 22) {
                    role.setServerRoleName(temp.getSecurityRole().getServerRoleName());
                    role.setUserGroups(null);
                    role.setUserNames(null);
                    return;
                }
                ++i;
            }
        }
    }

    private void setMapped(SecurityRoles role) {
        int i;
        String[] temp = role.getUserNames();
        int size = -1;
        this.selectedModel.removeAllElements();
        if (temp != null) {
            size = temp.length;
            i = 0;
            while (i < size) {
                this.selectedModel.addElement(new ListValues(temp[i], 3));
                ++i;
            }
        }
        if ((temp = role.getUserGroup()) != null) {
            size = temp.length;
            i = 0;
            while (i < size) {
                this.selectedModel.addElement(new ListValues(temp[i], 4));
                ++i;
            }
        }
    }

    private void concat(String[] first, Vector result) {
        if (first == null) {
            return;
        }
        boolean add = true;
        int size = first.length;
        String temp = null;
        int i = 0;
        while (i < size) {
            temp = first[i];
            add = true;
            if (temp != null) {
                int j = 0;
                while (j < result.size()) {
                    if (temp.equals(result.get(j))) {
                        add = false;
                        break;
                    }
                    ++j;
                }
                if (add) {
                    result.add(temp);
                }
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addAction();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeAction();
        }
    }

    private void changeToServerRole() {
        if (!this.userPanelAdded) {
            return;
        }
        this.identityPanel.remove((Component)this.userPanel);
        if (!this.isSelectionEmpty()) {
            this.changeNow = true;
            this.userPanel.clearSelection();
            this.changeNow = false;
        }
        this.selectedModel.removeAllElements();
        this.identityPanel.add((Component)this.serverRolesPanel, new GridBagConstraints(2, 0, 1, 1, 0.4, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.userPanelAdded = false;
        SecurityRoles roleMain = this.getSelectedNode().getSecurityRole();
        if (!this.rolesTree.isSelectionEmpty()) {
            SecurityRoles role = new SecurityRoles();
            role.setServerRoleName(roleMain.getServerRoleName());
            if (role.getServerRoleName() != null) {
                this.selectedModel.addElement(new ListValues(role, 22));
            }
        } else {
            this.serverSecRoleButton.setEnabled(false);
            this.userManagmentButton.setEnabled(false);
        }
        if (roleMain.getUserNames() != null || roleMain.getUserGroup() != null) {
            roleMain.setUserNames(null);
            roleMain.setUserGroups(null);
        }
    }

    private void changeToUserManagement() {
        if (this.userPanelAdded || this.rolesTree.isSelectionEmpty()) {
            return;
        }
        this.userPanelAdded = true;
        this.identityPanel.remove(this.serverRolesPanel);
        if (!this.serverSecRolesList.isSelectionEmpty()) {
            this.changeNow = true;
            this.serverSecRolesList.clearSelection();
            this.changeNow = false;
        }
        this.selectedModel.removeAllElements();
        this.identityPanel.add((Component)this.userPanel, new GridBagConstraints(2, 0, 1, 1, 0.4, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        if (!this.rolesTree.isSelectionEmpty()) {
            this.setMapped(this.getSelectedNode().getSecurityRole());
        }
        if (this.getSelectedNode().getSecurityRole().getServerRoleName() != null) {
            this.getSelectedNode().getSecurityRole().setServerRoleName(null);
        }
    }

    public void addAction() {
        if (this.userPanelAdded) {
            this.addActionUserNode();
        } else {
            this.addActionServerRole();
        }
        this.validate();
        this.repaint();
    }

    private void addActionUserNode() {
        Object node = this.userPanel.getSelectedUser();
        if (node == null) {
            return;
        }
        int type = -1;
        String name = "";
        try {
            if (node instanceof RemoteUserStoreInfo) {
                name = ((RemoteUserStoreInfo)node).getName();
                type = 3;
            } else if (node instanceof RemoteGroupInfo) {
                name = ((RemoteGroupInfo)node).getName();
                type = 4;
            }
        }
        catch (RemoteException re) {
            JOptionPane.showMessageDialog(this.mainFrame, re.toString(), "ERROR", 0);
            return;
        }
        ListValues listVal = null;
        int j = 0;
        while (j < this.selectedModel.size()) {
            if (((ListValues)this.selectedModel.elementAt(j)).getType() == type && ((ListValues)this.selectedModel.elementAt(j)).getName().equals(name)) {
                return;
            }
            ++j;
        }
        listVal = type == 4 ? new ListValues(0, name, 4) : new ListValues(0, name, 3);
        this.selectedModel.addElement(listVal);
        if (listVal != null && node != null) {
            SecurityRoles role = this.getSelectedNode().getSecurityRole();
            if (listVal.getType() == 3) {
                role.setUserSIDsElement(0);
                role.setUserName(name);
            } else if (listVal.getType() == 4) {
                role.setGroupSIDsElement(0);
                role.setUserGroup(name);
            }
        }
    }

    private void addActionServerRole() {
        int answer;
        SecurityRoles servRole = ((ListValues)this.serverSecRolesList.getSelectedValue()).getSecurityRole();
        ListValues listVal = new ListValues(servRole, 22);
        if (this.selectedModel.isEmpty()) {
            this.selectedModel.addElement(listVal);
        } else if (!this.selectedModel.get(0).equals(servRole) && (answer = JOptionPane.showConfirmDialog(this.mainFrame, "You can have only one server security role mapped to current security role.\n Do you want to replace current server security role with this?", "Security Role Mapping Warning", 0, 2)) == 0) {
            this.selectedModel.remove(0);
            this.selectedModel.addElement(listVal);
        }
        if (!this.rolesTree.isSelectionEmpty()) {
            SecurityRoles role = this.getSelectedNode().getSecurityRole();
            role.setServerRoleName(servRole.getServerRoleName());
            role.setUserGroups(null);
            role.setUserNames(null);
        } else {
            this.serverSecRoleButton.setEnabled(false);
            this.userManagmentButton.setEnabled(false);
        }
        this.serverSecRolesList.clearSelection();
    }

    public void removeAction() {
        int index = this.selectedList.getSelectedIndex();
        ListValues listVal = (ListValues)this.selectedModel.elementAt(index);
        this.selectedModel.removeElementAt(index);
        SecurityTreeNode node = this.getSelectedNode();
        if (listVal != null && node != null) {
            SecurityRoles role = node.getSecurityRole();
            if (listVal.getType() == 3) {
                role.removeUserSIDs(listVal.getIdentity());
                role.removeUserNames(listVal.getName());
            } else if (listVal.getType() == 4) {
                role.removeGroupSIDs(listVal.getIdentity());
                role.removeGroupNames(listVal.getName());
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.changeNow) {
            return;
        }
        if (this.selectedList.isSelectionEmpty()) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
        if (this.userManagmentButton.isSelected()) {
            if (!this.isSelectionEmpty() && !this.rolesTree.isSelectionEmpty()) {
                this.addButton.setEnabled(true);
            } else {
                this.addButton.setEnabled(false);
            }
            return;
        }
        if (this.serverSecRolesList.isSelectionEmpty()) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
    }

    protected SecurityTreeNode getSelectedNode() {
        TreePath selPath = this.rolesTree.getSelectionPath();
        if (selPath != null) {
            return (SecurityTreeNode)selPath.getLastPathComponent();
        }
        return null;
    }

    public void updateLook_Feel() {
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void setContext(RemoteSecurity remoteSecurity) {
        if (remoteSecurity == null) {
            this.userManagmentButton.setEnabled(false);
            this.userPanel.clear();
        } else {
            try {
                this.groupContext = remoteSecurity.getRemoteUserStoreFactory().getActiveUserStore().getGroupContext();
                this.userContext = remoteSecurity.getRemoteUserStoreFactory().getActiveUserStore().getUserContext();
                this.userPanel.init(remoteSecurity);
                this.userPanel.refresh(null);
            }
            catch (RemoteException re) {
                JOptionPane.showMessageDialog(this.mainFrame, re.toString(), "ERROR", 0);
                this.userManagmentButton.setEnabled(false);
            }
        }
        this.validate();
        this.repaint();
    }

    public void init(int madeFromConstant) {
    }

    public void initAvailableList(SecurityRoles[] roles1) {
        this.root.removeAllChildren();
        this.model.reload();
        this.setSecurityInfo(roles1, this.identities);
    }

    public RunAsIdentity[] getIdentities() {
        return this.identities;
    }

    public SecurityRoles[] getRoles() {
        return this.roles;
    }

    public void clear() {
        this.root.removeAllChildren();
        this.selectedModel.removeAllElements();
        this.userPanel.clear();
        this.roles = null;
        this.identities = null;
    }

    public int isCorrect() {
        int size = this.incorrect.size();
        if (size > 0) {
            String roles = new String("\n");
            int i = 0;
            while (i < size) {
                roles = roles + "     <" + ((RunAsIdentity)this.incorrect.get(i)).getSecurityRoleName() + ">";
                ++i;
            }
            return 1;
        }
        return 0;
    }

    public void commitChange() {
        this.roles = new SecurityRoles[this.root.getChildCount()];
        int i = 0;
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            this.roles[i] = ((SecurityTreeNode)enumeration.nextElement()).getSecurityRole();
            ++i;
        }
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
    }

    public void setLoader(ClassLoader loader) {
    }

    private SecurityTreeNode findRole(String name) {
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            this.currentNode = (SecurityTreeNode)enumeration.nextElement();
            if (!this.currentNode.getName().equals(name)) continue;
            return this.currentNode;
        }
        return null;
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.serverSecRoleButton) {
            if (this.serverSecRoleButton.isSelected() && this.userPanelAdded) {
                this.changeToServerRole();
            }
        } else if (e.getSource() == this.userManagmentButton && this.userManagmentButton.isSelected() && !this.userPanelAdded) {
            this.changeToUserManagement();
        }
        this.validate();
        this.repaint();
    }

    private boolean isSelectionEmpty() {
        return this.userPanel.getSelectedUser() == null;
    }
}

