/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.services.deploy.ApplicationInformation;
import com.sap.engine.services.deploy.DeployRuntimeControlInterface;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.ear.exceptions.BaseIOException;
import com.sap.engine.services.deploy.ear.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.deploy.gui.SFileChooser;
import com.sap.engine.services.deploy.gui.common.SingleFileUpdatePanel;
import com.sap.engine.services.deploy.gui.common.SingleFileUpdateTableModel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;

public class SingleFileUpdatePanelLogical
extends SingleFileUpdatePanel {
    protected Frame frame = null;
    private SFileChooser chooser;
    private Object informationProvider = null;
    private String[] containersWithSingle = null;
    private boolean isInvoked = false;
    private Hashtable container_FileNames = null;
    private Dialog parentDialog = null;

    public SingleFileUpdatePanelLogical() {
        ((JTextField)this.appNameComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent de) {
                this.doAction();
            }

            public void removeUpdate(DocumentEvent de) {
                this.doAction();
            }

            public void changedUpdate(DocumentEvent de) {
                this.doAction();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void doAction() {
                SingleFileUpdatePanelLogical.this.isInvoked = true;
                SingleFileUpdatePanelLogical.this.container_FileNames = null;
                String currentAppName = ((JTextField)SingleFileUpdatePanelLogical.this.appNameComboBox.getEditor().getEditorComponent()).getText().trim();
                if (currentAppName == null || currentAppName.trim().equals("")) {
                    SingleFileUpdatePanelLogical.this.clearPanel();
                    return;
                }
                try {
                    block7: {
                        try {
                            SingleFileUpdatePanelLogical.this.moduleComboBox.removeAllItems();
                            SingleFileUpdatePanelLogical.this.moduleComboBox.addItem("");
                            SingleFileUpdatePanelLogical.this.containerComboBox.removeAllItems();
                            SingleFileUpdatePanelLogical.this.containerComboBox.addItem("");
                            SingleFileUpdatePanelLogical.this.mappingComboBox.removeAllItems();
                            SingleFileUpdatePanelLogical.this.mappingComboBox.addItem("");
                            SingleFileUpdatePanelLogical.this.loadButton.setEnabled(false);
                            ApplicationInformation info = SingleFileUpdatePanelLogical.this.getApplicationInformation(currentAppName);
                            if (info == null) break block7;
                            SingleFileUpdatePanelLogical.this.container_FileNames = SingleFileUpdatePanelLogical.this.sort(info.getDeployedFileNames());
                            SingleFileUpdatePanelLogical.this.initContainersAndModuls(true, true);
                        }
                        catch (UndeclaredThrowableException ute) {
                            JOptionPane.showMessageDialog(SingleFileUpdatePanelLogical.this.frame, ute.toString(), "ERROR", 0);
                            if (SingleFileUpdatePanelLogical.this.parentDialog != null) {
                                ((Component)SingleFileUpdatePanelLogical.this.parentDialog).setVisible(false);
                            }
                            Object var5_5 = null;
                            SingleFileUpdatePanelLogical.this.isInvoked = false;
                            return;
                        }
                        catch (RemoteException re) {
                            JOptionPane.showMessageDialog(SingleFileUpdatePanelLogical.this.frame, re.toString(), "ERROR", 0);
                            Object var5_6 = null;
                            SingleFileUpdatePanelLogical.this.isInvoked = false;
                            return;
                        }
                    }
                    Object var5_4 = null;
                    SingleFileUpdatePanelLogical.this.isInvoked = false;
                    return;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    SingleFileUpdatePanelLogical.this.isInvoked = false;
                    throw throwable;
                }
            }
        });
        ((JTextField)this.moduleComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent de) {
                this.doAction();
            }

            public void removeUpdate(DocumentEvent de) {
                this.doAction();
            }

            public void changedUpdate(DocumentEvent de) {
                this.doAction();
            }

            private void doAction() {
                if (!SingleFileUpdatePanelLogical.this.isInvoked) {
                    SingleFileUpdatePanelLogical.this.isInvoked = true;
                    String module = SingleFileUpdatePanelLogical.this.moduleTextField.getText();
                    String container = ((JTextField)SingleFileUpdatePanelLogical.this.containerComboBox.getEditor().getEditorComponent()).getText();
                    if (container == null || container.trim().equals("")) {
                        if (module != null && !module.trim().equals("") && SingleFileUpdatePanelLogical.this.container_FileNames != null) {
                            SingleFileUpdatePanelLogical.this.containerComboBox.removeAllItems();
                            SingleFileUpdatePanelLogical.this.containerComboBox.addItem("");
                            SingleFileUpdatePanelLogical.this.mappingComboBox.removeAllItems();
                            SingleFileUpdatePanelLogical.this.mappingComboBox.addItem("");
                            SingleFileUpdatePanelLogical.this.loadButton.setEnabled(true);
                            if (SingleFileUpdatePanelLogical.this.containersWithSingle != null) {
                                String[] fileNames = null;
                                int i = 0;
                                while (i < SingleFileUpdatePanelLogical.this.containersWithSingle.length) {
                                    fileNames = (String[])SingleFileUpdatePanelLogical.this.container_FileNames.get(SingleFileUpdatePanelLogical.this.containersWithSingle[i]);
                                    if (this.findElement(module, fileNames) != -1) {
                                        SingleFileUpdatePanelLogical.this.containerComboBox.addItem(SingleFileUpdatePanelLogical.this.containersWithSingle[i]);
                                    }
                                    ++i;
                                }
                            }
                        } else {
                            SingleFileUpdatePanelLogical.this.loadButton.setEnabled(false);
                        }
                        if (SingleFileUpdatePanelLogical.this.containerComboBox.getModel().getSize() == 2) {
                            SingleFileUpdatePanelLogical.this.containerComboBox.setSelectedIndex(1);
                        }
                    } else if (module == null || module.trim().equals("")) {
                        SingleFileUpdatePanelLogical.this.initContainersAndModuls(true, false);
                    } else {
                        SingleFileUpdatePanelLogical.this.loadButton.setEnabled(true);
                        SingleFileUpdatePanelLogical.this.mappingComboBox.removeAllItems();
                        SingleFileUpdatePanelLogical.this.mappingComboBox.addItem("");
                    }
                    SingleFileUpdatePanelLogical.this.isInvoked = false;
                } else {
                    SingleFileUpdatePanelLogical.this.loadButton.setEnabled(true);
                }
            }

            private int findElement(String target, String[] source) {
                if (target != null && source != null) {
                    int i = 0;
                    while (i < source.length) {
                        if (source[i] != null && source[i].equals(target)) {
                            return i;
                        }
                        ++i;
                    }
                }
                return -1;
            }
        });
        ((JTextField)this.containerComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent de) {
                this.doAction();
            }

            public void removeUpdate(DocumentEvent de) {
                this.doAction();
            }

            public void changedUpdate(DocumentEvent de) {
                this.doAction();
            }

            private void doAction() {
                if (!SingleFileUpdatePanelLogical.this.isInvoked) {
                    SingleFileUpdatePanelLogical.this.isInvoked = true;
                    String module = SingleFileUpdatePanelLogical.this.moduleTextField.getText();
                    String container = ((JTextField)SingleFileUpdatePanelLogical.this.containerComboBox.getEditor().getEditorComponent()).getText();
                    if (module == null || module.trim().equals("")) {
                        if (container != null && !container.trim().equals("") && SingleFileUpdatePanelLogical.this.container_FileNames != null) {
                            SingleFileUpdatePanelLogical.this.moduleComboBox.removeAllItems();
                            SingleFileUpdatePanelLogical.this.moduleComboBox.addItem("");
                            String[] files = (String[])SingleFileUpdatePanelLogical.this.container_FileNames.get(container);
                            if (files != null) {
                                int i = 0;
                                while (i < files.length) {
                                    SingleFileUpdatePanelLogical.this.moduleComboBox.addItem(files[i]);
                                    ++i;
                                }
                            }
                        }
                        if (SingleFileUpdatePanelLogical.this.moduleComboBox.getModel().getSize() == 2) {
                            SingleFileUpdatePanelLogical.this.moduleComboBox.setSelectedIndex(1);
                        }
                    } else if (container == null || container.trim().equals("")) {
                        SingleFileUpdatePanelLogical.this.initContainersAndModuls(false, true);
                    } else {
                        SingleFileUpdatePanelLogical.this.loadButton.setEnabled(false);
                        SingleFileUpdatePanelLogical.this.mappingComboBox.removeAllItems();
                        SingleFileUpdatePanelLogical.this.mappingComboBox.addItem("");
                    }
                    SingleFileUpdatePanelLogical.this.isInvoked = false;
                }
            }
        });
        this.fileTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent de) {
                this.doAction();
            }

            public void removeUpdate(DocumentEvent de) {
                this.doAction();
            }

            public void changedUpdate(DocumentEvent de) {
                this.doAction();
            }

            private void doAction() {
                String fileName = SingleFileUpdatePanelLogical.this.fileTextField.getText();
                if (fileName != null) {
                    fileName = new File(fileName).getName();
                    int count = SingleFileUpdatePanelLogical.this.mappingComboBox.getModel().getSize();
                    String item = null;
                    int i = 0;
                    while (i < count) {
                        item = (String)SingleFileUpdatePanelLogical.this.mappingComboBox.getItemAt(i);
                        if (item != null && item.endsWith(fileName)) {
                            SingleFileUpdatePanelLogical.this.mappingComboBox.setSelectedIndex(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
        this.initButtons();
    }

    private void initContainersAndModuls(boolean isContainer, boolean isModule) {
        this.loadButton.setEnabled(false);
        if (this.container_FileNames != null && this.containersWithSingle != null) {
            String[] fileNames = null;
            int i = 0;
            while (i < this.containersWithSingle.length) {
                fileNames = (String[])this.container_FileNames.get(this.containersWithSingle[i]);
                if (fileNames != null) {
                    if (isContainer) {
                        this.containerComboBox.removeItem(this.containersWithSingle[i]);
                        this.containerComboBox.addItem(this.containersWithSingle[i]);
                    }
                    if (isModule) {
                        int j = 0;
                        while (j < fileNames.length) {
                            this.moduleComboBox.removeItem(fileNames[j]);
                            this.moduleComboBox.addItem(fileNames[j]);
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (isContainer && this.containerComboBox.getModel().getSize() == 2) {
                this.containerComboBox.setSelectedIndex(1);
            }
            if (isModule && this.moduleComboBox.getModel().getSize() == 2) {
                this.loadButton.setEnabled(true);
                this.moduleComboBox.setSelectedIndex(1);
            }
        }
        this.mappingComboBox.removeAllItems();
        this.mappingComboBox.addItem("");
    }

    public void valueChanged(ListSelectionEvent e) {
        int index = this.entryTable.getSelectedRow();
        if (index != -1) {
            this.initFields(index);
        } else {
            this.clearFields();
        }
        this.initButtons();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addAction();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeAction();
        } else if (cmd.equals("EDIT_CMD")) {
            this.editAction();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.clearAction();
        } else if (cmd.equals("BROWSE_CMD")) {
            this.browseAction();
        } else if (cmd.equals("LOAD_CMD")) {
            this.loadAction();
        }
    }

    private void loadAction() {
        int option = JOptionPane.showOptionDialog(this.frame, "This opearation might be long lasting.\nDo you want to proceed?", "INFORMATION", 0, 1, null, null, null);
        if (option == 1) {
            return;
        }
        String currentAppName = ((JTextField)this.appNameComboBox.getEditor().getEditorComponent()).getText().trim();
        String module = this.moduleTextField.getText();
        String container = ((JTextField)this.containerComboBox.getEditor().getEditorComponent()).getText();
        Object[] entries = null;
        try {
            entries = this.getMoluleEntries(currentAppName, container, module);
        }
        catch (RemoteException re) {
            JOptionPane.showMessageDialog(this.frame, re.toString(), "INFORMATION", 1);
        }
        this.mappingComboBox.removeAllItems();
        this.mappingComboBox.addItem("");
        if (entries != null) {
            Arrays.sort(entries);
            int i = 0;
            while (i < entries.length) {
                this.mappingComboBox.addItem(entries[i]);
                ++i;
            }
        } else {
            JOptionPane.showMessageDialog(this.frame, "The module " + module + " doesn't exist in the configurations of the application " + currentAppName + ".", "WARNING", 2);
        }
    }

    private void addAction() {
        if (!this.isTextFieldsEmpty()) {
            if (!this.entryExist()) {
                this.entryModel.addRow(new String[]{this.moduleTextField.getText().trim(), this.fileTextField.getText().trim(), this.mappingTextField.getText().trim(), ((JTextField)this.containerComboBox.getEditor().getEditorComponent()).getText().trim()});
                this.clearAction();
            } else {
                JOptionPane.showMessageDialog(this.frame, "This entry already exist!", "Warning", 2);
            }
        } else {
            JOptionPane.showMessageDialog(this.frame, "The obligatory fields are not filled in!", "Warning", 2);
        }
    }

    private boolean entryExist() {
        int rows = this.entryModel.getRowCount();
        int i = 0;
        while (i < rows) {
            if (((String)this.entryModel.getValueAt(i, 0)).equals(this.moduleTextField.getText().trim()) && ((String)this.entryModel.getValueAt(i, 1)).equals(this.fileTextField.getText().trim()) && ((String)this.entryModel.getValueAt(i, 2)).equals(this.mappingTextField.getText().trim()) && ((String)this.entryModel.getValueAt(i, 3)).equals(((JTextField)this.containerComboBox.getEditor().getEditorComponent()).getText().trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void removeAction() {
        this.entryModel.removeRow(this.entryTable.getSelectedRow());
        this.clearAction();
    }

    private void editAction() {
        int index = this.entryTable.getSelectionModel().getLeadSelectionIndex();
        if (this.isTextFieldsEmpty()) {
            JOptionPane.showMessageDialog(this.frame, "Some fields with required information is empty. Fill it with data", "Missing Data", 2);
            this.clearAction();
            return;
        }
        this.entryModel.insertRow(index, new String[]{this.moduleTextField.getText().trim(), this.fileTextField.getText().trim(), this.mappingTextField.getText().trim(), ((JTextField)this.containerComboBox.getEditor().getEditorComponent()).getText().trim()});
        this.entryModel.removeRow(index + 1);
        this.clearAction();
    }

    private void clearAction() {
        this.entryTable.getSelectionModel().clearSelection();
        this.clearFields();
        this.initContainersAndModuls(false, true);
        this.initButtons();
    }

    private void browseAction() {
        this.chooser = SFileChooser.getInstance((JFrame)this.frame);
        this.chooser.setFilters(new String[]{".*"});
        String[] fileName = this.chooser.showFileDialog("File Name", true, false, true);
        if (fileName != null && fileName.length > 0 && fileName[0] != null && !fileName[0].trim().equals("")) {
            this.fileTextField.setText(fileName[0].trim());
        }
    }

    private void initFields(int index) {
        this.moduleTextField.setText((String)this.entryModel.getValueAt(index, 0));
        this.fileTextField.setText((String)this.entryModel.getValueAt(index, 1));
        this.mappingTextField.setText((String)this.entryModel.getValueAt(index, 2));
        this.containerComboBox.setSelectedItem((String)this.entryModel.getValueAt(index, 3));
    }

    private void clearPanel() {
        this.entryModel = new SingleFileUpdateTableModel(new String[]{"Module", "File Name", "Mapping", "Container"});
        this.entryTable.setModel(this.entryModel);
        this.clearAction();
    }

    private void initButtons() {
        if (this.isTextFieldsEmpty()) {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        }
    }

    public boolean isTextFieldsEmpty() {
        return this.moduleTextField.getText().trim().equals("") || this.fileTextField.getText().equals("") || this.mappingTextField.getText().equals("") || this.moduleTextField.getText().trim() == null || this.fileTextField.getText() == null || this.mappingTextField.getText() == null || ((JTextField)this.containerComboBox.getEditor().getEditorComponent()).getText().trim().equals("") || ((JTextField)this.containerComboBox.getEditor().getEditorComponent()).getText() == null;
    }

    public String getApplicationName() {
        return ((JTextField)this.appNameComboBox.getEditor().getEditorComponent()).getText().trim();
    }

    public FileUpdateInfo[] getFileUpdateInfo() throws BaseIllegalArgumentException, BaseIOException {
        int len = this.entryModel.getRowCount();
        FileUpdateInfo[] infoes = new FileUpdateInfo[len];
        FileUpdateInfo info = null;
        int i = 0;
        while (i < len) {
            info = new FileUpdateInfo();
            info.setArchiveEntryName((String)this.entryModel.getValueAt(i, 0));
            info.setFileName((String)this.entryModel.getValueAt(i, 1));
            info.setFileEntryName((String)this.entryModel.getValueAt(i, 2));
            info.setContainerName((String)this.entryModel.getValueAt(i, 3));
            infoes[i] = info;
            ++i;
        }
        return infoes;
    }

    public void loadApplications(String[] apps) {
        if (apps == null || apps.length == 0) {
            return;
        }
        Arrays.sort(apps);
        this.appNameComboBox.removeAllItems();
        this.appNameComboBox.addItem("");
        int i = 0;
        while (i < apps.length) {
            this.addValueToComboBox(apps[i], this.appNameComboBox);
            ++i;
        }
    }

    public void loadContainers(String[] containers) {
        if (containers == null || containers.length == 0) {
            return;
        }
        Arrays.sort(containers);
        this.containersWithSingle = containers;
        this.containerComboBox.removeAllItems();
        this.containerComboBox.addItem("");
        int i = 0;
        while (i < containers.length) {
            this.addValueToComboBox(containers[i], this.containerComboBox);
            ++i;
        }
    }

    private synchronized void addValueToComboBox(String value, JComboBox target) {
        if (target == null || value == null) {
            return;
        }
        if (this.hasElementInComboBox(value, target) == -1) {
            target.addItem(value);
        }
    }

    public int hasElementInComboBox(String elem, JComboBox target) {
        if (target == null || elem == null) {
            return -1;
        }
        int i = 0;
        while (i < target.getItemCount()) {
            if (target.getItemAt(i).equals(elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isTableEmpty() {
        return this.entryTable.getModel().getRowCount() <= 0;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setInformationProvider(Object obj) {
        this.informationProvider = obj;
    }

    private ApplicationInformation getApplicationInformation(String appName) throws RemoteException {
        if (this.informationProvider instanceof DeployService) {
            return ((DeployService)this.informationProvider).getApplicationInformation(appName);
        }
        if (this.informationProvider instanceof DeployRuntimeControlInterface) {
            return ((DeployRuntimeControlInterface)this.informationProvider).getApplicationInformation(appName);
        }
        return null;
    }

    private String[] getMoluleEntries(String applicationName, String container, String module) throws RemoteException {
        if (this.informationProvider instanceof DeployService) {
            JOptionPane.showMessageDialog(this.frame, "This functionality is not supported in Deploy Tool.", "INFORMATION", 1);
            return new String[0];
        }
        if (this.informationProvider instanceof DeployRuntimeControlInterface) {
            return ((DeployRuntimeControlInterface)this.informationProvider).getModuleEntries(applicationName, container, module);
        }
        return null;
    }

    protected void clearFields() {
        this.moduleComboBox.removeAllItems();
        this.moduleComboBox.addItem("");
        this.fileTextField.setText("");
        this.mappingTextField.setText("");
        this.containerComboBox.removeAllItems();
        this.containerComboBox.addItem("");
        if (this.containersWithSingle != null) {
            int i = 0;
            while (i < this.containersWithSingle.length) {
                this.containerComboBox.addItem(this.containersWithSingle[i]);
                ++i;
            }
        }
    }

    public void setParentDialog(Dialog parent) {
        this.parentDialog = parent;
    }

    public void setApplicationName(String appName) {
        if (appName != null) {
            this.appNameComboBox.setSelectedItem(appName);
        }
    }

    private Hashtable sort(Hashtable source) {
        Hashtable<String, Object[]> res = null;
        if (source != null) {
            res = new Hashtable<String, Object[]>();
            Enumeration enumeration = source.keys();
            String key = null;
            Object[] value = null;
            while (enumeration != null && enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                value = (String[])source.get(key);
                Arrays.sort(value);
                res.put(key, value);
            }
        }
        return res;
    }
}

