/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.SecurityRolesPanel;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class SecurityRolesPanelLogical
extends SecurityRolesPanel {
    private SecurityRoles[] securityRoles = null;
    private Vector roleNames = null;
    private boolean changed = false;
    private boolean appClient = false;
    private ApplicationInformationProvider appProvider;

    public SecurityRolesPanelLogical() {
    }

    public SecurityRolesPanelLogical(Frame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public SecurityRolesPanelLogical(Frame mainFrame, int madeFrom) {
        this.mainFrame = mainFrame;
        if (madeFrom == 5) {
            this.enabledType = false;
            this.nameTextField.setEnabled(false);
            this.roleList.setEnabled(false);
            this.listScrollPane.setEnabled(false);
            this.descPanel.descriptionTextArea.setEnabled(false);
        }
    }

    public void setSecurityRoles(SecurityRoles[] roles) {
        this.clear();
        if (roles == null) {
            this.securityRoles = new SecurityRoles[0];
            this.roleNames = new Vector();
        } else {
            int length = roles.length;
            SecurityRoles tempRole = null;
            ListValues tempValue = null;
            this.securityRoles = new SecurityRoles[length];
            this.roleNames = new Vector(length);
            int i = 0;
            while (i < length) {
                tempRole = roles[i];
                if (tempRole != null) {
                    this.securityRoles[i] = tempRole;
                    this.roleNames.add(tempRole.getName());
                    tempValue = new ListValues(tempRole, 0);
                    this.model.addElement(tempValue);
                }
                ++i;
            }
        }
    }

    public SecurityRoles[] getSecurityRoles() {
        return this.securityRoles;
    }

    public Vector getSecurityRolesNames() {
        return this.roleNames;
    }

    public void setAppClient(boolean appClient) {
        this.appClient = appClient;
    }

    public void reset() {
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void init(int madeFromConstant) {
        if (madeFromConstant == 3 && this.appClient) {
            this.enabledType = false;
        }
    }

    public void clear() {
        this.clearFields();
        this.model.removeAllElements();
        this.securityRoles = new SecurityRoles[0];
        this.roleNames = new Vector();
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        Enumeration enumeration = this.model.elements();
        Vector<SecurityRoles> secRoles = new Vector<SecurityRoles>();
        this.roleNames = new Vector();
        ListValues elem = null;
        while (enumeration.hasMoreElements()) {
            elem = (ListValues)enumeration.nextElement();
            this.roleNames.add(elem.getName());
            secRoles.add(elem.getSecurityRole());
        }
        if (secRoles.size() != 0) {
            this.securityRoles = new SecurityRoles[secRoles.size()];
            secRoles.copyInto(this.securityRoles);
        } else {
            this.securityRoles = null;
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public void valueChanged(ListSelectionEvent e) {
        Object temp = null;
        Object name = null;
        if (!this.selectWithMouse) {
            this.checPanel();
        }
        if (!this.roleList.isSelectionEmpty()) {
            this.clearButton.setEnabled(true);
            this.modifyButton.setEnabled(true);
            this.removeButton.setEnabled(this.enabledType);
            this.addButton.setEnabled(false);
            this.show((ListValues)this.roleList.getSelectedValue());
            this.descPanel.setEnabled(true);
        } else {
            this.clearFields();
        }
    }

    private void show(ListValues listValue) {
        String description;
        if (!this.selectWithMouse) {
            this.setText = true;
            this.nameTextField.setText(listValue.getName());
            this.setText = false;
        }
        if ((description = listValue.getSecurityRole().getDescription()) == null) {
            this.descPanel.setText("");
        } else {
            this.descPanel.setText(description.trim());
        }
    }

    private void checPanel() {
        String name = this.nameTextField.getText().trim();
        if (!name.equals("")) {
            String description = this.descPanel.getText().trim();
            ListValues role = this.findRole(name);
            int answer = 1;
            if (role != null) {
                if (!description.equals(role.getSecurityRole().getDescription() == null ? "" : role.getSecurityRole().getDescription())) {
                    answer = JOptionPane.showConfirmDialog(this.mainFrame, "The security role <" + name + "> has changed description.\n Would you like to modify it?", "Warning", 0, 2);
                    if (answer == 0) {
                        this.modifyRole(role, description);
                    } else {
                        this.clearFields();
                    }
                }
            } else {
                answer = JOptionPane.showConfirmDialog(this.mainFrame, "There is new role <" + name + "> described.\n Would you like to add it?", "Warning", 0, 2);
                if (answer == 0) {
                    this.addRoleToList(name, description);
                } else {
                    this.clearFields();
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String name = this.nameTextField.getText().trim();
        String description = this.descPanel.getText().trim();
        if (cmd.equals("ADD_CMD")) {
            this.addRoleToList(name, description);
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeRole(this.roleList.getSelectedValue());
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyRole(this.findRole(name), description);
        } else if (cmd.equals("CLEAR_CMD")) {
            this.clearAction();
        }
    }

    private void clearAction() {
        if (!this.roleList.isSelectionEmpty()) {
            this.roleList.clearSelection();
        }
        this.clearFields();
    }

    private void addRoleToList(String name, String description) {
        SecurityRoles role = new SecurityRoles(name, description);
        this.model.addElement(new ListValues(role, 0));
        this.changed = true;
        this.clearAction();
    }

    private void modifyRole(ListValues role, String description) {
        role.getSecurityRole().setRoleDescription(description);
        this.changed = true;
        this.clearAction();
    }

    private void removeRole(Object role) {
        this.clearFields();
        this.model.removeElement(role);
        this.changed = true;
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.selectWithMouse) {
            this.manageEnableing();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.selectWithMouse) {
            this.manageEnableing();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.selectWithMouse) {
            this.manageEnableing();
        }
    }

    private void manageEnableing() {
        this.selectWithMouse = true;
        String name = this.nameTextField.getText().trim();
        if (!this.roleList.isSelectionEmpty()) {
            this.roleList.clearSelection();
        }
        if (name.equals("")) {
            this.clearFields();
        } else {
            ListValues role = this.findRole(name);
            if (role == null) {
                this.addButton.setEnabled(true);
                this.modifyButton.setEnabled(false);
                this.removeButton.setEnabled(false);
            } else {
                this.roleList.setSelectedValue(role, true);
                this.removeButton.setEnabled(this.enabledType);
                this.modifyButton.setEnabled(true);
                this.addButton.setEnabled(false);
            }
            this.clearButton.setEnabled(true);
            this.descPanel.setEnabled(true);
        }
        this.selectWithMouse = false;
    }

    private ListValues findRole(String name) {
        int size = this.model.size();
        int i = 0;
        while (i < size) {
            if (name.equals(((ListValues)this.model.get(i)).getName().trim())) {
                return (ListValues)this.model.get(i);
            }
            ++i;
        }
        return null;
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }
}

