/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.SecurityRoleRefsPanel;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class SecurityRoleRefsPanelLogical
extends SecurityRoleRefsPanel {
    private SecurityRoles[] securityRoles = null;
    private SecurityRoleReference[] references = null;
    private Vector refRoleNames = null;
    private boolean changed = false;
    private int correct = 0;
    private ApplicationInformationProvider appProvider;

    public SecurityRoleRefsPanelLogical(Frame mainFrame, int madeFrom) {
        this.mainFrame = mainFrame;
        this.init(madeFrom);
    }

    public void setSecurityRoleRefs(SecurityRoleReference[] references) {
        this.clear();
        if (references == null) {
            this.references = new SecurityRoleReference[0];
            this.refRoleNames = new Vector();
        } else {
            int length = references.length;
            SecurityRoleReference tempRef = null;
            ListValues tempValue = null;
            this.references = new SecurityRoleReference[length];
            this.refRoleNames = new Vector(length);
            int i = 0;
            while (i < length) {
                tempRef = references[i];
                if (tempRef != null) {
                    this.references[i] = tempRef;
                    this.refRoleNames.add(tempRef.getRoleName());
                    tempValue = new ListValues(tempRef, 2);
                    this.model.addElement(tempValue);
                }
                ++i;
            }
        }
    }

    public SecurityRoleReference[] getSecurityRoleRefs() {
        return this.references == null || this.references.length == 0 ? null : this.references;
    }

    public void setSecurityRoles(SecurityRoles[] roles) {
        if (roles == null) {
            roles = new SecurityRoles[]{};
        }
        this.securityRoles = roles;
        this.linkComboBox.removeAllItems();
        this.linkComboBox.addItem("");
        this.initComboBox();
        int size = roles.length;
        int i = 0;
        while (i < size) {
            this.linkComboBox.addItem(roles[i].getRoleName());
            ++i;
        }
    }

    public SecurityRoles[] getSecurityRoles() {
        return this.securityRoles;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void clear() {
        this.clearFields();
        this.model.removeAllElements();
        this.securityRoles = new SecurityRoles[0];
        this.refRoleNames = new Vector();
        this.references = new SecurityRoleReference[0];
    }

    public int isCorrect() {
        return this.correct;
    }

    public void commitChange() {
        Enumeration enumeration = this.model.elements();
        Vector<SecurityRoleReference> secRoles = new Vector<SecurityRoleReference>();
        this.refRoleNames = new Vector();
        ListValues elem = null;
        while (enumeration.hasMoreElements()) {
            elem = (ListValues)enumeration.nextElement();
            this.refRoleNames.add(elem.getName());
            secRoles.add(elem.getSecurityRoleRef());
        }
        if (secRoles.size() != 0) {
            this.references = new SecurityRoleReference[secRoles.size()];
            secRoles.copyInto(this.references);
        } else {
            this.references = null;
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String name = this.nameTextField.getText().trim();
        String description = this.descPanel.getText().trim();
        if (cmd.equals("ADD_CMD")) {
            this.addAction(name, description);
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeAction(this.referencesList.getSelectedValue());
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyAction(this.findReference(name), description);
        } else if (cmd.equals("CLEAR_CMD")) {
            this.clearAction();
        }
    }

    private void clearAction() {
        if (!this.referencesList.isSelectionEmpty()) {
            this.referencesList.clearSelection();
        }
        this.clearFields();
    }

    private void addAction(String name, String description) {
        SecurityRoleReference role = new SecurityRoleReference(name, description, this.findLink());
        this.model.addElement(new ListValues(role, 2));
        this.changed = true;
        this.clearFields();
    }

    private void modifyAction(ListValues value, String description) {
        SecurityRoleReference ref = value.getSecurityRoleRef();
        SecurityRoles oldLink = ref.getRoleLink();
        SecurityRoles newLink = this.findLink();
        ref.setRoleLink(newLink);
        ref.setDescription(description);
        this.changed = true;
        this.clearAction();
    }

    private void removeAction(Object value) {
        this.clearFields();
        this.model.removeElement(value);
        this.changed = true;
    }

    public void insertUpdate(DocumentEvent e) {
        this.manageEnableing();
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.manageEnableing();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.manageEnableing();
        }
    }

    private void manageEnableing() {
        String name = this.nameTextField.getText().trim();
        this.selectWithMouse = false;
        if (!this.referencesList.isSelectionEmpty()) {
            this.referencesList.clearSelection();
        }
        if (name.equals("")) {
            this.clearFields();
        } else {
            ListValues ref = this.findReference(name);
            if (ref == null) {
                this.addButton.setEnabled(true);
                this.modifyButton.setEnabled(false);
                this.removeButton.setEnabled(false);
            } else {
                this.referencesList.setSelectedValue(ref, true);
                this.removeButton.setEnabled(this.enabledAddButton);
                this.modifyButton.setEnabled(true);
                this.addButton.setEnabled(false);
                this.linkComboBox.setEnabled(this.enabledComboBox);
            }
            this.clearButton.setEnabled(true);
            this.descPanel.setEnabled(true);
        }
        this.selectWithMouse = true;
    }

    public void valueChanged(ListSelectionEvent e) {
        Object temp = null;
        Object name = null;
        if (this.selectWithMouse) {
            this.checPanel();
        }
        if (!this.referencesList.isSelectionEmpty()) {
            this.clearButton.setEnabled(true);
            this.modifyButton.setEnabled(true);
            this.removeButton.setEnabled(this.enabledAddButton);
            this.addButton.setEnabled(false);
            this.show((ListValues)this.referencesList.getSelectedValue());
            this.descPanel.setEnabled(true);
        } else {
            this.clearFields();
        }
    }

    private void show(ListValues listValue) {
        SecurityRoles link;
        if (this.selectWithMouse) {
            this.setText = true;
            this.nameTextField.setText(listValue.getName());
            this.setText = false;
        }
        if ((link = listValue.getSecurityRoleRef().getRoleLink()) != null) {
            this.linkComboBox.setSelectedItem(link.getName() == null ? "" : link.getName());
        } else {
            this.linkComboBox.setSelectedItem("");
        }
        String description = listValue.getSecurityRoleRef().getDescription();
        if (description == null) {
            this.descPanel.setText("");
        } else {
            this.descPanel.setText(description.trim());
        }
    }

    private void checPanel() {
        String name = this.nameTextField.getText().trim();
        if (!name.equals("")) {
            String description = this.descPanel.getText().trim();
            String linkName = ((JTextField)this.linkComboBox.getEditor().getEditorComponent()).getText();
            ListValues value = this.findReference(name);
            int answer = 1;
            if (value != null) {
                SecurityRoleReference ref = value.getSecurityRoleRef();
                if (!(ref == null || description.equals(ref.getDescription() == null ? "" : ref.getDescription()) && linkName.equals(ref.getRoleLink() == null ? "" : (ref.getRoleLink().getRoleName() == null ? "" : ref.getRoleLink().getRoleName())))) {
                    answer = JOptionPane.showConfirmDialog(this.mainFrame, "The security role reference <" + name + "> has changed.\n Would you like to modify it?", "Warning", 0, 2);
                    if (answer == 0) {
                        this.modifyAction(value, description);
                    } else {
                        this.clearFields();
                    }
                }
            } else {
                answer = JOptionPane.showConfirmDialog(this.mainFrame, "There is new role reference <" + name + "> described.\n Would you like to add it?", "Warning", 0, 2);
                if (answer == 0) {
                    this.addAction(name, description);
                } else {
                    this.clearFields();
                }
            }
        }
    }

    private ListValues findReference(String name) {
        int size = this.model.size();
        int i = 0;
        while (i < size) {
            if (name.equals(((ListValues)this.model.get(i)).getName().trim())) {
                return (ListValues)this.model.get(i);
            }
            ++i;
        }
        return null;
    }

    private SecurityRoles findRole(String name) {
        int size = this.securityRoles.length;
        int i = 0;
        while (i < size) {
            if (name.equals(this.securityRoles[i].getRoleName())) {
                return this.securityRoles[i];
            }
            ++i;
        }
        return new SecurityRoles(name);
    }

    private SecurityRoles findLink() {
        String linkName = ((JTextField)this.linkComboBox.getEditor().getEditorComponent()).getText();
        SecurityRoles link = null;
        if (!linkName.equals("")) {
            link = this.findRole(linkName);
        }
        return link;
    }

    public void reset() {
        this.changed = false;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }
}

