/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.services.security.remote.RemoteGroupContext;
import com.sap.engine.services.security.remote.RemoteIterator;
import com.sap.engine.services.security.remote.RemoteSecurity;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class RunAsMapPanel
extends JPanel
implements ActionListener,
ItemListener {
    private String currentUser = null;
    private JComboBox usersCombo = new JComboBox();
    private JComboBox groupsCombo = new JComboBox();
    private JComboBox usrFromGrCombo = new JComboBox();
    private JRadioButton usrBtn = new JRadioButton();
    private JRadioButton grBtn = new JRadioButton();
    private ButtonGroup radio = new ButtonGroup();
    private JTextField userText = new JTextField();
    private JPanel usersPanel = new JPanel();
    private JPanel groupsPanel = new JPanel();
    private JPanel btnPanel = new JPanel();
    private JButton setBtn = new JButton("Set");
    private JButton clearBtn = new JButton("Clear");
    private RemoteSecurity remoteSecurity = null;
    private Vector usersInGroup = new Vector();
    private Frame mainFrame = null;
    private String lastGroup = "";
    private Hashtable cashHash = new Hashtable();

    public RunAsMapPanel() {
        this.init();
    }

    public RunAsMapPanel(Frame frame, RemoteSecurity remoteSecurity) throws RemoteException {
        this.mainFrame = frame;
        this.remoteSecurity = remoteSecurity;
        this.init();
    }

    private void init() {
        this.usersCombo.addItemListener(this);
        this.groupsCombo.addItemListener(this);
        this.usrBtn.addActionListener(this);
        this.grBtn.addActionListener(this);
        this.setBtn.addActionListener(this);
        this.clearBtn.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
        this.usersPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
        this.groupsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
        this.groupsPanel.setLayout(new GridBagLayout());
        this.usersPanel.setLayout(new GridBagLayout());
        this.usrBtn.setSelected(true);
        this.enableRadio(true);
        this.usersCombo.setPreferredSize(new Dimension(50, 25));
        this.groupsCombo.setPreferredSize(new Dimension(50, 25));
        this.usersPanel.add((Component)this.usrBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.usersPanel.add((Component)new JLabel("Users"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.usersPanel.add((Component)this.usersCombo, new GridBagConstraints(1, 1, 1, 1, 0.2, 0.2, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.usersPanel.add((Component)new JLabel("User :"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.groupsPanel.add((Component)this.grBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.groupsPanel.add((Component)new JLabel("Users from groups"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.groupsPanel.add((Component)new JLabel("Group :"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.groupsPanel.add((Component)this.groupsCombo, new GridBagConstraints(1, 1, 1, 1, 0.2, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.groupsPanel.add((Component)new JLabel("User :"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.groupsPanel.add((Component)this.usrFromGrCombo, new GridBagConstraints(1, 2, 1, 1, 0.2, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.btnPanel.add(this.setBtn);
        this.btnPanel.add(this.clearBtn);
        this.add((Component)new JLabel("Mapped user :"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.userText, new GridBagConstraints(1, 0, 1, 1, 0.2, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.usersPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.groupsPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.btnPanel, new GridBagConstraints(0, 6, 2, 2, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.radio.add(this.usrBtn);
        this.radio.add(this.grBtn);
        this.enableBtn();
        this.userText.setEnabled(false);
    }

    public void setUsersAndGroups(String mapName, String[] users, String[] groups) {
        int i;
        this.userText.setText(mapName);
        this.groupsCombo.removeAllItems();
        this.cashHash = new Hashtable();
        if (groups != null) {
            i = 0;
            while (i < groups.length) {
                this.groupsCombo.insertItemAt(groups[i], 0);
                ++i;
            }
        }
        if (users != null) {
            i = 0;
            while (i < users.length) {
                this.usersCombo.insertItemAt(users[i], 0);
                ++i;
            }
        }
    }

    public String getSelectedItem() {
        return this.userText.getText();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.usrBtn) {
            this.enableRadio(true);
        } else if (e.getSource() == this.grBtn) {
            this.enableRadio(false);
        } else if (e.getSource() == this.setBtn) {
            if (this.usrBtn.isSelected()) {
                this.userText.setText((String)this.usersCombo.getSelectedItem());
            } else {
                this.userText.setText((String)this.usrFromGrCombo.getSelectedItem());
            }
        } else if (e.getSource() == this.clearBtn) {
            this.userText.setText("");
        }
        this.enableBtn();
    }

    private void fillUsersFromGroup(String group) {
        this.usersInGroup = new Vector();
        try {
            this.findUsersInGroup(group);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Cannot get users for group : " + group, "Warnning", 2);
        }
        this.usersInGroup.removeAllElements();
        Object[] usrs = new String[]{};
        if (this.cashHash.get(group) != null) {
            usrs = (String[])this.cashHash.get(group);
        } else {
            usrs = new String[this.usersInGroup.size()];
            this.usersInGroup.copyInto(usrs);
            this.cashHash.put(group, usrs);
        }
        int i = 0;
        while (i < usrs.length) {
            this.usersInGroup.insertElementAt(usrs[i], 0);
            ++i;
        }
    }

    private void findUsersInGroup(String group) throws RemoteException {
        RemoteGroupContext groupContext = this.remoteSecurity.getRemoteUserStoreFactory().getActiveUserStore().getGroupContext();
        RemoteIterator iterator = groupContext.getChildGroups(group);
        while (iterator.hasNext()) {
            this.findUsersInGroup((String)iterator.next());
        }
        iterator = groupContext.getUsersOfGroup(group);
        String temp = null;
        while (iterator.hasNext()) {
            temp = (String)iterator.next();
            if (this.usersInGroup.contains(temp)) continue;
            this.usersInGroup.add(temp);
        }
    }

    private void enableBtn() {
        String item = null;
        item = this.usrBtn.isSelected() ? (String)this.usersCombo.getSelectedItem() : (String)this.usrFromGrCombo.getSelectedItem();
        this.setBtn.setEnabled(item != null && !item.trim().equals("") && !item.trim().equals(this.userText.getText()));
    }

    private void enableRadio(boolean flag) {
        this.usersCombo.setEnabled(flag);
        this.groupsCombo.setEnabled(!flag);
        this.usrFromGrCombo.setEnabled(!flag);
    }

    public void itemStateChanged(ItemEvent p1) {
        this.enableBtn();
        if (p1.getSource() == this.groupsCombo) {
            if (this.lastGroup != (String)this.groupsCombo.getSelectedItem()) {
                this.fillUsersFromGroup((String)this.groupsCombo.getSelectedItem());
            }
            this.lastGroup = (String)this.groupsCombo.getSelectedItem();
        }
    }

    public void updateLook_Feel() {
        SwingUtilities.updateComponentTreeUI(this);
    }
}

