/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.services.deploy.gui.sfilechooser.ClassPathPanel;
import com.sap.engine.services.deploy.gui.sfilechooser.ExplorerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SFileChooser
extends CEscapeDialog
implements ActionListener,
FocusListener {
    private ExplorerPanel explorer;
    private JFrame frame;
    private Dialog parentDialog;
    private ClassPathPanel classPath;
    private boolean isAddedClassPath = false;
    private boolean displayClassPath;
    private boolean isOKPressed = false;
    private boolean firstStart = true;
    private static SFileChooser sfileChooser;

    public SFileChooser(JFrame arg0) {
        super((Frame)arg0, true);
        this.frame = arg0;
        this.init();
    }

    public SFileChooser(Dialog arg0) {
        super(arg0, true);
        this.parentDialog = arg0;
        this.init();
    }

    private void init() {
        this.explorer = new ExplorerPanel(this);
        this.classPath = new ClassPathPanel((Dialog)((Object)this));
        JButton ok = new JButton("OK");
        ok.setActionCommand("OK");
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("Cancel");
        ok.addActionListener(this);
        cancel.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add((Component)ok, null);
        buttonPanel.add((Component)cancel, null);
        ((JDialog)((Object)this)).getContentPane().setLayout(new GridBagLayout());
        ((JDialog)((Object)this)).getContentPane().add((Component)this.explorer, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        ((JDialog)((Object)this)).getContentPane().add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        ((Component)((Object)this)).addFocusListener(this);
        ((Window)((Object)this)).pack();
    }

    private void addClassPathPanel() {
        this.isAddedClassPath = true;
        this.classPath.setExplorerPanel(this.explorer);
        ((JDialog)((Object)this)).getContentPane().add((Component)this.classPath, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("OK")) {
            this.okAction();
        } else if (arg0.getActionCommand().equals("Cancel")) {
            this.isOKPressed = false;
            ((Component)((Object)this)).setVisible(false);
        }
    }

    public void okAction() {
        int res;
        if (!this.explorer.isAddressFieldEmpty() && this.isAddedClassPath && !this.classPath.getValues().contains(this.explorer.getAddressField()) && (res = JOptionPane.showConfirmDialog(this.frame, "You have selected value in files which is not in the class path.\n Do you wish to insert it?", "Warning", 0)) == 0) {
            this.classPath.addFiles(this.explorer.getAddressField());
        }
        if (this.explorer.isCorrectSelection()) {
            this.isOKPressed = true;
            ((Component)((Object)this)).setVisible(false);
        }
    }

    public Vector getClassPath() {
        return this.classPath.getValues();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Explorer Panel");
        SFileChooser dialog = new SFileChooser(frame);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ((Window)((Object)dialog)).addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().setLayout(new BorderLayout());
        JButton b = new JButton("SHOW");
        b.setActionCommand("SHOW");
        b.addActionListener(dialog);
        frame.getContentPane().add((Component)b, "Center");
        frame.pack();
        ((Component)frame).setVisible(true);
    }

    public boolean isDisplayClassPath() {
        return this.displayClassPath;
    }

    public void setDisplayClassPath(boolean displayClassPath) {
        this.displayClassPath = displayClassPath;
        this.addClassPathPanel();
    }

    public void setFilters(String[] filters) {
        this.explorer.setFilters(filters);
    }

    public void setProjectDir(String prDir) {
        this.explorer.setProjectDirectory(prDir);
    }

    public void goToDir(String prDir) {
        this.explorer.goTo(new File(prDir));
    }

    public String[] showClassPathDialog(String title) {
        return this.showDialog(title, false, true, false, true, false);
    }

    public String[] showFileDialog(String title, boolean gotoWorkDir, boolean multiselection, boolean isNewFile) {
        return this.showDialog(title, gotoWorkDir, multiselection, false, false, isNewFile);
    }

    public String[] showDirDialog(String title, boolean gotoWorkDir, boolean multiselection, boolean isNewFile) {
        return this.showDialog(title, gotoWorkDir, multiselection, true, false, isNewFile);
    }

    public void setClassPath(String[] cp) {
        this.classPath.setClassPath(cp);
    }

    private String[] showDialog(String title, boolean gotoWorkDir, boolean multiselection, boolean onlyDirectories, boolean displayclassPath, boolean isNewFile) {
        this.explorer.clear();
        this.explorer.setOnlyDirs(onlyDirectories);
        this.explorer.setMultiSelection(multiselection);
        this.explorer.setIsNewFile(isNewFile);
        ((Dialog)((Object)this)).setTitle(title);
        ((Component)((Object)this)).setSize(new Dimension(512, 502));
        this.explorer.setIsClassPathPanel(displayclassPath);
        if (displayclassPath && !this.isAddedClassPath) {
            this.addClassPathPanel();
        } else if (!displayclassPath && this.isAddedClassPath) {
            this.isAddedClassPath = false;
            ((JDialog)((Object)this)).getContentPane().remove(this.classPath);
            ((Component)((Object)this)).repaint();
            ((Container)((Object)this)).validate();
        }
        if (this.firstStart) {
            this.explorer.gotoUserDir();
            this.firstStart = false;
        } else if (gotoWorkDir) {
            this.explorer.gotoWorkDir();
        }
        ((Window)((Object)this)).setLocationRelativeTo(this.frame);
        this.explorer.refreshAction();
        if (displayclassPath) {
            ((Component)((Object)this)).setSize(new Dimension(800, 700));
        }
        ((Component)((Object)this)).setVisible(true);
        if (!this.isOKPressed) {
            this.isOKPressed = false;
            return null;
        }
        return this.explorer.getSeleectedPaths();
    }

    public String getFavourites() {
        return this.explorer.getFavourites();
    }

    public void setFavourites(String fav) {
        this.explorer.setFavourites(fav);
    }

    public void focusGained(FocusEvent e) {
        this.explorer.refreshAction();
    }

    public void focusLost(FocusEvent e) {
    }

    public static SFileChooser getInstance(JFrame frame) {
        if (sfileChooser != null) {
            return sfileChooser;
        }
        sfileChooser = new SFileChooser(frame);
        return sfileChooser;
    }

    public static SFileChooser getInstance(Dialog dialog) {
        if (sfileChooser != null) {
            return sfileChooser;
        }
        sfileChooser = new SFileChooser(dialog);
        return sfileChooser;
    }

    public void setVariables(Properties prop) {
        this.classPath.setVariables(prop);
    }

    public Properties getVariables() {
        return this.classPath.getVariables();
    }
}

