/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui;

import com.sap.engine.services.deploy.DeployEvent;
import com.sap.engine.services.deploy.DeployListener;
import com.sap.engine.services.deploy.DeployRuntimeControlInterface;
import com.sap.engine.services.deploy.container.ProgressEvent;
import com.sap.engine.services.deploy.gui.ApplicationsPanel;

public class DeployListenerImpl
implements DeployListener {
    DeployRuntimeControlInterface drci = null;
    ApplicationsPanel panel = null;

    public DeployListenerImpl(DeployRuntimeControlInterface drci, ApplicationsPanel panel) {
        this.drci = drci;
        this.panel = panel;
    }

    public void processApplicationEvent(DeployEvent event) {
        if (event.getComponentName() == null) {
            return;
        }
        if (event.getAction() == 1 || event.getAction() == 3) {
            int i;
            String[] message = event.getWarnings();
            if (message != null) {
                i = 0;
                while (i < message.length) {
                    this.panel.addAdditionalInfo(message[i] + "\n", 1);
                    ++i;
                }
            }
            if ((message = event.getErrors()) != null) {
                i = 0;
                while (i < message.length) {
                    this.panel.addAdditionalInfo(message[i] + "\n", 2);
                    ++i;
                }
            }
            String status = this.convertStatus(event);
            if (event.getActionType() == 9 || event.getActionType() == 8) {
                if (this.drci != null && this.panel != null) {
                    this.panel.reloadStatus(status, event);
                }
            } else if (event.getActionType() == 7) {
                this.panel.reloadStatus(status, event);
            } else if (event.getActionType() == 0) {
                this.panel.reloadStatus(status, event);
            }
        }
    }

    public void processServiceEvent(DeployEvent event) {
    }

    public void processLibraryEvent(DeployEvent event) {
    }

    public void processInterfaceEvent(DeployEvent event) {
    }

    public void processReferenceEvent(DeployEvent event) {
    }

    public void processStandaloneModuleEvent(DeployEvent event) {
    }

    public void processContainerEvent(ProgressEvent event) {
    }

    public void callbackLost(String serverName) {
    }

    public void serverAdded(String serverName) {
    }

    private String convertStatus(DeployEvent event) {
        switch (event.getStatus()) {
            case 1: {
                return "STOPPED";
            }
            case 5: {
                return "STOPPING";
            }
            case 0: {
                return "STARTED";
            }
            case 4: {
                return "STARTING";
            }
            case 3: {
                return "IMPLICIT_STOPPED";
            }
            case 6: {
                return "UPGRADING";
            }
        }
        return "UNKNOWN";
    }
}

