/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui;

import com.sap.engine.deploy.exceptions.DeployToolResourceAccessor;
import com.sap.engine.gui.CFileChooser;
import com.sap.engine.gui.LogMessageDialog;
import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.adminadapter.exception.AdminException;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.deploy.DeployEvent;
import com.sap.engine.services.deploy.DeployRuntimeControlInterface;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.ear.exceptions.BaseIOException;
import com.sap.engine.services.deploy.ear.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.deploy.gui.AdditionalInfoDialog;
import com.sap.engine.services.deploy.gui.ApplicationTask;
import com.sap.engine.services.deploy.gui.DeployDialogLogical;
import com.sap.engine.services.deploy.gui.DeployPanel;
import com.sap.engine.services.deploy.gui.DeployRuntimeView;
import com.sap.engine.services.deploy.gui.DeployTreeNode;
import com.sap.engine.services.deploy.gui.DeployUserObject;
import com.sap.engine.services.deploy.gui.DeployingTask;
import com.sap.engine.services.deploy.gui.FileUpdatingTask;
import com.sap.engine.services.deploy.gui.ImageHolder;
import com.sap.engine.services.deploy.gui.LoggingTask;
import com.sap.engine.services.deploy.gui.RemoveDialogLogical;
import com.sap.engine.services.deploy.gui.StartStopServerDialog;
import com.sap.engine.services.deploy.gui.common.SingleFileUpdateDialog;
import com.sap.engine.services.security.remote.RemoteSecurity;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ApplicationsPanel
extends DeployPanel
implements Runnable {
    protected DeployTreeNode root = new DeployTreeNode("Deploy Service", 0, null);
    protected DeployTreeNode containerRoot = new DeployTreeNode("Deploy Service", 0, null);
    protected DeployTreeNode applRoot = new DeployTreeNode("Deploy Service", 0, null);
    private Frame mainFrame = null;
    private static DeployDialogLogical deployDialog = null;
    private static RemoveDialogLogical removeDialog = null;
    private static SingleFileUpdateDialog singleFileUpdateDialog = null;
    private DeployRuntimeControlInterface dri = null;
    private RemoteSecurity node = null;
    private DefaultTreeModel lastSelectedModel = null;
    private JRadioButton lastSelectedButton = null;
    private JTextArea jArea = new JTextArea();
    private JScrollPane jScroll = new JScrollPane(this.jArea);
    private CFileChooser chooser = null;
    private Vector expanded = new Vector();
    private DeployingTask deployingTask = null;
    private ApplicationTask applicationTask = null;
    private FileUpdatingTask fileUpdatingTask = null;
    private LoggingTask loggingTask = null;
    private boolean isFirstTime = true;
    private String serverName = null;
    static /* synthetic */ Class class$com$sap$engine$services$security$remote$RemoteSecurity;

    public ApplicationsPanel() {
        this.servBtn.setSelected(true);
        this.setDisable();
        this.lastSelectedButton = this.servBtn;
        DeployToolResourceAccessor.init(null, null);
    }

    private void initTreeSimple() {
        block23: {
            if (this.isFirstTime) {
                this.isFirstTime = false;
                super.secondInit();
            }
            this.root.removeAllChildren();
            this.applRoot.removeAllChildren();
            this.containerRoot.removeAllChildren();
            if (this.dri == null) {
                return;
            }
            this.serverName = this.dri.getServerName();
            String[] current = null;
            DeployTreeNode parentNode = null;
            try {
                current = this.dri.getServerNames();
                if (current != null) {
                    int i = 0;
                    while (i < current.length) {
                        parentNode = new DeployTreeNode(current[i], 1, ImageHolder.serverIcon);
                        parentNode.setNodeLevel(1);
                        this.root.add(parentNode);
                        ++i;
                    }
                }
            }
            catch (UndeclaredThrowableException ute) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"server names"}, ute);
                current = null;
            }
            catch (RemoteException re) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"server names"}, re);
                current = null;
            }
            try {
                current = this.dri.getContainers(null);
                if (current != null) {
                    int i = 0;
                    while (i < current.length) {
                        parentNode = new DeployTreeNode(current[i], 2, ImageHolder.containerIcon);
                        parentNode.setNodeLevel(2);
                        this.containerRoot.add(parentNode);
                        ++i;
                    }
                }
            }
            catch (UndeclaredThrowableException ute) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"container names"}, ute);
                current = null;
            }
            catch (RemoteException re) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"container names"}, re);
                current = null;
            }
            try {
                current = this.dri.listApplications(null, null);
                if (current == null) break block23;
                String typeApp = null;
                int i = 0;
                while (i < current.length) {
                    block24: {
                        block26: {
                            block30: {
                                block29: {
                                    block28: {
                                        block27: {
                                            block25: {
                                                try {
                                                    typeApp = this.dri.getApplicationStatus(current[i]);
                                                }
                                                catch (UndeclaredThrowableException ute) {
                                                    DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"status of " + current[i] + " application"}, ute);
                                                    typeApp = null;
                                                }
                                                catch (RemoteException re) {
                                                    DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"status of " + current[i] + " application"}, re);
                                                    typeApp = null;
                                                }
                                                if (typeApp == null) break block24;
                                                if (!typeApp.equals("STARTED")) break block25;
                                                parentNode = new DeployTreeNode(current[i], 5, ImageHolder.startedIcon);
                                                parentNode.setNodeLevel(5);
                                                break block26;
                                            }
                                            if (!typeApp.equals("STARTING")) break block27;
                                            parentNode = new DeployTreeNode(current[i], 6, ImageHolder.startingIcon);
                                            parentNode.setNodeLevel(6);
                                            break block26;
                                        }
                                        if (!typeApp.equals("STOPPED")) break block28;
                                        parentNode = new DeployTreeNode(current[i], 3, ImageHolder.stoppedIcon);
                                        parentNode.setNodeLevel(3);
                                        break block26;
                                    }
                                    if (!typeApp.equals("IMPLICIT_STOPPED")) break block29;
                                    parentNode = new DeployTreeNode(current[i], 9, ImageHolder.implicit_stoppedIcon);
                                    parentNode.setNodeLevel(9);
                                    break block26;
                                }
                                if (!typeApp.equals("STOPPING")) break block30;
                                parentNode = new DeployTreeNode(current[i], 7, ImageHolder.stoppingIcon);
                                parentNode.setNodeLevel(7);
                                break block26;
                            }
                            if (!typeApp.equals("UPGRADING")) break block24;
                            parentNode = new DeployTreeNode(current[i], 8, ImageHolder.upgradingIcon);
                            parentNode.setNodeLevel(8);
                        }
                        this.applRoot.add(parentNode);
                    }
                    ++i;
                }
            }
            catch (UndeclaredThrowableException ute) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"all application names"}, ute);
                current = null;
            }
            catch (RemoteException re) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"all application names"}, re);
                Object var1_1 = null;
            }
        }
    }

    public void initTree() {
        block29: {
            if (this.dri == null) {
                return;
            }
            DeployTreeNode child = null;
            DeployTreeNode subChild = null;
            String[] current = null;
            String[] currentChild = null;
            String[] childArr = null;
            String[] subChildArr = null;
            try {
                current = this.dri.getServerNames();
            }
            catch (UndeclaredThrowableException ute) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"server names"}, ute);
                current = null;
            }
            catch (RemoteException re) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"server names"}, re);
                current = null;
            }
            String typeApp = null;
            if (current == null) break block29;
            try {
                currentChild = this.dri.getContainers(null);
            }
            catch (UndeclaredThrowableException ute) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"container names"}, ute);
                currentChild = null;
            }
            catch (RemoteException re) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"container names"}, re);
                currentChild = null;
            }
            DeployTreeNode parentNode = null;
            DeployTreeNode childNode = null;
            int i = 0;
            while (i < current.length) {
                block30: {
                    parentNode = this.findChildNode(this.root, current[i]);
                    if (parentNode == null) {
                        parentNode = new DeployTreeNode(current[i], 1, ImageHolder.serverIcon);
                        parentNode.setNodeLevel(1);
                        this.root.add(parentNode);
                    }
                    if (currentChild == null) break block30;
                    int j = 0;
                    while (j < currentChild.length) {
                        block27: {
                            childNode = new DeployTreeNode(currentChild[j], 2, ImageHolder.containerIcon);
                            childNode.setNodeLevel(2);
                            parentNode.add(childNode);
                            this.makeCont(currentChild[j], current[i], null, null);
                            try {
                                childArr = this.dri.listApplications(currentChild[j], null);
                            }
                            catch (UndeclaredThrowableException ute) {
                                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"all names of the applications deployed on " + currentChild[j]}, ute);
                                childArr = null;
                                break block27;
                            }
                            catch (RemoteException re) {
                                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"all names of the applications deployed on " + currentChild[j]}, re);
                                childArr = null;
                                break block27;
                            }
                            if (childArr == null) break block27;
                            int k = 0;
                            while (k < childArr.length) {
                                block28: {
                                    block31: {
                                        block33: {
                                            block37: {
                                                block36: {
                                                    block35: {
                                                        block34: {
                                                            block32: {
                                                                if (childArr[k] == null) break block28;
                                                                try {
                                                                    typeApp = this.dri.getApplicationStatus(childArr[k], current[i]);
                                                                }
                                                                catch (UndeclaredThrowableException ute) {
                                                                    DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"status of " + childArr[k] + " application from server " + current[i]}, ute);
                                                                    typeApp = null;
                                                                    break block28;
                                                                }
                                                                catch (RemoteException re) {
                                                                    DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"status of " + childArr[k] + " application from server " + current[i]}, re);
                                                                    typeApp = null;
                                                                    break block28;
                                                                }
                                                                if (typeApp == null) break block31;
                                                                if (!typeApp.equals("STARTED")) break block32;
                                                                child = new DeployTreeNode(childArr[k], 5, ImageHolder.startedIcon);
                                                                child.setNodeLevel(5);
                                                                break block33;
                                                            }
                                                            if (!typeApp.equals("STARTING")) break block34;
                                                            child = new DeployTreeNode(childArr[k], 6, ImageHolder.startingIcon);
                                                            child.setNodeLevel(6);
                                                            break block33;
                                                        }
                                                        if (!typeApp.equals("STOPPED")) break block35;
                                                        child = new DeployTreeNode(childArr[k], 3, ImageHolder.stoppedIcon);
                                                        child.setNodeLevel(3);
                                                        break block33;
                                                    }
                                                    if (!typeApp.equals("IMPLICIT_STOPPED")) break block36;
                                                    child = new DeployTreeNode(childArr[k], 9, ImageHolder.implicit_stoppedIcon);
                                                    child.setNodeLevel(9);
                                                    break block33;
                                                }
                                                if (!typeApp.equals("STOPPING")) break block37;
                                                child = new DeployTreeNode(childArr[k], 7, ImageHolder.stoppingIcon);
                                                child.setNodeLevel(7);
                                                break block33;
                                            }
                                            if (!typeApp.equals("UPGRADING")) break block28;
                                            child = new DeployTreeNode(childArr[k], 8, ImageHolder.upgradingIcon);
                                            child.setNodeLevel(8);
                                        }
                                        childNode.add(child);
                                    }
                                    this.makeAppl(childArr[k], currentChild[j], current[i], null);
                                    this.makeCont(currentChild[j], current[i], childArr[k], null);
                                    try {
                                        subChildArr = this.dri.listElements(currentChild[j], childArr[k], null);
                                    }
                                    catch (UndeclaredThrowableException ute) {
                                        DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"elements of " + childArr[k] + " application from " + currentChild[j] + " container"}, ute);
                                        subChildArr = null;
                                        break block28;
                                    }
                                    catch (RemoteException re) {
                                        DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"elements of " + childArr[k] + " application from " + currentChild[j] + " container"}, re);
                                        subChildArr = null;
                                        break block28;
                                    }
                                    if (subChildArr != null) {
                                        int l = 0;
                                        while (l < subChildArr.length) {
                                            subChild = new DeployTreeNode(subChildArr[l], 4, ImageHolder.componentIcon);
                                            subChild.setNodeLevel(4);
                                            child.add(subChild);
                                            this.makeAppl(childArr[k], currentChild[j], current[i], subChildArr[l]);
                                            this.makeCont(currentChild[j], current[i], childArr[k], subChildArr[l]);
                                            ++l;
                                        }
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (this.lastSelectedModel != null) {
            this.lastSelectedModel.reload();
        } else {
            ((DefaultTreeModel)this.deployTree.getModel()).setRoot(this.root);
            ((DefaultTreeModel)this.deployTree.getModel()).reload();
        }
        if (this.lastSelectedButton != null) {
            this.lastSelectedButton.setSelected(true);
        } else {
            this.servBtn.setSelected(true);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.refreshButtons(this.getSelectedApplication());
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("DEPLOY")) {
            this.deployAction(false, false);
        } else if (cmd.equals("DEPLOY_AND_START")) {
            this.deployAction(false, true);
        } else if (cmd.equals("GET CLIENT JAR")) {
            this.getJarsAction();
        } else if (cmd.equals("REMOVE")) {
            this.removeAction();
        } else if (cmd.equals("SERVER")) {
            ((DefaultTreeModel)this.deployTree.getModel()).setRoot(this.root);
            this.lastSelectedModel = (DefaultTreeModel)this.deployTree.getModel();
            this.lastSelectedButton = this.servBtn;
        } else if (cmd.equals("APPLICATION")) {
            ((DefaultTreeModel)this.deployTree.getModel()).setRoot(this.applRoot);
            this.lastSelectedModel = (DefaultTreeModel)this.deployTree.getModel();
            this.lastSelectedButton = this.applBtn;
        } else if (cmd.equals("CONTAINER")) {
            ((DefaultTreeModel)this.deployTree.getModel()).setRoot(this.containerRoot);
            this.lastSelectedModel = (DefaultTreeModel)this.deployTree.getModel();
            this.lastSelectedButton = this.contBtn;
        } else if (cmd.equals("START")) {
            this.startAction();
        } else if (cmd.equals("STOP")) {
            this.stopAction();
        } else if (cmd.equals("UPGRADE")) {
            this.deployAction(true, false);
        } else if (cmd.equals("SINGLE_FILE_UPDATE_CMD")) {
            this.singleFileUpdateAction();
        } else if (cmd.equals("ADD_APP_INFO")) {
            this.changeAddAppInfo();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void deployAction(boolean isUpdate, boolean postStart) {
        block24: {
            try {
                if (ApplicationsPanel.deployDialog == null) {
                    ApplicationsPanel.deployDialog = !isUpdate ? new DeployDialogLogical(this.mainFrame, postStart != false ? "Deploy & Start" : "Deploy", true) : new DeployDialogLogical(this.mainFrame, "Update", true);
                } else {
                    if (!isUpdate) {
                        ApplicationsPanel.deployDialog.setTitle(postStart != false ? "Deploy & Start" : "Deploy");
                    } else {
                        ApplicationsPanel.deployDialog.setTitle("Update");
                    }
                    if (ApplicationsPanel.deployDialog.isOK()) {
                        ApplicationsPanel.deployDialog.isOk = false;
                    }
                }
                if (isUpdate) {
                    ApplicationsPanel.deployDialog.setCheckAppVisible(false);
                } else {
                    ApplicationsPanel.deployDialog.setCheckAppVisible(true);
                }
                this.node = (RemoteSecurity)ClusterTreeGenerator.managementInterfaceProxyFactory.generateCurrentManagementInterfaceProxy("security", ApplicationsPanel.class$com$sap$engine$services$security$remote$RemoteSecurity == null ? (ApplicationsPanel.class$com$sap$engine$services$security$remote$RemoteSecurity = ApplicationsPanel.class$("com.sap.engine.services.security.remote.RemoteSecurity")) : ApplicationsPanel.class$com$sap$engine$services$security$remote$RemoteSecurity);
                ApplicationsPanel.deployDialog.setRemoteSecurity(this.node);
                ApplicationsPanel.deployDialog.showDialog(this.dri.getServerNames(), this.dri.getSupport());
                if (ApplicationsPanel.deployDialog.isOK()) {
                    this.shotExpandState();
                    if (!isUpdate && ApplicationsPanel.deployDialog.isAppExistingChecked()) {
                        appName = ApplicationsPanel.deployDialog.getAppName();
                        applications = this.dri.listApplications(null, null);
                        if (applications != null) {
                            i = 0;
                            while (i < applications.length) {
                                if (applications[i].equals(appName)) {
                                    elementsArray = this.dri.listElements(null, applications[i], null);
                                    elements = "";
                                    j = 0;
                                    while (j < elementsArray.length) {
                                        elements = elements + elementsArray[j] + "\n";
                                        ++j;
                                    }
                                    this.jArea.setText("Application " + applications[i] + " with element(s) : \n" + elements + " exists on server.\n Would you like to override it?");
                                    this.jScroll.setPreferredSize(new Dimension(200, 200));
                                    opt = JOptionPane.showOptionDialog(this.mainFrame, this.jScroll, "Existing application", 0, 2, null, null, null);
                                    if (opt == 0) break;
                                    return;
                                }
                                ++i;
                            }
                        }
                    }
                    if (DeployRuntimeView.manager != null) {
                        this.loggingTask = new LoggingTask(ApplicationsPanel.deployDialog.getTitle(), ApplicationsPanel.deployDialog.getErrors(), 0);
                        DeployRuntimeView.manager.addTask((TaskItem)this.loggingTask);
                        thread = new Thread(this.loggingTask);
                        thread.start();
                        this.deployingTask = postStart != false ? new DeployingTask(this.dri, ApplicationsPanel.deployDialog.getFileName(), ApplicationsPanel.deployDialog.getListServData(), ApplicationsPanel.deployDialog.getListSuppData(), ApplicationsPanel.deployDialog.getContanerType(), isUpdate, postStart, ApplicationsPanel.deployDialog.getAppName()) : new DeployingTask(this.dri, ApplicationsPanel.deployDialog.getFileName(), ApplicationsPanel.deployDialog.getListServData(), ApplicationsPanel.deployDialog.getListSuppData(), ApplicationsPanel.deployDialog.getContanerType(), isUpdate);
                        if (!isUpdate) {
                            this.deployingTask.setTitle(postStart != false ? "Deploy & Start" : "Deploy");
                        } else {
                            this.deployingTask.setTitle("Update");
                        }
                        DeployRuntimeView.manager.addTask((TaskItem)this.deployingTask);
                        thread = new Thread(this.deployingTask);
                        thread.start();
                    } else {
                        transferer = null;
                        remoteF = null;
                        serverEarName = "./temp/deploy/work/deploying/" + ApplicationsPanel.deployDialog.getOnlyName();
                        transferer = this.dri.getFileTransferer();
                        remoteF = transferer.createRemoteFile(ApplicationsPanel.deployDialog.getFileName(), serverEarName);
                        remoteF.upload();
                        this.dri.deploy(serverEarName, ApplicationsPanel.deployDialog.getListServData(), ApplicationsPanel.deployDialog.getListSuppData(), (byte)1, ApplicationsPanel.deployDialog.getContanerType(), isUpdate);
                        this.root.removeAllChildren();
                        this.containerRoot.removeAllChildren();
                        this.applRoot.removeAllChildren();
                        this.initTree();
                        ApplicationsPanel.deployDialog.deleteTempFiles();
                    }
                } else if (DeployRuntimeView.manager != null) {
                    this.loggingTask = ApplicationsPanel.deployDialog.getErrors() != null && ApplicationsPanel.deployDialog.getErrors().trim().equals("") == false ? new LoggingTask(ApplicationsPanel.deployDialog.getTitle(), ApplicationsPanel.deployDialog.getErrors(), 2) : new LoggingTask(ApplicationsPanel.deployDialog.getTitle(), ApplicationsPanel.deployDialog.getErrors(), 0);
                    DeployRuntimeView.manager.addTask((TaskItem)this.loggingTask);
                    thread = new Thread(this.loggingTask);
                    thread.start();
                }
            }
            catch (WarningException rex) {
                arr = rex.getWarnings();
                allMessages = "";
                i = 0;
                ** while (i < arr.length)
            }
lbl-1000:
            // 1 sources

            {
                allMessages = allMessages + arr[i] + "\n";
                ++i;
                continue;
            }
lbl83:
            // 1 sources

            DeployRuntimeView.logT(400, "Operation {0} finished with {1} {2}", new Object[]{postStart != false ? "Deploy & Start" : "Deploy", "warnings", "\n" + allMessages});
            JOptionPane.showMessageDialog(this.mainFrame, "Deployed with warnings!\n" + allMessages, "Warning", 0);
            this.root.removeAllChildren();
            this.containerRoot.removeAllChildren();
            this.applRoot.removeAllChildren();
            this.initTree();
            break block24;
            catch (AdminException ex) {
                DeployRuntimeView.logThrowableT(500, "Unexpected exception.", ex);
                JOptionPane.showMessageDialog(this.mainFrame, "Error: " + ex.toString(), "Error", 0);
            }
            catch (IOException ioe) {
                DeployRuntimeView.logThrowableT(500, "Unexpected exception.", ioe);
                JOptionPane.showMessageDialog(this.mainFrame, "Error: " + ioe.toString(), "Error", 0);
            }
        }
    }

    protected void singleFileUpdateAction() {
        try {
            if (singleFileUpdateDialog == null) {
                singleFileUpdateDialog = new SingleFileUpdateDialog(this.mainFrame, "Single File Update", true);
            }
            singleFileUpdateDialog.setInformationProvider(this.dri);
            singleFileUpdateDialog.setApplicationName(this.getSelectedApplication());
            singleFileUpdateDialog.showDialog(this.dri.listApplications(), this.dri.getContainersSupportingSingleFileUpdate(null));
            if (singleFileUpdateDialog.isOk()) {
                if (DeployRuntimeView.manager != null) {
                    this.fileUpdatingTask = null;
                    this.fileUpdatingTask = new FileUpdatingTask(this.dri, singleFileUpdateDialog.getFileUpdateInfo(), singleFileUpdateDialog.getApplicationName());
                    DeployRuntimeView.manager.addTask((TaskItem)this.fileUpdatingTask);
                    Thread thread = new Thread(this.fileUpdatingTask);
                    thread.start();
                } else {
                    this.dri.singleFileUpdate(singleFileUpdateDialog.getFileUpdateInfo(), singleFileUpdateDialog.getApplicationName(), new Properties());
                }
            }
        }
        catch (BaseIllegalArgumentException biae) {
            DeployRuntimeView.logThrowableT(500, "Operation {0} finished with {1} {2}", new Object[]{"SingleFileUpdate", "error", ""}, biae);
            LogMessageDialog logErrorDialog = LogMessageDialog.getInstance((Frame)singleFileUpdateDialog.getFrame());
            logErrorDialog.showErrorDialog("ERROR : Cannot update single file!", biae.toString());
        }
        catch (BaseIOException bioe) {
            DeployRuntimeView.logThrowableT(500, "Operation {0} finished with {1} {2}", new Object[]{"SingleFileUpdate", "error", ""}, bioe);
            LogMessageDialog logErrorDialog = LogMessageDialog.getInstance((Frame)singleFileUpdateDialog.getFrame());
            logErrorDialog.showErrorDialog("ERROR : Cannot update single file!", bioe.toString());
        }
        catch (UndeclaredThrowableException ute) {
            DeployRuntimeView.logThrowableT(500, "Operation {0} finished with {1} {2}", new Object[]{"SingleFileUpdate", "error", ""}, ute);
            LogMessageDialog logErrorDialog = LogMessageDialog.getInstance((Frame)singleFileUpdateDialog.getFrame());
            logErrorDialog.showErrorDialog("ERROR : Cannot update single file!", ute.toString());
        }
        catch (RemoteException re) {
            DeployRuntimeView.logThrowableT(500, "Operation {0} finished with {1} {2}", new Object[]{"SingleFileUpdate", "error", ""}, re);
            LogMessageDialog logErrorDialog = LogMessageDialog.getInstance((Frame)singleFileUpdateDialog.getFrame());
            logErrorDialog.showErrorDialog("ERROR : Cannot update single file!", re.toString());
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void getJarsAction() {
        TreePath[] paths = this.deployTree.getSelectionPaths();
        DefaultMutableTreeNode sellNode = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
        int type = ((DeployUserObject)sellNode.getUserObject()).getType();
        if (paths.length != 1 || type != 5 && type != 6 && type != 7 && type != 3 && type != 9) return;
        String appl = this.getSelectedApplication();
        String dirName = null;
        this.chooser = new CFileChooser(this.mainFrame);
        if (appl != null) {
            int answer = JOptionPane.showConfirmDialog(this.mainFrame, "Selected application : \n" + appl, "Get client jars", 2);
            if (answer != 0) return;
            String[] dirs = this.chooser.showDirDialog("Choose output directory for client jars", false);
            if (dirs == null) {
                return;
            }
            dirName = dirs[0];
            if (dirName == null) {
                return;
            }
            try {
                SerializableFile res = this.dri.getClientJar(null, appl, null);
                if (!new File(dirName).exists()) {
                    new File(dirName).mkdirs();
                }
                FileOutputStream out = null;
                if (res == null || res.getBytes() == null) return;
                out = new FileOutputStream((dirName == null ? "." : dirName) + File.separator + res.getFileName());
                out.write(res.getBytes());
                out.flush();
                out.close();
                Object var13_12 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException excep) {
                    DeployRuntimeView.logThrowableT(500, "Unexpected exception.", excep);
                    JOptionPane.showMessageDialog(this.mainFrame, "Error: " + excep.toString(), "Error", 0);
                }
                return;
                {
                    catch (FileNotFoundException fnfo) {
                        DeployRuntimeView.logThrowableT(500, "Unexpected exception.", fnfo);
                        JOptionPane.showMessageDialog(this.mainFrame, "Error: " + fnfo.toString(), "Error", 0);
                        Object var13_13 = null;
                        if (out == null) return;
                        try {
                            out.close();
                            return;
                        }
                        catch (IOException excep) {
                            DeployRuntimeView.logThrowableT(500, "Unexpected exception.", excep);
                            JOptionPane.showMessageDialog(this.mainFrame, "Error: " + excep.toString(), "Error", 0);
                        }
                        return;
                    }
                    catch (IOException ioe) {
                        DeployRuntimeView.logThrowableT(500, "Unexpected exception.", ioe);
                        JOptionPane.showMessageDialog(this.mainFrame, "Error: " + ioe.toString(), "Error", 0);
                        Object var13_14 = null;
                        if (out == null) return;
                        try {
                            out.close();
                            return;
                        }
                        catch (IOException excep) {
                            DeployRuntimeView.logThrowableT(500, "Unexpected exception.", excep);
                            JOptionPane.showMessageDialog(this.mainFrame, "Error: " + excep.toString(), "Error", 0);
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    if (out == null) throw throwable;
                    try {
                        out.close();
                        throw throwable;
                    }
                    catch (IOException excep) {
                        DeployRuntimeView.logThrowableT(500, "Unexpected exception.", excep);
                        JOptionPane.showMessageDialog(this.mainFrame, "Error: " + excep.toString(), "Error", 0);
                    }
                    throw throwable;
                }
            }
            catch (UndeclaredThrowableException ute) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"client jar"}, ute);
                JOptionPane.showMessageDialog(this.mainFrame, "Can not get client jar " + ute.toString(), "Error!", 0);
                return;
            }
            catch (RemoteException ex) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"client jar"}, ex);
                JOptionPane.showMessageDialog(this.mainFrame, "Can not get client jar " + ex.toString(), "Error!", 0);
            }
            return;
        }
        this.warning();
    }

    protected void removeAction() {
        if (removeDialog == null) {
            removeDialog = new RemoveDialogLogical(this.mainFrame, "Remove", true);
        }
        this.shotExpandState();
        String[] appNames = this.getSelectedApplications();
        if (appNames != null) {
            int i = 0;
            while (i < appNames.length) {
                block11: {
                    if (appNames[i] != null) {
                        try {
                            removeDialog.showApplDialog(appNames[i], this.dri.getApplicationInformation(appNames[i]).getContainerNames(), this.dri.getServerNames());
                            if (removeDialog.isOK()) {
                                if (DeployRuntimeView.manager != null) {
                                    this.applicationTask = null;
                                    this.applicationTask = new ApplicationTask(this.dri, removeDialog.getApplication().trim(), removeDialog.getListCompData(), removeDialog.getListServData(), true);
                                    DeployRuntimeView.manager.addTask((TaskItem)this.applicationTask);
                                    Thread thread = new Thread(this.applicationTask);
                                    thread.start();
                                } else {
                                    this.dri.remove(removeDialog.getApplication().trim(), removeDialog.getListCompData(), removeDialog.getListServData());
                                    this.root.removeAllChildren();
                                    this.containerRoot.removeAllChildren();
                                    this.applRoot.removeAllChildren();
                                    this.initTree();
                                }
                                break block11;
                            }
                            return;
                        }
                        catch (UndeclaredThrowableException ute) {
                            DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"application " + appNames[i] + " removed"}, ute);
                            JOptionPane.showMessageDialog(this.mainFrame, "Error " + ute.toString(), "Error", 0);
                        }
                        catch (RemoteException ex) {
                            DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"application " + appNames[i] + " removed"}, ex);
                            JOptionPane.showMessageDialog(this.mainFrame, "Error " + ex.toString(), "Error", 0);
                        }
                    }
                }
                ++i;
            }
        } else {
            this.warning();
        }
    }

    private void shotExpandState() {
        this.expanded = new Vector();
        Enumeration<TreePath> enumeration = this.deployTree.getExpandedDescendants(this.deployTree.getPathForRow(0));
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                this.expanded.add(((Object)enumeration.nextElement()).toString());
            }
        }
    }

    public void show(Remote ri) {
        this.dri = (DeployRuntimeControlInterface)ri;
        this.initTreeSimple();
        ((DefaultTreeModel)this.deployTree.getModel()).setRoot(this.root);
        ((DefaultTreeModel)this.deployTree.getModel()).reload();
        this.lastSelectedModel = (DefaultTreeModel)this.deployTree.getModel();
        this.lastSelectedModel.setRoot(this.root);
        Thread init = new Thread(this);
        init.start();
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
        if (deployDialog != null) {
            deployDialog.setFrame(this.mainFrame);
        }
        if (removeDialog != null) {
            removeDialog.setFrame(this.mainFrame);
        }
    }

    public void freeResources() {
        this.root.removeAllChildren();
        this.containerRoot.removeAllChildren();
        this.applRoot.removeAllChildren();
    }

    protected String[] getSelectedComponents() {
        Vector<String> comp = new Vector<String>();
        Object[] elem = null;
        TreePath[] paths = this.deployTree.getSelectionPaths();
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                DefaultMutableTreeNode sellNode = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                int type = ((DeployUserObject)sellNode.getUserObject()).getType();
                if (type == 4) {
                    comp.add(((DeployUserObject)sellNode.getUserObject()).getName());
                }
                ++i;
            }
            elem = new String[comp.size()];
            comp.copyInto(elem);
        }
        return elem;
    }

    protected String getSelectedApplication() {
        return this.getSelectedApplications()[0];
    }

    protected String[] getSelectedApplications() {
        String[] elem = new String[1];
        TreePath[] paths = this.deployTree.getSelectionPaths();
        if (paths != null && paths.length > 0) {
            elem = new String[paths.length];
            int i = 0;
            while (i < paths.length) {
                DefaultMutableTreeNode sellNode = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                int type = ((DeployUserObject)sellNode.getUserObject()).getType();
                if (type != 5 && type != 6 && type != 7 && type != 3 && type != 9) {
                    return new String[1];
                }
                elem[i] = ((DeployUserObject)sellNode.getUserObject()).getName();
                ++i;
            }
        }
        return elem;
    }

    private DeployTreeNode findChildNode(DeployTreeNode root, String child) {
        if (child != null && root != null) {
            DeployTreeNode current = null;
            int i = 0;
            while (i < root.getChildCount()) {
                current = (DeployTreeNode)root.getChildAt(i);
                if (child.equals(current.getName())) {
                    return current;
                }
                ++i;
            }
        }
        return null;
    }

    private void makeAppl(String applName, String contName, String serverName, String elem) {
        if (applName == null) {
            return;
        }
        DeployTreeNode current = this.findChildNode(this.applRoot, applName);
        DeployTreeNode contNode = null;
        DeployTreeNode serverNode = null;
        DeployTreeNode elementNode = null;
        if (current == null) {
            current = this.makeApplNode(applName, null);
        }
        if (current != null) {
            this.applRoot.add(current);
            if (serverName != null && current != null && (serverNode = this.findChildNode(current, serverName)) == null) {
                serverNode = new DeployTreeNode(serverName, 1, ImageHolder.serverIcon);
                current.add(serverNode);
            }
            if (contName != null && serverNode != null && (contNode = this.findChildNode(serverNode, contName)) == null) {
                contNode = new DeployTreeNode(contName, 2, ImageHolder.containerIcon);
                serverNode.add(contNode);
            }
            if (elem != null && contNode != null && (elementNode = this.findChildNode(contNode, elem)) == null) {
                elementNode = new DeployTreeNode(elem, 4, ImageHolder.componentIcon);
                contNode.add(elementNode);
            }
        }
    }

    private void makeCont(String contName, String serverName, String applName, String elem) {
        if (contName == null) {
            return;
        }
        DeployTreeNode contNode = this.findChildNode(this.containerRoot, contName);
        DeployTreeNode applNode = null;
        DeployTreeNode serverNode = null;
        DeployTreeNode elementNode = null;
        if (contNode == null) {
            contNode = new DeployTreeNode(contName, 2, ImageHolder.containerIcon);
        }
        if (contNode != null) {
            this.containerRoot.add(contNode);
            if (serverName != null && contNode != null && (serverNode = this.findChildNode(contNode, serverName)) == null) {
                serverNode = new DeployTreeNode(serverName, 1, ImageHolder.serverIcon);
                contNode.add(serverNode);
            }
            if (applName != null && serverNode != null && (applNode = this.findChildNode(serverNode, applName)) == null && (applNode = this.makeApplNode(applName, serverName)) != null) {
                serverNode.add(applNode);
            }
            if (elem != null && applNode != null && (elementNode = this.findChildNode(applNode, elem)) == null) {
                elementNode = new DeployTreeNode(elem, 4, ImageHolder.componentIcon);
                applNode.add(elementNode);
            }
        }
    }

    public DeployTreeNode makeApplNode(String applName, String serverName) {
        DeployTreeNode current = null;
        if (applName != null) {
            String typeApp;
            try {
                typeApp = serverName != null ? this.dri.getApplicationStatus(applName, serverName) : this.dri.getApplicationStatus(applName);
            }
            catch (UndeclaredThrowableException ute) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"status of " + applName + " application from server " + serverName}, ute);
                typeApp = null;
            }
            catch (RemoteException re) {
                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"status of " + applName + " application from server " + serverName}, re);
                typeApp = null;
            }
            if (typeApp != null) {
                if (typeApp.equals("STARTED")) {
                    current = new DeployTreeNode(applName, 5, ImageHolder.startedIcon);
                } else if (typeApp.equals("STARTING")) {
                    current = new DeployTreeNode(applName, 6, ImageHolder.startingIcon);
                } else if (typeApp.equals("STOPPED")) {
                    current = new DeployTreeNode(applName, 3, ImageHolder.stoppedIcon);
                } else if (typeApp.equals("IMPLICIT_STOPPED")) {
                    current = new DeployTreeNode(applName, 9, ImageHolder.stoppedIcon);
                } else if (typeApp.equals("STOPPING")) {
                    current = new DeployTreeNode(applName, 7, ImageHolder.stoppedIcon);
                } else if (typeApp.equals("UPGRADING")) {
                    current = new DeployTreeNode(applName, 8, ImageHolder.upgradingIcon);
                }
            }
        }
        return current;
    }

    public void setDisable() {
        this.removeBtn.setEnabled(false);
        this.clientBtn.setEnabled(false);
        this.startBtn.setEnabled(false);
        this.stopBtn.setEnabled(false);
        this.addAppInfoBtn.setEnabled(false);
    }

    protected void startAction() {
        try {
            String appName = this.getSelectedApplication();
            if (appName != null) {
                StartStopServerDialog startDialog = new StartStopServerDialog(this.mainFrame, true);
                startDialog.initData(this.filterServerNames(appName, this.dri.getServerNames(), true));
                ((Component)((Object)startDialog)).setVisible(true);
                if (!startDialog.isOk()) {
                    return;
                }
                if (startDialog.getServers() != null && startDialog.getServers().length != 0) {
                    if (DeployRuntimeView.manager != null) {
                        this.mainFrame.setCursor(new Cursor(3));
                        this.applicationTask = null;
                        this.applicationTask = new ApplicationTask(this.dri, appName, startDialog.getServers(), true);
                        DeployRuntimeView.manager.addTask((TaskItem)this.applicationTask);
                        Thread thread = new Thread(this.applicationTask);
                        thread.start();
                    } else {
                        this.dri.startApplication(appName, startDialog.getServers());
                    }
                }
            } else {
                this.warning();
            }
        }
        catch (UndeclaredThrowableException ute) {
            DeployRuntimeView.logThrowableT(500, "Operation {0} finished with {1} {2}", new Object[]{"start", "error", ""}, ute);
            JOptionPane.showMessageDialog(this.mainFrame, "Error: " + ute.toString(), "Error!", 0);
        }
        catch (RemoteException re) {
            DeployRuntimeView.logThrowableT(500, "Operation {0} finished with {1} {2}", new Object[]{"start", "error", ""}, re);
            JOptionPane.showMessageDialog(this.mainFrame, "Error: " + re.toString(), "Error!", 0);
        }
    }

    protected void stopAction() {
        try {
            String appName = this.getSelectedApplication();
            if (appName != null) {
                StartStopServerDialog stopDialog = new StartStopServerDialog(this.mainFrame, false);
                stopDialog.initData(this.filterServerNames(appName, this.dri.getServerNames(), false));
                ((Component)((Object)stopDialog)).setVisible(true);
                if (!stopDialog.isOk()) {
                    return;
                }
                if (stopDialog.getServers() != null && stopDialog.getServers().length != 0) {
                    if (DeployRuntimeView.manager != null) {
                        this.mainFrame.setCursor(new Cursor(3));
                        this.applicationTask = null;
                        this.applicationTask = new ApplicationTask(this.dri, appName, stopDialog.getServers(), false);
                        DeployRuntimeView.manager.addTask((TaskItem)this.applicationTask);
                        Thread thread = new Thread(this.applicationTask);
                        thread.start();
                    } else {
                        this.dri.stopApplication(appName, stopDialog.getServers());
                    }
                }
            } else {
                this.warning();
            }
        }
        catch (UndeclaredThrowableException ute) {
            DeployRuntimeView.logThrowableT(500, "Operation {0} finished with {1} {2}", new Object[]{"stop", "error", ""}, ute);
            JOptionPane.showMessageDialog(this.mainFrame, "Error: " + ute.toString(), "Error!", 0);
        }
        catch (RemoteException re) {
            DeployRuntimeView.logThrowableT(500, "Operation {0} finished with {1} {2}", new Object[]{"stop", "error", ""}, re);
            JOptionPane.showMessageDialog(this.mainFrame, "Error: " + re.toString(), "Error!", 0);
        }
    }

    private String[] filterServerNames(String appName, String[] serverNames, boolean isStartting) {
        ArrayList<String> list = new ArrayList<String>();
        if (serverNames != null) {
            String status = null;
            int i = 0;
            while (i < serverNames.length) {
                try {
                    status = this.dri.getApplicationStatus(appName, serverNames[i]);
                }
                catch (UndeclaredThrowableException ute) {
                    DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"status of " + appName + " application from server " + serverNames[i]}, ute);
                    status = null;
                }
                catch (RemoteException re) {
                    DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"status of " + appName + " application from server " + serverNames[i]}, re);
                    status = null;
                }
                if (status != null) {
                    if (isStartting) {
                        if (!status.equals("STARTED") && !status.equals("STARTING")) {
                            list.add(serverNames[i]);
                        }
                    } else if (!status.equals("STOPPED") && !status.equals("STOPPING")) {
                        list.add(serverNames[i]);
                    }
                }
                ++i;
            }
        }
        String[] result = null;
        if (list != null && list.size() != 0) {
            result = new String[list.size()];
            list.toArray(result);
        }
        return result;
    }

    public void reloadStatus(String status, DeployEvent event) {
        try {
            this.changeTreesForApplication(status, event);
            Runnable trivialRunnable = new Runnable(){

                public void run() {
                    TreePath[] paths = ApplicationsPanel.this.deployTree.getSelectionModel().getSelectionPaths();
                    if (paths != null && paths.length == 1) {
                        DefaultMutableTreeNode sellNode = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
                        ApplicationsPanel.this.refreshButtons(((DeployTreeNode)sellNode).getName());
                    }
                }
            };
            SwingUtilities.invokeLater(trivialRunnable);
        }
        catch (Exception ex) {
            DeployRuntimeView.logThrowableT(500, "Unexpected exception.", ex);
        }
        this.deployTree.repaint();
        this.mainFrame.setCursor(new Cursor(0));
    }

    private void changeServerTreeForApplication(String newStatus, DeployEvent event) {
        DeployTreeNode parentNode = null;
        DeployTreeNode childNode = null;
        DeployTreeNode child = null;
        Enumeration<TreeNode> servers = this.root.children();
        boolean found = false;
        while (servers.hasMoreElements()) {
            parentNode = (DeployTreeNode)servers.nextElement();
            if (!parentNode.getName().equals(event.getServer())) continue;
            found = true;
            break;
        }
        if (found) {
            found = false;
            Enumeration<TreeNode> containers = parentNode.children();
            while (containers.hasMoreElements()) {
                String[] elements;
                childNode = (DeployTreeNode)containers.nextElement();
                Enumeration<TreeNode> applications = childNode.children();
                block6: while (applications.hasMoreElements()) {
                    child = (DeployTreeNode)applications.nextElement();
                    if (!child.getName().equals(event.getComponentName())) continue;
                    switch (event.getActionType()) {
                        case 0: {
                            childNode.remove(child);
                            if (this.lastSelectedButton != this.servBtn) break block6;
                            this.lastSelectedModel.reload(childNode);
                            break;
                        }
                        case 7: {
                            childNode.remove(child);
                            if (this.lastSelectedButton != this.servBtn) break block6;
                            this.lastSelectedModel.reload(childNode);
                            break;
                        }
                        default: {
                            this.setStatusOnNode(newStatus, child);
                            break;
                        }
                    }
                    break;
                }
                if (event.getActionType() != 0 || event.getContainer_components() == null || childNode.getName() == null || event.getContainer_components().get(childNode.getName()) == null) continue;
                DeployTreeNode newChild = new DeployTreeNode(event.getComponentName(), 3, ImageHolder.stoppedIcon);
                this.setStatusOnNode(newStatus, newChild);
                if (event.getContainer_components() != null && event.getContainer_components().get(childNode.getName()) != null && (elements = (String[])event.getContainer_components().get(childNode.getName())) != null) {
                    int i = 0;
                    while (i < elements.length) {
                        DeployTreeNode elChild = new DeployTreeNode(elements[i], 4, ImageHolder.componentIcon);
                        elChild.setNodeLevel(4);
                        newChild.add(elChild);
                        ++i;
                    }
                }
                childNode.add(newChild);
                if (this.lastSelectedButton != this.servBtn) continue;
                this.lastSelectedModel.reload(childNode);
            }
        }
    }

    private void setStatusOnNode(String newStatus, DeployTreeNode child) {
        if (newStatus.equals("STARTED")) {
            child.setNodeLevel(5);
            child.setType(5);
            ((DeployUserObject)child.getUserObject()).setType(5);
        } else if (newStatus.equals("STARTING")) {
            child.setNodeLevel(6);
            child.setType(6);
            ((DeployUserObject)child.getUserObject()).setType(6);
        } else if (newStatus.equals("STOPPED")) {
            child.setNodeLevel(3);
            child.setType(3);
            ((DeployUserObject)child.getUserObject()).setType(3);
        } else if (newStatus.equals("IMPLICIT_STOPPED")) {
            child.setNodeLevel(9);
            child.setType(9);
            ((DeployUserObject)child.getUserObject()).setType(9);
        } else if (newStatus.equals("STOPPING")) {
            child.setNodeLevel(7);
            child.setType(7);
            ((DeployUserObject)child.getUserObject()).setType(7);
        } else if (newStatus.equals("UPGRADING")) {
            child.setNodeLevel(8);
            child.setType(8);
            ((DeployUserObject)child.getUserObject()).setType(8);
        }
    }

    private void changeAppTreeForApplication(String newStatus, DeployEvent event) {
        DeployTreeNode current = null;
        int childCount = this.applRoot.getChildCount();
        if (event.getComponentName() == null) {
            return;
        }
        boolean found = false;
        if (childCount != 0) {
            int i = 0;
            block4: while (i < childCount) {
                current = (DeployTreeNode)this.applRoot.getChildAt(i);
                String currName = current.getName();
                if (currName.equals(event.getComponentName())) {
                    switch (event.getActionType()) {
                        case 0: {
                            if (event.getAction() == 3) {
                                this.applRoot.remove(current);
                                if (this.lastSelectedButton != this.applBtn) break block4;
                                this.lastSelectedModel.reload(this.applRoot);
                                break;
                            }
                            found = true;
                            break;
                        }
                        case 7: {
                            this.applRoot.remove(current);
                            if (this.lastSelectedButton != this.applBtn) break block4;
                            this.lastSelectedModel.reload(this.applRoot);
                            break;
                        }
                        default: {
                            this.setStatusOnNode(newStatus, current);
                            break;
                        }
                    }
                    break;
                }
                ++i;
            }
        }
        if (event.getActionType() == 0) {
            if (!found) {
                current = new DeployTreeNode(event.getComponentName(), 3, ImageHolder.stoppedIcon);
                this.setStatusOnNode(newStatus, current);
            }
            DeployTreeNode serverNode = new DeployTreeNode(event.getServer(), 1, ImageHolder.serverIcon);
            serverNode.setNodeLevel(1);
            DeployTreeNode contNode = null;
            DeployTreeNode elementNode = null;
            if (event.getContainer_components() != null) {
                Enumeration containers = event.getContainer_components().keys();
                String contName = null;
                String[] elements = null;
                while (containers.hasMoreElements()) {
                    contName = (String)containers.nextElement();
                    contNode = new DeployTreeNode(contName, 2, ImageHolder.containerIcon);
                    contNode.setNodeLevel(2);
                    elements = (String[])event.getContainer_components().get(contName);
                    if (elements != null) {
                        int i = 0;
                        while (i < elements.length) {
                            elementNode = new DeployTreeNode(elements[i], 4, ImageHolder.componentIcon);
                            elementNode.setNodeLevel(4);
                            contNode.add(elementNode);
                            ++i;
                        }
                    }
                    serverNode.add(contNode);
                }
            }
            current.add(serverNode);
            if (!found) {
                this.applRoot.add(current);
                if (this.lastSelectedButton == this.applBtn) {
                    this.lastSelectedModel.reload(this.applRoot);
                }
            }
        }
    }

    private void changeContTreeForApplication(String newStatus, DeployEvent event) {
        DeployTreeNode applNode = null;
        DeployTreeNode contNode = null;
        DeployTreeNode serverNode = null;
        int childCount = this.containerRoot.getChildCount();
        int count = 0;
        int count1 = 0;
        if (childCount != 0) {
            int i = 0;
            while (i < childCount) {
                contNode = (DeployTreeNode)this.containerRoot.getChildAt(i);
                count = contNode.getChildCount();
                int j = 0;
                while (j < count) {
                    serverNode = (DeployTreeNode)contNode.getChildAt(j);
                    if (serverNode.getName().equals(event.getServer())) {
                        count1 = serverNode.getChildCount();
                        String[] elements = null;
                        DeployTreeNode elementNode = null;
                        int k = 0;
                        block6: while (k < count1) {
                            applNode = (DeployTreeNode)serverNode.getChildAt(k);
                            if (applNode.getName().equals(event.getComponentName())) {
                                switch (event.getActionType()) {
                                    case 0: {
                                        serverNode.remove(applNode);
                                        if (this.lastSelectedButton != this.contBtn) break block6;
                                        this.lastSelectedModel.reload(serverNode);
                                        break;
                                    }
                                    case 7: {
                                        serverNode.remove(applNode);
                                        if (this.lastSelectedButton != this.contBtn) break block6;
                                        this.lastSelectedModel.reload(serverNode);
                                        break;
                                    }
                                    default: {
                                        this.setStatusOnNode(newStatus, applNode);
                                        break;
                                    }
                                }
                                break;
                            }
                            ++k;
                        }
                        if (event.getActionType() != 0 || event.getContainer_components() == null || contNode.getName() == null || event.getContainer_components().get(contNode.getName()) == null) break;
                        applNode = new DeployTreeNode(event.getComponentName(), 3, ImageHolder.stoppedIcon);
                        this.setStatusOnNode(newStatus, applNode);
                        elements = (String[])event.getContainer_components().get(contNode.getName());
                        if (elements != null) {
                            int k2 = 0;
                            while (k2 < elements.length) {
                                elementNode = new DeployTreeNode(elements[k2], 4, ImageHolder.componentIcon);
                                elementNode.setNodeLevel(4);
                                applNode.add(elementNode);
                                ++k2;
                            }
                        }
                        serverNode.add(applNode);
                        if (this.lastSelectedButton != this.contBtn) break;
                        this.lastSelectedModel.reload(serverNode);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void changeTreesForApplication(String newStatus, DeployEvent event) {
        this.changeServerTreeForApplication(newStatus, event);
        if (event.getServer().equals(this.serverName)) {
            this.changeAppTreeForApplication(newStatus, event);
        }
        this.changeContTreeForApplication(newStatus, event);
    }

    public boolean setNewStatus(String applName, String serverName, DeployTreeNode node, int newStatus) {
        DeployTreeNode applNode = null;
        boolean flag = false;
        if (node != null && node.getChildCount() != 0) {
            int i = 0;
            while (i < node.getChildCount()) {
                applNode = (DeployTreeNode)node.getChildAt(i);
                if (applNode != null && applNode.getName().equals(applName) && ((DeployUserObject)applNode.getUserObject()).getType() != 1 && ((DeployUserObject)applNode.getUserObject()).getType() != 2 && ((DeployUserObject)applNode.getUserObject()).getType() != 4 && ((DeployUserObject)applNode.getUserObject()).getType() != newStatus && newStatus != -1) {
                    applNode.setUserObject(new DeployUserObject(applName, newStatus, null));
                    flag = true;
                    this.setNewStatus(applName, serverName, applNode, newStatus);
                }
                if (this.setNewStatus(applName, serverName, applNode, newStatus)) {
                    flag = true;
                }
                ++i;
            }
        }
        return flag;
    }

    public int getIntType(String typeApp) {
        if (typeApp != null) {
            if (typeApp.equals("STARTED")) {
                return 5;
            }
            if (typeApp.equals("STARTING")) {
                return 6;
            }
            if (typeApp.equals("STOPPED")) {
                return 3;
            }
            if (typeApp.equals("STOPPING")) {
                return 7;
            }
            if (typeApp.equals("UPGRADING")) {
                return 8;
            }
            if (typeApp.equals("IMPLICIT_STOPPED")) {
                return 9;
            }
        }
        return -1;
    }

    public void refreshButtons(String applName) {
        block18: {
            TreePath[] paths = this.deployTree.getSelectionModel().getSelectionPaths();
            if (paths != null) {
                if (paths.length == 1) {
                    DefaultMutableTreeNode sellNode = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
                    if (applName != null && applName.equals(((DeployTreeNode)sellNode).getName())) {
                        int type = ((DeployUserObject)sellNode.getUserObject()).getType();
                        if (type == 5 || type == 6 || type == 7 || type == 3 || type == 9 || type == 8) {
                            this.removeBtn.setEnabled(true);
                            this.clientBtn.setEnabled(true);
                            this.addAppInfoBtn.setEnabled(true);
                            try {
                                if (this.filterServerNames(applName, this.dri.getServerNames(), true) != null) {
                                    this.startBtn.setEnabled(true);
                                } else {
                                    this.startBtn.setEnabled(false);
                                }
                            }
                            catch (UndeclaredThrowableException ute) {
                                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"server names"}, ute);
                                this.startBtn.setEnabled(false);
                            }
                            catch (RemoteException re) {
                                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"server names"}, re);
                                this.startBtn.setEnabled(false);
                            }
                            try {
                                if (this.filterServerNames(applName, this.dri.getServerNames(), false) != null) {
                                    this.stopBtn.setEnabled(true);
                                    break block18;
                                }
                                this.stopBtn.setEnabled(false);
                            }
                            catch (UndeclaredThrowableException ute) {
                                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"server names"}, ute);
                                this.stopBtn.setEnabled(false);
                            }
                            catch (RemoteException re) {
                                DeployRuntimeView.logThrowableT(500, "Cannot get {0}.", new Object[]{"server names"}, re);
                                this.stopBtn.setEnabled(false);
                            }
                        } else {
                            this.setDisable();
                        }
                    } else {
                        this.setDisable();
                    }
                } else {
                    this.setDisable();
                    if (applName != null) {
                        this.removeBtn.setEnabled(true);
                    }
                }
            } else {
                this.setDisable();
            }
        }
    }

    private void changeAddAppInfo() {
        AdditionalInfoDialog dialog = new AdditionalInfoDialog(this.mainFrame, "Additional Application Info", true);
        ((Component)dialog).setSize(230, 100);
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(this.mainFrame);
        String appName = this.getSelectedApplication();
        if (appName != null) {
            AdditionalAppInfo appInfo = null;
            try {
                appInfo = this.dri.getAdditionalAppInfo(appName);
                dialog.setFailOverValue(appInfo.getFailOverValue());
                dialog.show();
                if (dialog.isOk()) {
                    appInfo.setFailOverValue(dialog.getFailOverValue());
                    this.dri.setAdditionalAppInfo(appName, appInfo);
                }
            }
            catch (UndeclaredThrowableException ute) {
                DeployRuntimeView.logThrowableT(500, "Operation {0} finished with {1} {2}", new Object[]{"change AddAppInfo", "error", ""}, ute);
                JOptionPane.showMessageDialog(this.mainFrame, "Error while setting Additional applicatio info:\n " + ute.toString(), "Error", 0);
            }
            catch (RemoteException re) {
                DeployRuntimeView.logThrowableT(500, "Operation {0} finished with {1} {2}", new Object[]{"change AddAppInfo", "error", ""}, re);
                JOptionPane.showMessageDialog(this.mainFrame, "Error while setting Additional applicatio info:\n " + re.toString(), "Error", 0);
            }
        } else {
            this.warning();
        }
    }

    public void addAdditionalInfo(String message, int status) {
        if (this.deployingTask != null) {
            this.deployingTask.addAdditionalInfo(message, status);
        }
        if (this.applicationTask != null) {
            this.applicationTask.addAdditionalInfo(message, status);
        }
        if (this.fileUpdatingTask != null) {
            this.fileUpdatingTask.addAdditionalInfo(message, status);
        }
    }

    public void run() {
        this.initTree();
    }

    private void warning() {
        JOptionPane.showMessageDialog(this.mainFrame, "Please select an application.", "Warning", 2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

