/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui;

import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.services.deploy.DeployRuntimeControlInterface;
import com.sap.engine.services.deploy.gui.DeployRuntimeView;
import java.rmi.RemoteException;

public class ApplicationTask
implements Runnable,
TaskItem {
    private DeployRuntimeControlInterface deploy;
    private String[] serverNames;
    private String[] support;
    private String appName;
    private String message = "";
    private String resultMessage = "";
    private String additionalMessage = "";
    private String name = "";
    private int status;
    private double progress;
    private boolean removeApplication = false;
    private boolean startApplication = false;
    private boolean stopApplication = false;
    private long beginTime = 0L;
    private long endTime = 0L;

    public ApplicationTask() {
        this(1, 0, "");
    }

    public ApplicationTask(int status, int progress, String name) {
        this.name = name;
        this.status = status;
        this.progress = progress;
    }

    public ApplicationTask(DeployRuntimeControlInterface deploy, String applicationName, String[] serverNames, String[] support, boolean removeApplication) {
        this(1, 0, "Remove ");
        this.appName = applicationName;
        this.deploy = deploy;
        this.serverNames = serverNames;
        this.support = support;
        this.removeApplication = removeApplication;
    }

    public ApplicationTask(DeployRuntimeControlInterface deploy, String appName, String[] serverNames, boolean flag) {
        this(1, 0, "");
        if (flag) {
            this.name = "Start application ";
            this.startApplication = true;
        } else {
            this.name = "Stop application ";
            this.stopApplication = true;
        }
        this.deploy = deploy;
        this.appName = appName;
        this.serverNames = serverNames;
    }

    public String getName() {
        return this.name;
    }

    public String getAdditionalInfo() {
        String result = null;
        if (this.removeApplication) {
            result = this.message;
        } else if (this.stopApplication || this.startApplication) {
            result = this.message + (this.additionalMessage != null && !this.additionalMessage.trim().equals("") ? this.additionalMessage : this.resultMessage);
        }
        if (result == null) {
            result = "NO MESSAGE";
        }
        DeployRuntimeView.logT(100, result);
        return result;
    }

    public void addAdditionalInfo(String message, int status) {
        if (this.removeApplication) {
            if (this.message != null && this.message.indexOf(message) == -1) {
                this.message = this.message + message + "\n";
            }
        } else if ((this.stopApplication || this.startApplication) && this.additionalMessage != null && this.additionalMessage.indexOf(message) == -1) {
            this.additionalMessage = this.additionalMessage + message + "\n";
        }
        this.status = status;
    }

    public int getProgress() {
        if (this.progress >= 100.0) {
            this.status = 0;
        } else {
            this.calculate();
        }
        return (int)this.progress;
    }

    private void calculate() {
        double step = (100.0 - this.progress) / 100.0;
        this.progress += step;
    }

    public int getStatus() {
        return this.status;
    }

    public void finished() {
        this.progress = 100.0;
    }

    public void run() {
        if (this.removeApplication) {
            try {
                this.beginTime = System.currentTimeMillis();
                this.deploy.remove(this.appName, this.serverNames, this.support);
                this.endTime = System.currentTimeMillis();
                this.message = this.message + "Remove application " + this.appName + " successfully in " + (this.endTime - this.beginTime) + " ms!\n";
                this.finished();
            }
            catch (RemoteException re) {
                DeployRuntimeView.logThrowableT(500, "Operation {0} finished with {1} {2}", new Object[]{"remove", "error", ""}, re);
                this.status = 2;
                this.message = this.message + "Remove of application " + this.appName + " failed, because: " + re.toString();
            }
        }
        if (this.startApplication) {
            try {
                this.beginTime = System.currentTimeMillis();
                this.deploy.startApplication(this.appName, this.serverNames);
                this.endTime = System.currentTimeMillis();
                this.resultMessage = this.resultMessage + "Application " + this.appName + " started successfully in " + (this.endTime - this.beginTime) + " ms!\n";
                this.finished();
            }
            catch (RemoteException re) {
                DeployRuntimeView.logThrowableT(500, "Operation {0} finished with {1} {2}", new Object[]{"start", "error", ""}, re);
                this.status = 2;
                this.message = this.message + "Application " + this.appName + " not started, because:" + re.toString();
            }
        }
        if (this.stopApplication) {
            try {
                this.beginTime = System.currentTimeMillis();
                this.deploy.stopApplication(this.appName, this.serverNames);
                this.endTime = System.currentTimeMillis();
                this.resultMessage = this.resultMessage + "Application " + this.appName + " stopped successfully in " + (this.endTime - this.beginTime) + " ms!\n";
                this.finished();
            }
            catch (RemoteException re) {
                DeployRuntimeView.logThrowableT(500, "Operation {0} finished with {1} {2}", new Object[]{"stop", "error", ""}, re);
                this.status = 2;
                this.message = this.message + "Application " + this.appName + " not stopped, because:" + re.toString();
            }
        }
    }
}

