/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.extended.ear;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.lib.jar.DependenceJarUtils;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import com.sap.engine.services.dbpool.deploy.XMLUtils;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.container.ReferenceObjectIntf;
import com.sap.engine.services.deploy.ear.xml.ApplicationJ2EEEngineDocument;
import com.sap.engine.services.deploy.ear.xml.ExtendedEARDescriptorWriter;
import com.sap.engine.services.deploy.extended.ear.EARDescriptor;
import com.sap.engine.services.jmsconnector.descriptor.DestinationsDescriptorDocument;
import com.sap.engine.services.jmsconnector.descriptor.JMSConnectorDescriptor;
import com.sap.engine.services.jmsconnector.descriptor.XMLParser;
import com.sap.engine.services.log_configurator.admin.LogXMLParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import org.w3c.dom.Document;

public class MakeEar
extends DependenceJarUtils {
    EARDescriptor earDescriptor = new EARDescriptor();

    public MakeEar() {
    }

    public MakeEar(EARDescriptor descriptor) {
        this.earDescriptor = descriptor;
    }

    public void setDescriptor(EARDescriptor descriptor) {
        this.earDescriptor = descriptor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeAdditionalEntries(JarOutputStream zip) {
        StandardDOMWriter writer = new StandardDOMWriter();
        ExtendedEARDescriptorWriter doc = new ExtendedEARDescriptorWriter();
        DestinationsDescriptorDocument destDoc = new DestinationsDescriptorDocument();
        Document document = null;
        byte[] buffer = null;
        JarEntry zEntry = null;
        CRC32 crc = null;
        try {
            if (this.earDescriptor != null) {
                document = doc.loadDocument(this.earDescriptor);
                String tmpFileName = SystemProperties.getProperty((String)"user.dir") + File.separator + "tmp_application.xml";
                File tmpFile = new File(tmpFileName);
                writer.write(document, tmpFileName, "<!DOCTYPE application PUBLIC '-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN' 'http://java.sun.com/dtd/application_1_3.dtd'>", "UTF-8");
                zEntry = new JarEntry("META-INF/application.xml");
                buffer = this.getBytes(new FileInputStream(tmpFileName));
                if (buffer != null) {
                    zEntry.setMethod(0);
                    zEntry.setSize(buffer.length);
                    crc = new CRC32();
                    crc.update(buffer);
                    zEntry.setCrc(crc.getValue());
                    zip.putNextEntry(zEntry);
                    zip.write(buffer, 0, buffer.length);
                    zip.closeEntry();
                    tmpFile.delete();
                    this.addDirEntries(zip, zEntry.getName());
                }
                if ((document = destDoc.loadDocumentFromDescriptor(this.earDescriptor.getJMSConnector())) != null && destDoc.needsLoad()) {
                    tmpFileName = SystemProperties.getProperty((String)"user.dir") + File.separator + "tmp_jms-destinaitons.xml";
                    tmpFile = new File(tmpFileName);
                    writer.write(document, tmpFileName, "<!DOCTYPE jms-destinations SYSTEM 'jms-destinations.dtd'>", "UTF-8");
                    zEntry = new JarEntry(this.earDescriptor.getXmlEntry("jms-destinations.xml"));
                    buffer = this.getBytes(new FileInputStream(tmpFileName));
                    if (buffer != null) {
                        zEntry.setMethod(0);
                        zEntry.setSize(buffer.length);
                        crc = new CRC32();
                        crc.update(buffer);
                        zEntry.setCrc(crc.getValue());
                        zip.putNextEntry(zEntry);
                        zip.write(buffer, 0, buffer.length);
                        zip.closeEntry();
                        tmpFile.delete();
                        this.addDirEntries(zip, zEntry.getName());
                    }
                }
                if ((document = XMLParser.loadDocumentFromDescriptor((JMSConnectorDescriptor)this.earDescriptor.getJMSConnector())) != null) {
                    tmpFileName = SystemProperties.getProperty((String)"user.dir") + File.separator + "tmp_jms-factories.xml";
                    tmpFile = new File(tmpFileName);
                    writer.write(document, tmpFileName, "<!DOCTYPE jms-factories SYSTEM 'jms-factories.dtd'>", "UTF-8");
                    zEntry = new JarEntry(this.earDescriptor.getXmlEntry("jms-factories.xml"));
                    buffer = this.getBytes(new FileInputStream(tmpFileName));
                    if (buffer != null) {
                        zEntry.setMethod(0);
                        zEntry.setSize(buffer.length);
                        crc = new CRC32();
                        crc.update(buffer);
                        zEntry.setCrc(crc.getValue());
                        zip.putNextEntry(zEntry);
                        zip.write(buffer, 0, buffer.length);
                        zip.closeEntry();
                        tmpFile.delete();
                        this.addDirEntries(zip, zEntry.getName());
                    }
                }
                if (this.earDescriptor.getReferences() != null && this.earDescriptor.getReferences().length != 0 || this.earDescriptor.getClassPath() != null && !this.earDescriptor.getClassPath().trim().equals("") || this.earDescriptor.getProviderName() != null && !this.earDescriptor.getProviderName().trim().equals("") && !this.earDescriptor.getProviderName().trim().equals(new EARDescriptor().getProviderName()) || this.earDescriptor.getAdditionalModules() != null || this.earDescriptor.isFailOverEnable()) {
                    ApplicationJ2EEEngineDocument appDoc = new ApplicationJ2EEEngineDocument();
                    ReferenceObjectIntf[] refIntfs = this.earDescriptor.getReferences();
                    if (refIntfs != null) {
                        ReferenceObject[] refs = new ReferenceObject[refIntfs.length];
                        int i = 0;
                        while (true) {
                            if (i >= refIntfs.length) {
                                appDoc.setReferences(refs);
                                break;
                            }
                            refs[i] = new ReferenceObject();
                            refs[i].setReferenceProviderName(refIntfs[i].getReferenceProviderName());
                            refs[i].setReferenceTarget(refIntfs[i].getReferenceTarget());
                            refs[i].setReferenceTargetType(refIntfs[i].getReferenceTargetType());
                            refs[i].setReferenceType(refIntfs[i].getReferenceType());
                            ++i;
                        }
                    }
                    appDoc.setClassPath(this.earDescriptor.getClassPath());
                    appDoc.setProviderName(this.earDescriptor.getProviderName());
                    appDoc.setModules(this.earDescriptor.getAdditionalModules());
                    appDoc.setFailOverValue(this.earDescriptor.getFailOverValue());
                    try {
                        document = appDoc.loadDocumentFromFields();
                    }
                    catch (Exception e) {
                        document = null;
                    }
                    if (document != null) {
                        tmpFileName = SystemProperties.getProperty((String)"user.dir") + File.separator + "tmp_application-j2ee-engine.xml";
                        tmpFile = new File(tmpFileName);
                        writer.write(document, tmpFileName, "<!DOCTYPE application-j2ee-engine SYSTEM 'application-j2ee-engine.dtd'>", "UTF-8");
                        zEntry = new JarEntry("META-INF/application-j2ee-engine.xml");
                        buffer = this.getBytes(new FileInputStream(tmpFileName));
                        if (buffer != null) {
                            zEntry.setMethod(0);
                            zEntry.setSize(buffer.length);
                            crc = new CRC32();
                            crc.update(buffer);
                            zEntry.setCrc(crc.getValue());
                            zip.putNextEntry(zEntry);
                            zip.write(buffer, 0, buffer.length);
                            zip.closeEntry();
                            tmpFile.delete();
                            this.addDirEntries(zip, zEntry.getName());
                        }
                    }
                }
                if (this.earDescriptor.getJdbcDescr() != null && this.earDescriptor.getJdbcDescr().length != 0) {
                    JDBCDescriptor[] tempJDBCArr = this.earDescriptor.getJdbcDescr();
                    Vector<JDBCDescriptor> tempJDBCVector = new Vector<JDBCDescriptor>();
                    int i = 0;
                    while (true) {
                        if (i >= tempJDBCArr.length) {
                            tmpFileName = SystemProperties.getProperty((String)"user.dir") + File.separator + "tmp_data-sources.xml";
                            tmpFile = new File(tmpFileName);
                            XMLUtils.generateAllXML((String)this.earDescriptor.getApplicationID(), tempJDBCVector, (String)tmpFileName);
                            zEntry = new JarEntry(this.earDescriptor.getXmlEntry("data-sources.xml"));
                            buffer = this.getBytes(new FileInputStream(tmpFileName));
                            if (buffer == null) break;
                            zEntry.setMethod(0);
                            zEntry.setSize(buffer.length);
                            crc = new CRC32();
                            crc.update(buffer);
                            zEntry.setCrc(crc.getValue());
                            zip.putNextEntry(zEntry);
                            zip.write(buffer, 0, buffer.length);
                            zip.closeEntry();
                            tmpFile.delete();
                            this.addDirEntries(zip, zEntry.getName());
                            break;
                        }
                        tempJDBCVector.add(tempJDBCArr[i]);
                        ++i;
                    }
                }
                if (this.earDescriptor.getlogConfiguration() != null) {
                    tmpFileName = SystemProperties.getProperty((String)"user.dir") + File.separator + "tmp_log-configuration.xml";
                    tmpFile = new File(tmpFileName);
                    LogXMLParser.writeToXml((OutputStream)new FileOutputStream(tmpFile), (LogConfiguration)this.earDescriptor.getlogConfiguration());
                    zEntry = new JarEntry(this.earDescriptor.getXmlEntry("log-configuration.xml"));
                    buffer = this.getBytes(new FileInputStream(tmpFileName));
                    if (buffer != null) {
                        zEntry.setMethod(0);
                        zEntry.setSize(buffer.length);
                        crc = new CRC32();
                        crc.update(buffer);
                        zEntry.setCrc(crc.getValue());
                        zip.putNextEntry(zEntry);
                        zip.write(buffer, 0, buffer.length);
                        zip.closeEntry();
                        tmpFile.delete();
                        this.addDirEntries(zip, zEntry.getName());
                    }
                }
                if (this.earDescriptor.getDataSourceAliase() != null) {
                    tmpFileName = SystemProperties.getProperty((String)"user.dir") + File.separator + "tmp_data-source-aliases.xml";
                    tmpFile = new File(tmpFileName);
                    XMLUtils.generateAliasesXML((String)this.earDescriptor.getApplicationID(), (Hashtable)this.earDescriptor.getDataSourceAliase(), (String)tmpFileName);
                    zEntry = new JarEntry(this.earDescriptor.getXmlEntry("data-source-aliases.xml"));
                    buffer = this.getBytes(new FileInputStream(tmpFileName));
                    if (buffer != null) {
                        zEntry.setMethod(0);
                        zEntry.setSize(buffer.length);
                        crc = new CRC32();
                        crc.update(buffer);
                        zEntry.setCrc(crc.getValue());
                        zip.putNextEntry(zEntry);
                        zip.write(buffer, 0, buffer.length);
                        zip.closeEntry();
                        tmpFile.delete();
                        this.addDirEntries(zip, zEntry.getName());
                    }
                }
            }
            if (this.hasManifest(((JarUtils)this).infoObjects)) return;
            zEntry = new JarEntry("META-INF/MANIFEST.MF");
            zEntry.setSize(0L);
            crc = new CRC32();
            buffer = new byte[]{};
            crc.update(buffer);
            zEntry.setCrc(crc.getValue());
            try {
                zip.putNextEntry(zEntry);
                zip.write(buffer, 0, buffer.length);
                Object var16_19 = null;
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                zip.closeEntry();
                throw throwable;
            }
            zip.closeEntry();
            return;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void makeEar(String earName, Vector infos) throws IOException {
        this.makeJarFromFiles(earName, infos);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getBytes(InputStream in) throws IOException {
        int c;
        if (in == null) {
            return null;
        }
        byte[] buff = null;
        ByteArrayOutputStream b = null;
        b = in.available() > 1 ? new ByteArrayOutputStream(in.available()) : new ByteArrayOutputStream();
        BufferedInputStream bin = new BufferedInputStream(in);
        while ((c = bin.read()) != -1) {
            void var3_5;
            b.write((int)var3_5);
        }
        b.flush();
        b.close();
        bin.close();
        buff = b.toByteArray();
        in.close();
        return buff;
    }
}

