/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.extended.ear;

import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.jar.JarExtractor;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import com.sap.engine.services.dbpool.deploy.XMLUtils;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.SimpleEarDescriptor;
import com.sap.engine.services.deploy.ear.xml.ApplicationJ2EEEngineDocument;
import com.sap.engine.services.deploy.ear.xml.ExtendedEARDescriptorReader;
import com.sap.engine.services.deploy.extended.ear.EARDescriptor;
import com.sap.engine.services.jmsconnector.descriptor.DestinationsDescriptorDocument;
import com.sap.engine.services.jmsconnector.descriptor.JMSConnectorDescriptor;
import com.sap.engine.services.jmsconnector.descriptor.XMLParser;
import com.sap.engine.services.log_configurator.admin.LogXMLParser;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ExtendedEARReader {
    String errorMsg = "";
    String debugMsg = "";
    protected EARDescriptor descr = null;
    protected File tempDir = null;
    protected String filename = null;
    protected ClassLoader loader = null;
    private Hashtable fileMappings = new Hashtable();
    protected Hashtable j2eeJars = new Hashtable();
    protected Hashtable nonJ2EEJars = new Hashtable();
    protected ContainerInfo[] cinfoes = null;
    protected File[] clientJarFiles = null;
    protected File[] connectorRarFiles = null;
    protected File[] ejbJars = null;
    protected File[] otherJarFiles = null;
    protected File[] serviceJars = null;
    protected File[] warFiles = null;
    private String dtd = null;

    public ExtendedEARReader() {
    }

    public ExtendedEARReader(String _filename) throws IOException {
        this.filename = _filename;
        File file = new File(this.filename);
        this.tempDir = new File(file.getParentFile(), "reader" + System.currentTimeMillis());
        this.tempDir.mkdirs();
        try {
            this.descr = this.getDescriptor();
        }
        catch (IOException ioex) {
            this.clear();
            throw ioex;
        }
    }

    public ExtendedEARReader(String _filename, File _tempDir) throws IOException {
        this.filename = _filename;
        this.tempDir = new File(_tempDir, "reader" + System.currentTimeMillis());
        this.tempDir.mkdirs();
        try {
            this.descr = this.getDescriptor();
        }
        catch (IOException ioex) {
            this.clear();
            throw ioex;
        }
    }

    public void setContainerInfoes(ContainerInfo[] cinfoes) {
        this.cinfoes = cinfoes;
    }

    public void setJarName(String _filename) throws IOException {
        this.filename = _filename;
        File file = new File(this.filename);
        this.tempDir = new File(file.getParentFile(), "reader" + System.currentTimeMillis());
        this.tempDir.mkdirs();
        try {
            this.descr = this.getDescriptor();
        }
        catch (IOException ioex) {
            this.clear();
            throw ioex;
        }
    }

    public String getJarName() {
        return this.filename;
    }

    public void clear() {
        if (this.tempDir.exists()) {
            FileUtils.deleteDirectory((File)this.tempDir);
        }
    }

    public EARDescriptor getEARDescriptor() throws IOException {
        if (this.descr == null) {
            this.descr = this.getDescriptor();
        }
        return this.descr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EARDescriptor getDescriptor() throws IOException {
        EARDescriptor eARDescriptor;
        ZipFile file;
        block29: {
            InputStream xmlStream = null;
            file = null;
            StandardDOMParser parser = new StandardDOMParser();
            try {
                try {
                    Vector jdbcVector;
                    JDBCDescriptor[] jdbcArr;
                    file = new ZipFile(this.filename);
                    ZipEntry entry = this.findEntry(file, "META-INF/application.xml");
                    if (entry == null) {
                        throw new IOException("Cannot find application.xml in ear file. File name: " + this.filename);
                    }
                    xmlStream = new BufferedInputStream(file.getInputStream(entry));
                    parser.setSystemId("META-INF/application.xml");
                    Document doc = parser.parse(xmlStream);
                    ExtendedEARDescriptorReader reader = new ExtendedEARDescriptorReader();
                    SimpleEarDescriptor descr1 = reader.loadSimpleEarDescriptor(doc);
                    this.descr = new EARDescriptor(descr1);
                    this.dtd = reader.dtd;
                    if (reader.getErrorMsg(true) != null && !reader.getErrorMsg(true).equals("")) {
                        this.debugMsg = reader.getErrorMsg(true);
                    }
                    if (reader.getErrorMsg(false) != null && !reader.getErrorMsg(false).equals("")) {
                        this.errorMsg = reader.getErrorMsg(false);
                    }
                    if ((entry = this.findEntry(file, "META-INF/application-j2ee-engine.xml")) != null) {
                        xmlStream = new BufferedInputStream(file.getInputStream(entry));
                        parser.setSystemId("META-INF/application-j2ee-engine.xml");
                        doc = parser.parse(xmlStream);
                        ApplicationJ2EEEngineDocument appDoc = new ApplicationJ2EEEngineDocument();
                        appDoc.loadFieldsFromDocument(doc);
                        this.descr.setReferences(appDoc.getReferences());
                        this.descr.setClassPath(appDoc.getClassPath());
                        this.descr.setProviderName(appDoc.getProviderName());
                        this.descr.setAdditionalModules(appDoc.getModules());
                        this.descr.setFailOverValue(appDoc.getFailOverValue());
                        this.descr.setStartUpValue(appDoc.getStartUpMode());
                    }
                    if ((entry = this.findEntry(file, "META-INF/jms-destinations.xml")) == null) {
                        entry = this.findEntry(file, "jms-destinations.xml");
                    }
                    if (entry != null) {
                        this.descr.addXmlEntry("jms-destinations.xml", entry.getName());
                        xmlStream = new BufferedInputStream(file.getInputStream(entry));
                        parser.setSystemId("META-INF/jms-destinations.xml");
                        doc = parser.parse(xmlStream);
                        DestinationsDescriptorDocument destDoc = new DestinationsDescriptorDocument();
                        JMSConnectorDescriptor jms = new JMSConnectorDescriptor();
                        destDoc.loadDescriptorFromDocument(doc, jms);
                        this.descr.setJMSConnector(jms);
                    }
                    if ((entry = this.findEntry(file, "META-INF/jms-factories.xml")) == null) {
                        entry = this.findEntry(file, "jms-factories.xml");
                    }
                    if (entry != null) {
                        this.descr.addXmlEntry("jms-factories.xml", entry.getName());
                        xmlStream = new BufferedInputStream(file.getInputStream(entry));
                        parser.setSystemId("META-INF/jms-factories.xml");
                        doc = parser.parse(xmlStream);
                        JMSConnectorDescriptor jms = this.descr.getJMSConnector();
                        if (jms == null) {
                            jms = new JMSConnectorDescriptor();
                        }
                        XMLParser.loadDescriptorFromDocument((Document)doc, (JMSConnectorDescriptor)jms);
                        this.descr.setJMSConnector(jms);
                    }
                    if ((entry = this.findEntry(file, "META-INF/app-data-source.xml")) == null) {
                        entry = this.findEntry(file, "app-data-source.xml");
                    }
                    if (entry != null) {
                        this.descr.addXmlEntry("data-sources.xml", entry.getName());
                        jdbcArr = null;
                        jdbcVector = XMLUtils.processXML((InputStream)new BufferedInputStream(file.getInputStream(entry)));
                        if (jdbcVector != null && jdbcVector.size() != 0) {
                            jdbcArr = new JDBCDescriptor[jdbcVector.size()];
                            int i = 0;
                            while (i < jdbcVector.size()) {
                                jdbcArr[i] = (JDBCDescriptor)jdbcVector.elementAt(i);
                                ++i;
                            }
                        }
                        this.descr.setJdbcDescr(jdbcArr);
                    } else {
                        entry = this.findEntry(file, "META-INF/data-sources.xml");
                        if (entry == null) {
                            entry = this.findEntry(file, "data-sources.xml");
                        }
                        if (entry != null) {
                            this.descr.addXmlEntry("data-sources.xml", entry.getName());
                            jdbcArr = null;
                            jdbcVector = XMLUtils.processXML((InputStream)new BufferedInputStream(file.getInputStream(entry)));
                            if (jdbcVector != null && jdbcVector.size() != 0) {
                                jdbcArr = new JDBCDescriptor[jdbcVector.size()];
                                int i = 0;
                                while (i < jdbcVector.size()) {
                                    jdbcArr[i] = (JDBCDescriptor)jdbcVector.elementAt(i);
                                    ++i;
                                }
                            }
                            this.descr.setJdbcDescr(jdbcArr);
                        }
                    }
                    entry = this.findEntry(file, "META-INF/log-configuration.xml");
                    if (entry == null) {
                        entry = this.findEntry(file, "log-configuration.xml");
                    }
                    if (entry != null) {
                        this.descr.addXmlEntry("log-configuration.xml", entry.getName());
                        LogConfiguration logConfig = new LogXMLParser().parse((InputStream)new BufferedInputStream(file.getInputStream(entry)));
                        this.descr.setlogConfiguration(logConfig);
                    }
                    if ((entry = this.findEntry(file, "META-INF/data-source-aliases.xml")) == null) {
                        entry = this.findEntry(file, "data-source-aliases.xml");
                    }
                    if (entry != null) {
                        this.descr.addXmlEntry("data-source-aliases.xml", entry.getName());
                        this.descr.setDataSourceAliase(XMLUtils.processAliasesXML((InputStream)new BufferedInputStream(file.getInputStream(entry))));
                    }
                    xmlStream.close();
                    this.checkDescriptor(this.descr, file);
                    file.close();
                    this.checkAliases(this.descr.getModules());
                    eARDescriptor = this.descr;
                    Object var12_15 = null;
                    if (xmlStream == null) break block29;
                }
                catch (DeploymentException e) {
                    throw new IOException("Exception occurred while reading ear descriptor xml " + e.getMessage());
                }
                catch (SAXException e) {
                    throw new IOException("Exception occurred while reading ear descriptor xml " + e.getMessage());
                }
                catch (WrongStructureException wse) {
                    throw new IOException("Exception occurred while reading ear descriptor xml " + wse.toString());
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                if (xmlStream != null) {
                    xmlStream.close();
                }
                if (file == null) throw throwable;
                file.close();
                throw throwable;
            }
            xmlStream.close();
        }
        if (file == null) return eARDescriptor;
        file.close();
        return eARDescriptor;
    }

    public File[] getEJBJars() throws IOException {
        if (this.ejbJars == null) {
            this.ejbJars = this.getComponentJarFiles(1);
        }
        return this.ejbJars;
    }

    public File[] getServiceJars() throws IOException {
        if (this.serviceJars == null) {
            this.serviceJars = this.getComponentJarFiles(2);
        }
        return this.serviceJars;
    }

    public File[] getWarFiles() throws IOException {
        if (this.warFiles == null) {
            this.warFiles = this.getComponentJarFiles(4);
        }
        return this.warFiles;
    }

    public File[] getClientJarFiles() throws IOException {
        if (this.clientJarFiles == null) {
            this.clientJarFiles = this.getComponentJarFiles(3);
        }
        return this.clientJarFiles;
    }

    public File[] getConnectorRarFiles() throws IOException {
        if (this.connectorRarFiles == null) {
            this.connectorRarFiles = this.getComponentJarFiles(5);
        }
        return this.connectorRarFiles;
    }

    public File[] getOtherJarFiles() throws IOException {
        if (this.otherJarFiles == null) {
            this.otherJarFiles = this.getComponentJarFiles(0);
        }
        return this.otherJarFiles;
    }

    public File[] getJ2EEJars(String type) throws IOException {
        if (this.j2eeJars.get(type) == null) {
            File[] res = this.getComponentJarFiles(type);
            if (res != null) {
                this.j2eeJars.put(type, res);
            }
            return res;
        }
        return (File[])this.j2eeJars.get(type);
    }

    public File[] getComponentJarFiles(String type) throws IOException {
        Vector<File> allOtherJars = new Vector<File>();
        Object[] allJars = null;
        J2EEModule[] modules = null;
        if (this.descr == null) {
            this.descr = this.getDescriptor();
            if (this.descr == null) {
                return null;
            }
        }
        if ((modules = this.descr.getModules()) != null) {
            int i = 0;
            while (i < modules.length) {
                if (modules[i].getType(true).equals(type)) {
                    allOtherJars.addElement(this.extractFile(modules[i].getUri()));
                }
                ++i;
            }
            if (allOtherJars.size() > 0) {
                allJars = new File[allOtherJars.size()];
                allOtherJars.copyInto(allJars);
                return allJars;
            }
        }
        return null;
    }

    public File[] getComponentJarFiles(int type) throws IOException {
        Vector<File> allOtherJars = new Vector<File>();
        Object[] allJars = null;
        J2EEModule[] modules = null;
        if (type < 0 && type > 5) {
            throw new IOException("Unknown ear component type " + type + ". The only recognized constants for the types are the contstants in J2EEModule.");
        }
        if (this.descr == null) {
            this.descr = this.getDescriptor();
            if (this.descr == null) {
                return null;
            }
        }
        if ((modules = this.descr.getModules()) != null) {
            int i = 0;
            while (i < modules.length) {
                if (modules[i].getType() == type) {
                    allOtherJars.addElement(this.extractFile(modules[i].getUri()));
                }
                ++i;
            }
            if (allOtherJars.size() > 0) {
                allJars = new File[allOtherJars.size()];
                allOtherJars.copyInto(allJars);
                return allJars;
            }
        }
        return null;
    }

    public File[] getNonJ2EEJars(String[] fileExtensions, String[] fileNames, String containerName) throws IOException {
        if (this.nonJ2EEJars.get(containerName) == null) {
            int i;
            Vector<File> res = new Vector<File>();
            JarFile earFile = new JarFile(this.filename);
            if (fileNames != null) {
                i = 0;
                while (i < fileNames.length) {
                    if (earFile.getEntry(fileNames[i]) != null) {
                        res.add(this.extractFile(fileNames[i]));
                    }
                    ++i;
                }
            }
            if (fileExtensions != null) {
                i = 0;
                while (i < fileExtensions.length) {
                    Enumeration<JarEntry> entries = earFile.entries();
                    ZipEntry entry = null;
                    while (entries.hasMoreElements()) {
                        entry = entries.nextElement();
                        if (!entry.getName().toLowerCase().endsWith(fileExtensions[i].toLowerCase())) continue;
                        res.add(this.extractFile(entry.getName()));
                    }
                    ++i;
                }
            }
            earFile.close();
            if (res.size() > 0) {
                File[] array = new File[res.size()];
                res.toArray(array);
                this.nonJ2EEJars.put(containerName, array);
                return array;
            }
            return null;
        }
        return (File[])this.nonJ2EEJars.get(containerName);
    }

    public Hashtable getAllContainerFiles() throws IOException, DeploymentException {
        if (this.cinfoes != null) {
            Hashtable<String, File[]> res = new Hashtable<String, File[]>();
            File[] files = null;
            J2EEModule[] modules = this.descr.getModules();
            if (modules != null) {
                boolean foundCont = false;
                int i = 0;
                while (i < modules.length) {
                    foundCont = false;
                    int j = 0;
                    while (j < this.cinfoes.length) {
                        if (this.cinfoes[j].isJ2EEContainer() && this.cinfoes[j].getJ2EEModuleName().equals(modules[i].getType(true))) {
                            foundCont = true;
                            break;
                        }
                        ++j;
                    }
                    if (!foundCont) {
                        throw new DeploymentException("No available container for J2EE module " + modules[i].getUri());
                    }
                    ++i;
                }
            } else {
                throw new DeploymentException("No available J2EE modules in ear descriptor!");
            }
            int i = 0;
            while (i < this.cinfoes.length) {
                if (this.cinfoes[i].isJ2EEContainer()) {
                    files = this.getJ2EEJars(this.cinfoes[i].getJ2EEModuleName());
                    if (files != null) {
                        res.put(this.cinfoes[i].getName(), files);
                    }
                } else {
                    files = this.getNonJ2EEJars(this.cinfoes[i].getFileExtensions(), this.cinfoes[i].getFileNames(), this.cinfoes[i].getName());
                    if (files != null) {
                        res.put(this.cinfoes[i].getName(), files);
                    }
                }
                ++i;
            }
            return res;
        }
        throw new DeploymentException("No available containers!");
    }

    protected void checkAliases_new(J2EEModule[] modules) {
        if (modules != null) {
            int i = 0;
            while (i < modules.length) {
                if (modules[i].getType(true).equals("web") && (modules[i].getContextRoot() == null || modules[i].getContextRoot().trim().equals(""))) {
                    modules[i].setContextRoot("/");
                }
                ++i;
            }
        }
    }

    protected void checkAliases(J2EEModule[] modules) {
        if (modules != null) {
            int i = 0;
            while (i < modules.length) {
                if (modules[i].getType() == 4 && (modules[i].getContextRoot() == null || modules[i].getContextRoot().trim().equals(""))) {
                    modules[i].setContextRoot("/");
                }
                ++i;
            }
        }
    }

    public File extractFile(String entryName) throws IOException {
        ZipFile zipf = null;
        zipf = new ZipFile(this.filename);
        ZipEntry tempent = zipf.getEntry(entryName = entryName.replace('\\', '/'));
        if (tempent == null) {
            throw new IOException("File " + entryName + " not found in ear " + this.filename + ".");
        }
        String fName = entryName;
        fName = fName.replace('/', File.separatorChar);
        fName = fName.replace('\\', File.separatorChar);
        File f = new File(this.tempDir.getAbsolutePath() + File.separator + fName);
        File parentDir = f.getParentFile();
        parentDir.mkdirs();
        BufferedInputStream in = new BufferedInputStream(zipf.getInputStream(tempent));
        FileOutputStream fos = new FileOutputStream(f);
        this.fileMappings.put(f.getAbsolutePath(), entryName.replace('\\', '/'));
        int count = 4096;
        byte[] buff = new byte[count];
        try {
            while (count == 4096) {
                count = ((InputStream)in).read(buff);
                if (count <= 0) continue;
                fos.write(buff, 0, count);
            }
            ((InputStream)in).close();
            zipf.close();
            fos.flush();
            fos.close();
        }
        catch (EOFException ex) {
            buff = new byte[(int)tempent.getSize()];
            ((InputStream)in).read(buff);
            ((InputStream)in).close();
            zipf.close();
            fos.flush();
            fos.close();
        }
        return f;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    protected void checkDescriptor(EARDescriptor descr, ZipFile file) throws IOException {
        J2EEModule[] modules = null;
        if (descr == null) {
            return;
        }
        modules = descr.getModules();
        if (modules == null) {
            throw new IOException("The ear descriptor don't contain any J2EE modules.");
        }
        String message = "";
        ZipEntry entry = null;
        int i = 0;
        while (i < modules.length) {
            entry = file.getEntry(modules[i].getUri().replace('\\', '/'));
            if (entry == null) {
                message = message + "\n     " + modules[i].getUri() + ",";
            }
            ++i;
        }
        if (!message.trim().equals("")) {
            throw new IOException("The following archives that are\ndescribed in the ear descriptor are not found in the ear: " + message + "\nPlease check the ear content.");
        }
    }

    public String[] getAdditionalLibraries(String destinationDir) throws IOException {
        String[] entries = this.getAdditionalLibrariesEntries(destinationDir);
        String[] res = null;
        if (entries != null) {
            res = new String[entries.length];
            int i = 0;
            while (i < entries.length) {
                res[i] = destinationDir + File.separator + entries[i].replace('/', File.separatorChar);
                ++i;
            }
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getAdditionalLibrariesEntries(String destinationDir) throws IOException {
        Vector<String> jars;
        block10: {
            jars = new Vector<String>();
            J2EEModule[] modules = null;
            if (this.descr == null) {
                this.descr = this.getDescriptor();
            }
            modules = this.descr.getModules();
            String name = null;
            JarEntry entry = null;
            JarFile file = null;
            JarExtractor extractor = new JarExtractor();
            try {
                file = new JarFile(this.filename);
                Enumeration<JarEntry> enumeration = file.entries();
                boolean found = false;
                while (enumeration.hasMoreElements()) {
                    entry = enumeration.nextElement();
                    name = entry.getName();
                    if (entry.isDirectory() || !name.endsWith(".jar") && !name.endsWith(".zip") && !name.endsWith(".war") && !name.endsWith(".rar")) continue;
                    found = false;
                    int i = 0;
                    while (i < modules.length) {
                        if (entry.getName().equals(modules[i].getUri().replace('\\', '/'))) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (found) continue;
                    name = entry.getName();
                    jars.add(name);
                    extractor.extractFile(file, entry.getName(), destinationDir);
                }
                Object var12_12 = null;
                if (file == null) break block10;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (file != null) {
                    file.close();
                }
                throw throwable;
            }
            file.close();
        }
        if (jars.size() > 0) {
            Object[] res = new String[jars.size()];
            jars.copyInto(res);
            return res;
        }
        return null;
    }

    public String getErrorMsg(boolean debug) {
        if (debug) {
            return this.debugMsg;
        }
        return this.errorMsg;
    }

    private ZipEntry findEntry(ZipFile zip, String entryName) {
        ZipEntry temp = null;
        Enumeration<? extends ZipEntry> enumeration = zip.entries();
        while (enumeration.hasMoreElements()) {
            temp = enumeration.nextElement();
            if (!temp.getName().equalsIgnoreCase(entryName)) continue;
            return temp;
        }
        return null;
    }

    public String getDTD() {
        return this.dtd;
    }

    public Hashtable getFileMappings() {
        return this.fileMappings;
    }

    public void setFileMappings(Hashtable fileMappings) {
        this.fileMappings = fileMappings;
    }
}

