/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.xml;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.SimpleEarDescriptor;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtendedEARDescriptorReader {
    String errorMsg = "";
    String debugMsg = "";
    SimpleEarDescriptor descriptor;
    public String dtd = null;
    public static final String defaultDTD = "<!DOCTYPE application [\n<!ELEMENT application (icon?, display-name, description?, module+, security-role*)>\n<!ATTLIST application id ID #IMPLIED>\n<!ELEMENT icon (small-icon?, large-icon?)>\n<!ATTLIST icon id ID #IMPLIED>\n<!ELEMENT small-icon (#PCDATA)>\n<!ATTLIST small-icon id ID #IMPLIED>\n<!ELEMENT large-icon (#PCDATA)>\n<!ATTLIST large-icon id ID #IMPLIED>\n<!ELEMENT display-name (#PCDATA)>\n<!ATTLIST display-name id ID #IMPLIED>\n<!ELEMENT description (#PCDATA)>\n<!ATTLIST description id ID #IMPLIED>\n<!ELEMENT module ((ejb | java | web), alt-dd?)>\n<!ATTLIST module id ID #IMPLIED>\n<!ELEMENT ejb (#PCDATA)>\n<!ATTLIST ejb id ID #IMPLIED>\n<!ELEMENT java (#PCDATA)>\n<!ATTLIST java id ID #IMPLIED>\n<!ELEMENT web (web-uri, context-root)>\n<!ATTLIST web id ID #IMPLIED>\n<!ELEMENT web-uri (#PCDATA)>\n<!ATTLIST web-uri id ID #IMPLIED>\n<!ELEMENT context-root (#PCDATA)>\n<!ATTLIST context-root id ID #IMPLIED>\n<!ELEMENT alt-dd (#PCDATA)>\n<!ATTLIST alt-dd id ID #IMPLIED>\n<!ELEMENT security-role (description?, role-name)>\n<!ATTLIST security-role id ID #IMPLIED>\n<!ELEMENT role-name (#PCDATA)>\n<!ATTLIST role-name id ID #IMPLIED>\n]>";
    public static final String sunDTD = "http://java.sun.com/j2ee/dtds/application_1_2.dtd";

    public SimpleEarDescriptor loadSimpleEarDescriptor(Element docElement) throws DeploymentException {
        Element nameElement = (Element)this.getFirstChild(docElement, "display-name");
        if (nameElement == null) {
            throw new DeploymentException("deploy_2028");
        }
        String displayName = this.getElementValue(nameElement);
        if (displayName == null || displayName.equals("")) {
            throw new DeploymentException("deploy_2027");
        }
        if (new File(displayName).isAbsolute()) {
            int index = displayName.lastIndexOf("/");
            if (index == -1) {
                index = displayName.lastIndexOf("\\");
            }
            if (index > -1) {
                displayName = displayName.substring(index);
            }
        }
        if (displayName.indexOf(47) > -1 || displayName.indexOf(92) > -1 || displayName.indexOf(58) > -1 || displayName.indexOf(42) > -1 || displayName.indexOf(63) > -1 || displayName.indexOf(34) > -1 || displayName.indexOf(60) > -1 || displayName.indexOf(62) > -1 || displayName.indexOf(124) > -1 || displayName.endsWith(".")) {
            if (this.debugMsg == null || this.debugMsg.equals("")) {
                this.debugMsg = "Display name of application is not correct [" + displayName + "]. " + "It should not contain any of the following characters: / \\ : * ? \" < > |. " + "It should not end with '.' character. " + "All incorrect occurrences will be replaced with '_'.";
            }
            displayName = displayName.replace('/', '~');
            displayName = displayName.replace('\\', '~');
            displayName = displayName.replace(':', '~');
            displayName = displayName.replace('*', '~');
            displayName = displayName.replace('?', '~');
            displayName = displayName.replace('\"', '~');
            displayName = displayName.replace('<', '~');
            displayName = displayName.replace('>', '~');
            if ((displayName = displayName.replace('|', '~')).endsWith(".")) {
                displayName = displayName.substring(0, displayName.length() - 1) + "~";
            }
            if (this.errorMsg == null || this.errorMsg.equals("")) {
                this.errorMsg = "Warning! Application display name " + this.getElementValue(nameElement) + " was internally changed to " + displayName + ".";
            }
        }
        this.descriptor = new SimpleEarDescriptor(displayName.trim());
        this.loadDescriptor(docElement);
        return this.descriptor;
    }

    public SimpleEarDescriptor loadSimpleEarDescriptor(Document doc) throws DeploymentException {
        DocumentType dt = doc.getDoctype();
        this.dtd = dt == null ? "http://java.sun.com/dtd/application_1_3.dtd" : dt.getSystemId();
        Element docElement = doc.getDocumentElement();
        return this.loadSimpleEarDescriptor(docElement);
    }

    public void loadDescriptor(Element docElement) throws DeploymentException {
        Node descr;
        Node icon = this.getFirstChild(docElement, "icon");
        if (icon != null) {
            this.loadIcons((Element)icon);
        }
        if ((descr = this.getFirstChild(docElement, "description")) != null) {
            this.loadApplicationDescription((Element)descr);
        }
        NodeList moduleList = docElement.getElementsByTagName("module");
        this.loadModules(moduleList);
        NodeList secRolesList = docElement.getElementsByTagName("security-role");
        if (secRolesList != null) {
            this.loadSecurityRoles(secRolesList);
        }
    }

    private void loadIcons(Element icon) {
        String largeIcon;
        Node large;
        String smIcon;
        Node sm = this.getFirstChild(icon, "small-icon");
        if (sm != null && (smIcon = this.getElementValue((Element)sm)) != null && !smIcon.trim().equals("")) {
            this.descriptor.setSmallIcon(new SerializableFile(smIcon));
        }
        if ((large = this.getFirstChild(icon, "large-icon")) != null && (largeIcon = this.getElementValue((Element)large)) != null && !largeIcon.trim().equals("")) {
            this.descriptor.setLargeIcon(new SerializableFile(largeIcon));
        }
    }

    private void loadApplicationDescription(Element descrElement) {
        String descr = this.getElementValue(descrElement);
        if (descr != null) {
            this.descriptor.setDescription(descr);
        }
    }

    private void loadModules(NodeList list) throws DeploymentException {
        J2EEModule[] modules = new J2EEModule[list.getLength()];
        int i = 0;
        while (i < list.getLength()) {
            Element next = (Element)list.item(i);
            modules[i] = this.loadModule(next);
            if (modules[i].getType() == 4) {
                int j = 0;
                while (j < i) {
                    if (modules[j].getType() == 4 && modules[i].getContextRoot().equals(modules[j].getContextRoot())) {
                        throw new DeploymentException("deploy_2029", (Object[])new String[]{modules[i].getContextRoot()});
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.descriptor.setModules(modules);
    }

    private J2EEModule loadModule(Element modElement) {
        String uri;
        int type = 1;
        J2EEModule mod = null;
        Node child = null;
        child = this.getFirstChild(modElement, "ejb");
        if (child != null) {
            uri = this.getElementValue((Element)child);
            mod = new J2EEModule(type, uri);
        } else {
            child = this.getFirstChild(modElement, "java");
            if (child != null) {
                type = 3;
                uri = this.getElementValue((Element)child);
                mod = new J2EEModule(type, uri);
            } else {
                child = this.getFirstChild(modElement, "web");
                if (child != null) {
                    type = 4;
                    Element weburiElement = (Element)this.getFirstChild((Element)child, "web-uri");
                    String uri2 = this.getElementValue(weburiElement);
                    Element contextElement = (Element)this.getFirstChild((Element)child, "context-root");
                    String context = this.getElementValue(contextElement);
                    if (context == null || context.equals("")) {
                        context = "/";
                    }
                    context = context.replace(':', '_');
                    context = context.replace('*', '_');
                    context = context.replace('?', '_');
                    context = context.replace('\"', '_');
                    context = context.replace('<', '_');
                    context = context.replace('>', '_');
                    context = context.replace('|', '_');
                    if ((context = context.replace('\\', '/')).endsWith(".")) {
                        context = context.substring(0, context.length() - 1) + "_";
                    }
                    while (context.length() > 1 && context.startsWith("/")) {
                        context = context.substring(1, context.length());
                    }
                    StringBuffer temp = new StringBuffer();
                    int i = 0;
                    while (i < context.length()) {
                        if (context.charAt(i) != '/' || context.charAt(i) == '/' && (temp.length() == 0 || temp.charAt(temp.length() - 1) != '/')) {
                            temp.append(context.charAt(i));
                        }
                        ++i;
                    }
                    context = new String(temp);
                    if (!context.equals(this.getElementValue(contextElement))) {
                        if (this.debugMsg == null) {
                            this.debugMsg = "";
                        }
                        this.debugMsg = this.debugMsg + "\nContext root of application component " + uri2 + " is not correct. " + "It should not begin with '/' character. " + "It should not contain any of the following characters: * : ? \" < > |. " + "It should not end with '.' character. " + "All incorrect occurrences will be replaced with '_' and all occurrences of '\\' will be replaced with '/'. All series of '/' character will be replaced by '/' single character.";
                        this.debugMsg = this.debugMsg + "\nError in context root of " + uri2 + ": " + this.getElementValue(contextElement) + " is replaced by " + context + " .";
                    }
                    mod = new J2EEModule(uri2, context);
                } else {
                    child = this.getFirstChild(modElement, "connector");
                    if (child != null) {
                        type = 5;
                        uri = this.getElementValue((Element)child);
                        mod = new J2EEModule(type, uri);
                    } else {
                        child = this.getFirstChild(modElement, "service");
                        if (child != null) {
                            type = 2;
                            uri = this.getElementValue((Element)child);
                            mod = new J2EEModule(type, uri);
                        } else {
                            child = this.getFirstChild(modElement, "other");
                            if (child != null) {
                                type = 0;
                                uri = this.getElementValue((Element)child);
                                mod = new J2EEModule(type, uri);
                            }
                        }
                    }
                }
            }
        }
        Node altChild = this.getFirstChild(modElement, "alt-dd");
        if (altChild != null) {
            String altdd = this.getElementValue((Element)altChild);
            mod.setAlt_dd(altdd);
        }
        return mod;
    }

    private void loadSecurityRoles(NodeList secRoles) {
        SecurityRoles[] roles = new SecurityRoles[secRoles.getLength()];
        int i = 0;
        while (i < secRoles.getLength()) {
            Element next = (Element)secRoles.item(i);
            roles[i] = this.loadSecurityRoles(next);
            ++i;
        }
        this.descriptor.setRoles(roles);
    }

    private SecurityRoles loadSecurityRoles(Element secRoleElement) {
        Node descr = this.getFirstChild(secRoleElement, "description");
        Node roleNode = this.getFirstChild(secRoleElement, "role-name");
        String roleName = this.getElementValue((Element)roleNode);
        if (descr != null) {
            return new SecurityRoles(roleName, this.getElementValue((Element)descr));
        }
        return new SecurityRoles(roleName);
    }

    private Node getFirstChild(Element el, String name) {
        NodeList list = el.getElementsByTagName(name);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        return list.item(0);
    }

    private String getElementValue(Element el) {
        Node child = el.getFirstChild();
        if (child == null) {
            return null;
        }
        return child.getNodeValue().trim();
    }

    public String getErrorMsg(boolean debug) {
        if (debug) {
            return this.debugMsg;
        }
        return this.errorMsg;
    }
}

