/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.webservices;

import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.xml.util.DOMSerializer;
import com.sap.engine.services.deploy.ear.webservices.WebInfo;
import com.sap.engine.services.deploy.ear.webservices.WebInfoCreator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WebInfoCreatorImpl
implements WebInfoCreator {
    public static String SOAP_SERVLET_NAME = "SoapServlet";
    public static String SOAP_SERVLET_SOURCE = "com/sap/engine/services/deploy/ear/webservices/SoapServlet.src";
    public static String WEB_XML_TEMPLATE = "com/sap/engine/services/deploy/ear/webservices/web.xml";
    public static String WEB_J2EE_ENGINE_XML_TEMPLATE = "com/sap/engine/services/deploy/ear/webservices/web-j2ee-engine.xml";
    public static String WEB_J2EE_ENGINE_BASIC_XML_TEMPLATE = "com/sap/engine/services/deploy/ear/webservices/web-j2ee-engine-basic.xml";
    public static String WEB_J2EE_ENGINE_CERT_XML_TEMPLATE = "com/sap/engine/services/deploy/ear/webservices/web-j2ee-engine-certificate.xml";
    public static String AUTHENTICATION_FEATURE_NAME = "http://www.sap.com/webas/630/soap/features/authentication";
    public static String WSS_FEATURE_NAME = "http://www.sap.com/webas/630/soap/features/wss";
    public static String TG_FEATURE_NAME = "http://www.sap.com/webas/630/soap/features/transportguarantee";
    public static String SUPPORT_SSO2_PROPERTY_NAME = "SupportsSSO2Authentication";
    public static String AUTHENTICATION_METHOD_PROPERTY_NAME = "AuthenticationMethod";
    public static String AUTHENTICATION_MECHANISM_PROPERTY_NAME = "AuthenticationMechanism";
    public static String AUTH_BASICAUTH = "BasicAuth";
    public static String AUTH_CERTAUTH = "CertAuth";
    public static String AUTH_MECH_HTTP = "HTTP";
    public static String TG_TLSTYPE_PROPERTY_NAME = "TLSType";
    public static String TG_SSL = "SSL";
    public static final String EJB_IMPLEMENTATION_ID = "ejb-impllink";
    public static final String JAVA_IMPLEMENTATTION_ID = "javaclass-impllink";
    public static String SOAPDISPATCHER_PREFIX = "soapdispatcher";
    public static final String SOAPHTTP_TRANSPORTBINDING = "SOAPHTTP_TransportBinding";
    public static final String MIME_TRANSPORTBINDING = "MIME_TransportBinding";
    public static final String HTTP_TRANSPORTBINDING = "HTTP_TransportBinding";
    public static int IAUTH_NO = 1;
    public static int IAUTH_BASIC = 2;
    public static int IAUTH_CERT = 3;
    public static int AUTH_LOGIN_TYPE = 1;
    public static int WSS_LOGIN_TYPE = 2;
    public static int ITG_NO = 1;
    public static int ITG_YES = 2;
    private DocumentBuilder documentBuilder = null;

    public WebInfoCreatorImpl() throws ParserConfigurationException {
        DocumentBuilderFactoryImpl documentBuilderFactory = new DocumentBuilderFactoryImpl();
        this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
    }

    public WebInfo[] createSingleWebInfo(String workingDir, String wsDeploymentDescriptorPath) throws Exception {
        return this.createSingleWebInfo(workingDir, new FileInputStream(wsDeploymentDescriptorPath));
    }

    public WebInfo[] createSingleWebInfo(String workingDir, InputStream in) throws Exception {
        DocumentBuilderFactoryImpl documentBuilderFactory = new DocumentBuilderFactoryImpl();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(in);
        ArrayList<WebInfo> webInfos = new ArrayList<WebInfo>();
        NodeList nlWebService = document.getElementsByTagName("webservice");
        int i = 0;
        while (i < nlWebService.getLength()) {
            NodeList nlConfiguration = ((Element)nlWebService.item(i)).getElementsByTagName("ws-configuration");
            int j = 0;
            while (j < nlConfiguration.getLength()) {
                WebInfo info = this.getWebInfo(workingDir, nlConfiguration.item(j));
                if (info != null) {
                    webInfos.add(info);
                }
                ++j;
            }
            ++i;
        }
        return this.getWebInfosAsArray(webInfos);
    }

    public WebInfo[] createWebInfo(String workingDir, String[] wsDeploymentDescriptorPaths) throws Exception {
        int descriptorsSize = wsDeploymentDescriptorPaths.length;
        WebInfo[] webInfos = new WebInfo[]{};
        int i = 0;
        while (i < descriptorsSize) {
            WebInfo[] currentWebInfos = this.createSingleWebInfo(workingDir, wsDeploymentDescriptorPaths[i]);
            WebInfo[] newWebInfos = new WebInfo[webInfos.length + currentWebInfos.length];
            System.arraycopy(webInfos, 0, newWebInfos, 0, webInfos.length);
            System.arraycopy(currentWebInfos, 0, newWebInfos, webInfos.length, currentWebInfos.length);
            webInfos = newWebInfos;
            ++i;
        }
        return webInfos;
    }

    private WebInfo getWebInfo(String workingDir, Node wsConfigurationNode) throws Exception {
        NodeList nlTransportAddress;
        Element endpointSetting;
        WebInfo webInfo = null;
        String implementationId = EJB_IMPLEMENTATION_ID;
        int authentication = IAUTH_NO;
        int transportGuarantee = ITG_NO;
        String authMechanism = null;
        boolean supportSSO = false;
        String transportBinding = SOAPHTTP_TRANSPORTBINDING;
        NodeList nl = ((Element)wsConfigurationNode).getElementsByTagName("impl-link");
        if (nl.getLength() > 0) {
            implementationId = ((Element)nl.item(0)).getAttribute("implementation-id");
        }
        nl = ((Element)wsConfigurationNode).getElementsByTagName("feature");
        int i = 0;
        while (i < nl.getLength()) {
            int j;
            NodeList nl2;
            if (((Element)nl.item(i)).getAttribute("name").equals(AUTHENTICATION_FEATURE_NAME)) {
                nl2 = ((Element)nl.item(i)).getElementsByTagName("property");
                j = 0;
                while (j < nl2.getLength()) {
                    Element currentElement = (Element)nl2.item(j);
                    String currentElName = currentElement.getAttribute("name").trim();
                    String currentElValue = currentElement.getAttribute("value");
                    if (currentElName.equals(AUTHENTICATION_METHOD_PROPERTY_NAME)) {
                        authentication = currentElValue.equals(AUTH_BASICAUTH) ? IAUTH_BASIC : (currentElValue.equals(AUTH_CERTAUTH) ? IAUTH_CERT : IAUTH_NO);
                    } else if (currentElName.equals(SUPPORT_SSO2_PROPERTY_NAME)) {
                        if (currentElValue.equalsIgnoreCase("true")) {
                            supportSSO = true;
                        }
                    } else if (currentElName.equals(AUTHENTICATION_MECHANISM_PROPERTY_NAME)) {
                        authMechanism = currentElValue;
                    }
                    ++j;
                }
            } else if (((Element)nl.item(i)).getAttribute("name").equals(TG_FEATURE_NAME)) {
                nl2 = ((Element)nl.item(i)).getElementsByTagName("property");
                j = 0;
                while (j < nl2.getLength()) {
                    String value;
                    if (((Element)nl2.item(j)).getAttribute("name").equals(TG_TLSTYPE_PROPERTY_NAME) && (value = ((Element)nl2.item(j)).getAttribute("value")).equals(TG_SSL)) {
                        transportGuarantee = ITG_YES;
                    }
                    ++j;
                }
            }
            ++i;
        }
        nl = ((Element)wsConfigurationNode).getElementsByTagName("transport-binding");
        if (nl.getLength() > 0) {
            transportBinding = ((Element)nl.item(0)).getAttribute("name");
        }
        NodeList securityRoleNodes = null;
        NodeList securityRoleDefNodes = ((Element)wsConfigurationNode).getElementsByTagName("security-roles-definition");
        if (securityRoleDefNodes.getLength() > 0) {
            securityRoleNodes = ((Element)securityRoleDefNodes.item(0)).getElementsByTagName("security-role");
        }
        String sessionTimeout = null;
        NodeList endpointSettings = ((Element)wsConfigurationNode).getElementsByTagName("entrypoint-settings");
        if (endpointSettings.getLength() > 0 && (endpointSetting = (Element)endpointSettings.item(0)).getAttribute("type").equals("http")) {
            NodeList properties = endpointSetting.getElementsByTagName("property");
            int p = 0;
            while (p < properties.getLength()) {
                Element tmpProp = (Element)properties.item(p);
                if (tmpProp.getAttribute("name").equals("session-timeout")) {
                    String sessStr = tmpProp.getAttribute("value");
                    if (sessStr.length() <= 0) break;
                    sessionTimeout = sessStr;
                    break;
                }
                ++p;
            }
        }
        if ((nlTransportAddress = ((Element)wsConfigurationNode).getElementsByTagName("transport-address")).getLength() > 0) {
            String transportAddress = nlTransportAddress.item(0).getFirstChild().getNodeValue().trim();
            if (transportAddress.startsWith("/")) {
                transportAddress = transportAddress.substring(1);
            }
            if (!transportAddress.startsWith(SOAPDISPATCHER_PREFIX)) {
                webInfo = new WebInfo();
                webInfo.setContextRoot(transportAddress);
                webInfo.setWarModulePath(this.getWar(workingDir, transportAddress, authentication, transportGuarantee, transportBinding, implementationId, securityRoleNodes, supportSSO, authMechanism, sessionTimeout));
            } else {
                return null;
            }
        }
        return webInfo;
    }

    private String getWar(String workingDir, String contextRoot, int authentication, int transportGuarantee, String transportBinding, String implementationId, NodeList securityRoles, boolean supportSSO, String authMechanism, String sessionTimeout) throws Exception {
        String uniquePrefix = contextRoot;
        if (uniquePrefix.startsWith("/")) {
            uniquePrefix = uniquePrefix.substring(1);
        }
        uniquePrefix = uniquePrefix.replace('\\', '/');
        uniquePrefix = uniquePrefix.replace('/', '_');
        String warWorkingDir = workingDir + File.separator + "WS_war1";
        File warWorkingDirFile = new File(warWorkingDir);
        if (warWorkingDirFile.exists()) {
            this.deleteDir(warWorkingDirFile);
        }
        if (!warWorkingDirFile.mkdirs()) {
            throw new IOException("Unable to create temporary directory for webservices needs: " + warWorkingDir);
        }
        String webInfDir = warWorkingDir + File.separator + "WEB-INF";
        if (!new File(webInfDir).mkdirs()) {
            throw new IOException("Unable to create temporary directory for webservices needs: " + webInfDir);
        }
        String classesDir = webInfDir + File.separator + "classes";
        if (!new File(classesDir).mkdirs()) {
            throw new IOException("Unable to create temporary directory for webservices needs: " + classesDir);
        }
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream servletSourceInput = loader.getResourceAsStream(SOAP_SERVLET_SOURCE);
        String servletFileName = classesDir + File.separator + SOAP_SERVLET_NAME + ".class";
        File servletFile = new File(servletFileName);
        FileOutputStream servletSourceOutput = new FileOutputStream(servletFile);
        this.copy(servletSourceInput, servletSourceOutput);
        servletSourceInput.close();
        servletSourceOutput.close();
        InputStream webj2eeSourceInput = loader.getResourceAsStream(WEB_J2EE_ENGINE_XML_TEMPLATE);
        String webj2eeFileName = webInfDir + File.separator + "web-j2ee-engine.xml";
        File webj2eeFile = new File(webj2eeFileName);
        Document webj2eeDocument = this.getModifiedWebJ2eeXML(webj2eeSourceInput, implementationId, authentication, securityRoles, supportSSO);
        FileOutputStream webj2eeSourceOutput = new FileOutputStream(webj2eeFile);
        DOMSerializer serializer = new DOMSerializer();
        serializer.write(webj2eeDocument, (OutputStream)webj2eeSourceOutput);
        webj2eeSourceInput.close();
        webj2eeSourceOutput.close();
        String warName = uniquePrefix + ".war";
        InputStream webXMLSourceInput = loader.getResourceAsStream(WEB_XML_TEMPLATE);
        FileOutputStream webXMLSourceOutput = new FileOutputStream(webInfDir + File.separator + "web.xml");
        Document webDocument = this.getModifiedWebXML(webXMLSourceInput, warName, uniquePrefix, authentication, transportGuarantee, transportBinding, implementationId, securityRoles, supportSSO, authMechanism, sessionTimeout);
        serializer = new DOMSerializer();
        serializer.write(webDocument, (OutputStream)webXMLSourceOutput);
        webXMLSourceInput.close();
        webXMLSourceOutput.close();
        JarUtils jarUtils = new JarUtils();
        String warModulePath = workingDir + File.separator + warName;
        jarUtils.makeJarFromDir(warModulePath, warWorkingDir);
        return warModulePath;
    }

    private Document getModifiedWebXML(InputStream webXMLSourceInput, String warName, String uniquePrefix, int authentication, int transportGuarantee, String transportBinding, String implementationId, NodeList securityRoles, boolean supportSSO, String authMechanism, String sessionTimeout) throws Exception {
        Document document = this.documentBuilder.parse(webXMLSourceInput);
        Element documentElement = document.getDocumentElement();
        NodeList nodes = documentElement.getChildNodes();
        int nodesSize = nodes.getLength();
        int i = 0;
        while (i < nodesSize) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Node child;
                int j;
                int childsSize;
                NodeList childNodes;
                if (node.getNodeName().equals("display-name")) {
                    node.getFirstChild().setNodeValue(warName);
                }
                if (node.getNodeName().equals("servlet")) {
                    childNodes = node.getChildNodes();
                    childsSize = childNodes.getLength();
                    j = 0;
                    while (j < childsSize) {
                        child = childNodes.item(j);
                        if (child.getNodeType() == 1) {
                            if (child.getNodeName().equals("display-name")) {
                                child.getFirstChild().setNodeValue(uniquePrefix + "_" + SOAP_SERVLET_NAME);
                            }
                            if (child.getNodeName().equals("servlet-name")) {
                                child.getFirstChild().setNodeValue(uniquePrefix + "_" + SOAP_SERVLET_NAME);
                            }
                            if (child.getNodeName().equals("servlet-class")) {
                                child.getFirstChild().setNodeValue(SOAP_SERVLET_NAME);
                            }
                        }
                        ++j;
                    }
                }
                if (node.getNodeName().equals("servlet-mapping")) {
                    childNodes = node.getChildNodes();
                    childsSize = childNodes.getLength();
                    j = 0;
                    while (j < childsSize) {
                        child = childNodes.item(j);
                        if (child.getNodeType() == 1 && child.getNodeName().equals("servlet-name")) {
                            child.getFirstChild().setNodeValue(uniquePrefix + "_" + SOAP_SERVLET_NAME);
                        }
                        ++j;
                    }
                }
                if (sessionTimeout != null && node.getNodeName().equals("session-config")) {
                    childNodes = node.getChildNodes();
                    childsSize = childNodes.getLength();
                    j = 0;
                    while (j < childsSize) {
                        child = childNodes.item(j);
                        if (child.getNodeType() == 1 && child.getNodeName().equals("session-timeout")) {
                            child.getFirstChild().setNodeValue(sessionTimeout);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (authentication != IAUTH_NO && (authMechanism == null || authMechanism.equalsIgnoreCase(AUTH_MECH_HTTP))) {
            Element securityConstraint = document.createElement("security-constraint");
            Element webResourceCollection = document.createElement("web-resource-collection");
            securityConstraint.appendChild(webResourceCollection);
            Element urlPattern = document.createElement("url-pattern");
            webResourceCollection.appendChild(urlPattern);
            Text tx = document.createTextNode("/*");
            urlPattern.appendChild(tx);
            Element el = document.createElement("http-method");
            el.appendChild(document.createTextNode("POST"));
            webResourceCollection.appendChild(el);
            Element el2 = null;
            el = document.createElement("auth-constraint");
            el2 = document.createElement("role-name");
            el2.appendChild(document.createTextNode("web-services-user"));
            el.appendChild(el2);
            securityConstraint.appendChild(el);
            el = document.createElement("user-data-constraint");
            el2 = document.createElement("description");
            el2.appendChild(document.createTextNode("Secutiy support for a WS"));
            el.appendChild(el2);
            el2 = document.createElement("transport-guarantee");
            if (transportGuarantee == ITG_NO) {
                el2.appendChild(document.createTextNode("NONE"));
            } else {
                el2.appendChild(document.createTextNode("CONFIDENTIAL"));
            }
            el.appendChild(el2);
            securityConstraint.appendChild(el);
            documentElement.appendChild(securityConstraint);
            el = document.createElement("login-config");
            el2 = document.createElement("auth-method");
            tx = authentication == IAUTH_BASIC ? document.createTextNode("BASIC") : document.createTextNode("CLIENT-CERT");
            el2.appendChild(tx);
            el.appendChild(el2);
            documentElement.appendChild(el);
            el = document.createElement("security-role");
            el2 = document.createElement("description");
            el2.appendChild(document.createTextNode("Role to access web services"));
            el.appendChild(el2);
            el2 = document.createElement("role-name");
            tx = document.createTextNode("web-services-user");
            el2.appendChild(tx);
            el.appendChild(el2);
            documentElement.appendChild(el);
            if (implementationId.equals(JAVA_IMPLEMENTATTION_ID)) {
                this.setSecurityRoles(document, securityRoles);
            }
            if (supportSSO) {
                this.setDefaultLoginSecurityRoles(document, authentication);
            }
        }
        return document;
    }

    private Document getModifiedWebJ2eeXML(InputStream in, String implementationId, int authentication, NodeList securityRoleMaps, boolean supportSSO) throws Exception {
        Document webJ2eeXmlDocument = this.documentBuilder.parse(in);
        if (authentication != IAUTH_NO) {
            if (implementationId.equals(JAVA_IMPLEMENTATTION_ID)) {
                this.setSecurityRoleMaps(webJ2eeXmlDocument, securityRoleMaps);
            }
            if (supportSSO) {
                this.setDefaultLoginConfig(webJ2eeXmlDocument, authentication);
            }
        }
        return webJ2eeXmlDocument;
    }

    private void setSecurityRoles(Document webXmlDocument, NodeList wsSecurityRoles) {
        if (wsSecurityRoles == null) {
            return;
        }
        Element webXmlDocumentEl = webXmlDocument.getDocumentElement();
        int i = 0;
        while (i < wsSecurityRoles.getLength()) {
            Element el = null;
            NodeList nl = null;
            Text node = null;
            Element wsSecRole = (Element)wsSecurityRoles.item(i);
            Element webSecRoleEl = webXmlDocument.createElement("security-role");
            el = webXmlDocument.createElement("role-name");
            nl = wsSecRole.getElementsByTagName("role-name");
            node = webXmlDocument.createTextNode(nl.item(0).getFirstChild().getNodeValue());
            el.appendChild(node);
            webSecRoleEl.appendChild(el);
            nl = wsSecRole.getElementsByTagName("description");
            if (nl.getLength() > 0) {
                el = webXmlDocument.createElement("description");
                node = webXmlDocument.createTextNode(nl.item(0).getFirstChild().getNodeValue());
                el.appendChild(node);
                webSecRoleEl.appendChild(el);
            }
            webXmlDocumentEl.appendChild(webSecRoleEl);
            ++i;
        }
    }

    private void setDefaultLoginSecurityRoles(Document webDocument, int authentication) throws Exception {
        this.setSecurityRoles(webDocument, this.getDefaultLoginSecurityRoleMaps(authentication));
    }

    private NodeList getDefaultLoginSecurityRoleMaps(int authentication) throws Exception {
        NodeList securityRoleMaps = null;
        if (authentication == IAUTH_BASIC) {
            securityRoleMaps = this.getDefaultLoginSecurityRoleMaps(WEB_J2EE_ENGINE_BASIC_XML_TEMPLATE);
        } else if (authentication == IAUTH_CERT) {
            securityRoleMaps = this.getDefaultLoginSecurityRoleMaps(WEB_J2EE_ENGINE_CERT_XML_TEMPLATE);
        }
        return securityRoleMaps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NodeList getDefaultLoginSecurityRoleMaps(String webJ2eeLoginSourceLocation) throws Exception {
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream webJ2eeLoginInput = null;
        NodeList nodeList = null;
        try {
            webJ2eeLoginInput = loader.getResourceAsStream(webJ2eeLoginSourceLocation);
            nodeList = this.getDefaultLoginSecurityRoleMaps(webJ2eeLoginInput);
            Object var6_5 = null;
            if (webJ2eeLoginInput == null) return nodeList;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (webJ2eeLoginInput == null) throw throwable;
            webJ2eeLoginInput.close();
            throw throwable;
        }
        webJ2eeLoginInput.close();
        return nodeList;
    }

    private NodeList getDefaultLoginSecurityRoleMaps(InputStream webJ2eeLoginInput) throws Exception {
        Document webJ2eeLoginDocument = this.documentBuilder.parse(webJ2eeLoginInput);
        return webJ2eeLoginDocument.getElementsByTagName("security-role-map");
    }

    private void setSecurityRoleMaps(Document webJ2eeXmlDocument, NodeList wsSecurityRoleMaps) {
        if (wsSecurityRoleMaps == null) {
            return;
        }
        Element webJ2eeXmlDocumentEl = webJ2eeXmlDocument.getDocumentElement();
        int i = 0;
        while (i < wsSecurityRoleMaps.getLength()) {
            Element el = null;
            NodeList nl = null;
            Text node = null;
            Element wsSecRoleMap = (Element)wsSecurityRoleMaps.item(i);
            Element webSecRoleEl = webJ2eeXmlDocument.createElement("security-role-map");
            el = webJ2eeXmlDocument.createElement("role-name");
            nl = wsSecRoleMap.getElementsByTagName("role-name");
            node = webJ2eeXmlDocument.createTextNode(nl.item(0).getFirstChild().getNodeValue());
            el.appendChild(node);
            webSecRoleEl.appendChild(el);
            nl = wsSecRoleMap.getElementsByTagName("user-name");
            int j = 0;
            while (j < nl.getLength()) {
                el = webJ2eeXmlDocument.createElement("user-name");
                node = webJ2eeXmlDocument.createTextNode(nl.item(j).getFirstChild().getNodeValue());
                el.appendChild(node);
                webSecRoleEl.appendChild(el);
                ++j;
            }
            nl = wsSecRoleMap.getElementsByTagName("group-name");
            int j2 = 0;
            while (j2 < nl.getLength()) {
                el = webJ2eeXmlDocument.createElement("group-name");
                node = webJ2eeXmlDocument.createTextNode(nl.item(j2).getFirstChild().getNodeValue());
                el.appendChild(node);
                webSecRoleEl.appendChild(el);
                ++j2;
            }
            nl = wsSecRoleMap.getElementsByTagName("server-role-name");
            int j3 = 0;
            while (j3 < nl.getLength()) {
                el = webJ2eeXmlDocument.createElement("server-role-name");
                node = webJ2eeXmlDocument.createTextNode(nl.item(j3).getFirstChild().getNodeValue());
                el.appendChild(node);
                webSecRoleEl.appendChild(el);
                ++j3;
            }
            webJ2eeXmlDocumentEl.appendChild(webSecRoleEl);
            ++i;
        }
    }

    private void setDefaultLoginConfig(Document webJ2eeDocument, int authentication) throws Exception {
        if (authentication == IAUTH_BASIC) {
            this.setDefaultLoginConfig(webJ2eeDocument, WEB_J2EE_ENGINE_BASIC_XML_TEMPLATE);
        } else if (authentication == IAUTH_CERT) {
            this.setDefaultLoginConfig(webJ2eeDocument, WEB_J2EE_ENGINE_CERT_XML_TEMPLATE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDefaultLoginConfig(Document webJ2eeDocument, String webJ2eeLoginSourceLocation) throws Exception {
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream webJ2eeLoginInput = null;
        try {
            webJ2eeLoginInput = loader.getResourceAsStream(webJ2eeLoginSourceLocation);
            this.setDefaultLoginConfig(webJ2eeDocument, webJ2eeLoginInput);
            Object var6_5 = null;
            if (webJ2eeLoginInput == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (webJ2eeLoginInput == null) throw throwable;
            webJ2eeLoginInput.close();
            throw throwable;
        }
        webJ2eeLoginInput.close();
    }

    private void setDefaultLoginConfig(Document webJ2eeDocument, InputStream webJ2eeLoginInput) throws Exception {
        Document webJ2eeLoginDocument = this.documentBuilder.parse(webJ2eeLoginInput);
        this.setDefaultLoginConfig(webJ2eeDocument, webJ2eeLoginDocument);
    }

    private void setDefaultLoginConfig(Document webJ2eeDocument, Document webJ2eeLoginDocument) {
        NodeList loginModuleConfigs = webJ2eeLoginDocument.getElementsByTagName("login-module-configuration");
        Node loginModuleConfig = null;
        if (loginModuleConfigs.getLength() > 0) {
            loginModuleConfig = loginModuleConfigs.item(0);
        }
        this.setLoginConfig(webJ2eeDocument, loginModuleConfig);
    }

    private void setSecurityRoleMapsByImport(Document webJ2eeDocument, NodeList securityRolesMaps) {
        if (securityRolesMaps == null) {
            return;
        }
        int i = 0;
        while (i < securityRolesMaps.getLength()) {
            Node securityRoleMap = securityRolesMaps.item(i);
            this.setSecurityRoleMapByImport(webJ2eeDocument, securityRoleMap);
            ++i;
        }
    }

    private void setSecurityRoleMapByImport(Document webJ2eeDocument, Node securityRoleMap) {
        if (securityRoleMap == null) {
            return;
        }
        Node newSecurityRoleMap = webJ2eeDocument.importNode(securityRoleMap, true);
        webJ2eeDocument.getDocumentElement().appendChild(newSecurityRoleMap);
    }

    private void setLoginConfig(Document webJ2eeDocument, Node loginModuleConfig) {
        if (loginModuleConfig == null) {
            return;
        }
        Node newLoginModuleConfig = webJ2eeDocument.importNode(loginModuleConfig, true);
        webJ2eeDocument.getDocumentElement().appendChild(newLoginModuleConfig);
    }

    public void copy(InputStream in, OutputStream out) throws IOException {
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        int count = 0;
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        out.flush();
    }

    public boolean deleteDir(File dir) throws IOException {
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            throw new IOException("The current file is not a directory.");
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.deleteDir(files[i]);
            }
            if (files[i].isFile()) {
                files[i].delete();
            }
            ++i;
        }
        dir.delete();
        return !dir.exists();
    }

    private WebInfo[] getWebInfosAsArray(ArrayList webInfos) {
        WebInfo[] webInfosArr = new WebInfo[webInfos.size()];
        int i = 0;
        while (i < webInfos.size()) {
            webInfosArr[i] = (WebInfo)webInfos.get(i);
            ++i;
        }
        return webInfosArr;
    }
}

