/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.jar;

import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.jar.JarExtractor;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.exceptions.BaseIOException;
import com.sap.engine.services.deploy.ear.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.deploy.ear.jar.AbstractUpdater;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimpleEARUpdater
extends AbstractUpdater {
    private String earPath = null;
    private final String[] WEBSERVICE_ENTRY = new String[]{"META-INF/ws-deployment-descriptor.xml", "meta-inf/ws-deployment-descriptor.xml"};
    private JarExtractor extractor = new JarExtractor();
    private JarUtils jarUtils = new JarUtils();
    private FileUtils fileUtils = new FileUtils();
    private Enumeration enum = null;
    private Hashtable altXmls = null;
    private InfoObject[] earAltDD = null;
    byte[] bytes = null;
    private Document doc = null;

    public SimpleEARUpdater() {
    }

    public SimpleEARUpdater(String _earPath, Hashtable altXmls) {
        this.earPath = _earPath;
        this.altXmls = altXmls;
    }

    public SimpleEARUpdater(String _earPath, Hashtable altXmls, InfoObject[] _earAltDD) {
        this.earPath = _earPath;
        this.altXmls = altXmls;
        this.earAltDD = _earAltDD;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateEar(String tempEar) throws DeploymentException {
        block35: {
            if (this.earPath == null) {
                throw new DeploymentException("deploy_2016");
            }
            if (this.tempDir == null) {
                this.tempDir = new File(new File(this.earPath).getParentFile(), "SimpleUpdater" + System.currentTimeMillis());
            }
            int index = -1;
            ZipFile ear = null;
            ZipEntry entry = null;
            try {
                try {
                    this.extractor.extractJar(this.earPath, this.tempDir.getAbsolutePath());
                    if (this.earAltDD != null) {
                        String earAltEntry = null;
                        int i = 0;
                        while (i < this.earAltDD.length) {
                            if (this.earAltDD[i].getEntryName().equals("META-INF/application.xml")) {
                                index = i;
                            } else {
                                earAltEntry = this.earAltDD[i].getEntryName().replace('/', File.separatorChar);
                                FileUtils.copyFile((File)new File(this.earAltDD[i].getFilePath()), (File)new File(this.tempDir.getAbsolutePath() + File.separator + earAltEntry));
                            }
                            ++i;
                        }
                    }
                    ear = new ZipFile(this.earPath);
                    entry = this.findEntry(ear, "META-INF/application.xml");
                }
                catch (IOException ioe) {
                    throw new DeploymentException("deploy_2008", (Object[])new String[]{"extracting", ioe.toString()}, (Throwable)ioe);
                }
                BufferedInputStream xmlStream = null;
                String[] modules = null;
                try {
                    StandardDOMParser parser = new StandardDOMParser();
                    if (index > -1) {
                        this.doc = new StandardDOMParser().parse(this.earAltDD[index].getFilePath());
                        try {
                            FileUtils.copyFile((File)new File(this.earAltDD[index].getFilePath()), (File)new File(this.tempDir.getAbsolutePath() + File.separator + this.earAltDD[index].getEntryName().replace('/', File.separatorChar)));
                        }
                        catch (IOException ioe) {
                            this.doc = null;
                        }
                    }
                    if (this.doc == null && entry != null) {
                        xmlStream = new BufferedInputStream(ear.getInputStream(entry));
                        parser.setSystemId("META-INF/application.xml");
                        this.doc = parser.parse((InputStream)xmlStream);
                    }
                    if (this.doc != null) {
                        modules = this.getModules(this.doc);
                    }
                }
                catch (Exception e) {
                    throw new DeploymentException("deploy_2019", (Object[])new String[]{e.toString()}, (Throwable)e);
                }
                try {
                    this.updateEarXmls(this.tempDir);
                }
                catch (BaseIllegalArgumentException billex) {
                    throw billex;
                }
                catch (Exception e) {
                    throw new DeploymentException("deploy_2018", (Object[])new String[]{e.toString()}, (Throwable)e);
                }
                Hashtable<String, String> newEntriesFiles = null;
                ZipEntry moduleEntry = null;
                if (modules != null) {
                    int i = 0;
                    while (true) {
                        if (i >= modules.length) {
                            break;
                        }
                        newEntriesFiles = new Hashtable<String, String>();
                        InfoObject[] infos = (InfoObject[])this.altXmls.get(modules[i]);
                        if (infos != null && infos.length != 0) {
                            String key = null;
                            String value = null;
                            int j = 0;
                            while (j < infos.length) {
                                if (infos[j] != null && (value = infos[j].getFilePath()) != null) {
                                    key = infos[j].getEntryName() != null ? infos[j].getEntryName() : value;
                                    newEntriesFiles.put(key, value);
                                }
                                ++j;
                            }
                        }
                        if ((moduleEntry = this.findEntry(ear, modules[i])) == null) {
                            throw new DeploymentException("deploy_2021", (Object[])new String[]{modules[i]});
                        }
                        try {
                            this.writeUpdatedJar(new File(this.tempDir, modules[i]), newEntriesFiles);
                        }
                        catch (BaseIllegalArgumentException biaexc) {
                            throw biaexc;
                        }
                        catch (IOException ioex) {
                            throw new DeploymentException("deploy_2022", (Object[])new String[]{modules[i] + "\n" + ioex.getMessage()}, (Throwable)ioex);
                        }
                        ++i;
                    }
                }
                Object var15_23 = null;
                if (ear == null) break block35;
            }
            catch (Throwable throwable) {
                Object var15_24 = null;
                if (ear == null) throw throwable;
                try {
                    ear.close();
                    throw throwable;
                }
                catch (IOException ioex) {
                    throw new DeploymentException("deploy_4407", (Object[])new String[]{ear.getName()}, (Throwable)ioex);
                }
            }
            try {}
            catch (IOException ioex) {
                throw new DeploymentException("deploy_4407", (Object[])new String[]{ear.getName()}, (Throwable)ioex);
            }
            ear.close();
        }
        try {
            this.jarUtils.makeJarFromDir(tempEar, this.tempDir.getAbsolutePath());
        }
        catch (IOException ioex) {
            throw new DeploymentException("deploy_2022", (Object[])new String[]{"", ioex.toString()}, (Throwable)ioex);
        }
        FileUtils.deleteDirectory((File)this.tempDir);
    }

    private void writeUpdatedJar(File oldFile, Hashtable newEntries) throws IOException {
        this.writeUpdatedJar(oldFile, newEntries, null);
    }

    public void writeUpdatedJar(File oldFile, InfoObject[] newEntries, File newFile) throws IOException {
        Hashtable<String, String> newEntriesHash = new Hashtable<String, String>();
        if (newEntries != null) {
            int i = 0;
            while (i < newEntries.length) {
                newEntriesHash.put(newEntries[i].getEntryName(), newEntries[i].getFilePath());
                ++i;
            }
        }
        this.writeUpdatedJar(oldFile, newEntriesHash, newFile);
    }

    /*
     * Loose catch block
     */
    public void writeUpdatedJar(File oldFile, Hashtable newEntries, File newFile) throws IOException {
        FileOutputStream fos;
        ZipOutputStream newJar;
        File tempFile;
        ZipFile old;
        block26: {
            old = new ZipFile(oldFile);
            tempFile = new File(oldFile.getAbsolutePath() + System.currentTimeMillis());
            newJar = null;
            fos = null;
            try {
                fos = new FileOutputStream(tempFile);
                newJar = new ZipOutputStream(fos);
                newJar.setMethod(0);
            }
            catch (IOException ioe) {
                throw new BaseIOException("deploy_2023", (Object[])new String[]{ioe.getMessage()}, (Throwable)ioe);
            }
            ZipEntry entry = null;
            ZipEntry newEntry = null;
            String entryName = null;
            Enumeration enumeration = null;
            String key = null;
            BufferedInputStream bis = null;
            byte[] bytes = null;
            boolean hasUpdate = false;
            CRC32 crc = null;
            Enumeration<? extends ZipEntry> enumZip = old.entries();
            while (enumZip.hasMoreElements()) {
                entry = enumZip.nextElement();
                hasUpdate = false;
                entryName = entry.getName().replace('\\', '/');
                enumeration = newEntries.keys();
                while (enumeration.hasMoreElements()) {
                    key = (String)enumeration.nextElement();
                    if (!entryName.equalsIgnoreCase(key)) continue;
                    newEntry = new ZipEntry(key);
                    newEntry.setMethod(0);
                    bis = newEntries.get(key) instanceof File ? new BufferedInputStream(new FileInputStream((File)newEntries.get(key))) : new BufferedInputStream(new FileInputStream((String)newEntries.get(key)));
                    hasUpdate = true;
                    newEntries.remove(key);
                    break;
                }
                if (!hasUpdate) {
                    newEntry = new ZipEntry(entryName);
                    newEntry.setMethod(0);
                    bis = new BufferedInputStream(old.getInputStream(entry));
                }
                boolean original = false;
                try {
                    if (entryName.equalsIgnoreCase("META-INF/ejb-jar.xml") || entryName.equalsIgnoreCase("META-INF/ejb-j2ee-engine.xml") || entryName.equalsIgnoreCase("META-INF/persistent.xml") || entryName.equalsIgnoreCase("WEB-INF/web.xml") || entryName.equalsIgnoreCase("WEB-INF/web-j2ee-engine.xml") || entryName.equalsIgnoreCase("META-INF/application-client.xml") || entryName.equalsIgnoreCase("META-INF/application-client-additional.xml") || entryName.equalsIgnoreCase("META-INF/appclient-j2ee-engine.xml") || entryName.equalsIgnoreCase("META-INF/ra.xml") || entryName.equalsIgnoreCase("META-INF/connector-j2ee-engine.xml")) {
                        this.setCurrentXMLName(entryName);
                        bytes = this.makeSubstitution(bis);
                    } else {
                        original = true;
                        bytes = new byte[bis.available()];
                        bis.read(bytes, 0, bytes.length);
                    }
                }
                catch (BaseIllegalArgumentException biaexc) {
                    throw biaexc;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BaseIOException("deploy_2024", (Object[])new String[]{e.toString()}, (Throwable)e);
                }
                try {
                    bis.close();
                }
                catch (IOException ioex) {
                    throw new BaseIOException("deploy_4407", (Object[])new String[]{old.getName()}, (Throwable)ioex);
                }
                newEntry.setSize(bytes.length);
                crc = new CRC32();
                crc.update(bytes);
                newEntry.setCrc(crc.getValue());
                if (original) {
                    newEntry.setTime(entry.getTime());
                }
                newJar.putNextEntry(newEntry);
                newJar.write(bytes, 0, bytes.length);
                newJar.closeEntry();
            }
            if (newEntries.size() <= 0) break block26;
            enumeration = newEntries.keys();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                newEntry = new ZipEntry(key);
                newEntry.setMethod(0);
                bis = newEntries.get(key) instanceof File ? new BufferedInputStream(new FileInputStream((File)newEntries.get(key))) : new BufferedInputStream(new FileInputStream((String)newEntries.get(key)));
                bytes = new byte[bis.available()];
                bis.read(bytes, 0, bytes.length);
                newEntry.setSize(bytes.length);
                try {
                    bis.close();
                }
                catch (Exception ioex) {
                    Object value = newEntries.get(key);
                    throw new BaseIOException("deploy_4407", (Object[])new String[]{value != null ? value.toString() : ""}, (Throwable)ioex);
                }
                crc = new CRC32();
                crc.update(bytes);
                newEntry.setCrc(crc.getValue());
                newJar.putNextEntry(newEntry);
                newJar.write(bytes, 0, bytes.length);
                newJar.closeEntry();
            }
        }
        Object var22_26 = null;
        try {
            old.close();
            ((FilterOutputStream)newJar).flush();
            newJar.finish();
            newJar.close();
            fos.flush();
            fos.close();
        }
        catch (Exception ioex) {
            throw new BaseIOException("deploy_4407", (Object[])new String[]{""}, (Throwable)ioex);
        }
        {
            catch (IOException ioex) {
                throw ioex;
            }
        }
        catch (Throwable throwable) {
            Object var22_27 = null;
            try {
                old.close();
                ((FilterOutputStream)newJar).flush();
                newJar.finish();
                newJar.close();
                fos.flush();
                fos.close();
            }
            catch (Exception ioex) {
                throw new BaseIOException("deploy_4407", (Object[])new String[]{""}, (Throwable)ioex);
            }
            throw throwable;
        }
        if (newFile == null) {
            oldFile.delete();
            FileUtils.copyFile((File)tempFile, (File)oldFile);
            tempFile.delete();
        } else {
            if (newFile.exists()) {
                newFile.delete();
            }
            FileUtils.copyFile((File)tempFile, (File)newFile);
            tempFile.delete();
        }
    }

    private String[] getModules(Document doc) throws Exception {
        Element docElement = doc.getDocumentElement();
        NodeList moduleList = docElement.getElementsByTagName("module");
        if (moduleList == null || moduleList.getLength() == 0) {
            return null;
        }
        String[] result = new String[moduleList.getLength()];
        Element moduleEl = null;
        Node child = null;
        int i = 0;
        while (i < moduleList.getLength()) {
            if (moduleList.item(i).getNodeType() == 1) {
                moduleEl = (Element)moduleList.item(i);
            }
            if ((child = this.getFirstChild(moduleEl, "ejb")) != null) {
                result[i] = this.getElementValue((Element)child);
            } else {
                child = this.getFirstChild(moduleEl, "web");
                if (child != null) {
                    result[i] = this.getElementValue((Element)this.getFirstChild((Element)child, "web-uri"));
                } else {
                    child = this.getFirstChild(moduleEl, "java");
                    if (child != null) {
                        result[i] = this.getElementValue((Element)child);
                    } else {
                        child = this.getFirstChild(moduleEl, "connector");
                        if (child != null) {
                            result[i] = this.getElementValue((Element)child);
                        }
                    }
                }
            }
            ++i;
        }
        return result;
    }

    private Node getFirstChild(Element el, String name) {
        NodeList list = el.getElementsByTagName(name);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        return list.item(0);
    }

    private String getElementValue(Element el) {
        Node child = el.getFirstChild();
        if (child == null) {
            return null;
        }
        return child.getNodeValue().trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateEarXmls(File dir) throws Exception {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            block14: {
                if (!(files[i].getName().equalsIgnoreCase("jms-destinations.xml") || files[i].getName().equalsIgnoreCase("jms-factories.xml") || files[i].getName().equalsIgnoreCase("app-data-source.xml") || files[i].getName().equalsIgnoreCase("data-sources.xml") || files[i].getName().equalsIgnoreCase("data-source-aliases.xml") || files[i].getName().equalsIgnoreCase("application-j2ee-engine.xml") || files[i].getName().equalsIgnoreCase("application.xml") || files[i].getName().equalsIgnoreCase("log-configuration.xml") || files[i].getName().equalsIgnoreCase("sap.application.global.properties"))) {
                    if (files[i].isDirectory() && files[i].getName().equalsIgnoreCase("META-INF")) {
                        this.updateEarXmls(files[i]);
                    }
                } else {
                    Object var10_8;
                    this.setCurrentXMLName(files[i].getName());
                    byte[] bytes = this.makeSubstitution(new BufferedInputStream(new FileInputStream(files[i])));
                    File temp = new File(dir, files[i].getName() + System.currentTimeMillis());
                    FileUtils.copyFile((File)files[i], (File)temp);
                    files[i].delete();
                    FileOutputStream fos = new FileOutputStream(files[i]);
                    try {
                        try {
                            fos.write(bytes);
                        }
                        catch (Exception e) {
                            try {
                                FileUtils.copyFile((File)temp, (File)files[i]);
                            }
                            catch (IOException ioex) {
                                throw new BaseIOException("deploy_5051", (Object[])new String[]{temp.getAbsolutePath(), files[i].getAbsolutePath()}, (Throwable)ioex);
                            }
                            var10_8 = null;
                            try {}
                            catch (IOException ioex) {
                                throw new BaseIOException("deploy_2008", (Object[])new String[]{"updating xmls in", ioex.toString()}, (Throwable)ioex);
                            }
                            temp.delete();
                            fos.flush();
                            fos.close();
                            break block14;
                        }
                        var10_8 = null;
                        try {
                            temp.delete();
                            fos.flush();
                            fos.close();
                        }
                        catch (IOException ioex) {
                            throw new BaseIOException("deploy_2008", (Object[])new String[]{"updating xmls in", ioex.toString()}, (Throwable)ioex);
                        }
                    }
                    catch (Throwable throwable) {
                        var10_8 = null;
                        try {}
                        catch (IOException ioex) {
                            throw new BaseIOException("deploy_2008", (Object[])new String[]{"updating xmls in", ioex.toString()}, (Throwable)ioex);
                        }
                        temp.delete();
                        fos.flush();
                        fos.close();
                        throw throwable;
                    }
                }
            }
            ++i;
        }
    }
}

