/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.jar;

import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.jar.JarExtractor;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ReferenceObjectIntf;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.SimpleEarDescriptor;
import com.sap.engine.services.deploy.ear.exceptions.BaseEarException;
import com.sap.engine.services.deploy.ear.exceptions.BaseIOException;
import com.sap.engine.services.deploy.ear.webservices.WebInfo;
import com.sap.engine.services.deploy.ear.webservices.WebInfoCreatorImpl;
import com.sap.engine.services.deploy.ear.xml.ApplicationJ2EEEngineDocument;
import com.sap.engine.services.deploy.ear.xml.ExtendedEARDescriptorReader;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class EARReader {
    String errorMsg = "";
    String debugMsg = "";
    SimpleEarDescriptor descr = null;
    protected File tempDir = null;
    protected String filename = null;
    protected ClassLoader loader = null;
    private Hashtable fileMappings = new Hashtable();
    protected Hashtable j2eeJars = new Hashtable();
    protected Hashtable nonJ2EEJars = new Hashtable();
    protected ContainerInfo[] cinfoes = null;
    protected File[] clientJarFiles = null;
    protected File[] connectorRarFiles = null;
    protected File[] ejbJars = null;
    protected File[] otherJarFiles = null;
    protected File[] serviceJars = null;
    protected File[] warFiles = null;
    private String dtd = null;
    private static final String[] WEBSERVICE_ENTRY = new String[]{"META-INF/ws-deployment-descriptor.xml", "meta-inf/ws-deployment-descriptor.xml"};
    private Vector webServInfo = null;

    public EARReader() {
    }

    public EARReader(String _filename) throws IOException {
        this.filename = _filename;
        File file = new File(this.filename);
        this.tempDir = new File(file.getParentFile(), "reader" + System.currentTimeMillis());
        this.tempDir.mkdirs();
        try {
            this.descr = this.getDescriptor();
        }
        catch (IOException ioexc) {
            this.clear();
            throw ioexc;
        }
    }

    public EARReader(String _filename, File _tempDir) throws IOException {
        this.filename = _filename;
        this.tempDir = new File(_tempDir, "reader" + System.currentTimeMillis());
        this.tempDir.mkdirs();
        try {
            this.descr = this.getDescriptor();
        }
        catch (IOException ioexc) {
            this.clear();
            throw ioexc;
        }
    }

    public void setContainerInfoes(ContainerInfo[] cinfoes) {
        this.cinfoes = cinfoes;
    }

    public void setJarName(String _filename) throws IOException {
        this.filename = _filename;
        File file = new File(this.filename);
        this.tempDir = new File(file.getParentFile(), "reader" + System.currentTimeMillis());
        this.tempDir.mkdirs();
        this.descr = this.getDescriptor();
    }

    public String getJarName() {
        return this.filename;
    }

    public void clear() {
        if (this.tempDir.exists()) {
            FileUtils.deleteDirectory((File)this.tempDir);
        }
    }

    public SimpleEarDescriptor getEARDescriptor() throws IOException {
        if (this.descr == null) {
            this.descr = this.getDescriptor();
        }
        return this.descr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SimpleEarDescriptor getDescriptor() throws IOException {
        SimpleEarDescriptor simpleEarDescriptor;
        ZipFile file;
        block15: {
            InputStream xmlStream = null;
            file = null;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            StandardDOMParser parser = new StandardDOMParser();
            Thread.currentThread().setContextClassLoader(cl);
            try {
                try {
                    SimpleEarDescriptor descr;
                    block14: {
                        file = new ZipFile(this.filename);
                        ZipEntry entry = this.findEntry(file, "META-INF/application.xml");
                        if (entry == null) {
                            throw new BaseIOException("deploy_2007", (Object[])new String[]{this.filename});
                        }
                        xmlStream = new BufferedInputStream(file.getInputStream(entry));
                        parser.setSystemId("META-INF/application.xml");
                        Document doc = parser.parse(xmlStream);
                        ExtendedEARDescriptorReader reader = new ExtendedEARDescriptorReader();
                        descr = reader.loadSimpleEarDescriptor(doc);
                        this.dtd = reader.dtd;
                        xmlStream.close();
                        if (reader.getErrorMsg(true) != null && !reader.getErrorMsg(true).equals("")) {
                            this.debugMsg = reader.getErrorMsg(true);
                        }
                        if (reader.getErrorMsg(false) != null && !reader.getErrorMsg(false).equals("")) {
                            this.errorMsg = reader.getErrorMsg(false);
                        }
                        if ((entry = this.findEntry(file, "META-INF/application-j2ee-engine.xml")) != null) {
                            ApplicationJ2EEEngineDocument appDoc = new ApplicationJ2EEEngineDocument();
                            try {
                                try {
                                    xmlStream = new BufferedInputStream(file.getInputStream(entry));
                                    parser.setSystemId("META-INF/application-j2ee-engine.xml");
                                    doc = parser.parse(xmlStream);
                                    appDoc.loadFieldsFromDocument(doc);
                                    descr.setReferences((ReferenceObjectIntf[])appDoc.getReferences());
                                    descr.setClassPath(appDoc.getClassPath());
                                    descr.setProviderName(appDoc.getProviderName());
                                    descr.setAdditionalModules(appDoc.getModules());
                                    descr.setFailOverValue(appDoc.getFailOverValue());
                                    descr.setStartUpValue(appDoc.getStartUpMode());
                                }
                                catch (Exception e) {
                                    throw new BaseIOException("deploy_5093", (Object[])new String[]{e.toString()}, (Throwable)e);
                                }
                                Object var12_12 = null;
                                if (xmlStream == null) break block14;
                            }
                            catch (Throwable throwable) {
                                Object var12_13 = null;
                                if (xmlStream == null) throw throwable;
                                xmlStream.close();
                                throw throwable;
                            }
                            xmlStream.close();
                        }
                    }
                    this.checkDescriptor(descr, file);
                    file.close();
                    this.checkAliases(descr.getModules());
                    simpleEarDescriptor = descr;
                    Object var14_16 = null;
                    if (xmlStream == null) break block15;
                }
                catch (DeploymentException e) {
                    throw new BaseIOException("deploy_2008", (Object[])new String[]{"reading", e.toString()}, (Throwable)e);
                }
                catch (SAXException e) {
                    throw new BaseIOException("deploy_2008", (Object[])new String[]{"reading", e.toString()}, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                if (xmlStream != null) {
                    xmlStream.close();
                }
                if (file == null) throw throwable;
                file.close();
                throw throwable;
            }
            xmlStream.close();
        }
        if (file == null) return simpleEarDescriptor;
        file.close();
        return simpleEarDescriptor;
    }

    public File[] getEJBJars() throws IOException {
        if (this.ejbJars == null) {
            this.ejbJars = this.getComponentJarFiles(1);
        }
        return this.ejbJars;
    }

    public File[] getServiceJars() throws IOException {
        if (this.serviceJars == null) {
            this.serviceJars = this.getComponentJarFiles(2);
        }
        return this.serviceJars;
    }

    public File[] getWarFiles() throws IOException {
        if (this.warFiles == null) {
            this.warFiles = this.getComponentJarFiles(4);
        }
        return this.warFiles;
    }

    public File[] getClientJarFiles() throws IOException {
        if (this.clientJarFiles == null) {
            this.clientJarFiles = this.getComponentJarFiles(3);
        }
        return this.clientJarFiles;
    }

    public File[] getConnectorRarFiles() throws IOException {
        if (this.connectorRarFiles == null) {
            this.connectorRarFiles = this.getComponentJarFiles(5);
        }
        return this.connectorRarFiles;
    }

    public File[] getOtherJarFiles() throws IOException {
        if (this.otherJarFiles == null) {
            this.otherJarFiles = this.getComponentJarFiles(0);
        }
        return this.otherJarFiles;
    }

    public File[] getJ2EEJars(String type) throws IOException {
        if (this.j2eeJars.get(type) == null) {
            File[] res = this.getComponentJarFiles(type);
            if (res != null) {
                this.j2eeJars.put(type, res);
            }
            return res;
        }
        return (File[])this.j2eeJars.get(type);
    }

    public File[] getComponentJarFiles(String type) throws IOException {
        Vector<File> allOtherJars = new Vector<File>();
        Object[] allJars = null;
        J2EEModule[] modules = null;
        if (this.descr == null) {
            this.descr = this.getDescriptor();
            if (this.descr == null) {
                return null;
            }
        }
        if ((modules = this.descr.getModules()) != null) {
            int i = 0;
            while (i < modules.length) {
                if (modules[i].getType(true).equals(type)) {
                    try {
                        allOtherJars.addElement(this.extractFile(modules[i].getUri()));
                    }
                    catch (IOException ioe) {
                        throw ioe;
                    }
                    catch (Exception e) {
                        throw new BaseIOException("deploy_2008", (Object[])new String[]{"reading", e.toString()}, (Throwable)e);
                    }
                }
                ++i;
            }
            if (allOtherJars.size() > 0) {
                allJars = new File[allOtherJars.size()];
                allOtherJars.copyInto(allJars);
                return allJars;
            }
        }
        return null;
    }

    public File[] getComponentJarFiles(int type) throws IOException {
        Vector<File> allOtherJars = new Vector<File>();
        Object[] allJars = null;
        J2EEModule[] modules = null;
        if (type < 0 && type > 5) {
            throw new BaseIOException("deploy_2009", (Object[])new Integer[]{new Integer(type)});
        }
        if (this.descr == null) {
            this.descr = this.getDescriptor();
            if (this.descr == null) {
                return null;
            }
        }
        if ((modules = this.descr.getModules()) != null) {
            int i = 0;
            while (i < modules.length) {
                if (modules[i].getType() == type) {
                    try {
                        allOtherJars.addElement(this.extractFile(modules[i].getUri()));
                    }
                    catch (IOException ioe) {
                        throw ioe;
                    }
                    catch (Exception e) {
                        throw new BaseIOException("deploy_2008", (Object[])new String[]{"reading", e.toString()}, (Throwable)e);
                    }
                }
                ++i;
            }
            if (allOtherJars.size() > 0) {
                allJars = new File[allOtherJars.size()];
                allOtherJars.copyInto(allJars);
                return allJars;
            }
        }
        return null;
    }

    public File[] getNonJ2EEJars(String[] fileExtensions, String[] fileNames, String containerName) throws IOException {
        if (this.nonJ2EEJars.get(containerName) == null) {
            Vector<File> res = new Vector<File>();
            Vector<String> entryNames = new Vector<String>();
            JarFile earFile = new JarFile(this.filename);
            Hashtable additionalModules = this.descr.getAdditionalModules();
            if (additionalModules != null) {
                Enumeration entries = additionalModules.keys();
                String entry = null;
                String conts = null;
                while (entries.hasMoreElements()) {
                    entry = (String)entries.nextElement();
                    conts = (String)additionalModules.get(entry);
                    if (conts.indexOf(containerName) == -1 || entryNames.contains(entry)) continue;
                    entryNames.add(entry);
                    res.add(this.extractFile(entry));
                }
            }
            if (fileNames != null) {
                int i = 0;
                while (i < fileNames.length) {
                    if (earFile.getEntry(fileNames[i]) != null && !entryNames.contains(fileNames[i])) {
                        entryNames.add(fileNames[i]);
                        res.add(this.extractFile(fileNames[i]));
                    }
                    ++i;
                }
            }
            if (fileExtensions != null) {
                int i = 0;
                while (i < fileExtensions.length) {
                    Enumeration<JarEntry> entries = earFile.entries();
                    ZipEntry entry = null;
                    while (entries.hasMoreElements()) {
                        entry = entries.nextElement();
                        if (!entry.getName().toLowerCase().endsWith(fileExtensions[i].toLowerCase()) || entryNames.contains(entry.getName())) continue;
                        entryNames.add(entry.getName());
                        res.add(this.extractFile(entry.getName()));
                    }
                    ++i;
                }
            }
            earFile.close();
            if (res.size() > 0) {
                File[] array = new File[res.size()];
                res.toArray(array);
                this.nonJ2EEJars.put(containerName, array);
                return array;
            }
            return null;
        }
        return (File[])this.nonJ2EEJars.get(containerName);
    }

    public Hashtable getAllContainerFiles() throws IOException, DeploymentException {
        if (this.cinfoes != null) {
            Hashtable<String, File[]> res = new Hashtable<String, File[]>();
            File[] files = null;
            J2EEModule[] modules = this.descr.getModules();
            if (modules != null) {
                boolean foundCont = false;
                int i = 0;
                while (i < modules.length) {
                    foundCont = false;
                    int j = 0;
                    while (j < this.cinfoes.length) {
                        if (this.cinfoes[j].isJ2EEContainer() && this.cinfoes[j].getJ2EEModuleName().equals(modules[i].getType(true))) {
                            foundCont = true;
                            break;
                        }
                        ++j;
                    }
                    if (!foundCont) {
                        throw new BaseEarException("deploy_2010", new String[]{modules[i].getUri()});
                    }
                    ++i;
                }
            } else {
                throw new BaseEarException("deploy_2011");
            }
            int i = 0;
            while (i < this.cinfoes.length) {
                if (this.cinfoes[i].isJ2EEContainer()) {
                    files = this.getJ2EEJars(this.cinfoes[i].getJ2EEModuleName());
                    if (files != null) {
                        res.put(this.cinfoes[i].getName(), files);
                    }
                } else {
                    files = this.getNonJ2EEJars(this.cinfoes[i].getFileExtensions(), this.cinfoes[i].getFileNames(), this.cinfoes[i].getName());
                    if (files != null) {
                        res.put(this.cinfoes[i].getName(), files);
                    }
                }
                ++i;
            }
            return res;
        }
        throw new BaseEarException("deploy_2012");
    }

    protected void checkAliases_new(J2EEModule[] modules) {
        if (modules != null) {
            int i = 0;
            while (i < modules.length) {
                if (modules[i].getType(true).equals("web") && (modules[i].getContextRoot() == null || modules[i].getContextRoot().trim().equals(""))) {
                    modules[i].setContextRoot("/");
                }
                ++i;
            }
        }
    }

    protected void checkAliases(J2EEModule[] modules) {
        if (modules != null) {
            int i = 0;
            while (i < modules.length) {
                if (modules[i].getType() == 4 && (modules[i].getContextRoot() == null || modules[i].getContextRoot().trim().equals(""))) {
                    modules[i].setContextRoot("/");
                }
                ++i;
            }
        }
    }

    public File extractFile(String entryName) throws IOException {
        ZipFile zipf = null;
        zipf = new ZipFile(this.filename);
        entryName = entryName.replace('\\', '/');
        ZipEntry tempent = zipf.getEntry(entryName);
        String fName = entryName;
        fName = fName.replace('/', File.separatorChar);
        fName = fName.replace('\\', File.separatorChar);
        File f = new File(this.tempDir.getAbsolutePath() + File.separator + fName);
        if (tempent == null) {
            boolean found = false;
            WebInfo webInfo = null;
            int i = 0;
            while (this.webServInfo != null && i < this.webServInfo.size()) {
                webInfo = (WebInfo)this.webServInfo.elementAt(i);
                if (entryName.equals(new File(webInfo.getWarModulePath()).getName())) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                throw new BaseIOException("deploy_2013", (Object[])new String[]{entryName, this.filename});
            }
            return f;
        }
        File parentDir = f.getParentFile();
        parentDir.mkdirs();
        BufferedInputStream in = new BufferedInputStream(zipf.getInputStream(tempent));
        FileOutputStream fos = new FileOutputStream(f);
        this.fileMappings.put(f.getAbsolutePath(), entryName.replace('\\', '/'));
        int count = 4096;
        byte[] buff = new byte[count];
        try {
            while (count == 4096) {
                count = ((InputStream)in).read(buff);
                if (count <= 0) continue;
                fos.write(buff, 0, count);
            }
            ((InputStream)in).close();
            zipf.close();
            fos.flush();
            fos.close();
        }
        catch (EOFException ex) {
            buff = new byte[(int)tempent.getSize()];
            ((InputStream)in).read(buff);
            ((InputStream)in).close();
            zipf.close();
            fos.flush();
            fos.close();
        }
        return f;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    protected void checkDescriptor(SimpleEarDescriptor descr, ZipFile file) throws IOException {
        J2EEModule[] modules = null;
        if (descr == null) {
            return;
        }
        modules = descr.getModules();
        if (modules == null) {
            return;
        }
        String message = "";
        ZipEntry entry = null;
        int i = 0;
        while (i < modules.length) {
            entry = file.getEntry(modules[i].getUri().replace('\\', '/'));
            if (entry == null) {
                message = message + modules[i].getUri() + ",";
            }
            ++i;
        }
        if (!message.trim().equals("")) {
            throw new BaseIOException("deploy_2015", (Object[])new String[]{message});
        }
    }

    public String[] getAdditionalLibraries(String destinationDir) throws IOException {
        String[] entries = this.getAdditionalLibrariesEntries(destinationDir);
        String[] res = null;
        if (entries != null) {
            res = new String[entries.length];
            int i = 0;
            while (i < entries.length) {
                res[i] = destinationDir + File.separator + entries[i].replace('/', File.separatorChar);
                ++i;
            }
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getAdditionalLibrariesEntries(String destinationDir) throws IOException {
        Vector<String> jars;
        block11: {
            jars = new Vector<String>();
            J2EEModule[] modules = null;
            if (this.descr == null) {
                this.descr = this.getDescriptor();
            }
            modules = this.descr.getModules();
            String name = null;
            JarEntry entry = null;
            JarFile file = null;
            JarExtractor extractor = new JarExtractor();
            try {
                try {
                    file = new JarFile(this.filename);
                    Enumeration<JarEntry> enumeration = file.entries();
                    boolean found = false;
                    while (enumeration.hasMoreElements()) {
                        entry = enumeration.nextElement();
                        name = entry.getName();
                        if (entry.isDirectory() || !name.endsWith(".jar") && !name.endsWith(".zip") && !name.endsWith(".war") && !name.endsWith(".rar")) continue;
                        found = false;
                        int i = 0;
                        while (i < modules.length) {
                            if (entry.getName().equals(modules[i].getUri().replace('\\', '/'))) {
                                found = true;
                                break;
                            }
                            ++i;
                        }
                        if (found) continue;
                        name = entry.getName();
                        jars.add(name);
                        extractor.extractFile(file, entry.getName(), destinationDir);
                    }
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Exception e) {
                    throw new BaseIOException("deploy_2008", (Object[])new String[]{"reading", e.toString()}, (Throwable)e);
                }
                Object var12_13 = null;
                if (file == null) break block11;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (file != null) {
                    file.close();
                }
                throw throwable;
            }
            file.close();
        }
        if (jars.size() > 0) {
            Object[] res = new String[jars.size()];
            jars.copyInto(res);
            return res;
        }
        return null;
    }

    public String getErrorMsg(boolean debug) {
        if (debug) {
            return this.debugMsg;
        }
        return this.errorMsg;
    }

    private ZipEntry findEntry(ZipFile zip, String entryName) {
        ZipEntry temp = null;
        Enumeration<? extends ZipEntry> enumeration = zip.entries();
        while (enumeration.hasMoreElements()) {
            temp = enumeration.nextElement();
            if (!temp.getName().equalsIgnoreCase(entryName)) continue;
            return temp;
        }
        return null;
    }

    public String getDTD() {
        return this.dtd;
    }

    public Hashtable getFileMappings() {
        return this.fileMappings;
    }

    public void setFileMappings(Hashtable fileMappings) {
        this.fileMappings = fileMappings;
    }

    public void webServicesCheck() throws IOException {
        int iw;
        Enumeration<? extends ZipEntry> enumEntries;
        int i;
        File[] ejbJarFiles = this.getEJBJars();
        File[] wsarFiles = this.getNonJ2EEJars(new String[]{".wsar"}, null, "");
        ZipFile jar = null;
        ZipEntry entry = null;
        this.webServInfo = new Vector();
        if (this.ejbJars != null) {
            i = 0;
            while (i < ejbJarFiles.length) {
                jar = new ZipFile(ejbJarFiles[i]);
                enumEntries = jar.entries();
                while (enumEntries.hasMoreElements()) {
                    entry = enumEntries.nextElement();
                    iw = 0;
                    while (iw < WEBSERVICE_ENTRY.length) {
                        if (WEBSERVICE_ENTRY[iw].equals(entry.getName().replace('\\', '/'))) {
                            this.makeWebServiceSupport(jar.getInputStream(entry));
                        }
                        ++iw;
                    }
                }
                ++i;
            }
        }
        if (wsarFiles != null) {
            i = 0;
            while (i < wsarFiles.length) {
                jar = new ZipFile(wsarFiles[i]);
                enumEntries = jar.entries();
                while (enumEntries.hasMoreElements()) {
                    entry = enumEntries.nextElement();
                    iw = 0;
                    while (iw < WEBSERVICE_ENTRY.length) {
                        if (WEBSERVICE_ENTRY[iw].equals(entry.getName().replace('\\', '/'))) {
                            this.makeWebServiceSupport(jar.getInputStream(entry));
                        }
                        ++iw;
                    }
                }
                ++i;
            }
        }
        J2EEModule webModule = null;
        WebInfo webInfo = null;
        if (this.webServInfo != null) {
            int iwi = 0;
            while (iwi < this.webServInfo.size()) {
                webInfo = (WebInfo)this.webServInfo.elementAt(iwi);
                webModule = new J2EEModule(4, new File(webInfo.getWarModulePath()).getName());
                webModule.setContextRoot(webInfo.getContextRoot());
                this.descr.addModule(webModule);
                ++iwi;
            }
        }
    }

    private void makeWebServiceSupport(InputStream is) throws IOException {
        String tempCreatorDir = new File(this.tempDir, "webService" + System.currentTimeMillis()).getAbsolutePath();
        try {
            block5: {
                try {
                    WebInfoCreatorImpl creator = new WebInfoCreatorImpl();
                    WebInfo[] webInfo = creator.createSingleWebInfo(tempCreatorDir, is);
                    File warFile = null;
                    if (webInfo == null) break block5;
                    int i = 0;
                    while (i < webInfo.length) {
                        this.webServInfo.add(webInfo[i]);
                        warFile = new File(webInfo[i].getWarModulePath());
                        FileUtils.copyFile((File)warFile, (File)new File(this.tempDir, warFile.getName()));
                        ++i;
                    }
                }
                catch (Exception e) {
                    StringWriter strWr = new StringWriter();
                    e.printStackTrace(new PrintWriter(strWr));
                    throw new IOException(strWr.toString());
                }
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            FileUtils.deleteDirectory((File)new File(tempCreatorDir));
            throw throwable;
        }
        FileUtils.deleteDirectory((File)new File(tempCreatorDir));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File extractFileNonCaseSensitive(String fileName) throws IOException {
        String entryName;
        block7: {
            if (fileName == null) {
                return null;
            }
            ZipFile ear = null;
            entryName = null;
            try {
                block6: {
                    ear = new ZipFile(this.filename);
                    Enumeration<? extends ZipEntry> entries = ear.entries();
                    ZipEntry entry = null;
                    do {
                        if (entries.hasMoreElements()) continue;
                        break block6;
                    } while (!(entry = entries.nextElement()).getName().equalsIgnoreCase(fileName));
                    entryName = entry.getName();
                }
                Object var7_6 = null;
                if (ear == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (ear != null) {
                    ear.close();
                }
                throw throwable;
            }
            ear.close();
        }
        if (entryName != null) {
            return this.extractFile(entryName);
        }
        return null;
    }
}

