/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.converter;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.ear.common.ContextParam;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.exceptions.BaseIOException;
import com.sap.engine.services.servlets_jsp.descriptor.AuthConstraints;
import com.sap.engine.services.servlets_jsp.descriptor.ErrorPage;
import com.sap.engine.services.servlets_jsp.descriptor.FilterDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.FilterMapping;
import com.sap.engine.services.servlets_jsp.descriptor.FormLoginConfig;
import com.sap.engine.services.servlets_jsp.descriptor.LoginConfig;
import com.sap.engine.services.servlets_jsp.descriptor.MIMEMapping;
import com.sap.engine.services.servlets_jsp.descriptor.SecurityConstraints;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ServletMapping;
import com.sap.engine.services.servlets_jsp.descriptor.TagLib;
import com.sap.engine.services.servlets_jsp.descriptor.UserDataConstraints;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebResourceCollection;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WebDocument {
    public static final String dtd = "<!DOCTYPE web-app [\n<!ELEMENT web-app (icon?, display-name?, description?, distributable?,\n context-param*, filter*, filter-mapping*, listener*, servlet*, servlet-mapping*, session-config?,\n mime-mapping*, welcome-file-list?, error-page*, taglib*,\n resource-ref*, security-constraint*, login-config?,\n security-role*, env-entry*, ejb-ref*, response-status*)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n <!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT distributable EMPTY>\n<!ELEMENT context-param (param-name, param-value, description?)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT filter (icon?, filter-name, display-name?, description?, filter-class, init-param*)>\n<!ELEMENT filter-name (#PCDATA)>\n<!ELEMENT filter-class (#PCDATA)>\n<!ELEMENT filter-mapping (filter-name, (url-pattern | servlet-name))>\n<!ELEMENT listener (listener-class)>\n<!ELEMENT listener-class (#PCDATA)>\n<!ELEMENT servlet (icon?, servlet-name, display-name?, description?,\n(servlet-class|jsp-file), init-param*, load-on-startup?, security-role-ref*)>\n<!ELEMENT servlet-name (#PCDATA)>\n<!ELEMENT servlet-class (#PCDATA)>\n<!ELEMENT jsp-file (#PCDATA)>\n<!ELEMENT init-param (param-name, param-value, description?)>\n<!ELEMENT load-on-startup (#PCDATA)>\n<!ELEMENT servlet-mapping (servlet-name, url-pattern)>\n<!ELEMENT url-pattern (#PCDATA)>\n<!ELEMENT session-config (session-timeout?)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT mime-mapping (extension, mime-type)>\n<!ELEMENT extension (#PCDATA)>\n<!ELEMENT mime-type (#PCDATA)>\n<!ELEMENT welcome-file-list (welcome-file+)>\n<!ELEMENT welcome-file (#PCDATA)>\n<!ELEMENT taglib (taglib-uri, taglib-location)>\n<!ELEMENT taglib-uri (#PCDATA)>\n<!ELEMENT taglib-location (#PCDATA)>\n<!ELEMENT error-page ((error-code | exception-type), location)>\n<!ELEMENT error-code (#PCDATA)>\n<!ELEMENT exception-type (#PCDATA)>\n<!ELEMENT location (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT security-constraint (web-resource-collection+,\n auth-constraint?, user-data-constraint?)>\n<!ELEMENT web-resource-collection (web-resource-name, description?,\n url-pattern*, http-method*)>\n<!ELEMENT web-resource-name (#PCDATA)>\n<!ELEMENT http-method (#PCDATA)>\n<!ELEMENT user-data-constraint (description?, transport-guarantee)>\n<!ELEMENT transport-guarantee (#PCDATA)>\n<!ELEMENT auth-constraint (description?, role-name*)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT login-config (auth-method?, realm-name?, form-login-config?)>\n<!ELEMENT realm-name (#PCDATA)>\n<!ELEMENT form-login-config (form-login-page, form-error-page)>\n<!ELEMENT form-login-page (#PCDATA)>\n<!ELEMENT form-error-page (#PCDATA)>\n<!ELEMENT auth-method (#PCDATA)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-value?,\n env-entry-type)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home,\n   remote,ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n <!ELEMENT response-status (code, description)>\n <!ELEMENT code (#PCDATA)>\n]>";
    public static final String simpleDTD = "<!DOCTYPE web-app [\n<!ELEMENT web-app (icon?, display-name?, description?, distributable?,\n context-param*, filter*, filter-mapping*, listener*, servlet*, servlet-mapping*, session-config?, mime-mapping*,\n welcome-file-list?, error-page*, taglib*, resource-ref*, security-constraint*,\n login-config?, security-role*, env-entry*, ejb-ref*)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n <!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT distributable EMPTY>\n<!ELEMENT context-param (param-name, param-value, description?)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT filter (icon?, filter-name, display-name?, description?, filter-class, init-param*)>\n<!ELEMENT filter-name (#PCDATA)>\n<!ELEMENT filter-class (#PCDATA)>\n<!ELEMENT filter-mapping (filter-name, (url-pattern | servlet-name))>\n<!ELEMENT listener (listener-class)>\n<!ELEMENT listener-class (#PCDATA)>\n<!ELEMENT servlet (icon?, servlet-name, display-name?, description?,\n(servlet-class|jsp-file), init-param*, load-on-startup?, security-role-ref*)>\n<!ELEMENT servlet-name (#PCDATA)>\n<!ELEMENT servlet-class (#PCDATA)>\n<!ELEMENT jsp-file (#PCDATA)>\n<!ELEMENT init-param (param-name, param-value, description?)>\n<!ELEMENT load-on-startup (#PCDATA)>\n<!ELEMENT servlet-mapping (servlet-name, url-pattern)>\n<!ELEMENT url-pattern (#PCDATA)>\n<!ELEMENT session-config (session-timeout?)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT mime-mapping (extension, mime-type)>\n<!ELEMENT extension (#PCDATA)>\n<!ELEMENT mime-type (#PCDATA)>\n<!ELEMENT welcome-file-list (welcome-file+)>\n<!ELEMENT welcome-file (#PCDATA)>\n<!ELEMENT taglib (taglib-uri, taglib-location)>\n<!ELEMENT taglib-uri (#PCDATA)>\n<!ELEMENT taglib-location (#PCDATA)>\n<!ELEMENT error-page ((error-code | exception-type), location)>\n<!ELEMENT error-code (#PCDATA)>\n<!ELEMENT exception-type (#PCDATA)>\n<!ELEMENT location (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT security-constraint (web-resource-collection+,\n auth-constraint?, user-data-constraint?)>\n<!ELEMENT web-resource-collection (web-resource-name, description?,\n url-pattern*, http-method*)>\n<!ELEMENT web-resource-name (#PCDATA)>\n<!ELEMENT http-method (#PCDATA)>\n<!ELEMENT user-data-constraint (description?, transport-guarantee)>\n<!ELEMENT transport-guarantee (#PCDATA)>\n<!ELEMENT auth-constraint (description?, role-name*)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT login-config (auth-method?, realm-name?, form-login-config?)>\n<!ELEMENT realm-name (#PCDATA)>\n<!ELEMENT form-login-config (form-login-page, form-error-page)>\n<!ELEMENT form-login-page (#PCDATA)>\n<!ELEMENT form-error-page (#PCDATA)>\n<!ELEMENT auth-method (#PCDATA)>\n<!ELEMENT security-role (description?, role-name)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-value?,\n env-entry-type)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home,\n   remote,ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n]>";
    protected Document mainDocument;
    protected Vector securityRoles = new Vector();
    private Vector warnings = new Vector();

    public WebDeploymentDescriptor parseXml(BufferedInputStream xmlStream, String xmlName) throws BaseIOException, DeploymentException {
        Document document = null;
        try {
            StandardDOMParser domParser = new StandardDOMParser();
            domParser.setSystemId(xmlName);
            document = domParser.parse((InputStream)xmlStream);
            xmlStream.close();
        }
        catch (IOException ioe) {
            throw new BaseIOException("deploy_4404", new String[]{"web"}, (Throwable)ioe);
        }
        catch (SAXException sax) {
            throw new DeploymentException("deploy_4404", (Object[])new String[]{"web"}, (Throwable)sax);
        }
        return this.loadDescriptorFromDocument(document);
    }

    public WebDeploymentDescriptor loadDescriptorFromDocument(Document document) {
        Element elm = document.getDocumentElement();
        return this.loadDescriptorFromElement(elm);
    }

    public WebDeploymentDescriptor loadDescriptorFromElement(Element elmnt) {
        NodeList list = elmnt.getChildNodes();
        WebDeploymentDescriptor webDescriptor = new WebDeploymentDescriptor();
        Element element = null;
        String tag = null;
        webDescriptor.setDistributable(false);
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("description")) {
                    webDescriptor.setDescription(this.getTextValue(element));
                } else if (tag.equals("session-config")) {
                    webDescriptor.setSessionTimeout(this.initTimeOut(element));
                } else if (tag.equals("display-name")) {
                    webDescriptor.setDisplayName(this.getTextValue(element));
                } else if (tag.equals("small-icon")) {
                    webDescriptor.setSmallIcon(new SerializableFile(this.getTextValue(element)));
                } else if (tag.equals("large-icon")) {
                    webDescriptor.setLargeIcon(new SerializableFile(this.getTextValue(element)));
                } else if (tag.equals("distributable")) {
                    webDescriptor.setDistributable(true);
                } else if (tag.equals("context-param")) {
                    webDescriptor.addContextParam(this.initParams(element));
                } else if (tag.equals("servlet")) {
                    webDescriptor.addServlet(this.initServlets(element));
                } else if (tag.equals("servlet-mapping")) {
                    webDescriptor.addServletMapping(this.initServletMappings(element));
                } else if (tag.equals("mime-mapping")) {
                    webDescriptor.addMIMEMapping(this.initMIMEMapping(element));
                } else if (tag.equals("welcome-file-list")) {
                    webDescriptor.setWelcomeFileList(this.initWelcomeFiles(element));
                } else if (tag.equals("taglib")) {
                    webDescriptor.addTagLib(this.initTagLibs(element));
                } else if (tag.equals("error-page")) {
                    webDescriptor.addErrorPage(this.initErrorPages(element));
                } else if (tag.equals("resource-ref")) {
                    webDescriptor.addResReference(this.initResourceReferences(element));
                } else if (tag.equals("ejb-ref")) {
                    webDescriptor.addEjbRef(this.initEJBRefs(element));
                } else if (tag.equals("env-entry")) {
                    webDescriptor.addEnvEntry(this.initEnvEntries(element));
                } else if (tag.equals("login-config")) {
                    webDescriptor.setLoginConfig(this.initLoginConfig(element));
                } else if (tag.equals("security-role")) {
                    webDescriptor.addSecRole(this.getSecurityRoles(element, "security-role"));
                } else if (tag.equals("security-constraint")) {
                    webDescriptor.addSecConstraint(this.initSecurityConstraints(element));
                } else if (tag.equals("filter")) {
                    webDescriptor.addFilter(this.initFilter(element));
                } else if (tag.equals("filter-mapping")) {
                    webDescriptor.addFilterMapping(this.initFilterMapping(element));
                } else if (tag.equals("listener")) {
                    webDescriptor.addListener(this.initListener(element));
                } else if (tag.equals("response-status")) {
                    this.initResponseStatus(element, webDescriptor);
                }
            }
            ++i;
        }
        return webDescriptor;
    }

    protected ResourceReference initResourceReferences(Element elmnt) {
        NodeList refsList = elmnt.getChildNodes();
        if (refsList != null) {
            Element refEl = null;
            ResourceReference resRef = new ResourceReference();
            String nextElTag = null;
            String value = null;
            int i = 0;
            while (i < refsList.getLength()) {
                if (refsList.item(i).getNodeType() == 1) {
                    String link;
                    refEl = (Element)refsList.item(i);
                    nextElTag = refEl.getNodeName();
                    if (nextElTag.equals("description")) {
                        value = this.getTextValue(refEl);
                        resRef.setResourceDescription(value);
                    } else if (nextElTag.equals("res-ref-name")) {
                        value = this.getTextValue(refEl);
                        resRef.setResourceName(value);
                    } else if (nextElTag.equals("res-type")) {
                        value = this.getTextValue(refEl);
                        resRef.setResourceType(value);
                    } else if (nextElTag.equals("res-auth")) {
                        value = this.getTextValue(refEl);
                        if (value == null) {
                            resRef.setResourceAuthorization(1);
                        } else if (value.equalsIgnoreCase("SERVLET")) {
                            resRef.setResourceAuthorization(1);
                        } else if (value.equalsIgnoreCase("CONTAINER")) {
                            resRef.setResourceAuthorization(2);
                        }
                    } else if (nextElTag.equals("res-link") && (link = this.getTextValue(refEl)) != null && !link.equals("")) {
                        resRef.setResourceLink(link);
                    }
                }
                ++i;
            }
            return resRef;
        }
        return null;
    }

    protected ContextParam initParams(Element el) {
        NodeList paramsList = el.getChildNodes();
        ContextParam cParam = new ContextParam();
        String nextElTag = null;
        String value = null;
        Element paramEl = null;
        if (paramsList == null) {
            return null;
        }
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i) instanceof Element) {
                paramEl = (Element)paramsList.item(i);
                nextElTag = paramEl.getNodeName();
                if (nextElTag.equals("param-name")) {
                    value = this.getTextValue(paramEl);
                    cParam.setParamName(value);
                } else if (nextElTag.equals("param-value")) {
                    value = this.getTextValue(paramEl);
                    cParam.setParamValue(value);
                } else if (nextElTag.equals("description")) {
                    value = this.getTextValue(paramEl);
                    cParam.setDescription(value);
                }
            }
            ++i;
        }
        if (cParam != null) {
            return cParam;
        }
        return null;
    }

    protected int initTimeOut(Element el) {
        NodeList list = el.getChildNodes();
        Element nextEl = null;
        String nextElTag = "";
        String value = "";
        int timeout = 0;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1 && (nextElTag = (nextEl = (Element)list.item(i)).getNodeName()).equals("session-timeout")) {
                value = this.getTextValue(nextEl);
                timeout = new Integer(value);
            }
            ++i;
        }
        return timeout;
    }

    protected SecurityRoles getSecurityRoles(Element el, String tagName) {
        NodeList rolesList = el.getChildNodes();
        Element rolesEl = null;
        SecurityRoles roles = new SecurityRoles();
        String nextElTag = null;
        String value = null;
        int i = 0;
        while (i < rolesList.getLength()) {
            if (rolesList.item(i).getNodeType() == 1) {
                String userGroup;
                rolesEl = (Element)rolesList.item(i);
                nextElTag = rolesEl.getNodeName();
                if (nextElTag.equals("description")) {
                    value = this.getTextValue(rolesEl);
                    roles.setRoleDescription(value);
                } else if (nextElTag.equals("role-name")) {
                    value = this.getTextValue(rolesEl);
                    roles.setRoleName(value);
                } else if (nextElTag.equals("group-id")) {
                    String groupSID = this.getTextValue(rolesEl);
                    if (!groupSID.equals("")) {
                        roles.setGroupSIDsElement(new Integer(groupSID).intValue());
                    }
                } else if (nextElTag.equals("user-id")) {
                    String userSID = this.getTextValue(rolesEl);
                    if (!userSID.equals("")) {
                        roles.setUserSIDsElement(new Integer(userSID).intValue());
                    }
                } else if (nextElTag.equals("user-name")) {
                    String userName = this.getTextValue(rolesEl);
                    if (userName != null && !userName.equals("")) {
                        roles.setUserName(userName);
                    }
                } else if (nextElTag.equals("group-name") && (userGroup = this.getTextValue(rolesEl)) != null && !userGroup.equals("")) {
                    roles.setUserGroup(userGroup);
                }
            }
            ++i;
        }
        return roles;
    }

    protected SecurityRoleReference getSecurityRoleReference(Element el, String tagName) {
        NodeList rolesList = el.getChildNodes();
        Element rolesEl = null;
        SecurityRoleReference roleRef = new SecurityRoleReference();
        String nextElTag = null;
        String value = null;
        int i = 0;
        while (i < rolesList.getLength()) {
            if (rolesList.item(i).getNodeType() == 1) {
                rolesEl = (Element)rolesList.item(i);
                nextElTag = rolesEl.getNodeName();
                if (nextElTag.equals("description")) {
                    value = this.getTextValue(rolesEl);
                    roleRef.setDescription(value);
                } else if (nextElTag.equals("role-name")) {
                    value = this.getTextValue(rolesEl);
                    roleRef.setRoleName(value);
                } else if (nextElTag.equals("role-link")) {
                    value = this.getTextValue(rolesEl);
                    roleRef.setRoleLink(new SecurityRoles(value));
                }
            }
            ++i;
        }
        return roleRef;
    }

    protected String[] getSecurityRoleNames(Element elmnt) {
        NodeList roleNamesList = elmnt.getChildNodes();
        Vector<String> namesVector = null;
        if (roleNamesList != null) {
            namesVector = new Vector<String>();
            Element roleEl = null;
            String roleElTag = null;
            String name = null;
            int i = 0;
            while (i < roleNamesList.getLength()) {
                if (roleNamesList.item(i).getNodeType() == 1 && (roleElTag = (roleEl = (Element)roleNamesList.item(i)).getNodeName()).equals("role-name")) {
                    name = this.getTextValue(roleEl);
                    namesVector.add(name);
                }
                ++i;
            }
        }
        if (namesVector.size() > 0) {
            Object[] values = new String[namesVector.size()];
            namesVector.copyInto(values);
            return values;
        }
        return null;
    }

    protected LoginConfig initLoginConfig(Element el) {
        NodeList paramsList = el.getChildNodes();
        LoginConfig loginConfig = new LoginConfig();
        String nextElTag = null;
        String value = null;
        Element loginEl = null;
        if (paramsList == null) {
            return null;
        }
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                loginEl = (Element)paramsList.item(i);
                nextElTag = loginEl.getNodeName();
                if (nextElTag.equals("form-login-config")) {
                    loginConfig.setFormLogin(this.initFormConfig(loginEl));
                } else if (nextElTag.equals("realm-name")) {
                    value = this.getTextValue(loginEl);
                    loginConfig.setRealmName(value);
                } else if (nextElTag.equals("auth-method")) {
                    value = this.getTextValue(loginEl);
                    loginConfig.setAuthMethod(value);
                }
            }
            ++i;
        }
        if (loginConfig != null) {
            return loginConfig;
        }
        return null;
    }

    protected FormLoginConfig initFormConfig(Element el) {
        NodeList paramsList = el.getChildNodes();
        FormLoginConfig fLogin = new FormLoginConfig();
        String nextElTag = null;
        String value = null;
        Element loginEl = null;
        if (paramsList == null) {
            return null;
        }
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i) instanceof Element) {
                loginEl = (Element)paramsList.item(i);
                nextElTag = loginEl.getNodeName();
                if (nextElTag.equals("form-login-page")) {
                    value = this.getTextValue(loginEl);
                    if (value != null) {
                        fLogin.setLoginPage(value);
                    } else {
                        fLogin.setLoginPage(null);
                    }
                } else if (nextElTag.equals("form-error-page")) {
                    value = this.getTextValue(loginEl);
                    if (value != null) {
                        fLogin.setErrorPage(value);
                    } else {
                        fLogin.setErrorPage(null);
                    }
                }
            }
            ++i;
        }
        if (fLogin != null) {
            if (fLogin.getLoginPage() == null && fLogin.getErrorPage() == null) {
                return null;
            }
            return fLogin;
        }
        return null;
    }

    protected SecurityConstraints initSecurityConstraints(Element el) {
        NodeList paramsList = el.getChildNodes();
        Vector<WebResourceCollection> webCollections = new Vector<WebResourceCollection>();
        Object[] collection = null;
        SecurityConstraints secConstr = new SecurityConstraints();
        String nextElTag = null;
        Element secEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                secEl = (Element)paramsList.item(i);
                nextElTag = secEl.getNodeName();
                if (nextElTag.equals("web-resource-collection")) {
                    webCollections.addElement(this.initWebCollection(secEl));
                } else if (nextElTag.equals("auth-constraint")) {
                    secConstr.setAuthorityConstraints(this.initAuthConstraints(secEl));
                } else if (nextElTag.equals("user-data-constraint")) {
                    secConstr.setUserDataConstraints(this.initUserDataConstraints(secEl));
                }
                collection = new WebResourceCollection[webCollections.size()];
                webCollections.copyInto(collection);
                secConstr.setWebCollections((WebResourceCollection[])collection);
            }
            ++i;
        }
        return secConstr;
    }

    protected WebResourceCollection initWebCollection(Element el) {
        NodeList paramsList = el.getChildNodes();
        WebResourceCollection webCollection = null;
        Object[] urls = null;
        Vector<String> urlPatterns = new Vector<String>();
        Vector<String> httpMethods = new Vector<String>();
        Object[] methods = null;
        Element nextEl = null;
        String nextElTag = null;
        String value = null;
        if (paramsList != null) {
            webCollection = new WebResourceCollection();
            int i = 0;
            while (i < paramsList.getLength()) {
                if (paramsList.item(i).getNodeType() == 1) {
                    nextEl = (Element)paramsList.item(i);
                    nextElTag = nextEl.getNodeName();
                    if (nextElTag.equals("web-resource-name")) {
                        value = this.getTextValue(nextEl);
                        webCollection.setWebResourceName(value);
                    } else if (nextElTag.equals("description")) {
                        value = this.getTextValue(nextEl);
                        webCollection.setDescription(value);
                    } else if (nextElTag.equals("url-pattern")) {
                        value = this.getTextValue(nextEl);
                        urlPatterns.addElement(value);
                    } else if (nextElTag.equals("http-method")) {
                        value = this.getTextValue(nextEl);
                        httpMethods.addElement(value);
                    }
                }
                ++i;
            }
            methods = new String[httpMethods.size()];
            httpMethods.copyInto(methods);
            urls = new String[urlPatterns.size()];
            urlPatterns.copyInto(urls);
            webCollection.setHttpMethod((String[])methods);
            webCollection.setUrlPattern((String[])urls);
        }
        return webCollection;
    }

    protected AuthConstraints initAuthConstraints(Element el) {
        NodeList params = el.getChildNodes();
        AuthConstraints auth = new AuthConstraints();
        Element authEl = null;
        String nextElTag = null;
        String value = "";
        Vector<String> roles = new Vector<String>();
        Object[] roleNames = null;
        int i = 0;
        while (i < params.getLength()) {
            if (params.item(i).getNodeType() == 1) {
                authEl = (Element)params.item(i);
                nextElTag = authEl.getNodeName();
                if (nextElTag.equals("description")) {
                    value = this.getTextValue(authEl);
                    auth.setDescription(value);
                } else if (nextElTag.equals("role-name")) {
                    value = this.getTextValue(authEl);
                    roles.addElement(value);
                }
            }
            ++i;
        }
        if (roles.size() > 0) {
            roleNames = new String[roles.size()];
            roles.copyInto(roleNames);
            auth.setRoleName((String[])roleNames);
        }
        if (auth != null) {
            return auth;
        }
        return null;
    }

    protected UserDataConstraints initUserDataConstraints(Element el) {
        NodeList params = el.getChildNodes();
        UserDataConstraints user = new UserDataConstraints();
        Element nextEl = null;
        String nextElTag = null;
        String value = "";
        int i = 0;
        while (i < params.getLength()) {
            if (params.item(i).getNodeType() == 1) {
                nextEl = (Element)params.item(i);
                nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("description")) {
                    value = this.getTextValue(nextEl);
                    user.setDescription(value);
                } else if (nextElTag.equals("transport-guarantee")) {
                    value = this.getTextValue(nextEl);
                    user.setTransport(value);
                }
            }
            ++i;
        }
        if (user != null) {
            return user;
        }
        return null;
    }

    protected ServletMapping initServletMappings(Element el) {
        ServletMapping mapping = new ServletMapping();
        String nextElTag = null;
        String value = null;
        Element servletEl = null;
        NodeList paramsList = el.getChildNodes();
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                servletEl = (Element)paramsList.item(i);
                nextElTag = servletEl.getNodeName();
                if (nextElTag.equals("servlet-name")) {
                    value = this.getTextValue(servletEl);
                    mapping.setServletName(value);
                } else if (nextElTag.equals("url-pattern")) {
                    value = this.getTextValue(servletEl);
                    mapping.setURLPattern(value);
                }
            }
            ++i;
        }
        return mapping;
    }

    protected ServletDescriptor initServlets(Element el) {
        NodeList paramsList = el.getChildNodes();
        Object[] valuesC = null;
        Vector<ContextParam> initParam = new Vector<ContextParam>();
        ServletDescriptor servlet = new ServletDescriptor();
        String nextElTag = null;
        String value = null;
        Element servletEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                servletEl = (Element)paramsList.item(i);
                nextElTag = servletEl.getNodeName();
                if (nextElTag.equals("servlet-name")) {
                    value = this.getTextValue(servletEl);
                    servlet.setServletName(value);
                } else if (nextElTag.equals("display-name")) {
                    value = this.getTextValue(servletEl);
                    servlet.setDisplayName(value);
                } else if (nextElTag.equals("description")) {
                    value = this.getTextValue(servletEl);
                    servlet.setDescription(value);
                } else if (nextElTag.equals("servlet-class")) {
                    value = this.getTextValue(servletEl);
                    if (value != null) {
                        value = value.replace('\\', '.');
                        value = value.replace('/', '.');
                    }
                    servlet.setServletClass(value);
                } else if (nextElTag.equals("jsp-file")) {
                    value = this.getTextValue(servletEl);
                    servlet.setJspFile(value);
                } else if (nextElTag.equals("init-param")) {
                    initParam.addElement(this.initParams(servletEl));
                } else if (nextElTag.equals("load-on-startup")) {
                    value = this.getTextValue(servletEl);
                    int load_on_startup = 0;
                    try {
                        load_on_startup = new Integer(value);
                    }
                    catch (NumberFormatException e) {
                        load_on_startup = 0;
                        this.warnings.add(new WarningException("deploy_4001", (Object[])new String[]{"load-on-startup", value}).getLocalizedMessage());
                    }
                    if (load_on_startup > 0) {
                        servlet.setLoadOnStartUp(load_on_startup);
                    } else {
                        servlet.setLoadOnStartUp(0);
                    }
                } else if (nextElTag.equals("security-role-ref")) {
                    servlet.setRoleReference(this.getSecurityRoleReference(servletEl, "sec-role-ref"));
                }
            }
            ++i;
        }
        if (initParam.size() > 0) {
            valuesC = new ContextParam[initParam.size()];
            initParam.copyInto(valuesC);
        }
        servlet.setInitParams(valuesC);
        return servlet;
    }

    protected MIMEMapping initMIMEMapping(Element el) {
        NodeList paramsList = el.getChildNodes();
        MIMEMapping map = new MIMEMapping();
        String nextElTag = null;
        String value = null;
        Element mapEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                mapEl = (Element)paramsList.item(i);
                nextElTag = mapEl.getNodeName();
                if (nextElTag.equals("extension")) {
                    value = this.getTextValue(mapEl);
                    map.setExtension(value);
                } else if (nextElTag.equals("mime-type")) {
                    value = this.getTextValue(mapEl);
                    map.setMIMEType(value);
                }
            }
            ++i;
        }
        return map;
    }

    protected String[] initWelcomeFiles(Element el) {
        NodeList paramsList = el.getElementsByTagName("welcome-file");
        Vector<String> files = new Vector<String>();
        Object[] file_list = null;
        Element nextEl = null;
        String value = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                nextEl = (Element)paramsList.item(i);
                value = this.getTextValue(nextEl);
                files.addElement(value);
            }
            ++i;
        }
        if (files.size() > 0) {
            file_list = new String[files.size()];
            files.copyInto(file_list);
            return file_list;
        }
        return null;
    }

    protected ErrorPage initErrorPages(Element el) {
        NodeList paramsList = el.getChildNodes();
        ErrorPage ePage = new ErrorPage();
        String nextElTag = null;
        String value = null;
        Element mapEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                mapEl = (Element)paramsList.item(i);
                nextElTag = mapEl.getNodeName();
                try {
                    if (nextElTag.equals("error-code")) {
                        value = this.getTextValue(mapEl);
                        ePage.setValue((Object)new Integer(value));
                        ePage.setType(ErrorPage.errorCode);
                    } else if (nextElTag.equals("exception-type")) {
                        value = this.getTextValue(mapEl);
                        ePage.setValue((Object)value);
                        ePage.setType(ErrorPage.exception_type);
                    } else if (nextElTag.equals("location")) {
                        value = this.getTextValue(mapEl);
                        if (!value.startsWith("/")) {
                            value = "/" + value;
                        }
                        ePage.setLocation(value);
                    }
                }
                catch (NumberFormatException exc) {
                    this.warnings.add(new WarningException("deploy_4001", (Object[])new String[]{"error-code", value}).getLocalizedMessage());
                }
            }
            ++i;
        }
        return ePage;
    }

    protected TagLib initTagLibs(Element el) {
        NodeList paramsList = el.getChildNodes();
        TagLib tag = new TagLib();
        String nextElTag = null;
        String value = null;
        Element tagEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                tagEl = (Element)paramsList.item(i);
                nextElTag = tagEl.getNodeName();
                if (nextElTag.equals("taglib-uri")) {
                    value = this.getTextValue(tagEl);
                    tag.setUri(value);
                } else if (nextElTag.equals("taglib-location")) {
                    value = this.getTextValue(tagEl);
                    tag.setLocation(value);
                }
            }
            ++i;
        }
        return tag;
    }

    protected EnvironmentEntry initEnvEntries(Element el) {
        NodeList paramsList = el.getChildNodes();
        EnvironmentEntry entry = new EnvironmentEntry();
        String nextElTag = null;
        String value = null;
        Element mapEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                mapEl = (Element)paramsList.item(i);
                nextElTag = mapEl.getNodeName();
                if (nextElTag.equals("env-entry-name")) {
                    value = this.getTextValue(mapEl);
                    entry.setEntryName(value);
                } else if (nextElTag.equals("env-entry-type")) {
                    value = this.getTextValue(mapEl);
                    entry.setEntryType(value);
                } else if (nextElTag.equals("env-entry-value")) {
                    value = this.getTextValue(mapEl);
                    entry.setEntryValue((Object)value);
                } else if (nextElTag.equals("description")) {
                    value = this.getTextValue(mapEl);
                    entry.setEntryDescription(value);
                }
            }
            ++i;
        }
        return entry;
    }

    protected EJBeanReference initEJBRefs(Element el) {
        NodeList paramsList = el.getChildNodes();
        EJBeanReference ref = new EJBeanReference();
        String nextElTag = null;
        String value = null;
        Element refEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                refEl = (Element)paramsList.item(i);
                nextElTag = refEl.getNodeName();
                if (nextElTag.equals("ejb-ref-name")) {
                    value = this.getTextValue(refEl);
                    ref.setReferenceName(value);
                } else if (nextElTag.equals("ejb-ref-type")) {
                    value = this.getTextValue(refEl);
                    if (value != null) {
                        if (value.equalsIgnoreCase("Entity")) {
                            ref.setType(1);
                        } else {
                            ref.setType(0);
                        }
                    } else {
                        ref.setType(0);
                    }
                } else if (nextElTag.equals("home")) {
                    value = this.getTextValue(refEl);
                    ref.setHomeInterfaceName(value);
                } else if (nextElTag.equals("remote")) {
                    value = this.getTextValue(refEl);
                    ref.setRemoteInterfaceName(value);
                } else if (nextElTag.equals("ejb-link")) {
                    value = this.getTextValue(refEl);
                    ref.setReferenceEjbLink(value);
                } else if (nextElTag.equals("description")) {
                    value = this.getTextValue(refEl);
                    ref.setReferenceDescription(value);
                }
            }
            ++i;
        }
        return ref;
    }

    protected String getTextValue(Element element) {
        Node node;
        if (element != null && (node = element.getFirstChild()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String obj = node.getNodeValue();
            if (obj == null) {
                return null;
            }
            String value = obj;
            if (value.trim().equals("")) {
                return null;
            }
            return value.trim();
        }
        return null;
    }

    private Element getFirstElement(Element parent) {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                return (Element)list.item(i);
            }
            ++i;
        }
        return null;
    }

    private Element getLastElement(Element parent) {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return null;
        }
        int i = list.getLength() - 1;
        while (i >= 0) {
            if (list.item(i) instanceof Element) {
                return (Element)list.item(i);
            }
            --i;
        }
        return null;
    }

    protected FilterDescriptor initFilter(Element el) {
        NodeList paramsList = el.getChildNodes();
        Object[] valuesC = null;
        Vector<ContextParam> initParam = new Vector<ContextParam>();
        FilterDescriptor filter = new FilterDescriptor();
        String nextElTag = null;
        String value = null;
        Element filterEl = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                filterEl = (Element)paramsList.item(i);
                nextElTag = filterEl.getNodeName();
                if (nextElTag.equals("filter-name")) {
                    value = this.getTextValue(filterEl);
                    filter.setName(value);
                } else if (nextElTag.equals("display-name")) {
                    value = this.getTextValue(filterEl);
                    filter.setDisplayName(value);
                } else if (nextElTag.equals("description")) {
                    value = this.getTextValue(filterEl);
                    filter.setDescription(value);
                } else if (nextElTag.equals("filter-class")) {
                    value = this.getTextValue(filterEl);
                    filter.setFilterClass(value);
                } else if (nextElTag.equals("init-param")) {
                    initParam.addElement(this.initParams(filterEl));
                }
            }
            ++i;
        }
        if (initParam.size() > 0) {
            valuesC = new ContextParam[initParam.size()];
            initParam.copyInto(valuesC);
        }
        filter.setInitParams(valuesC);
        return filter;
    }

    protected FilterMapping initFilterMapping(Element el) {
        FilterMapping filterMap = new FilterMapping();
        String nextElTag = null;
        String value = null;
        Element filterEl = null;
        NodeList paramsList = el.getChildNodes();
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                filterEl = (Element)paramsList.item(i);
                nextElTag = filterEl.getNodeName();
                if (nextElTag.equals("filter-name")) {
                    value = this.getTextValue(filterEl);
                    filterMap.setFilterName(value);
                } else if (nextElTag.equals("url-pattern")) {
                    value = this.getTextValue(filterEl);
                    filterMap.setURLPattern(value);
                } else if (nextElTag.equals("servlet-name")) {
                    value = this.getTextValue(filterEl);
                    filterMap.setServletName(value);
                }
            }
            ++i;
        }
        return filterMap;
    }

    protected String initListener(Element el) {
        String nextElTag = null;
        String value = null;
        Element filterEl = null;
        NodeList paramsList = el.getChildNodes();
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1 && (nextElTag = (filterEl = (Element)paramsList.item(i)).getNodeName()).equals("listener-class")) {
                value = this.getTextValue(filterEl);
                return value;
            }
            ++i;
        }
        return null;
    }

    private void initResponseStatus(Element respStatusEl, WebDeploymentDescriptor descr) {
        Element element = null;
        String tag = null;
        int code = -1;
        String description = null;
        NodeList list = respStatusEl.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("code")) {
                    try {
                        code = Integer.parseInt(this.getTextValue(element));
                    }
                    catch (NumberFormatException nme) {
                        this.warnings.add(new WarningException("deploy_4001", (Object[])new String[]{"code", this.getTextValue(element)}).getLocalizedMessage());
                    }
                }
                if (tag.equals("description")) {
                    description = this.getTextValue(element);
                }
                if (code != -1 && description != null) {
                    descr.addResponseStatus(code, description);
                }
            }
            ++i;
        }
    }

    public Vector getWarnings() {
        return this.warnings;
    }
}

