/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.converter;

import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.FieldEntry;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.deploy.exceptions.BaseWrongStructureException;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EJBDescriptorDocument {
    protected Document mainDocument;
    protected Element docElement;
    protected Element beans;
    protected ClassLoader loader;
    public static final String APPLICATION_AUTHORIZATION = "Application";
    public static final String BEAN_PERSISTENT = "Bean";
    public static final String CONTAINER_PERSISTENT = "Container";
    public static final String STATEFUL_SESSION = "Stateful";
    public static final String STATELESS_SESSION = "Stateless";
    public static final String BEAN_TRANSACTION = "Bean";
    public static final String CONTAINER_TRANSACTION = "Container";
    private Vector warnings = new Vector();

    public void setLoader(ClassLoader _loader) {
        this.loader = _loader;
    }

    public DeploymentDescriptor loadDescriptor(Element beanEl) throws BaseWrongStructureException {
        if (beanEl.getTagName().equals("entity")) {
            return this.loadEntityDescriptor(beanEl);
        }
        if (beanEl.getTagName().equals("session")) {
            return this.loadSessionDescriptor(beanEl);
        }
        throw new BaseWrongStructureException("deploy_4102", new String[]{"entity | session", beanEl.getTagName()});
    }

    public EntityDescriptor loadEntityDescriptor(Element element) throws BaseWrongStructureException {
        if (!element.getNodeName().equals("entity")) {
            throw new BaseWrongStructureException("deploy_4102", new String[]{"entity", element.getNodeName()});
        }
        EntityDescriptor descriptor = null;
        NodeList persistence = element.getElementsByTagName("persistence-type");
        String value = this.getTextValue((Element)persistence.item(0));
        if (value.equals("Bean")) {
            descriptor = new EntityDescriptor();
            descriptor.setPersistenceType(0);
        } else if (value.equals("Container")) {
            descriptor = new CMPEntityDescriptor();
            descriptor.setPersistenceType(1);
            ((CMPEntityDescriptor)descriptor).setCmpVersion(1);
        }
        NodeList list = element.getChildNodes();
        if (list != null) {
            Vector<FieldEntry> cmpFields = new Vector<FieldEntry>();
            Vector<EnvironmentEntry> envEntries = new Vector<EnvironmentEntry>();
            Vector<EJBeanReference> ejbRefs = new Vector<EJBeanReference>();
            Vector<SecurityRoleReference> roleRef = new Vector<SecurityRoleReference>();
            Vector<ResourceReference> resRefs = new Vector<ResourceReference>();
            String ejbClass = "";
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 1) {
                    Element el = (Element)list.item(i);
                    String tag = el.getNodeName();
                    Element parent = (Element)el.getParentNode();
                    String parentTag = parent.getNodeName();
                    if (tag.equals("description") && parentTag.equals("entity")) {
                        value = this.getTextValue(el);
                        if (!value.equals("")) {
                            descriptor.setDescription(value);
                        }
                    } else if (tag.equals("display-name")) {
                        value = this.getTextValue(el);
                        if (!value.equals("")) {
                            descriptor.setDisplayName(value);
                        }
                    } else if (tag.equals("small-icon")) {
                        value = this.getTextValue(el);
                        if (!value.equals("")) {
                            String smallIconPr = this.processString(value, false);
                            descriptor.setSmallIcon(smallIconPr);
                        }
                    } else if (tag.equals("large-icon")) {
                        value = this.getTextValue(el);
                        if (!value.equals("")) {
                            String largeIconPr = this.processString(value, false);
                            descriptor.setLargeIcon(largeIconPr);
                        }
                    } else if (tag.equals("ejb-name")) {
                        value = this.getTextValue(el);
                        if (!value.equals("")) {
                            descriptor.setBeanName(value);
                        }
                    } else if (tag.equals("home") && parentTag.equals("entity")) {
                        value = this.getTextValue(el);
                        if (!value.equals("")) {
                            descriptor.setRemoteHomeInterface(value);
                        }
                    } else if (tag.equals("remote") && parentTag.equals("entity")) {
                        value = this.getTextValue(el);
                        if (!value.equals("")) {
                            descriptor.setRemoteInterface(value);
                        }
                    } else if (tag.equals("ejb-class")) {
                        ejbClass = this.getTextValue(el);
                        if (!ejbClass.equals("")) {
                            descriptor.setClassName(ejbClass);
                        }
                    } else if (tag.equals("prim-key-class")) {
                        value = this.getTextValue(el);
                        if (!value.equals("")) {
                            descriptor.setPrimaryKeyClass(value);
                        }
                    } else if (tag.equals("bean-count")) {
                        value = this.getTextValue(el);
                        if (value != null && !value.equals("")) {
                            try {
                                descriptor.setContainerSize(Integer.parseInt(value));
                            }
                            catch (NumberFormatException e) {
                                this.warnings.add(new WarningException("deploy_4001", (Object[])new String[]{"bean-count", value}).getLocalizedMessage());
                            }
                        }
                    } else if (tag.equals("reentrant")) {
                        value = this.getTextValue(el);
                        if (value.equalsIgnoreCase("true")) {
                            descriptor.setReentrant(true);
                        } else if (value.equalsIgnoreCase("false")) {
                            descriptor.setReentrant(false);
                        }
                    } else if (tag.equals("cmp-field")) {
                        FieldEntry field = this.getCMPField(el, ejbClass);
                        if (field != null && field.getName() != null) {
                            cmpFields.addElement(field);
                        }
                    } else if (tag.equals("primkey-field")) {
                        String primkeyField = this.getTextValue(el);
                        if (!primkeyField.equals("")) {
                            ((CMPEntityDescriptor)descriptor).setPKFieldName(primkeyField);
                        }
                    } else if (tag.equals("env-entry")) {
                        EnvironmentEntry envEntry = this.getEnvEntry(el);
                        if (envEntry != null) {
                            envEntries.addElement(envEntry);
                        }
                    } else if (tag.equals("ejb-ref")) {
                        EJBeanReference ejbRef = this.getEjbRef(el);
                        if (ejbRef != null) {
                            ejbRefs.addElement(ejbRef);
                        }
                    } else if (tag.equals("security-role-ref")) {
                        SecurityRoleReference roleReference = this.getSecurityRefs(el);
                        if (roleReference != null) {
                            roleRef.addElement(roleReference);
                        }
                    } else if (tag.equals("resource-ref")) {
                        ResourceReference resRef = this.getResourceRef(el);
                        if (resRef != null) {
                            resRefs.addElement(resRef);
                        }
                    } else if (!tag.equals("persistence-type") && !tag.equals("with-cache")) {
                        throw new BaseWrongStructureException("deploy_4103", new String[]{tag});
                    }
                }
                ++i;
            }
            if (cmpFields.size() != 0) {
                PersistentField[] fieldEntries = new PersistentField[cmpFields.size()];
                FieldEntry entry1 = null;
                int i2 = 0;
                while (i2 < cmpFields.size()) {
                    entry1 = (FieldEntry)cmpFields.elementAt(i2);
                    fieldEntries[i2] = new PersistentField();
                    fieldEntries[i2].setFieldName(entry1.getName());
                    fieldEntries[i2].setFieldType(entry1.getField() != null ? entry1.getField().getType().getName() : null);
                    fieldEntries[i2].setDescription(entry1.getDescription());
                    ++i2;
                }
                ((CMPEntityDescriptor)descriptor).setCmpFields(fieldEntries);
            }
            if (envEntries.size() != 0) {
                Object[] entries = new EnvironmentEntry[envEntries.size()];
                envEntries.copyInto(entries);
                descriptor.setEnvironmentEntries((EnvironmentEntry[])entries);
            }
            if (ejbRefs.size() != 0) {
                Object[] EJBeanRefs = new EJBeanReference[ejbRefs.size()];
                ejbRefs.copyInto(EJBeanRefs);
                descriptor.setEJBeanReferences((EJBeanReference[])EJBeanRefs);
            }
            if (roleRef.size() != 0) {
                Hashtable<String, Object> references = new Hashtable<String, Object>();
                Object[] refs = new SecurityRoleReference[roleRef.size()];
                roleRef.copyInto(refs);
                int i3 = 0;
                while (i3 < refs.length) {
                    references.put(refs[i3].getRoleName(), refs[i3]);
                    ++i3;
                }
                descriptor.setRoleReferences(references);
            }
            if (resRefs.size() != 0) {
                Object[] resourceRefs = new ResourceReference[resRefs.size()];
                resRefs.copyInto(resourceRefs);
                descriptor.setResourceReferences((ResourceReference[])resourceRefs);
            }
        }
        return descriptor;
    }

    protected String getTextValue(Element element) {
        if (element == null) {
            return new String();
        }
        Node node = element.getFirstChild();
        if (node != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String value = node.getNodeValue();
            return value.trim();
        }
        return new String("");
    }

    protected FieldEntry getCMPField(Element elmnt, String className) {
        NodeList nameList;
        Element descrElement;
        String description;
        NodeList descriptionList = elmnt.getElementsByTagName("description");
        FieldEntry fieldEntry = new FieldEntry();
        if (descriptionList != null && !(description = this.getTextValue(descrElement = (Element)descriptionList.item(0))).equals("")) {
            fieldEntry.setDescription(description);
        }
        if ((nameList = elmnt.getElementsByTagName("field-name")) != null) {
            Element fieldElement = (Element)nameList.item(0);
            String fieldName = this.getTextValue(fieldElement);
            if (!fieldName.equals("")) {
                fieldEntry.setName(fieldName);
                try {
                    Field currentField;
                    Class<?> cl = this.loader != null ? this.loader.loadClass(className) : Class.forName(className);
                    try {
                        currentField = cl.getField(fieldName);
                    }
                    catch (NoSuchFieldException ex) {
                        this.warnings.add(new WarningException("deploy_4003", (Object[])new String[]{fieldName, className}, (Exception)ex).getLocalizedMessage());
                        return null;
                    }
                    if (currentField != null) {
                        fieldEntry.setField(currentField);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.warnings.add(new WarningException("deploy_4002", (Object[])new String[]{className}, (Exception)e).getLocalizedMessage());
                }
                catch (NoClassDefFoundError ex) {
                    this.warnings.add(new WarningException("deploy_4002", (Object[])new String[]{className}, (Throwable)ex).getLocalizedMessage());
                }
            }
            return fieldEntry;
        }
        return null;
    }

    protected EnvironmentEntry getEnvEntry(Element elmnt) {
        NodeList entryList = elmnt.getChildNodes();
        if (entryList != null) {
            EnvironmentEntry envEntry = new EnvironmentEntry();
            String entryType = new String("");
            int k = 0;
            while (k < entryList.getLength()) {
                if (entryList.item(k).getNodeType() == 1) {
                    String entryValueStr;
                    Element envEl = (Element)entryList.item(k);
                    String envTag = envEl.getNodeName();
                    if (envTag.equals("description")) {
                        String description = this.getTextValue(envEl);
                        if (!description.equals("")) {
                            envEntry.setEntryDescription(description);
                        }
                    } else if (envTag.equals("env-entry-name")) {
                        String entryName = this.getTextValue(envEl);
                        if (!entryName.equals("")) {
                            envEntry.setEntryName(entryName);
                        }
                    } else if (envTag.equals("env-entry-type")) {
                        entryType = this.getTextValue(envEl);
                        if (!entryType.equals("")) {
                            envEntry.setEntryType(entryType);
                        }
                    } else if (envTag.equals("env-entry-value") && !(entryValueStr = this.getTextValue(envEl)).equals("")) {
                        Object entryValue;
                        if (entryType.equals("java.lang.Double")) {
                            entryValue = new Double(entryValueStr);
                            envEntry.setEntryValue(entryValue);
                        }
                        if (entryType.equals("java.lang.Integer")) {
                            entryValue = new Integer(entryValueStr);
                            envEntry.setEntryValue(entryValue);
                        }
                        if (entryType.equals("java.lang.Boolean")) {
                            entryValue = new Boolean(entryValueStr);
                            envEntry.setEntryValue(entryValue);
                        }
                        if (entryType.equals("java.lang.Float")) {
                            entryValue = new Float(entryValueStr);
                            envEntry.setEntryValue(entryValue);
                        }
                        if (entryType.equals("java.lang.String")) {
                            entryValue = entryValueStr;
                            envEntry.setEntryValue(entryValue);
                        }
                    }
                }
                ++k;
            }
            return envEntry;
        }
        return null;
    }

    protected EJBeanReference getEjbRef(Element elmnt) {
        NodeList refsList = elmnt.getChildNodes();
        if (refsList != null) {
            EJBeanReference ejbRef = new EJBeanReference();
            int k = 0;
            while (k < refsList.getLength()) {
                if (refsList.item(k).getNodeType() == 1) {
                    Element nextEl = (Element)refsList.item(k);
                    String nextElTag = nextEl.getNodeName();
                    String value = null;
                    if (nextElTag.equals("description")) {
                        value = this.getTextValue(nextEl);
                        if (!value.equals("")) {
                            ejbRef.setReferenceDescription(value);
                        }
                    } else if (nextElTag.equals("ejb-ref-name")) {
                        value = this.getTextValue(nextEl);
                        if (!value.equals("")) {
                            ejbRef.setReferenceName(value);
                        }
                    } else if (nextElTag.equals("ejb-ref-type")) {
                        value = this.getTextValue(nextEl);
                        if (value.equals("Entity")) {
                            ejbRef.setType(1);
                        } else if (value.equals("Session")) {
                            ejbRef.setType(0);
                        }
                    } else if (nextElTag.equals("home")) {
                        value = this.getTextValue(nextEl);
                        if (!value.equals("")) {
                            ejbRef.setHomeInterfaceName(value);
                        }
                    } else if (nextElTag.equals("remote")) {
                        value = this.getTextValue(nextEl);
                        if (!value.equals("")) {
                            ejbRef.setRemoteInterfaceName(value);
                        }
                    } else if (nextElTag.equals("ejb-link") && !(value = this.getTextValue(nextEl)).equals("")) {
                        ejbRef.setReferenceEjbLink(value);
                    }
                }
                ++k;
            }
            return ejbRef;
        }
        return null;
    }

    protected SecurityRoleReference getSecurityRefs(Element elmnt) {
        NodeList secList = elmnt.getChildNodes();
        if (secList != null) {
            SecurityRoleReference reference = new SecurityRoleReference();
            int k = 0;
            while (k < secList.getLength()) {
                if (secList.item(k).getNodeType() == 1) {
                    String roleLink;
                    Element nextEl = (Element)secList.item(k);
                    String nextElTag = nextEl.getNodeName();
                    if (nextElTag.equals("description")) {
                        String description = this.getTextValue(nextEl);
                        if (!description.equals("")) {
                            reference.setDescription(description);
                        }
                    } else if (nextElTag.equals("role-name")) {
                        String roleName = this.getTextValue(nextEl);
                        if (!roleName.equals("")) {
                            reference.setRoleName(roleName);
                        }
                    } else if (nextElTag.equals("role-link") && !(roleLink = this.getTextValue(nextEl)).equals("")) {
                        reference.setRoleLink(new SecurityRoles(roleLink));
                    }
                }
                ++k;
            }
            return reference;
        }
        return null;
    }

    protected ResourceReference getResourceRef(Element elmnt) {
        NodeList resList = elmnt.getChildNodes();
        if (resList != null) {
            ResourceReference resRef = new ResourceReference();
            int k = 0;
            while (k < resList.getLength()) {
                if (resList.item(k).getNodeType() == 1) {
                    String link;
                    Element nextEl = (Element)resList.item(k);
                    String nextElTag = nextEl.getNodeName();
                    if (nextElTag.equals("description")) {
                        String description = this.getTextValue(nextEl);
                        if (!description.equals("")) {
                            resRef.setResourceDescription(description);
                        }
                    } else if (nextElTag.equals("res-ref-name")) {
                        String name = this.getTextValue(nextEl);
                        if (!name.equals("")) {
                            resRef.setResourceName(name);
                        }
                    } else if (nextElTag.equals("res-type")) {
                        String type = this.getTextValue(nextEl);
                        if (!type.equals("")) {
                            resRef.setResourceType(type);
                        }
                    } else if (nextElTag.equals("res-auth")) {
                        String authStr = this.getTextValue(nextEl);
                        if (authStr.equals("Bean") || authStr.equals(APPLICATION_AUTHORIZATION)) {
                            resRef.setResourceAuthorization(3);
                        } else if (authStr.equals("Container")) {
                            resRef.setResourceAuthorization(2);
                        }
                    } else if (nextElTag.equals("res-link") && !(link = this.getTextValue(nextEl)).equals("")) {
                        resRef.setResourceLink(link);
                    }
                }
                ++k;
            }
            return resRef;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SessionDescriptor loadSessionDescriptor(Element element) throws BaseWrongStructureException {
        if (!element.getNodeName().equals("session")) {
            throw new BaseWrongStructureException("deploy_4102", new String[]{"session", element.getNodeName()});
        }
        SessionDescriptor descriptor = new SessionDescriptor();
        NodeList list = element.getChildNodes();
        if (list == null) return descriptor;
        Vector<EnvironmentEntry> envEntries = new Vector<EnvironmentEntry>();
        Vector<EJBeanReference> ejbRefs = new Vector<EJBeanReference>();
        Vector<SecurityRoleReference> roleRef = new Vector<SecurityRoleReference>();
        Vector<ResourceReference> resRefs = new Vector<ResourceReference>();
        String ejbClass = "";
        String value = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String tag = el.getNodeName();
                Element parent = (Element)el.getParentNode();
                String parentTag = parent.getNodeName();
                if (tag.equals("description") && parentTag.equals("session")) {
                    value = this.getTextValue(el);
                    if (!value.equals("")) {
                        descriptor.setDescription(value);
                    }
                } else if (tag.equals("display-name")) {
                    value = this.getTextValue(el);
                    if (!value.equals("")) {
                        descriptor.setDisplayName(value);
                    }
                } else if (tag.equals("small-icon")) {
                    value = this.getTextValue(el);
                    if (!value.equals("")) {
                        String smallIconPr = this.processString(value, false);
                        descriptor.setSmallIcon(smallIconPr);
                    }
                } else if (tag.equals("large-icon")) {
                    value = this.getTextValue(el);
                    if (!value.equals("")) {
                        String largeIconPr = this.processString(value, false);
                        descriptor.setLargeIcon(largeIconPr);
                    }
                } else if (tag.equals("ejb-name")) {
                    value = this.getTextValue(el);
                    if (!value.equals("")) {
                        descriptor.setBeanName(value);
                    }
                } else if (tag.equals("home") && parentTag.equals("session")) {
                    value = this.getTextValue(el);
                    if (!value.equals("")) {
                        descriptor.setRemoteHomeInterface(value);
                    }
                } else if (tag.equals("remote") && parentTag.equals("session")) {
                    value = this.getTextValue(el);
                    if (!value.equals("")) {
                        descriptor.setRemoteInterface(value);
                    }
                } else if (tag.equals("ejb-class")) {
                    ejbClass = this.getTextValue(el);
                    if (!ejbClass.equals("")) {
                        descriptor.setClassName(ejbClass);
                    }
                } else if (tag.equals("session-type")) {
                    value = this.getTextValue(el);
                    if (value.equals(STATEFUL_SESSION)) {
                        descriptor.setSessionType(1);
                    } else {
                        if (!value.equals(STATELESS_SESSION)) throw new BaseIllegalArgumentException("deploy_4201", new String[]{"session-type", "Stateful, Stateless", value});
                        descriptor.setSessionType(0);
                    }
                } else if (tag.equals("transaction-type")) {
                    value = this.getTextValue(el);
                    if (value.equals("Bean")) {
                        descriptor.setTransactionType(0);
                    } else if (value.equals("Container")) {
                        descriptor.setTransactionType(1);
                    }
                } else if (tag.equals("session-timeout")) {
                    value = this.getTextValue(el);
                    descriptor.setSessionTimeout(new Integer(value).intValue());
                } else if (tag.equals("env-entry")) {
                    EnvironmentEntry envEntry = this.getEnvEntry(el);
                    if (envEntry != null) {
                        envEntries.addElement(envEntry);
                    }
                } else if (tag.equals("ejb-ref")) {
                    EJBeanReference ejbRef = this.getEjbRef(el);
                    if (ejbRef != null) {
                        ejbRefs.addElement(ejbRef);
                    }
                } else if (tag.equals("security-role-ref")) {
                    SecurityRoleReference roleReference = this.getSecurityRefs(el);
                    if (roleReference != null) {
                        roleRef.addElement(roleReference);
                    }
                } else if (tag.equals("resource-ref")) {
                    ResourceReference resRef = this.getResourceRef(el);
                    if (resRef != null) {
                        resRefs.addElement(resRef);
                    }
                } else {
                    if (!tag.equals("bean-count")) throw new BaseWrongStructureException("deploy_4103", new String[]{tag});
                    value = this.getTextValue(el);
                    if (value != null && !value.equals("")) {
                        try {
                            descriptor.setContainerSize(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            this.warnings.add(new WarningException("deploy_4001", (Object[])new String[]{"bean-count", value}).getLocalizedMessage());
                        }
                    }
                }
            }
            ++i;
        }
        if (envEntries.size() != 0) {
            Object[] entries = new EnvironmentEntry[envEntries.size()];
            envEntries.copyInto(entries);
            descriptor.setEnvironmentEntries((EnvironmentEntry[])entries);
        }
        if (ejbRefs.size() != 0) {
            Object[] EJBeanRefs = new EJBeanReference[ejbRefs.size()];
            ejbRefs.copyInto(EJBeanRefs);
            descriptor.setEJBeanReferences((EJBeanReference[])EJBeanRefs);
        }
        if (roleRef.size() != 0) {
            Hashtable<String, Object> references = new Hashtable<String, Object>();
            Object[] refs = new SecurityRoleReference[roleRef.size()];
            roleRef.copyInto(refs);
            int i2 = 0;
            while (i2 < refs.length) {
                references.put(refs[i2].getRoleName(), refs[i2]);
                ++i2;
            }
            descriptor.setRoleReferences(references);
        }
        if (resRefs.size() == 0) return descriptor;
        Object[] resourceRefs = new ResourceReference[resRefs.size()];
        resRefs.copyInto(resourceRefs);
        descriptor.setResourceReferences((ResourceReference[])resourceRefs);
        return descriptor;
    }

    protected String processString(String str, boolean saving) {
        char separator = File.separatorChar;
        String str2 = new String();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (saving) {
                if (ch == separator) {
                    ch = '\\';
                }
            } else if (ch == '\\') {
                ch = separator;
            }
            str2 = new String(str2 + ch);
            ++i;
        }
        return str2;
    }

    public Vector getWarnings() {
        return this.warnings;
    }
}

