/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.converter;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.jar.JarExtractor;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.converter.ApplicationClientConverter;
import com.sap.engine.services.deploy.converter.EJBConverter;
import com.sap.engine.services.deploy.converter.WebConverter;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.exceptions.BaseEarException;
import com.sap.engine.services.deploy.exceptions.BaseIOException;
import com.sap.engine.services.deploy.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.deploy.exceptions.BaseWrongStructureException;
import com.sap.engine.services.deploy.exceptions.EarWontBeConvertedException;
import com.sap.engine.services.deploy.extended.ear.EARDescriptor;
import com.sap.engine.services.deploy.extended.ear.ExtendedEARReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class EARConverter {
    private TransformerFactory factory;
    ExtendedEARReader reader = null;
    JarUtils utils = new JarUtils();
    JarExtractor extractor = new JarExtractor();
    Vector archives = new Vector();
    ClassLoader loader = null;
    Vector allWarnings = new Vector(){

        public String toString() {
            String result = "";
            int i = 0;
            while (i < EARConverter.this.allWarnings.size()) {
                result = result + (String)EARConverter.this.allWarnings.elementAt(i) + "\n";
                ++i;
            }
            return result;
        }
    };
    String earFilePath = null;

    public EARConverter() {
    }

    public EARConverter(String _earFilePath) {
        this.earFilePath = _earFilePath;
    }

    public void setEarPath(String _earPath) {
        this.earFilePath = _earPath;
    }

    public void convert(String earName, String newEarName) throws BaseIllegalArgumentException, BaseWrongStructureException, BaseEarException, BaseIOException, DeploymentException {
        EARDescriptor earDescr = null;
        String tmp = null;
        this.checkArgs(earName, newEarName);
        tmp = this.earFilePath != null ? this.earFilePath : SystemProperties.getProperty((String)"user.dir");
        earName = earName.replace('/', File.separatorChar);
        earName = earName.replace('\\', File.separatorChar);
        String convDir = tmp + File.separator + "conv" + System.currentTimeMillis();
        String tempDir = convDir + File.separator + earName.substring(earName.lastIndexOf(File.separator) + 1, earName.lastIndexOf("."));
        String dtd = null;
        try {
            try {
                int i;
                Vector warnings;
                this.reader = new ExtendedEARReader(earName);
                earDescr = this.reader.getDescriptor();
                dtd = this.reader.getDTD();
                if (dtd != null && dtd.equals("http://java.sun.com/j2ee/dtds/application_1_2.dtd")) {
                    throw new EarWontBeConvertedException("deploy_4304", new String[]{earName});
                }
                if (dtd != null && (dtd.equals("http://java.sun.com/dtd/application_1_3.dtd") || dtd.equals("http://java.sun.com/j2ee/dtds/application_1_3.dtd"))) {
                    throw new EarWontBeConvertedException("deploy_4305", new String[]{earName});
                }
                if (dtd != null && !dtd.equals("<!DOCTYPE application [\n<!ELEMENT application (icon?, display-name, description?, module+, security-role*)>\n<!ATTLIST application id ID #IMPLIED>\n<!ELEMENT icon (small-icon?, large-icon?)>\n<!ATTLIST icon id ID #IMPLIED>\n<!ELEMENT small-icon (#PCDATA)>\n<!ATTLIST small-icon id ID #IMPLIED>\n<!ELEMENT large-icon (#PCDATA)>\n<!ATTLIST large-icon id ID #IMPLIED>\n<!ELEMENT display-name (#PCDATA)>\n<!ATTLIST display-name id ID #IMPLIED>\n<!ELEMENT description (#PCDATA)>\n<!ATTLIST description id ID #IMPLIED>\n<!ELEMENT module ((ejb | java | web), alt-dd?)>\n<!ATTLIST module id ID #IMPLIED>\n<!ELEMENT ejb (#PCDATA)>\n<!ATTLIST ejb id ID #IMPLIED>\n<!ELEMENT java (#PCDATA)>\n<!ATTLIST java id ID #IMPLIED>\n<!ELEMENT web (web-uri, context-root)>\n<!ATTLIST web id ID #IMPLIED>\n<!ELEMENT web-uri (#PCDATA)>\n<!ATTLIST web-uri id ID #IMPLIED>\n<!ELEMENT context-root (#PCDATA)>\n<!ATTLIST context-root id ID #IMPLIED>\n<!ELEMENT alt-dd (#PCDATA)>\n<!ATTLIST alt-dd id ID #IMPLIED>\n<!ELEMENT security-role (description?, role-name)>\n<!ATTLIST security-role id ID #IMPLIED>\n<!ELEMENT role-name (#PCDATA)>\n<!ATTLIST role-name id ID #IMPLIED>\n]>") && dtd.indexOf("http://java.sun.com/j2ee/dtds/application_1_2.dtd") <= -1) {
                    throw new BaseEarException("deploy_4301", new String[]{earName});
                }
                File tempD = new File(tempDir);
                tempD.mkdirs();
                this.extractor.extractJar(earName, tempD.getAbsolutePath());
                this.saveAppDescriptor(tempD.getAbsolutePath(), earName);
                String classpath = "";
                Vector clNames = new Vector();
                this.listDir(tempD, clNames);
                int i2 = 0;
                while (i2 < clNames.size()) {
                    classpath = classpath + (String)clNames.elementAt(i2) + File.pathSeparator;
                    ++i2;
                }
                DynamicClassLoader dynLoader = new DynamicClassLoader(classpath, this.loader);
                String[] fileNames = this.getFiles(tempDir, earDescr.getEJBs());
                String[] altDDs = this.getAltDDAsString(tempDir, earDescr.getEJBs());
                if (fileNames != null) {
                    EJBConverter ejbConv = new EJBConverter(fileNames);
                    ejbConv.setParent(this.loader);
                    ejbConv.setLoader((ClassLoader)dynLoader);
                    ejbConv.setTempDir(tempDir);
                    ejbConv.setAltDDs(altDDs);
                    ejbConv.convert();
                    warnings = ejbConv.getWarnings();
                    if (warnings != null) {
                        i = 0;
                        while (i < warnings.size()) {
                            this.allWarnings.add(warnings.elementAt(i));
                            System.out.println("Warning " + (i + 1) + " from EJBConverter: " + warnings.elementAt(i));
                            ++i;
                        }
                    }
                }
                fileNames = this.getFiles(tempDir, earDescr.getWEBs());
                altDDs = this.getAltDDAsString(tempDir, earDescr.getWEBs());
                if (fileNames != null) {
                    WebConverter webConv = new WebConverter(fileNames);
                    webConv.setParent(this.loader);
                    webConv.setLoader((ClassLoader)dynLoader);
                    webConv.setTempDir(tempDir);
                    webConv.setAltDDs(altDDs);
                    webConv.convert();
                    warnings = webConv.getWarnings();
                    if (warnings != null) {
                        i = 0;
                        while (i < warnings.size()) {
                            this.allWarnings.add(warnings.elementAt(i));
                            System.out.println("Warning " + (i + 1) + " from WebConverter: " + warnings.elementAt(i));
                            ++i;
                        }
                    }
                }
                fileNames = this.getFiles(tempDir, earDescr.getClients());
                altDDs = this.getAltDDAsString(tempDir, earDescr.getClients());
                if (fileNames != null) {
                    ApplicationClientConverter clientConv = new ApplicationClientConverter(fileNames);
                    clientConv.setParent(this.loader);
                    clientConv.setLoader((ClassLoader)dynLoader);
                    clientConv.setTempDir(tempDir);
                    clientConv.setAltDDs(altDDs);
                    clientConv.convert();
                    warnings = clientConv.getWarnings();
                    if (warnings != null) {
                        i = 0;
                        while (i < warnings.size()) {
                            this.allWarnings.add(warnings.elementAt(i));
                            System.out.println("Warning " + (i + 1) + " from AppClientConverter: " + warnings.elementAt(i));
                            ++i;
                        }
                    }
                }
                if (newEarName != null) {
                    new File(newEarName).getParentFile().mkdirs();
                    new JarUtils().makeJarFromDir(newEarName, tempDir);
                } else {
                    new JarUtils().makeJarFromDir(new File(new File(earName).getParentFile(), "temp.ear").getAbsolutePath(), tempDir);
                }
                System.out.println("\n" + earName + " converted successfully to J2EE 1.2 ear as described in J2EE 1.2 specification.");
            }
            catch (IOException e) {
                throw new BaseIOException("deploy_4405", new String[]{earName}, (Throwable)e);
            }
            Object var19_19 = null;
            if (this.reader != null) {
                this.reader.clear();
            }
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            if (this.reader != null) {
                this.reader.clear();
            }
            FileUtils.deleteDirectory((File)new File(convDir));
            throw throwable;
        }
        FileUtils.deleteDirectory((File)new File(convDir));
    }

    private String[] getFiles(String dirName, J2EEModule[] modules) {
        String[] res = null;
        if (modules == null) {
            return null;
        }
        res = new String[modules.length];
        int i = 0;
        while (i < modules.length) {
            res[i] = dirName + File.separator + modules[i].getUri().replace('\\', '/');
            ++i;
        }
        return res;
    }

    private String[] getAltDDAsString(String dirName, J2EEModule[] modules) {
        String[] streams = null;
        if (modules == null) {
            return null;
        }
        streams = new String[modules.length];
        int i = 0;
        while (i < modules.length) {
            streams[i] = modules[i].getAlt_dd() != null ? dirName + File.separator + modules[i].getAlt_dd() : null;
            ++i;
        }
        return streams;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveAppDescriptor(String dirName, String earName) throws BaseIOException {
        String newName;
        FileOutputStream fos;
        String filePath;
        block22: {
            ZipEntry entry;
            block21: {
                filePath = null;
                entry = null;
                ZipFile earFile = null;
                try {
                    try {
                        earFile = new ZipFile(earName);
                        entry = earFile.getEntry("META-INF/application.xml");
                    }
                    catch (IOException e) {
                        throw new BaseIOException("deploy_4406", new String[]{earName}, (Throwable)e);
                    }
                    Object var8_6 = null;
                    if (earFile == null) break block21;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    if (earFile == null) throw throwable;
                    try {
                        earFile.close();
                        throw throwable;
                    }
                    catch (IOException ioex) {
                        throw new BaseIOException("deploy_4407", new String[]{earName}, (Throwable)ioex);
                    }
                }
                try {}
                catch (IOException ioex) {
                    throw new BaseIOException("deploy_4407", new String[]{earName}, (Throwable)ioex);
                }
                earFile.close();
            }
            if (entry != null) {
                filePath = dirName + File.separator + entry.getName();
            } else {
                filePath = dirName + File.separator + "META-INF";
                new File(filePath).mkdirs();
                filePath = filePath + File.separator + "application.xml";
            }
            InputStream applicationStream = null;
            fos = null;
            newName = null;
            try {
                try {
                    applicationStream = this.getClass().getClassLoader().getResourceAsStream("com/sap/engine/services/deploy/converter/xsl/application.xsl");
                    Transformer transformer = this.getTransformerFactory().newTransformer(new StreamSource(applicationStream));
                    newName = dirName + File.separator + "META-INF" + File.separator + "new-application.xml";
                    fos = new FileOutputStream(newName);
                    StandardDOMParser parser = new StandardDOMParser();
                    Document doc = parser.parse(filePath);
                    transformer.transform(new DOMSource(doc), new StreamResult(fos));
                }
                catch (Exception exc) {
                    throw new BaseIOException("deploy_4411", new String[]{"application.xml", earName}, (Throwable)exc);
                }
                Object var13_18 = null;
                if (applicationStream == null) break block22;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                if (applicationStream != null) {
                    try {
                        applicationStream.close();
                    }
                    catch (IOException ioexc) {
                        throw new BaseIOException("deploy_4410", new String[]{"application.xsl"}, (Throwable)ioexc);
                    }
                }
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException ioexc) {
                    throw new BaseIOException("deploy_4410", new String[]{"new-application.xml"}, (Throwable)ioexc);
                }
            }
            try {}
            catch (IOException ioexc) {
                throw new BaseIOException("deploy_4410", new String[]{"application.xsl"}, (Throwable)ioexc);
            }
            applicationStream.close();
        }
        if (fos != null) {
            try {}
            catch (IOException ioexc) {
                throw new BaseIOException("deploy_4410", new String[]{"new-application.xml"}, (Throwable)ioexc);
            }
            fos.close();
        }
        new File(filePath).delete();
        new File(newName).renameTo(new File(filePath));
    }

    public void setLoader(ClassLoader l) {
        this.loader = l;
    }

    public Vector getWarnings() {
        return this.allWarnings;
    }

    public static void main(String[] args) throws BaseIllegalArgumentException, BaseWrongStructureException, BaseEarException, BaseIOException, DeploymentException {
        if (args.length != 2) {
            System.out.println("\nUsage: converter <path_to_original_j2ee1.2.ear> <path_to_new.ear>");
            return;
        }
        try {
            EARConverter conv = new EARConverter();
            conv.convert(args[0], args[1]);
        }
        catch (EarWontBeConvertedException ewc) {
            System.out.println("This ear doesn't need to be converted.");
        }
    }

    private void listDir(File dir, Vector res) {
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.listDir(files[i], res);
                } else if (files[i].getName().endsWith(".rar") || files[i].getName().endsWith(".zip") || files[i].getName().endsWith(".jar") || files[i].getName().endsWith(".war")) {
                    res.add(files[i].getAbsolutePath());
                }
                ++i;
            }
        }
    }

    private TransformerFactory getTransformerFactory() {
        if (this.factory == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.factory = TransformerFactory.newInstance();
            Thread.currentThread().setContextClassLoader(cl);
        }
        return this.factory;
    }

    private void checkArgs(String originalEar, String newEar) throws BaseIllegalArgumentException {
        if (originalEar == null || originalEar.equals("")) {
            throw new BaseIllegalArgumentException("deploy_4202", new String[]{"original ear file"});
        }
        originalEar = originalEar.replace('/', File.separatorChar);
        if (!new File(originalEar = originalEar.replace('\\', File.separatorChar)).isFile()) {
            throw new BaseIllegalArgumentException("deploy_4203", new String[]{"original ear file", "File not found"});
        }
        if (newEar == null) {
            return;
        }
        if (newEar.indexOf(42) > -1 || newEar.indexOf(63) > -1 || newEar.indexOf(34) > -1 || newEar.indexOf(60) > -1 || newEar.indexOf(62) > -1 || newEar.indexOf(124) > -1) {
            throw new BaseIllegalArgumentException("deploy_4203", new String[]{"new ear file", "It contains illegal characters"});
        }
        newEar = newEar.replace('/', File.separatorChar);
        if (new File(newEar = newEar.replace('\\', File.separatorChar)).isDirectory()) {
            throw new BaseIllegalArgumentException("deploy_4204");
        }
        if (new File(newEar).getParentFile() == null) {
            throw new BaseIllegalArgumentException("deploy_4203", new String[]{"new ear file", "Parent directory is not specified"});
        }
    }
}

