/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.ear.exceptions.BaseIOException;
import com.sap.engine.services.deploy.ear.exceptions.BaseIllegalArgumentException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.Vector;

public class UpdateFilesCommand
implements Command {
    DeployService deploy = null;

    public UpdateFilesCommand(DeployService deployment) {
        this.deploy = deployment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length == 0 || params[0].equals("-?") || params[0].toLowerCase().startsWith("-h")) {
            pw.println(this.getHelpMessage());
            return;
        }
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        Vector<FileUpdateInfo> updateInfoes = new Vector<FileUpdateInfo>();
        FileUpdateInfo updateInfo = null;
        String applicationName = null;
        int i = 0;
        while (i < params.length) {
            if (params[i].equalsIgnoreCase("-unit")) {
                if (updateInfo != null) {
                    updateInfoes.add(updateInfo);
                }
                updateInfo = new FileUpdateInfo();
            } else if (params[i].equalsIgnoreCase("-c")) {
                if (++i >= params.length) {
                    pw.println(this.getHelpMessage());
                    return;
                }
                if (updateInfo == null) {
                    pw.println(this.getHelpMessage());
                    return;
                }
                updateInfo.setContainerName(params[i]);
            } else {
                if (params[i].equalsIgnoreCase("-f")) {
                    if (++i >= params.length) {
                        pw.println(this.getHelpMessage());
                        return;
                    }
                    if (updateInfo == null) {
                        pw.println(this.getHelpMessage());
                        return;
                    }
                    try {
                        updateInfo.setFileName(params[i]);
                    }
                    catch (BaseIllegalArgumentException biae) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, biae);
                        return;
                    }
                    catch (BaseIOException bioe) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, bioe);
                        return;
                    }
                }
                if (params[i].equalsIgnoreCase("-a")) {
                    if (++i >= params.length) {
                        pw.println(this.getHelpMessage());
                        return;
                    }
                    applicationName = params[i];
                } else {
                    if (params[i].equalsIgnoreCase("-e")) {
                        if (++i >= params.length) {
                            pw.println(this.getHelpMessage());
                            return;
                        }
                        if (updateInfo == null) {
                            pw.println(this.getHelpMessage());
                            return;
                        }
                        try {
                            updateInfo.setFileEntryName(params[i]);
                        }
                        catch (BaseIllegalArgumentException biae) {
                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, biae);
                            return;
                        }
                    }
                    if (params[i].equalsIgnoreCase("-m")) {
                        if (++i >= params.length) {
                            pw.println(this.getHelpMessage());
                            return;
                        }
                        if (updateInfo == null) {
                            pw.println(this.getHelpMessage());
                            return;
                        }
                        try {
                            updateInfo.setArchiveEntryName(params[i]);
                        }
                        catch (BaseIllegalArgumentException biae) {
                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, biae);
                            return;
                        }
                    }
                }
            }
            ++i;
        }
        if (updateInfo != null) {
            updateInfoes.add(updateInfo);
        }
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            FileUpdateInfo[] infoes = new FileUpdateInfo[updateInfoes.size()];
            updateInfoes.toArray(infoes);
            try {
                if (applicationName != null) {
                    this.deploy.singleFileUpdate(infoes, applicationName, new Properties());
                } else {
                    pw.println("Application name is not specified!");
                }
            }
            catch (RemoteException re) {
                DCommandsUtils.handleProblem(pw, re.toString());
            }
            catch (Exception ex) {
                DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                Object var18_18 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            catch (ThreadDeath td) {
                DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                throw td;
            }
            catch (OutOfMemoryError oome) {
                DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                throw oome;
            }
            catch (Error er) {
                DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
            }
            Object var18_19 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            return;
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            throw throwable;
        }
    }

    public String getHelpMessage() {
        return "Updates single file(s) in the structure of a deployed application. Information about each updated file is described in a separate unit.\nUsage: UPDATE_FILES <-a applicationName> <-unit <-f filePath> <-e fileEntryName> <-m moduleArchiveEntryName> <-c containerName>>*\nParameters :\n   <-a applicationName>        - The name of the application which files to\n                                 update.\n   <-unit>*                    - Marks the start of a file-to-update information\n   <-f filePath>               - Path to a file-to-update which to replace an\n                                 existing file in application structure.\n   <-e fileEntryName>          - Entry name of a file-to-update in the structure\n                                 of a module archive which is a part of\n                                 application ear.\n   <-m moduleArchiveEntryName> - Entry name of a module archive in the structure\n                                 of application ear.\n   <-c containerName>          - The name of the container on which a module\n                                 archive is deployed.\n";
    }

    public String getName() {
        return "UPDATE_FILES";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

