/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import com.sap.engine.services.deploy.container.WarningException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class UpdateCommand
implements Command {
    DeployService deploy = null;

    public UpdateCommand(DeployService deployment) {
        this.deploy = deployment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        ClassLoader threadLoader;
        block37: {
            block35: {
                block34: {
                    block33: {
                        PrintWriter pw = new PrintWriter(os, true);
                        boolean nowarn = false;
                        Properties props = new Properties();
                        String containerName = null;
                        if (params.length == 0 || params[0].equals("-?") || params[0].toLowerCase().startsWith("-h")) {
                            pw.println(this.getHelpMessage());
                            return;
                        }
                        threadLoader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        try {
                            block38: {
                                if (params.length <= 1) break block38;
                                int i = 0;
                                while (i < params.length - 1) {
                                    block40: {
                                        block39: {
                                            if (!params[i].equalsIgnoreCase("-properties")) break block39;
                                            if (++i < params.length - 1) {
                                                StringTokenizer tokenizer = new StringTokenizer(params[i], ";");
                                                String pr = null;
                                                while (tokenizer.hasMoreTokens()) {
                                                    pr = tokenizer.nextToken();
                                                    if (pr.indexOf(61) == -1) {
                                                        pw.println(this.getHelpMessage());
                                                        Object var17_17 = null;
                                                        Thread.currentThread().setContextClassLoader(threadLoader);
                                                        return;
                                                    }
                                                    ((Hashtable)props).put(pr.substring(0, pr.indexOf(61)).trim(), pr.substring(pr.indexOf(61) + 1).trim());
                                                }
                                                break block40;
                                            } else {
                                                pw.println(this.getHelpMessage());
                                                break block33;
                                            }
                                        }
                                        if (params[i].equalsIgnoreCase("-noWarnings")) {
                                            nowarn = true;
                                        } else if (params[i].equalsIgnoreCase("-c")) {
                                            if (i >= params.length - 1) {
                                                pw.println(this.getHelpMessage());
                                                break block34;
                                            }
                                            containerName = params[++i];
                                        }
                                    }
                                    ++i;
                                }
                            }
                            String earName = params[params.length - 1];
                            try {
                                File originalFile = new File(earName);
                                if (!originalFile.exists()) {
                                    pw.println("The file " + earName + " was not found!");
                                    break block35;
                                }
                                String fileCopy = "." + File.separator + "temp" + File.separator + "deploy" + File.separator + "work" + File.separator + "deploying" + File.separator + originalFile.getName();
                                File file = new File(fileCopy);
                                try {
                                    FileUtils.copyFile((File)originalFile, (File)file);
                                }
                                catch (IOException ex) {
                                    DCommandsUtils.handleProblem(pw, "deploy_1001", new String[]{earName, fileCopy, ex.toString()}, ex);
                                    Object var17_21 = null;
                                    Thread.currentThread().setContextClassLoader(threadLoader);
                                    return;
                                }
                                if (containerName != null) {
                                    ((Hashtable)props).put("isStandAlone", "true");
                                }
                                String[] res = null;
                                try {
                                    if (file.getName().toLowerCase().endsWith(".ear")) {
                                        res = this.deploy.update(file.getAbsolutePath(), props);
                                    } else {
                                        if (file.getName().toLowerCase().endsWith(".war") && props.getProperty("alias") != null) {
                                            String alias = props.getProperty("alias");
                                            ((Hashtable)props).remove("alias");
                                            ((Hashtable)props).put("web:" + alias, file.getName());
                                        }
                                        res = this.deploy.update(file.getAbsolutePath(), containerName, null, props);
                                    }
                                }
                                catch (WarningException wex) {
                                    pw.println("Updated with WARNINGS. \n");
                                    if (!nowarn) {
                                        DCommandsUtils.handleWarnings(pw, wex);
                                    }
                                    res = wex.getResult();
                                }
                                if (res != null) {
                                    if (res.length > 1) {
                                        pw.println("");
                                        pw.println("Updated components :");
                                        int i = 0;
                                        while (i < res.length) {
                                            pw.println(res[i]);
                                            ++i;
                                        }
                                    } else if (res.length == 1) {
                                        pw.println(res[0]);
                                        pw.println("No deployable components were found in the archive " + earName);
                                    }
                                }
                                pw.println("Update of the " + earName + " completed successfully.");
                                break block37;
                            }
                            catch (RemoteException re) {
                                DCommandsUtils.handleProblem(pw, re.toString());
                                break block37;
                            }
                            catch (Exception ex) {
                                DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                                Object var17_22 = null;
                                Thread.currentThread().setContextClassLoader(threadLoader);
                                return;
                            }
                            catch (ThreadDeath td) {
                                DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                                throw td;
                            }
                            catch (OutOfMemoryError oome) {
                                DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                                throw oome;
                            }
                            catch (Error er) {
                                DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                                break block37;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var17_24 = null;
                            Thread.currentThread().setContextClassLoader(threadLoader);
                            throw throwable;
                        }
                    }
                    Object var17_18 = null;
                    Thread.currentThread().setContextClassLoader(threadLoader);
                    return;
                }
                Object var17_19 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            Object var17_20 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            return;
        }
        Object var17_23 = null;
        Thread.currentThread().setContextClassLoader(threadLoader);
    }

    public String getHelpMessage() {
        return "Updates components of an archive file deployed on servers in the cluster.\nUsage: UPDATE [-properties \"<key=value>*\"] [-noWarnings] [-c containerName] <archiveName>\nParameters:\n   [-properties \"<key=value>*\"]   - User properties for update process to be\n                                    send to deploy service and containers.\n      \"<key=value>*\"              - A semicolon-separated list of properties\n                                    which is enclosed in quotes.\n                                    If you update a stand-alone war module, then you have to specify its application and provider name (otherwise unique ones will be generated and you will not be able to update already deployed war application). They are described as properties with the syntax application_name=...;provider_name=...\n                                    The alias name of the stand-alone war module also has to be specified as a property. The syntax is alias=...\n   [-noWarnings]                  - Performs update without displaying warnings.\n   [-c containerName]             - The name of the container to which a stand\n                                    alone module is updated. It is ignored if\n                                    deployable archive is not a stand alone\n                                    module.\n   <archiveName>                  - The name of the archive to be updated.\n";
    }

    public String getName() {
        return "UPDATE";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

