/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.locking.LockEntry;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class UnlockApplicationCommand
implements Command {
    LockingContext lockContext = null;
    String deployOwner = null;
    String deployArea = null;

    public UnlockApplicationCommand(LockingContext _lockContext, String _deployOwner, String _deployArea) {
        this.lockContext = _lockContext;
        this.deployOwner = _deployOwner;
        this.deployArea = _deployArea;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length == 0 || params[0].equals("-?") || params[0].toLowerCase().startsWith("-h")) {
            pw.println(this.getHelpMessage());
            return;
        }
        try {
            AdministrativeLocking admLock = this.lockContext.getAdministrativeLocking();
            LockEntry[] lEntries = admLock.getLocks(this.deployArea, params[0]);
            if (lEntries == null || lEntries.length == 0) {
                pw.println("Currently application [" + params[0] + "] is not locked.");
                return;
            }
            LockEntry entry = null;
            int i = 0;
            while (i < lEntries.length) {
                entry = lEntries[i];
                if (entry != null) {
                    admLock.unlock(entry.getOwner(), this.deployArea, params[0], entry.getMode(), false);
                }
                ++i;
            }
            pw.println("Application [" + params[0] + "] was successfully unlocked.");
        }
        catch (TechnicalLockException tle) {
            DCommandsUtils.handleProblem(pw, "There was a problem with unlocking of application [" + params[0] + "], " + tle.toString());
        }
        catch (IllegalArgumentException iae) {
            DCommandsUtils.handleProblem(pw, "There was an illegal argument, " + iae.toString());
        }
        catch (Exception ex) {
            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
            return;
        }
        catch (ThreadDeath td) {
            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
            throw td;
        }
        catch (OutOfMemoryError oome) {
            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
            throw oome;
        }
        catch (Error er) {
            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
        }
    }

    public String getHelpMessage() {
        return "Unlocks an application on all servers in the cluster. Application is locked while another shell command from DEPLOY group operates on the same application.\nUsage: UNLOCK_APP <applicationName>\nParameters:\n   <applicationName> - The name of the application to unlock.\nNote: We recommend using this command only in case of emergency and provided that another command from DEPLOY group is not operating on that application at the same time.\n";
    }

    public String getName() {
        return "UNLOCK_APP";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

