/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.server.DeployServiceImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Vector;

public class StopApplicationCommand
implements Command {
    DeployServiceImpl deploy = null;

    public StopApplicationCommand(DeployServiceImpl deployment) {
        this.deploy = deployment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        ClassLoader threadLoader;
        block38: {
            block37: {
                block33: {
                    block36: {
                        block35: {
                            block34: {
                                PrintWriter pw = new PrintWriter(os, true);
                                String applicationName = null;
                                boolean isServerName = false;
                                Vector<String> servers = new Vector<String>();
                                boolean isSynchron = false;
                                boolean isAllApplications = false;
                                threadLoader = Thread.currentThread().getContextClassLoader();
                                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                                try {
                                    if (params.length == 0 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h")) {
                                        pw.println(this.getHelpMessage());
                                        Object var22_12 = null;
                                        Thread.currentThread().setContextClassLoader(threadLoader);
                                        return;
                                    }
                                    int i = 0;
                                    while (true) {
                                        block40: {
                                            block43: {
                                                block42: {
                                                    block41: {
                                                        block39: {
                                                            if (i >= params.length) {
                                                                if (this.deploy != null) break;
                                                                pw.println("Deploy Service was not started!");
                                                                break block33;
                                                            }
                                                            if (!params[i].equalsIgnoreCase("-s")) break block39;
                                                            if (isAllApplications) {
                                                                pw.println(this.getHelpMessage());
                                                                break block34;
                                                            }
                                                            isServerName = true;
                                                            break block40;
                                                        }
                                                        if (!params[i].equalsIgnoreCase("-synchron")) break block41;
                                                        isSynchron = true;
                                                        break block40;
                                                    }
                                                    if (!params[i].equalsIgnoreCase("-all")) break block42;
                                                    if (isServerName || applicationName != null) {
                                                        pw.println(this.getHelpMessage());
                                                        break block35;
                                                    }
                                                    isSynchron = true;
                                                    isAllApplications = true;
                                                    break block40;
                                                }
                                                if (isServerName) break block43;
                                                if (applicationName == null && !isAllApplications) {
                                                    applicationName = params[i];
                                                    break block40;
                                                } else {
                                                    pw.println(this.getHelpMessage());
                                                    break block36;
                                                }
                                            }
                                            if (isServerName) {
                                                servers.add(params[i]);
                                            }
                                        }
                                        ++i;
                                    }
                                    if (applicationName == null && !isAllApplications) {
                                        pw.println("Application not specified!");
                                        break block37;
                                    }
                                    String[] serverNames = null;
                                    if (servers.size() > 0) {
                                        serverNames = new String[servers.size()];
                                        servers.toArray(serverNames);
                                    } else {
                                        serverNames = this.deploy.getAllServerNames();
                                    }
                                    String[] apps = null;
                                    if (isAllApplications) {
                                        try {
                                            apps = this.deploy.listApplications(null, serverNames);
                                        }
                                        catch (RemoteException re) {
                                            DCommandsUtils.handleProblem(pw, re.toString());
                                        }
                                        catch (Exception ex) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                                            Object var22_18 = null;
                                            Thread.currentThread().setContextClassLoader(threadLoader);
                                            return;
                                        }
                                        catch (ThreadDeath td) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                                            throw td;
                                        }
                                        catch (OutOfMemoryError oome) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                                            throw oome;
                                        }
                                        catch (Error er) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                                        }
                                    } else {
                                        apps = new String[]{applicationName};
                                    }
                                    if (apps == null) break block38;
                                    int j = 0;
                                    while (true) {
                                        if (j >= apps.length) {
                                            break block38;
                                        }
                                        applicationName = apps[j];
                                        try {
                                            if (applicationName != null) {
                                                if (!isSynchron) {
                                                    this.deploy.stopApplication(applicationName, serverNames);
                                                } else {
                                                    this.deploy.stopApplicationAndWait(applicationName, serverNames);
                                                    pw.println("");
                                                    pw.println("Application " + applicationName + " has been stopped.");
                                                }
                                                pw.println("");
                                            }
                                        }
                                        catch (WarningException wex) {
                                            pw.println("Application " + applicationName + " stopped with WARNINGS. \n");
                                            DCommandsUtils.handleWarnings(pw, wex);
                                        }
                                        catch (RemoteException re) {
                                            DCommandsUtils.handleProblem(pw, re.toString());
                                        }
                                        catch (Exception ex) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                                            Object var22_19 = null;
                                            Thread.currentThread().setContextClassLoader(threadLoader);
                                            return;
                                        }
                                        catch (ThreadDeath td) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                                            throw td;
                                        }
                                        catch (OutOfMemoryError oome) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                                            throw oome;
                                        }
                                        catch (Error er) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                                        }
                                        ++j;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var22_21 = null;
                                    Thread.currentThread().setContextClassLoader(threadLoader);
                                    throw throwable;
                                }
                            }
                            Object var22_13 = null;
                            Thread.currentThread().setContextClassLoader(threadLoader);
                            return;
                        }
                        Object var22_14 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        return;
                    }
                    Object var22_15 = null;
                    Thread.currentThread().setContextClassLoader(threadLoader);
                    return;
                }
                Object var22_16 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            Object var22_17 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            return;
        }
        Object var22_20 = null;
        Thread.currentThread().setContextClassLoader(threadLoader);
    }

    public String getHelpMessage() {
        return "Stops an application on servers in the cluster.\nUsage: STOP_APP  [<applicationName> | <-all>] [-synchron] [-s serverName*]\nParameters:\n   <applicationName> - The name of the application to stop.\n   <-all>            - Stops all applications synchron in the cluster.\n   [-synchron]       - With this option the operation will be executed in the same thread. You will see all warning and errors, which are missing in the console if the stop is asynchronous. If the option is not selected, the stop is asynchronous.\n   [-s serverName*]  - A space-separated list of server names on which to stop the application.\n";
    }

    public String getName() {
        return "STOP_APP";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

