/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import com.sap.engine.services.deploy.container.WarningException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Vector;

public class StartApplicationCommand
implements Command {
    DeployService deploy = null;

    public StartApplicationCommand(DeployService deployment) {
        this.deploy = deployment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        ClassLoader threadLoader;
        block37: {
            block36: {
                block32: {
                    block35: {
                        block34: {
                            block33: {
                                PrintWriter pw = new PrintWriter(os, true);
                                String applicationName = null;
                                Vector<String> servers = new Vector<String>();
                                boolean isServerName = false;
                                boolean isSynchron = false;
                                boolean isAllApplications = false;
                                threadLoader = Thread.currentThread().getContextClassLoader();
                                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                                try {
                                    if (params.length == 0 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h")) {
                                        pw.println(this.getHelpMessage());
                                        Object var22_12 = null;
                                        Thread.currentThread().setContextClassLoader(threadLoader);
                                        return;
                                    }
                                    int i = 0;
                                    while (true) {
                                        block39: {
                                            block42: {
                                                block41: {
                                                    block40: {
                                                        block38: {
                                                            if (i >= params.length) {
                                                                if (this.deploy != null) break;
                                                                pw.println("Deploy Service was not started!");
                                                                break block32;
                                                            }
                                                            if (!params[i].equalsIgnoreCase("-s")) break block38;
                                                            if (isAllApplications) {
                                                                pw.println(this.getHelpMessage());
                                                                break block33;
                                                            }
                                                            isServerName = true;
                                                            break block39;
                                                        }
                                                        if (!params[i].equalsIgnoreCase("-synchron")) break block40;
                                                        isSynchron = true;
                                                        break block39;
                                                    }
                                                    if (!params[i].equalsIgnoreCase("-all")) break block41;
                                                    if (isServerName || applicationName != null) {
                                                        pw.println(this.getHelpMessage());
                                                        break block34;
                                                    }
                                                    isSynchron = true;
                                                    isAllApplications = true;
                                                    break block39;
                                                }
                                                if (isServerName) break block42;
                                                if (applicationName == null && !isAllApplications) {
                                                    applicationName = params[i];
                                                    break block39;
                                                } else {
                                                    pw.println(this.getHelpMessage());
                                                    break block35;
                                                }
                                            }
                                            if (isServerName) {
                                                servers.add(params[i]);
                                            }
                                        }
                                        ++i;
                                    }
                                    if (applicationName == null && !isAllApplications) {
                                        pw.println("Application not specified!");
                                        break block36;
                                    }
                                    String[] serverNames = null;
                                    if (servers.size() > 0) {
                                        serverNames = new String[servers.size()];
                                        servers.toArray(serverNames);
                                    }
                                    String[] apps = null;
                                    if (isAllApplications) {
                                        try {
                                            apps = this.deploy.listApplications(null, serverNames);
                                        }
                                        catch (RemoteException re) {
                                            DCommandsUtils.handleProblem(pw, re.toString());
                                        }
                                        catch (Exception ex) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                                            Object var22_18 = null;
                                            Thread.currentThread().setContextClassLoader(threadLoader);
                                            return;
                                        }
                                        catch (ThreadDeath td) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                                            throw td;
                                        }
                                        catch (OutOfMemoryError oome) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                                            throw oome;
                                        }
                                        catch (Error er) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                                        }
                                    } else {
                                        apps = new String[]{applicationName};
                                    }
                                    if (apps == null) break block37;
                                    int j = 0;
                                    while (true) {
                                        if (j >= apps.length) {
                                            break block37;
                                        }
                                        applicationName = apps[j];
                                        try {
                                            if (applicationName != null) {
                                                if (!isSynchron) {
                                                    this.deploy.startApplication(applicationName, serverNames);
                                                } else {
                                                    this.deploy.startApplicationAndWait(applicationName, serverNames);
                                                    pw.println("");
                                                    pw.println("Application " + applicationName + " has been started.");
                                                }
                                                pw.println("");
                                            }
                                        }
                                        catch (WarningException wex) {
                                            pw.println("Application " + applicationName + " started with WARNINGS. \n");
                                            DCommandsUtils.handleWarnings(pw, wex);
                                        }
                                        catch (RemoteException re) {
                                            DCommandsUtils.handleProblem(pw, re.toString());
                                        }
                                        catch (Exception ex) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                                            Object var22_19 = null;
                                            Thread.currentThread().setContextClassLoader(threadLoader);
                                            return;
                                        }
                                        catch (ThreadDeath td) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                                            throw td;
                                        }
                                        catch (OutOfMemoryError oome) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                                            throw oome;
                                        }
                                        catch (Error er) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                                        }
                                        ++j;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var22_21 = null;
                                    Thread.currentThread().setContextClassLoader(threadLoader);
                                    throw throwable;
                                }
                            }
                            Object var22_13 = null;
                            Thread.currentThread().setContextClassLoader(threadLoader);
                            return;
                        }
                        Object var22_14 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        return;
                    }
                    Object var22_15 = null;
                    Thread.currentThread().setContextClassLoader(threadLoader);
                    return;
                }
                Object var22_16 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            Object var22_17 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            return;
        }
        Object var22_20 = null;
        Thread.currentThread().setContextClassLoader(threadLoader);
    }

    public String getHelpMessage() {
        return "Starts an application on servers in the cluster.\nUsage: START_APP  [<applicationName> | <-all>] [-synchron] [-s serverName*] \nParameters:\n   <applicationName> - The name of the application to start.\n   <-all>            - Starts all applications synchron in the cluster.\n   [-synchron]       - With this option the operation will be executed in the same thread. You will see all warning and errors, which are missing in the console if the start is asynchronous. If the option is not selected, the start is asynchronous.\n   [-s serverName*]  - A space-separated list of server names on which to start the application.\n";
    }

    public String getName() {
        return "START_APP";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

