/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import com.sap.engine.services.deploy.container.WarningException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class RemoveApplicationCommand
implements Command {
    DeployService deploy = null;

    public RemoveApplicationCommand(DeployService deployment) {
        this.deploy = deployment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        ClassLoader threadLoader;
        block29: {
            block28: {
                block27: {
                    block26: {
                        block24: {
                            PrintWriter pw = new PrintWriter(os, true);
                            String applicationName = null;
                            boolean isApplication = false;
                            boolean isAllApplications = false;
                            threadLoader = Thread.currentThread().getContextClassLoader();
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                            try {
                                block25: {
                                    block32: {
                                        block31: {
                                            if (params.length == 0) {
                                                pw.println(this.getHelpMessage());
                                                Object var18_10 = null;
                                                Thread.currentThread().setContextClassLoader(threadLoader);
                                                return;
                                            }
                                            if (params.length != 1) break block31;
                                            if (params[0].equals("-?") || params[0].toLowerCase().startsWith("-h")) {
                                                pw.println(this.getHelpMessage());
                                                break block24;
                                            }
                                            if (params[0].toLowerCase().equals("-all")) {
                                                isAllApplications = true;
                                                break block25;
                                            } else {
                                                isApplication = true;
                                                applicationName = params[0];
                                            }
                                            break block25;
                                        }
                                        if (params.length != 2) break block32;
                                        if (params[0].toLowerCase().equals("-a")) {
                                            isApplication = true;
                                            applicationName = params[1];
                                            break block25;
                                        } else {
                                            pw.println(this.getHelpMessage());
                                            break block26;
                                        }
                                    }
                                    pw.println(this.getHelpMessage());
                                    break block27;
                                }
                                if (this.deploy == null) {
                                    pw.println("Deploy Service was not started!");
                                    break block28;
                                }
                                String[] appsForRemove = null;
                                try {
                                    if (isAllApplications) {
                                        appsForRemove = this.deploy.listApplications(null, null);
                                    } else if (isApplication) {
                                        appsForRemove = new String[]{applicationName};
                                    }
                                    if (appsForRemove == null) break block29;
                                    int i = 0;
                                    while (i < appsForRemove.length) {
                                        block30: {
                                            applicationName = appsForRemove[i];
                                            try {
                                                if (applicationName == null) break block30;
                                                if (i > 0) {
                                                    pw.println("");
                                                }
                                                try {
                                                    this.deploy.remove(applicationName);
                                                }
                                                catch (WarningException wex) {
                                                    pw.println("Application " + applicationName + " removed with WARNINGS. \n");
                                                    DCommandsUtils.handleWarnings(pw, wex);
                                                }
                                                pw.println("");
                                                pw.println("Application " + applicationName + " has been removed.");
                                            }
                                            catch (RemoteException re) {
                                                DCommandsUtils.handleProblem(pw, re.toString());
                                            }
                                            catch (Exception ex) {
                                                DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                                                Object var18_15 = null;
                                                Thread.currentThread().setContextClassLoader(threadLoader);
                                                return;
                                            }
                                            catch (ThreadDeath td) {
                                                DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                                                throw td;
                                            }
                                            catch (OutOfMemoryError oome) {
                                                DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                                                throw oome;
                                            }
                                            catch (Error er) {
                                                DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                                            }
                                        }
                                        ++i;
                                    }
                                    break block29;
                                }
                                catch (RemoteException rex) {
                                    DCommandsUtils.handleProblem(pw, rex.toString());
                                    Object var18_16 = null;
                                    Thread.currentThread().setContextClassLoader(threadLoader);
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var18_18 = null;
                                Thread.currentThread().setContextClassLoader(threadLoader);
                                throw throwable;
                            }
                        }
                        Object var18_11 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        return;
                    }
                    Object var18_12 = null;
                    Thread.currentThread().setContextClassLoader(threadLoader);
                    return;
                }
                Object var18_13 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            Object var18_14 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            return;
        }
        Object var18_17 = null;
        Thread.currentThread().setContextClassLoader(threadLoader);
    }

    public String getHelpMessage() {
        return "Removes an application from all servers in the cluster.\nUsage: REMOVE_APP [<applicationName> | <-all>]\nParameters:\n   <applicationName> - The name of the application to remove.\n   <-all>            - Removes all applications from the cluster.\n";
    }

    public String getName() {
        return "REMOVE_APP";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

