/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import com.sap.engine.services.deploy.server.DUtils;
import com.sap.engine.services.deploy.server.DeployServiceImpl;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;

public class ListRefsCommand
implements Command {
    DeployServiceImpl deploy = null;

    public ListRefsCommand(DeployServiceImpl deployment) {
        this.deploy = deployment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        ClassLoader threadLoader;
        block22: {
            block21: {
                block20: {
                    block19: {
                        PrintWriter pw = new PrintWriter(os, true);
                        threadLoader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        try {
                            if (params.length > 0) {
                                if (params[0].equalsIgnoreCase("-help") || params[0].equalsIgnoreCase("-h") || params[0].equals("-?")) {
                                    pw.println(this.getHelpMessage());
                                    Object var13_7 = null;
                                    Thread.currentThread().setContextClassLoader(threadLoader);
                                    return;
                                }
                                try {
                                    String appName = params[0];
                                    if (params.length == 1) {
                                        Properties refs = this.deploy.getApplicationReferences(appName);
                                        if (refs == null) {
                                            pw.println("Application " + appName + " has no references.");
                                        }
                                        Enumeration<?> refNames = refs.propertyNames();
                                        String refName = null;
                                        while (refNames.hasMoreElements()) {
                                            refName = (String)refNames.nextElement();
                                            pw.println(appName + " has " + refs.getProperty(refName) + " reference to " + refName);
                                        }
                                    }
                                    if (params.length == 2 && params[1].equalsIgnoreCase("-resource")) {
                                        DeploymentInfo dInfo = this.deploy.getDeploymentInfo(appName = this.deploy.getApplicationID(appName));
                                        if (dInfo == null) {
                                            pw.println("Application " + appName + " has no references to resources.");
                                            break block19;
                                        }
                                        String[] resources = dInfo.getResources();
                                        if (resources == null || resources.length == 0) {
                                            pw.println("Application " + appName + " has no references to resources.");
                                            break block20;
                                        } else {
                                            String ref = null;
                                            int i = 0;
                                            while (i < resources.length) {
                                                ref = resources[i];
                                                pw.println("Application " + appName + " has " + (DUtils.decodeResourceReferenceType(ref).equals("hard") ? "hard" : "weak") + " reference to resource " + DUtils.decodeResourceName(ref) + " of type " + DUtils.decodeResourceType(ref) + ".");
                                                ++i;
                                            }
                                        }
                                    }
                                    pw.println(this.getHelpMessage());
                                    break block21;
                                }
                                catch (RemoteException re) {
                                    DCommandsUtils.handleProblem(pw, re.toString());
                                }
                                catch (Exception ex) {
                                    DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                                    Object var13_11 = null;
                                    Thread.currentThread().setContextClassLoader(threadLoader);
                                    return;
                                }
                                catch (ThreadDeath td) {
                                    DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                                    throw td;
                                }
                                catch (OutOfMemoryError oome) {
                                    DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                                    throw oome;
                                }
                                catch (Error er) {
                                    DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                                }
                            } else {
                                pw.println(this.getHelpMessage());
                                break block22;
                            }
                            Object var13_13 = null;
                            Thread.currentThread().setContextClassLoader(threadLoader);
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var13_14 = null;
                            Thread.currentThread().setContextClassLoader(threadLoader);
                            throw throwable;
                        }
                    }
                    Object var13_8 = null;
                    Thread.currentThread().setContextClassLoader(threadLoader);
                    return;
                }
                Object var13_9 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            Object var13_10 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            return;
        }
        Object var13_12 = null;
        Thread.currentThread().setContextClassLoader(threadLoader);
    }

    public String getHelpMessage() {
        return "Lists all the references of an application.\nUsage: LIST_REFS <applicationName> [-resource]\nParameters: \n   <applicationName> - The name of the application to check.\n   [-resource]       - With this option references only to resources are listed.\n                       Otherwise references to other components are listed.\n";
    }

    public String getName() {
        return "LIST_REFS";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

